/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbunit.dataset.Column;
import org.unitils.dbunit.dataset.Row;
import org.unitils.dbunit.dataset.comparison.RowDifference;
import org.unitils.dbunit.dataset.comparison.TableDifference;

public class Table {
    private String name;
    private List<Row> rows = new ArrayList<Row>();
    private List<Column> columns = new ArrayList<Column>();

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public TableDifference compare(Table actualTable) {
        TableDifference result = new TableDifference(this, actualTable);
        if (this.isEmpty()) {
            if (actualTable.isEmpty()) {
                return null;
            }
            return result;
        }
        this.compareRows(this.rows, actualTable, result);
        if (result.isMatch()) {
            return null;
        }
        return result;
    }

    protected void compareRows(List<Row> rows, Table actualTable, TableDifference result) {
        ArrayList<Row> rowsWithoutMatch = new ArrayList<Row>(rows);
        block0: for (Row actualRow : actualTable.getRows()) {
            Iterator rowIterator = rowsWithoutMatch.iterator();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (row.hasDifferentPrimaryKeyColumns(actualRow)) continue;
                RowDifference rowDifference = row.compare(actualRow);
                if (rowDifference == null) {
                    result.setMatchingRow(row, actualRow);
                    rowIterator.remove();
                    continue block0;
                }
                result.setIfBestRowDifference(rowDifference);
            }
        }
        for (Row row : rowsWithoutMatch) {
            if (result.getBestRowDifference(row) != null) continue;
            result.addMissingRow(row);
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addColumns(Column[] columns2) {
        for (Column column : columns2) {
            this.addColumn(column);
        }
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }
}

