/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class LoggedExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static Set<String> LOG_CONFIGURATION_MESSAGES;
    private static LoggedExceptionHandlerThreadLocal handler;
    private final Thread.UncaughtExceptionHandler parent;
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    LoggedExceptionHandler(Thread.UncaughtExceptionHandler parent) {
        this.parent = parent;
    }

    public void register(Throwable exception) {
        this.exceptions.add(exception);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            if (this.isPassedToParent(ex) && this.parent != null) {
                this.parent.uncaughtException(thread, ex);
            }
        }
        finally {
            this.exceptions.clear();
        }
    }

    private boolean isPassedToParent(Throwable ex) {
        return this.isLogConfigurationMessage(ex) || !this.isRegistered(ex);
    }

    private boolean isLogConfigurationMessage(Throwable ex) {
        String message = ex.getMessage();
        if (message != null) {
            for (String candidate : LOG_CONFIGURATION_MESSAGES) {
                if (!message.contains(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRegistered(Throwable ex) {
        if (this.exceptions.contains(ex)) {
            return true;
        }
        if (ex instanceof InvocationTargetException) {
            return this.isRegistered(ex.getCause());
        }
        return false;
    }

    static LoggedExceptionHandler forCurrentThread() {
        return (LoggedExceptionHandler)handler.get();
    }

    static {
        HashSet<String> messages = new HashSet<String>();
        messages.add("Logback configuration error detected");
        LOG_CONFIGURATION_MESSAGES = Collections.unmodifiableSet(messages);
        handler = new LoggedExceptionHandlerThreadLocal();
    }

    private static class LoggedExceptionHandlerThreadLocal
    extends ThreadLocal<LoggedExceptionHandler> {
        private LoggedExceptionHandlerThreadLocal() {
        }

        @Override
        protected LoggedExceptionHandler initialValue() {
            LoggedExceptionHandler handler = new LoggedExceptionHandler(Thread.currentThread().getUncaughtExceptionHandler());
            Thread.currentThread().setUncaughtExceptionHandler(handler);
            return handler;
        }
    }
}

