/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIteratorInterface;
import org.rocksdb.RocksObject;

public abstract class AbstractRocksIterator<P extends RocksObject>
extends RocksObject
implements RocksIteratorInterface {
    final P parent_;

    protected AbstractRocksIterator(P p, long l) {
        this.nativeHandle_ = l;
        assert (p != null);
        this.parent_ = p;
    }

    @Override
    public boolean isValid() {
        assert (this.isInitialized());
        return this.isValid0(this.nativeHandle_);
    }

    @Override
    public void seekToFirst() {
        assert (this.isInitialized());
        this.seekToFirst0(this.nativeHandle_);
    }

    @Override
    public void seekToLast() {
        assert (this.isInitialized());
        this.seekToLast0(this.nativeHandle_);
    }

    @Override
    public void seek(byte[] byArray) {
        assert (this.isInitialized());
        this.seek0(this.nativeHandle_, byArray, byArray.length);
    }

    @Override
    public void next() {
        assert (this.isInitialized());
        this.next0(this.nativeHandle_);
    }

    @Override
    public void prev() {
        assert (this.isInitialized());
        this.prev0(this.nativeHandle_);
    }

    @Override
    public void status() throws RocksDBException {
        assert (this.isInitialized());
        this.status0(this.nativeHandle_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeInternal() {
        P p = this.parent_;
        synchronized (p) {
            assert (this.isInitialized());
            if (((RocksObject)this.parent_).isInitialized()) {
                this.disposeInternal(this.nativeHandle_);
            }
        }
    }

    abstract void disposeInternal(long var1);

    abstract boolean isValid0(long var1);

    abstract void seekToFirst0(long var1);

    abstract void seekToLast0(long var1);

    abstract void next0(long var1);

    abstract void prev0(long var1);

    abstract void seek0(long var1, byte[] var3, int var4);

    abstract void status0(long var1) throws RocksDBException;
}

