/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weixin.guanjia.menu.web;

import com.jeecg.api.account.dao.CommWeixinAccountDao;
import com.jeecg.api.account.entity.CommWeixinAccount;
import com.jeecg.api.util.WeixinUtil;
import com.jeecg.weixin.guanjia.menu.entity.Button;
import com.jeecg.weixin.guanjia.menu.entity.CommonButton;
import com.jeecg.weixin.guanjia.menu.entity.ComplexButton;
import com.jeecg.weixin.guanjia.menu.entity.Menu;
import com.jeecg.weixin.guanjia.menu.entity.NewsTemplate;
import com.jeecg.weixin.guanjia.menu.entity.TextTemplate;
import com.jeecg.weixin.guanjia.menu.entity.ViewButton;
import com.jeecg.weixin.guanjia.menu.entity.WeixinAudiosucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinLinksucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinMenuMatchruleEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinMenuPersonalityEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinPhotosucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinVideosucaiEntity;
import com.jeecg.weixin.guanjia.menu.service.WeixinMenuMatchruleService;
import com.jeecg.weixin.guanjia.menu.service.WeixinMenuPersonalityService;
import com.jeecg.weixin.guanjia.menu.util.ResourceUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.page.SystemTools;
import org.jeecgframework.p3.core.util.UUIDGenerator;
import org.jeecgframework.p3.core.util.oConvertUtils;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/guanjia/weixinMenuPersonality"})
public class WeixinMenuPersonalityController
extends BaseController {
    @Autowired
    private WeixinMenuPersonalityService weixinMenuPersonalityService;
    @Autowired
    private CommWeixinAccountDao weixinAccountDao;
    @Autowired
    private WeixinMenuMatchruleService weixinMenuMatchruleService;
    public static final String addconditional = "https://api.weixin.qq.com/cgi-bin/menu/addconditional?access_token=ACCESS_TOKEN";
    public static final String delconditional = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=ACCESS_TOKEN";

    @RequestMapping(params={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute WeixinMenuPersonalityEntity query, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="30") int pageSize) throws Exception {
        try {
            this.LOG.info(request, " go list");
            query.setHideflag(0);
            MiniDaoPage<WeixinMenuPersonalityEntity> list = this.weixinMenuPersonalityService.getAll(query, pageNo, pageSize);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("weixinMenuPersonality", (Object)query);
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(list));
            String viewName = "guanjia/menu/vm/weixinMenuPersonality-list.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"toDetail"}, method={RequestMethod.GET})
    public void weixinMenuPersonalityDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "guanjia/menu/vm/weixinMenuPersonality-detail.vm";
        WeixinMenuPersonalityEntity weixinMenuPersonality = this.weixinMenuPersonalityService.get(id);
        velocityContext.put("weixinMenuPersonality", (Object)weixinMenuPersonality);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(@ModelAttribute WeixinMenuPersonalityEntity weixinMenuPersonality, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            VelocityContext velocityContext = new VelocityContext();
            if (StringUtils.isNotEmpty((String)weixinMenuPersonality.getId()) && StringUtils.isNotEmpty((String)(weixinMenuPersonality = this.weixinMenuPersonalityService.get(weixinMenuPersonality.getId())).getFatherid())) {
                WeixinMenuPersonalityEntity pMenu = this.weixinMenuPersonalityService.get(weixinMenuPersonality.getFatherid());
                weixinMenuPersonality.setParentName(pMenu.getName());
            }
            velocityContext.put("weixinMenuPersonality", (Object)weixinMenuPersonality);
            String viewName = "guanjia/menu/vm/weixinMenuPersonality-add.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute WeixinMenuPersonalityEntity menuEntity) {
        AjaxJson j = new AjaxJson();
        try {
            List<WeixinMenuPersonalityEntity> checklist = this.weixinMenuPersonalityService.checkOrders(menuEntity.getId(), menuEntity.getAccountid(), menuEntity.getOrders());
            if (checklist != null && checklist.size() > 0) {
                j.setMsg("\u540c\u4e00\u4e2a\u5fae\u4fe1\u4f4d\u7f6e\u53ea\u80fd\u6709\u4e00\u4e2a\u83dc\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f4d\u7f6e\uff01");
                j.setSuccess(false);
                return j;
            }
            j = this.buildParentMenu(menuEntity);
            if (!j.isSuccess()) {
                return j;
            }
            if (!StringUtils.isNotEmpty((String)menuEntity.getId())) {
                List<WeixinMenuPersonalityEntity> list;
                if (StringUtils.isNotEmpty((String)menuEntity.getFatherid())) {
                    list = this.weixinMenuPersonalityService.getMenusByFatherId(menuEntity.getFatherid(), menuEntity.getAccountid());
                    if (list != null && list.size() >= 5) {
                        j.setSuccess(false);
                        j.setMsg("\u6700\u591a\u53ef\u4ee5\u65b0\u5efa\u4e94\u4e2a\u4e8c\u7ea7\u83dc\u5355");
                        return j;
                    }
                } else {
                    list = this.weixinMenuPersonalityService.getFuMenusByAccountId(menuEntity.getAccountid());
                    if (list != null && list.size() >= 3) {
                        j.setSuccess(false);
                        j.setMsg("\u6700\u591a\u53ef\u4ee5\u65b0\u5efa\u4e09\u4e2a\u4e00\u7ea7\u83dc\u5355");
                        return j;
                    }
                }
                if (!"-1".equals(menuEntity.getAccountid())) {
                    menuEntity.setCode(DateUtils.getDataString((SimpleDateFormat)new SimpleDateFormat("yyyyMMddHHmmss")));
                    menuEntity.setMenukey(menuEntity.getCode());
                    menuEntity.setMenuSourceType("1");
                    menuEntity.setHideflag(0);
                    menuEntity.setPriority(1);
                } else {
                    j.setSuccess(false);
                    j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
                }
                String randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
                menuEntity.setId(randomSeed);
                this.weixinMenuPersonalityService.insert(menuEntity);
            }
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
            j.setObj((Object)menuEntity);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    private AjaxJson buildParentMenu(WeixinMenuPersonalityEntity menuEntity) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        String orders = "";
        if (StringUtils.isNotEmpty((String)menuEntity.getOrders())) {
            orders = menuEntity.getOrders();
            if (orders.length() == 1) {
                menuEntity.setFatherid("");
            } else {
                String pOrders = orders.substring(0, 1);
                List<WeixinMenuPersonalityEntity> list = this.weixinMenuPersonalityService.checkOrders(null, menuEntity.getAccountid(), pOrders);
                if (list == null || list.size() < 1) {
                    j.setSuccess(false);
                    j.setMsg("\u8bf7\u5148\u521b\u5efa\u4e00\u7ea7\u83dc\u5355" + pOrders);
                } else {
                    menuEntity.setFatherid(list.get(0).getId());
                }
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u8bf7\u9009\u62e9\u83dc\u5355\u6240\u5728\u4f4d\u7f6e");
        }
        return j;
    }

    @RequestMapping(params={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        WeixinMenuPersonalityEntity weixinMenuPersonality = this.weixinMenuPersonalityService.get(id);
        velocityContext.put("weixinMenuPersonality", (Object)weixinMenuPersonality);
        String viewName = "guanjia/menu/vm/weixinMenuPersonality-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute WeixinMenuPersonalityEntity weixinMenuPersonality) {
        AjaxJson j = new AjaxJson();
        try {
            this.weixinMenuPersonalityService.update(weixinMenuPersonality);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
            j.setObj((Object)weixinMenuPersonality);
            j.setSuccess(true);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"doDelete"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            List<WeixinMenuPersonalityEntity> list;
            WeixinMenuPersonalityEntity weixinMenuPersonality = new WeixinMenuPersonalityEntity();
            weixinMenuPersonality.setId(id);
            WeixinMenuPersonalityEntity menuy = this.weixinMenuPersonalityService.get(id);
            if ("P".equals(menuy.getShareStatus())) {
                j.setMsg("\u540c\u6b65\u7684\u83dc\u5355\u4e0d\u80fd\u88ab\u5220\u9664");
                return j;
            }
            if (("1".equals(menuy.getOrders()) || "2".equals(menuy.getOrders()) || "3".equals(menuy.getOrders())) && (list = this.weixinMenuPersonalityService.getChildMenusByPid(id)) != null && list.size() > 0) {
                for (WeixinMenuPersonalityEntity m : list) {
                    if (!"P".equals(menuy.getShareStatus())) continue;
                    j.setMsg("\u9009\u4e2d\u83dc\u5355\u4e2d\u5305\u542b\u5171\u4eab\u7684\u83dc\u5355\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    return j;
                }
            }
            this.weixinMenuPersonalityService.delete(weixinMenuPersonality);
            if (("1".equals(menuy.getOrders()) || "2".equals(menuy.getOrders()) || "3".equals(menuy.getOrders())) && (list = this.weixinMenuPersonalityService.getChildMenusByPid(id)) != null && list.size() > 0) {
                for (WeixinMenuPersonalityEntity m : list) {
                    this.weixinMenuPersonalityService.delete(m);
                }
            }
            j.setMsg("\u5220\u9664\u6210\u529f");
            j.setObj((Object)menuy);
            j.setSuccess(true);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"doCopy"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doCopy(@ModelAttribute WeixinMenuPersonalityEntity weixinMenuPersonality) {
        AjaxJson j = new AjaxJson();
        try {
            this.weixinMenuPersonalityService.deleteAll();
            List<Map<String, Object>> mainMenuList = this.weixinMenuPersonalityService.getMenuByAccountId(weixinMenuPersonality.getAccountid());
            for (Map<String, Object> map : mainMenuList) {
                String fatherid = (String)map.get("ID");
                WeixinMenuPersonalityEntity personality = new WeixinMenuPersonalityEntity();
                personality.setMatchruleId(weixinMenuPersonality.getMatchruleId());
                personality = this.copyFather(map, personality);
                this.weixinMenuPersonalityService.insert(personality);
                List<Map<String, Object>> childMenuList = this.weixinMenuPersonalityService.getMenuByFatherId(fatherid);
                for (Map<String, Object> map2 : childMenuList) {
                    WeixinMenuPersonalityEntity childPersonality = new WeixinMenuPersonalityEntity();
                    childPersonality.setFatherid(personality.getId());
                    childPersonality.setMatchruleId(weixinMenuPersonality.getMatchruleId());
                    this.copyChild(map2, childPersonality);
                    this.weixinMenuPersonalityService.insert(childPersonality);
                }
            }
            j.setMsg("\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u590d\u5236\u5931\u8d25" + e.getMessage());
        }
        return j;
    }

    private WeixinMenuPersonalityEntity copyChild(Map<String, Object> map2, WeixinMenuPersonalityEntity childPersonality) {
        try {
            childPersonality.setId(UUIDGenerator.generate());
            childPersonality.setAccountid((String)map2.get("accountid"));
            childPersonality.setCode((String)map2.get("CODE"));
            childPersonality.setHideflag((Integer)map2.get("hideflag"));
            childPersonality.setMenukey((String)map2.get("menukey"));
            childPersonality.setMenuSourceType((String)map2.get("menu_source_type"));
            childPersonality.setMsgtype((String)map2.get("msgtype"));
            childPersonality.setName((String)map2.get("name"));
            childPersonality.setOrders((String)map2.get("orders"));
            childPersonality.setPostCode((String)map2.get("POST_CODE"));
            childPersonality.setPriority((Integer)map2.get("priority"));
            childPersonality.setShareStatus((String)map2.get("SHARE_STATUS"));
            childPersonality.setSynchronous((String)map2.get("synchronous"));
            childPersonality.setSynchronousAccountid((String)map2.get("synchronous_accountid"));
            childPersonality.setSynchronoustime((String)map2.get("synchronoustime"));
            childPersonality.setTemplateid((String)map2.get("templateid"));
            childPersonality.setType((String)map2.get("type"));
            childPersonality.setUrl((String)map2.get("url"));
            return childPersonality;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private WeixinMenuPersonalityEntity copyFather(Map<String, Object> map, WeixinMenuPersonalityEntity personality) {
        try {
            personality.setId(UUIDGenerator.generate());
            personality.setAccountid((String)map.get("accountid"));
            personality.setCode((String)map.get("CODE"));
            personality.setHideflag((Integer)map.get("hideflag"));
            personality.setMenukey((String)map.get("menukey"));
            personality.setMenuSourceType((String)map.get("menu_source_type"));
            personality.setMsgtype((String)map.get("msgtype"));
            personality.setName((String)map.get("name"));
            personality.setOrders((String)map.get("orders"));
            personality.setPostCode((String)map.get("POST_CODE"));
            personality.setPriority((Integer)map.get("priority"));
            personality.setShareStatus((String)map.get("SHARE_STATUS"));
            personality.setSynchronous((String)map.get("synchronous"));
            personality.setSynchronousAccountid((String)map.get("synchronous_accountid"));
            personality.setSynchronoustime((String)map.get("synchronoustime"));
            personality.setTemplateid((String)map.get("templateid"));
            personality.setType((String)map.get("type"));
            personality.setUrl((String)map.get("url"));
            return personality;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(params={"doSynch"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doSynch(@ModelAttribute WeixinMenuPersonalityEntity weixinMenuPersonality) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.synchWeixin(j, weixinMenuPersonality.getAccountid(), weixinMenuPersonality.getMatchruleId());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u540c\u6b65\u5931\u8d25" + e.getMessage());
        }
        return j;
    }

    private AjaxJson synchWeixin(AjaxJson j, final String accountid, String matchruleId) throws WexinReqException {
        CommWeixinAccount weixinAccount = this.weixinAccountDao.get(accountid);
        String accesstoken = weixinAccount.getAccountaccesstoken();
        List<WeixinMenuPersonalityEntity> menuList = this.weixinMenuPersonalityService.getFuMenusByAccountId(accountid);
        WeixinMenuMatchruleEntity menuMatchrule = this.weixinMenuMatchruleService.get(matchruleId);
        if (StringUtils.isNotEmpty((String)menuMatchrule.getMenuid())) {
            String url = delconditional.replace("ACCESS_TOKEN", accesstoken);
            JSONObject obj = new JSONObject();
            obj.put((Object)"menuid", (Object)menuMatchrule.getMenuid());
            JSONObject result = WeixinUtil.httpRequest((String)url, (String)"POST", (String)obj.toString());
            if ("0".equals(result.getString("errcode"))) {
                log.info("==========\u540c\u6b65\u5fae\u4fe1\u83dc\u5355\u524d\u5220\u9664\u83dc\u5355\u6210\u529f=================");
            }
        }
        if (menuList == null || menuList.size() <= 0) {
            j.setMsg("\u540c\u6b65\u5fae\u4fe1\u83dc\u5355\u6210\u529f");
            j.setSuccess(true);
            return j;
        }
        Menu menu = new Menu();
        Button[] firstArr = new Button[menuList.size()];
        int a = 0;
        while (a < menuList.size()) {
            WeixinMenuPersonalityEntity entity = menuList.get(a);
            List<WeixinMenuPersonalityEntity> childList = this.weixinMenuPersonalityService.getZiMenusByFatherIdAndAccountId(entity.getId(), accountid);
            if (childList == null || childList.size() == 0) {
                ViewButton viewButton;
                if ("view".equals(entity.getType())) {
                    viewButton = new ViewButton();
                    viewButton.setName(entity.getName());
                    viewButton.setType(entity.getType());
                    viewButton.setUrl(entity.getUrl());
                    firstArr[a] = viewButton;
                } else if ("click".equals(entity.getType())) {
                    if ("link".equals(entity.getMsgtype())) {
                        viewButton = new ViewButton();
                        viewButton.setName(entity.getName());
                        viewButton.setType("view");
                        if (oConvertUtils.isNotEmpty((Object)entity.getTemplateid())) {
                            String url = this.getInnerLink(entity.getTemplateid(), accountid);
                            viewButton.setUrl(url);
                        }
                        firstArr[a] = viewButton;
                    } else {
                        CommonButton cb = new CommonButton();
                        cb.setKey(entity.getMenukey());
                        cb.setName(entity.getName());
                        cb.setType(entity.getType());
                        firstArr[a] = cb;
                    }
                }
            } else {
                ComplexButton complexButton = new ComplexButton();
                complexButton.setName(entity.getName());
                Button[] secondARR = new Button[childList.size()];
                int i = 0;
                while (i < childList.size()) {
                    ViewButton viewButton;
                    WeixinMenuPersonalityEntity children = childList.get(i);
                    String type = children.getType();
                    if ("view".equals(type)) {
                        viewButton = new ViewButton();
                        viewButton.setName(children.getName());
                        viewButton.setType(children.getType());
                        viewButton.setUrl(children.getUrl());
                        secondARR[i] = viewButton;
                    } else if ("click".equals(type)) {
                        if ("link".equals(children.getMsgtype())) {
                            viewButton = new ViewButton();
                            viewButton.setName(children.getName());
                            viewButton.setUrl(children.getUrl());
                            viewButton.setType("view");
                            if (oConvertUtils.isNotEmpty((Object)children.getTemplateid())) {
                                String url = this.getInnerLink(children.getTemplateid(), accountid);
                                viewButton.setUrl(url);
                            }
                            secondARR[i] = viewButton;
                        } else {
                            CommonButton cb1 = new CommonButton();
                            cb1.setName(children.getName());
                            cb1.setType(children.getType());
                            cb1.setKey(children.getMenukey());
                            secondARR[i] = cb1;
                        }
                    }
                    ++i;
                }
                complexButton.setSub_button(secondARR);
                firstArr[a] = complexButton;
            }
            ++a;
        }
        menu.setButton(firstArr);
        HashMap<String, String> zimap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)menuMatchrule.getCity())) {
            zimap.put("city", menuMatchrule.getCity());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getClientPlatformType())) {
            zimap.put("client_platform_type", menuMatchrule.getClientPlatformType());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getCountry())) {
            zimap.put("country", menuMatchrule.getCountry());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getLanguage())) {
            zimap.put("language", menuMatchrule.getLanguage());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getProvince())) {
            zimap.put("province", menuMatchrule.getProvince());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getSex())) {
            zimap.put("sex", menuMatchrule.getSex());
        }
        if (StringUtils.isNotEmpty((String)menuMatchrule.getTagId())) {
            zimap.put("tag_id", menuMatchrule.getTagId());
        }
        JSONObject jsonMenu = JSONObject.fromObject((Object)menu);
        jsonMenu.put((Object)"matchrule", zimap);
        log.info("============\u521b\u5efa\u4e2a\u6027\u5316\u83dc\u5355\u524d\u62fc\u63a5\u53c2\u6570=========\uff1a" + jsonMenu.toString());
        String url = null;
        url = addconditional.replace("ACCESS_TOKEN", accesstoken);
        JSONObject jsonObject = new JSONObject();
        jsonObject = WeixinUtil.httpRequest((String)url, (String)"POST", (String)jsonMenu.toString());
        log.info("============\u521b\u5efa\u4e2a\u6027\u5316\u83dc\u5355\u8fd4\u56de\u7ed3\u679c=========\uff1a" + jsonObject.toString());
        if (jsonObject.containsKey((Object)"menuid")) {
            j.setMsg("\u540c\u6b65\u83dc\u5355\u4fe1\u606f\u6570\u636e\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\uff01");
            j.setSuccess(true);
            menuMatchrule.setMenuid(jsonObject.getString("menuid"));
            this.weixinMenuMatchruleService.update(menuMatchrule);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    WeixinMenuPersonalityController.this.setMenuSynch(accountid);
                }
            });
            t.start();
            return j;
        }
        if ("42001".equals(jsonObject.getString("errcode")) || "40001".equals(jsonObject.getString("errcode"))) {
            j.setMsg("\u540c\u6b65\u83dc\u5355\u4fe1\u606f\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u7f6eToken\u540e\u91cd\u8bd5\uff01");
            j.setSuccess(false);
            return j;
        }
        j.setMsg("\u540c\u6b65\u83dc\u5355\u4fe1\u606f\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u7f16\u7801\uff1a" + jsonObject.getString("errcode") + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + jsonObject.getString("errmsg"));
        j.setSuccess(false);
        return j;
    }

    private String getInnerLink(String templateid, String accountid) {
        String baseurl = ResourceUtil.getConfigByName("domain");
        String inner_link = String.valueOf(baseurl) + "/weixinLinksucaiController.do?link&id=" + templateid + "&accountid=" + accountid;
        return inner_link;
    }

    private void setMenuSynch(String accountid) {
        CommWeixinAccount account = this.weixinAccountDao.get(accountid);
        List<WeixinMenuPersonalityEntity> fuMenus = this.weixinMenuPersonalityService.getFuMenusByAccountId(accountid);
        if (fuMenus != null && fuMenus.size() > 0) {
            for (WeixinMenuPersonalityEntity fu : fuMenus) {
                List<WeixinMenuPersonalityEntity> ziMenus = this.weixinMenuPersonalityService.getZiMenusByFatherIdAndAccountId(fu.getId(), accountid);
                if (ziMenus != null && ziMenus.size() > 0) {
                    for (WeixinMenuPersonalityEntity zi : ziMenus) {
                        zi.setSynchronous("Y");
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        zi.setSynchronoustime(format.format(new Date()));
                        zi.setPostCode(account.getPostCode());
                        this.weixinMenuPersonalityService.update(zi);
                    }
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                fu.setSynchronoustime(format.format(new Date()));
                fu.setSynchronous("Y");
                fu.setPostCode(account.getPostCode());
                this.weixinMenuPersonalityService.update(fu);
            }
        }
    }

    @RequestMapping(params={"gettemplate"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson gettemplate(@ModelAttribute WeixinMenuPersonalityEntity personality) {
        AjaxJson j = new AjaxJson();
        try {
            if ("text".equals(personality.getMsgtype())) {
                List<TextTemplate> textTemplateList = this.weixinMenuPersonalityService.getTextTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(textTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("news".equals(personality.getMsgtype())) {
                List<NewsTemplate> newsTemplateList = this.weixinMenuPersonalityService.getNewsTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(newsTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("expand".equals(personality.getMsgtype())) {
                List<NewsTemplate> expandTemplateList = this.weixinMenuPersonalityService.getExpandTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(expandTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("voice".equals(personality.getMsgtype())) {
                List<WeixinAudiosucaiEntity> voiceTemplateList = this.weixinMenuPersonalityService.getVoiceTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(voiceTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("video".equals(personality.getMsgtype())) {
                List<WeixinVideosucaiEntity> videoTemplateList = this.weixinMenuPersonalityService.getVideoTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(videoTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("image".equals(personality.getMsgtype())) {
                List<WeixinPhotosucaiEntity> imageTemplateList = this.weixinMenuPersonalityService.getImageTemplateByAccount(personality.getMsgtype());
                List<Map<String, String>> list = this.objToMap(imageTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
            if ("link".equals(personality.getMsgtype())) {
                List<WeixinLinksucaiEntity> linkTemplateList = this.weixinMenuPersonalityService.getLinkTemplateByAccount(personality.getAccountid());
                List<Map<String, String>> list = this.objToMap(linkTemplateList, personality.getMsgtype());
                j.setObj(list);
                j.setSuccess(true);
                return j;
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5931\u8d25 \uff0c\u5931\u8d25\u539f\u56e0 \uff1a" + e.getMessage());
        }
        return j;
    }

    private List<Map<String, String>> objToMap(Object data, String msgType) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> row = new HashMap<String, String>();
        String key_id = "resContentid";
        String key_name = "resContentname";
        if ("text".equals(msgType)) {
            List textList = (List)data;
            for (TextTemplate text : textList) {
                row = new HashMap();
                row.put(key_id, text.getId());
                row.put(key_name, String.valueOf(text.getTemplateName()) + "-" + text.getPostcodeName());
                result.add(row);
            }
        }
        if ("news".equals(msgType)) {
            List newsList = (List)data;
            for (NewsTemplate news : newsList) {
                row = new HashMap();
                row.put(key_id, news.getId());
                row.put(key_name, String.valueOf(news.getTemplateName()) + "-" + news.getPostcodeName());
                result.add(row);
            }
        }
        if ("voice".equals(msgType)) {
            List audiosucais = (List)data;
            for (WeixinAudiosucaiEntity audiosucai : audiosucais) {
                row = new HashMap();
                row.put(key_id, audiosucai.getId());
                row.put(key_name, audiosucai.getName());
                result.add(row);
            }
        }
        if ("video".equals(msgType)) {
            List videosucais = (List)data;
            for (WeixinVideosucaiEntity videosucai : videosucais) {
                row = new HashMap();
                row.put(key_id, videosucai.getId());
                row.put(key_name, videosucai.getName());
                result.add(row);
            }
        }
        if ("image".equals(msgType)) {
            List photosucais = (List)data;
            for (WeixinPhotosucaiEntity photosucai : photosucais) {
                row = new HashMap();
                row.put(key_id, photosucai.getId());
                row.put(key_name, photosucai.getName());
                result.add(row);
            }
        }
        return result;
    }

    @RequestMapping(params={"checkOrders"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson checkOrders(@ModelAttribute WeixinMenuPersonalityEntity menu, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        try {
            List<WeixinMenuPersonalityEntity> list = this.weixinMenuPersonalityService.checkOrders(menu.getId(), menu.getAccountid(), menu.getOrders());
            if (list != null && list.size() > 0) {
                j.setMsg("\u540c\u4e00\u4e2a\u5fae\u4fe1\u4f4d\u7f6e\u53ea\u80fd\u6709\u4e00\u4e2a\u83dc\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f4d\u7f6e\uff01");
                j.setSuccess(false);
                return j;
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5931\u8d25 \uff0c\u5931\u8d25\u539f\u56e0 \uff1a" + e.getMessage());
        }
        return j;
    }

    public static void main(String[] args) {
        String accountToken = "71fN085FGDTIT2O2CwmJwMZPBmnm0u2feN4-Qfr-anr0zbrLyah6r_hR1F7RMquMvsqViCWccGHz3kUEN3o1pcvmbxfh-GuwnWVVc1hi7LpqmZ5s8zQKXgUP_0CiDyV2BVRgACASMI";
        String url = delconditional.replace("ACCESS_TOKEN", accountToken);
        JSONObject obj = new JSONObject();
        obj.put((Object)"menuid", (Object)408692900);
        JSONObject result = WeixinUtil.httpRequest((String)url, (String)"POST", (String)obj.toString());
        System.err.println(result.toString());
    }
}

