/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weixin.guanjia.menu.web;

import com.jeecg.api.account.dao.CommWeixinAccountDao;
import com.jeecg.api.account.entity.CommWeixinAccount;
import com.jeecg.api.util.WeixinUtil;
import com.jeecg.weixin.guanjia.menu.entity.WeixinMenuMatchruleEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinTagVo;
import com.jeecg.weixin.guanjia.menu.service.WeixinMenuMatchruleService;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.p3.core.author.LoginUser;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.page.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ContextHolderUtils;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/guanjia/weixinMenuMatchrule"})
public class WeixinMenuMatchruleController
extends BaseController {
    @Autowired
    private WeixinMenuMatchruleService weixinMenuMatchruleService;
    @Autowired
    private CommWeixinAccountDao weixinAccountDao;
    public static final String delconditional = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=ACCESS_TOKEN";

    @RequestMapping(params={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute WeixinMenuMatchruleEntity query, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        try {
            this.LOG.info(request, " back list");
            MiniDaoPage<WeixinMenuMatchruleEntity> list = this.weixinMenuMatchruleService.getAll(query, pageNo, pageSize);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("weixinMenuMatchrule", (Object)query);
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(list));
            LoginUser user = ContextHolderUtils.getLoginSessionUser();
            String weixinAccountId = user.getDefaultWeixinAccountId();
            if (StringUtils.isNotEmpty((String)weixinAccountId)) {
                List<WeixinTagVo> tagList = this.weixinMenuMatchruleService.getTagByAccountid(weixinAccountId);
                velocityContext.put("tagList", tagList);
            }
            String viewName = "guanjia/menu/vm/weixinMenuMatchrule-list.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"toDetail"}, method={RequestMethod.GET})
    public void weixinMenuMatchruleDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "guanjia/menu/vm/weixinMenuMatchrule-detail.vm";
        WeixinMenuMatchruleEntity weixinMenuMatchrule = this.weixinMenuMatchruleService.get(id);
        velocityContext.put("weixinMenuMatchrule", (Object)weixinMenuMatchrule);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(params={"toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            VelocityContext velocityContext = new VelocityContext();
            LoginUser user = ContextHolderUtils.getLoginSessionUser();
            String weixinAccountId = user.getDefaultWeixinAccountId();
            if (StringUtils.isNotEmpty((String)weixinAccountId)) {
                List<WeixinTagVo> tagList = this.weixinMenuMatchruleService.getTagByAccountid(weixinAccountId);
                velocityContext.put("tagList", tagList);
            }
            String viewName = "guanjia/menu/vm/weixinMenuMatchrule-add.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute WeixinMenuMatchruleEntity weixinMenuMatchrule) {
        AjaxJson j = new AjaxJson();
        try {
            String randomSeed = UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
            weixinMenuMatchrule.setId(randomSeed);
            LoginUser user = ContextHolderUtils.getLoginSessionUser();
            String weixinAccountId = user.getDefaultWeixinAccountId();
            if (StringUtils.isNotEmpty((String)weixinAccountId)) {
                weixinMenuMatchrule.setAccountid(weixinAccountId);
                weixinMenuMatchrule.setCreateDate(new Date());
                this.weixinMenuMatchruleService.insert(weixinMenuMatchrule);
                j.setMsg("\u4fdd\u5b58\u6210\u529f");
                j.setSuccess(true);
                return j;
            }
            j.setMsg("\u672a\u83b7\u53d6\u5230jwid\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        try {
            VelocityContext velocityContext = new VelocityContext();
            LoginUser user = ContextHolderUtils.getLoginSessionUser();
            String weixinAccountId = user.getDefaultWeixinAccountId();
            if (StringUtils.isNotEmpty((String)weixinAccountId)) {
                List<WeixinTagVo> tagList = this.weixinMenuMatchruleService.getTagByAccountid(weixinAccountId);
                velocityContext.put("tagList", tagList);
            }
            WeixinMenuMatchruleEntity weixinMenuMatchrule = this.weixinMenuMatchruleService.get(id);
            velocityContext.put("weixinMenuMatchrule", (Object)weixinMenuMatchrule);
            String viewName = "guanjia/menu/vm/weixinMenuMatchrule-edit.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute WeixinMenuMatchruleEntity weixinMenuMatchrule) {
        AjaxJson j = new AjaxJson();
        try {
            this.weixinMenuMatchruleService.update(weixinMenuMatchrule);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(params={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            block6: {
                WeixinMenuMatchruleEntity weixinMenuMatchrule = new WeixinMenuMatchruleEntity();
                weixinMenuMatchrule.setId(id);
                weixinMenuMatchrule = this.weixinMenuMatchruleService.get(id);
                if (StringUtils.isNotEmpty((String)weixinMenuMatchrule.getMenuid())) {
                    LoginUser user = ContextHolderUtils.getLoginSessionUser();
                    String weixinAccountId = user.getDefaultWeixinAccountId();
                    CommWeixinAccount account = this.weixinAccountDao.get(weixinAccountId);
                    String url = delconditional.replace("ACCESS_TOKEN", account.getAccountaccesstoken());
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"menuid", (Object)weixinMenuMatchrule.getMenuid());
                    JSONObject result = WeixinUtil.httpRequest((String)url, (String)"POST", (String)obj.toString());
                    if ("0".equals(result.getString("errcode"))) {
                        this.weixinMenuMatchruleService.delete(weixinMenuMatchrule);
                        break block6;
                    } else {
                        if (!"40001".equals(result.getString("errcode")) && !"42001".equals(result.getString("errcode"))) {
                            j.setMsg("\u5220\u9664\u5931\u8d25\uff0c\u5fae\u4fe1\u63a5\u53e3\u9519\u8bef\u7f16\u7801\uff1a" + result.getString("errcode") + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + result.getString("errmsg"));
                            j.setSuccess(false);
                            return j;
                        }
                        j.setMsg("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u7f6etoken\u540e\u91cd\u8bd5\uff01");
                        j.setSuccess(false);
                        return j;
                    }
                }
                this.weixinMenuMatchruleService.delete(weixinMenuMatchrule);
            }
            j.setMsg("\u5220\u9664\u6210\u529f");
            return j;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25," + e.getMessage());
        }
        return j;
    }
}

