/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weixin.guanjia.menu.service.impl;

import com.jeecg.api.account.dao.CommWeixinAccountDao;
import com.jeecg.api.account.entity.CommWeixinAccount;
import com.jeecg.weixin.guanjia.menu.dao.WeixinMenuPersonalityDao;
import com.jeecg.weixin.guanjia.menu.entity.NewsTemplate;
import com.jeecg.weixin.guanjia.menu.entity.TextTemplate;
import com.jeecg.weixin.guanjia.menu.entity.WeixinAudiosucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinLinksucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinMenuPersonalityEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinPhotosucaiEntity;
import com.jeecg.weixin.guanjia.menu.entity.WeixinVideosucaiEntity;
import com.jeecg.weixin.guanjia.menu.service.WeixinMenuPersonalityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.springframework.stereotype.Service;

@Service(value="weixinMenuPersonalityService")
public class WeixinMenuPersonalityServiceImpl
implements WeixinMenuPersonalityService {
    @Resource
    private WeixinMenuPersonalityDao weixinMenuPersonalityDao;
    @Resource
    private CommWeixinAccountDao weixinAccountDao;

    @Override
    public WeixinMenuPersonalityEntity get(String id) {
        return this.weixinMenuPersonalityDao.get(id);
    }

    @Override
    public int update(WeixinMenuPersonalityEntity weixinMenuPersonality) {
        return this.weixinMenuPersonalityDao.update(weixinMenuPersonality);
    }

    @Override
    public void insert(WeixinMenuPersonalityEntity weixinMenuPersonality) {
        this.weixinMenuPersonalityDao.insert(weixinMenuPersonality);
    }

    @Override
    public MiniDaoPage<WeixinMenuPersonalityEntity> getAll(WeixinMenuPersonalityEntity weixinMenuPersonality, int page, int rows) {
        return this.weixinMenuPersonalityDao.getAll(weixinMenuPersonality, page, rows);
    }

    @Override
    public void delete(WeixinMenuPersonalityEntity weixinMenuPersonality) {
        this.weixinMenuPersonalityDao.delete(weixinMenuPersonality);
    }

    @Override
    public List<Map<String, Object>> getMenuByAccountId(String accountid) {
        return this.weixinMenuPersonalityDao.getMenuByAccountId(accountid);
    }

    @Override
    public List<Map<String, Object>> getMenuByFatherId(String fatherid) {
        return this.weixinMenuPersonalityDao.getMenuByFatherId(fatherid);
    }

    @Override
    public List<WeixinMenuPersonalityEntity> getFuMenusByAccountId(String accountid) {
        return this.weixinMenuPersonalityDao.getFuMenusByAccountId(accountid);
    }

    @Override
    public List<WeixinMenuPersonalityEntity> getZiMenusByFatherIdAndAccountId(String fatherid, String accountid) {
        return this.weixinMenuPersonalityDao.getZiMenusByFatherIdAndAccountId(fatherid, accountid);
    }

    @Override
    public List<TextTemplate> getTextTemplateByAccount(String accountid) {
        CommWeixinAccount account = this.weixinAccountDao.get(accountid);
        List<String> list = this.splitString(account.getPostCode(), 5);
        String postCode = this.populationInString(list);
        List<TextTemplate> textTemplateList = this.weixinMenuPersonalityDao.getTextTemplateByAccount(postCode, accountid);
        return textTemplateList;
    }

    @Override
    public List<NewsTemplate> getNewsTemplateByAccount(String accountid) {
        CommWeixinAccount account = this.weixinAccountDao.get(accountid);
        List<String> list = this.splitString(account.getPostCode(), 5);
        String postCode = this.populationInString(list);
        List<NewsTemplate> newsTemplateList = this.weixinMenuPersonalityDao.getNewsTemplateByAccount(postCode, accountid);
        return newsTemplateList;
    }

    @Override
    public List<NewsTemplate> getExpandTemplateByAccount(String accountid) {
        List<NewsTemplate> expandTemplateList = this.weixinMenuPersonalityDao.getExpandTemplateByAccount(accountid);
        return expandTemplateList;
    }

    @Override
    public List<WeixinAudiosucaiEntity> getVoiceTemplateByAccount(String accountid) {
        List<WeixinAudiosucaiEntity> voiceTemplateList = this.weixinMenuPersonalityDao.getVoiceTemplateByAccount(accountid);
        return voiceTemplateList;
    }

    @Override
    public List<WeixinVideosucaiEntity> getVideoTemplateByAccount(String accountid) {
        List<WeixinVideosucaiEntity> videoTemplateList = this.weixinMenuPersonalityDao.getVideoTemplateByAccount(accountid);
        return videoTemplateList;
    }

    @Override
    public List<WeixinPhotosucaiEntity> getImageTemplateByAccount(String accountid) {
        List<WeixinPhotosucaiEntity> imageTemplateList = this.weixinMenuPersonalityDao.getImageTemplateByAccount(accountid);
        return imageTemplateList;
    }

    @Override
    public List<WeixinLinksucaiEntity> getLinkTemplateByAccount(String accountid) {
        CommWeixinAccount account = this.weixinAccountDao.get(accountid);
        List<String> list = this.splitString(account.getPostCode(), 5);
        String postCode = this.populationInString(list);
        List<WeixinLinksucaiEntity> linkTemplateList = this.weixinMenuPersonalityDao.getLinkTemplateByAccount(postCode, accountid);
        return linkTemplateList;
    }

    public List<String> splitString(String str, int length) {
        int strLength;
        ArrayList<String> list = new ArrayList<String>();
        int i = strLength = str.length();
        while (i > 0) {
            list.add(str.substring(0, i));
            i -= length;
        }
        return list;
    }

    public String populationInString(List<String> list) {
        StringBuilder sb = new StringBuilder("");
        if (list.size() > 1) {
            int i = 0;
            while (i < list.size()) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'" + list.get(i) + "'");
                ++i;
            }
        }
        return sb.toString();
    }

    @Override
    public List<WeixinMenuPersonalityEntity> checkOrders(String id, String accountid, String orders) {
        List<WeixinMenuPersonalityEntity> list = this.weixinMenuPersonalityDao.checkOrders(accountid, id, orders);
        return list;
    }

    @Override
    public List<WeixinMenuPersonalityEntity> getMenusByFatherId(String fatherid, String accountid) {
        return this.weixinMenuPersonalityDao.getMenusByFatherId(fatherid, accountid);
    }

    @Override
    public void deleteAll() {
        this.weixinMenuPersonalityDao.deleteAll();
    }

    @Override
    public List<WeixinMenuPersonalityEntity> getChildMenusByPid(String pid) {
        return this.weixinMenuPersonalityDao.getChildMenusByPid(pid);
    }
}

