/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxuser.user;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.user.UserInfoListGet;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwUserAPI {
    private static Logger logger = LoggerFactory.getLogger(JwUserAPI.class);
    private static String GET_USER_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";

    public static Wxuser getWxuser(String accesstoken, String user_openid) throws WexinReqException {
        if (accesstoken != null) {
            String requestUrl = GET_USER_URL.replace("ACCESS_TOKEN", accesstoken).replace("OPENID", user_openid);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", null);
            logger.info(result.toString());
            Wxuser wxuser = null;
            Object error = result.get("errcode");
            wxuser = (Wxuser)JSONObject.toBean((JSONObject)result, Wxuser.class);
            return wxuser;
        }
        return null;
    }

    public static List<Wxuser> getAllWxuser(String accesstoken, String next_openid) throws WexinReqException {
        if (accesstoken != null) {
            UserInfoListGet userInfoListGet = new UserInfoListGet();
            userInfoListGet.setAccess_token(accesstoken);
            userInfoListGet.setNext_openid(next_openid);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userInfoListGet);
            Object error = result.get("errcode");
            ArrayList<Wxuser> lstUser = null;
            Wxuser mxuser = null;
            int total = result.getInt("total");
            int count = result.getInt("count");
            String strNextOpenId = result.getString("next_openid");
            JSONObject data = result.getJSONObject("data");
            lstUser = new ArrayList<Wxuser>(total);
            if (count > 0) {
                JSONArray lstOpenid = data.getJSONArray("openid");
                int iSize = lstOpenid.size();
                int i = 0;
                while (i < iSize) {
                    String openId = lstOpenid.getString(i);
                    mxuser = JwUserAPI.getWxuser(accesstoken, openId);
                    lstUser.add(mxuser);
                    ++i;
                }
                if (strNextOpenId != null) {
                    lstUser.addAll(JwUserAPI.getAllWxuser(accesstoken, strNextOpenId));
                }
            }
            return lstUser;
        }
        return null;
    }
}

