/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxuser.group;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.user.BatchGroupMembersUpdate;
import org.jeewx.api.core.req.model.user.Group;
import org.jeewx.api.core.req.model.user.GroupCreate;
import org.jeewx.api.core.req.model.user.GroupDelete;
import org.jeewx.api.core.req.model.user.GroupGet;
import org.jeewx.api.core.req.model.user.GroupGetId;
import org.jeewx.api.core.req.model.user.GroupMembersUpdate;
import org.jeewx.api.core.req.model.user.GroupUpdate;
import org.jeewx.api.core.util.WeiXinConstant;
import org.jeewx.api.wxbase.wxtoken.JwTokenAPI;

public class JwGroupAPI {
    private static String TOKEN = "GHFs1OHxNiwi9cKT_oUr53enRhSStZ7QpAOjoheRWKvJFR9JtPzEkO5KnepHOT7CnDzWghTjpMyEKsWy4IGiHxv-VS9f2BN7tF6sge-H8lo";
    public static String RETURN_INFO_NAME = "groups";

    public static GroupCreate createGroup(String accesstoken, String groupName) throws WexinReqException {
        GroupCreate c = new GroupCreate();
        c.setAccess_token(accesstoken);
        Group g = new Group();
        g.setName(groupName);
        c.setGroup(g);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(c);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        GroupCreate groupCreate = null;
        groupCreate = (GroupCreate)JSONObject.toBean((JSONObject)result, GroupCreate.class);
        return groupCreate;
    }

    public static List<Group> getAllGroup(String accesstoken) throws WexinReqException {
        GroupGet c = new GroupGet();
        c.setAccess_token(accesstoken);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(c);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        ArrayList<Group> lstGroup = null;
        JSONArray infoArray = result.getJSONArray(RETURN_INFO_NAME);
        lstGroup = new ArrayList<Group>(infoArray.size());
        int i = 0;
        while (i < infoArray.size()) {
            Group group = (Group)JSONObject.toBean((JSONObject)infoArray.getJSONObject(i), Group.class);
            if (!"\u672a\u5206\u7ec4".equals(group.getName())) {
                lstGroup.add(group);
            }
            ++i;
        }
        return lstGroup;
    }

    public static String getUserGroup(String accesstoken, String openid) throws WexinReqException {
        GroupGetId g = new GroupGetId();
        g.setAccess_token(accesstoken);
        g.setOpenid(openid);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(g);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        String groupId = "";
        groupId = result.getString("groupid");
        return groupId;
    }

    public static String updateGroup(String accesstoken, String groupId, String groupNewName) throws WexinReqException {
        GroupUpdate groupUpdate = new GroupUpdate();
        groupUpdate.setAccess_token(accesstoken);
        Group g = new Group();
        g.setId(groupId);
        g.setName(groupNewName);
        groupUpdate.setGroup(g);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(groupUpdate);
        return result.getString("errmsg");
    }

    public static String groupMemberMove(String accesstoken, String openid, String to_groupid) throws WexinReqException {
        GroupMembersUpdate u = new GroupMembersUpdate();
        u.setAccess_token(accesstoken);
        u.setOpenid(openid);
        u.setTo_groupid(to_groupid);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(u);
        return result.getString("errmsg");
    }

    public static String batchGroupMemberMove(String accesstoken, List<String> openid_list, String to_groupid) throws WexinReqException {
        BatchGroupMembersUpdate u = new BatchGroupMembersUpdate();
        u.setAccess_token(accesstoken);
        u.setOpenid_list(openid_list);
        u.setTo_groupid(to_groupid);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(u);
        return result.getString("errmsg");
    }

    public static String groupDelete(String accesstoken, String deletegGroupid) throws WexinReqException {
        GroupDelete group = new GroupDelete();
        Group g = new Group();
        g.setId(deletegGroupid);
        group.setAccess_token(accesstoken);
        group.setGroup(g);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(group);
        if ("{}".equals(result.toString().trim())) {
            return "ok";
        }
        return result.getString("errmsg");
    }

    public static void main(String[] args) {
        try {
            JwGroupAPI.getAccessToken();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getAccessToken() {
        try {
            TOKEN = JwTokenAPI.getAccessToken("wxd2b52b8f4bd5af7f", "1b982dba2c3f853c3396babcdfa6cb1e");
            System.out.println(TOKEN);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testCreateGroup() {
        try {
            GroupCreate group = JwGroupAPI.createGroup(TOKEN, "\u5206\u7ec42017");
            System.out.println("\u521b\u5efa\u7684\u5206\u7ec4ID:" + group.getGroup().getId());
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testUpdateGroup() {
        try {
            String errmsg = JwGroupAPI.updateGroup(TOKEN, "106", "\u5206\u7ec420172");
            System.out.println("\u66f4\u65b0\u5206\u7ec4\u4fe1\u606f:" + errmsg);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testGetAllGroup() {
        try {
            List<Group> groupList = JwGroupAPI.getAllGroup(TOKEN);
            for (Group g : groupList) {
                System.out.println(g.getName());
            }
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testGetUserGroup() {
        String openid = "oSmm-vhtoFwRo0kaqIxVnw8INSFg";
        try {
            String groupid = JwGroupAPI.getUserGroup(TOKEN, openid);
            System.out.println("\u8be5\u7c89\u4e1d\u6240\u5728\u5206\u7ec4\u4e3a:" + groupid);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testGroupMemberMove() {
        String openid = "oSmm-vjkfKrkIw94VKciV5JSG8io";
        try {
            String groupid = JwGroupAPI.groupMemberMove(TOKEN, openid, "2");
            System.out.println("\u8be5\u7c89\u4e1d\u6240\u5728\u5206\u7ec4\u4e3a:" + groupid);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testBatchGroupMemberMove() {
        ArrayList<String> openidList = new ArrayList<String>();
        String openid = "oSmm-vjkfKrkIw94VKciV5JSG8io";
        try {
            openidList.add(openid);
            String groupid = JwGroupAPI.batchGroupMemberMove(TOKEN, openidList, "101");
            System.out.println("\u8be5\u7c89\u4e1d\u6240\u5728\u5206\u7ec4\u4e3a:" + groupid);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    private static void testGroupDelete() {
        try {
            String errmsg = JwGroupAPI.groupDelete(TOKEN, "129");
            System.out.println("\u5220\u9664\u5206\u7ec4:" + errmsg);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

