/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxstore.product;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.poi.util.IOUtils;
import org.jeewx.api.core.common.JSONHelper;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.core.common.util.WeixinUtil;
import org.jeewx.api.wxstore.product.model.CateInfo;
import org.jeewx.api.wxstore.product.model.CommodityRtnInfo;
import org.jeewx.api.wxstore.product.model.Product;
import org.jeewx.api.wxstore.product.model.PropertiesInfo;
import org.jeewx.api.wxstore.product.model.SkuInfo;

public class JwProductAPI {
    private static String create_commodity_url = "https://api.weixin.qq.com/merchant/create?access_token=${ACCESS_TOKEN}";
    private static String update_commodity_url = "https://api.weixin.qq.com/merchant/update?access_token=ACCESS_TOKEN";
    private static String get_commodity_url = "https://api.weixin.qq.com/merchant/get?access_token=ACCESS_TOKEN";
    private static String del_commodity_url = "https://api.weixin.qq.com/merchant/del?access_token=ACCESS_TOKEN";
    private static String upload_img_commodity_url = "https://api.weixin.qq.com/merchant/common/upload_img?access_token=ACCESS_TOKEN&filename=IMG_NAME";
    private static String getbystatus_commodity_url = "https://api.weixin.qq.com/merchant/getbystatus?access_token=ACCESS_TOKEN";
    private static String modproductstatus_commodity_url = "https://api.weixin.qq.com/merchant/modproductstatus?access_token=ACCESS_TOKEN";
    private static String getsub_commodity_url = "https://api.weixin.qq.com/merchant/category/getsub?access_token=ACCESS_TOKEN";
    private static String getsku_commodity_url = "https://api.weixin.qq.com/merchant/category/getsku?access_token=ACCESS_TOKEN";
    private static String getproperty_commodity_url = "https://api.weixin.qq.com/merchant/category/getproperty?access_token=ACCESS_TOKEN";

    public static CommodityRtnInfo doAddCommodity(String newAccessToken, Product product) {
        if (newAccessToken != null) {
            String requestUrl = WeixinUtil.parseWeiXinHttpUrl(create_commodity_url, newAccessToken);
            JSONObject obj = JSONObject.fromObject((Object)product);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            CommodityRtnInfo commodityRtnInfo = (CommodityRtnInfo)JSONObject.toBean((JSONObject)result, CommodityRtnInfo.class);
            return commodityRtnInfo;
        }
        return null;
    }

    public static CommodityRtnInfo doDelCommodity(String newAccessToken, String product_id) {
        if (newAccessToken != null) {
            String requestUrl = del_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"product_id\": \"" + product_id + "\"}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", json);
            CommodityRtnInfo commodityRtnInfo = (CommodityRtnInfo)JSONObject.toBean((JSONObject)result, CommodityRtnInfo.class);
            return commodityRtnInfo;
        }
        return null;
    }

    public static CommodityRtnInfo doUpdateCommodity(String newAccessToken, Product product, String accountid) {
        if (newAccessToken != null) {
            String requestUrl = update_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            JSONObject obj = JSONObject.fromObject((Object)product);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            CommodityRtnInfo commodityRtnInfo = (CommodityRtnInfo)JSONObject.toBean((JSONObject)result, CommodityRtnInfo.class);
            return commodityRtnInfo;
        }
        return null;
    }

    public static Product getCommodity(String newAccessToken, String product_id) {
        if (newAccessToken != null) {
            String requestUrl = get_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"product_id\": \"" + product_id + "\"}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", json);
            Product product = null;
            JSONObject info = result.getJSONObject("product_info");
            product = (Product)JSONObject.toBean((JSONObject)info, Product.class);
            return product;
        }
        return null;
    }

    public static CommodityRtnInfo getByStatus(String newAccessToken, Integer status) {
        if (newAccessToken != null) {
            String requestUrl = getbystatus_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"status\": " + status + "}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", json);
            CommodityRtnInfo commodityRtnInfo = (CommodityRtnInfo)JSONObject.toBean((JSONObject)result, CommodityRtnInfo.class);
            return commodityRtnInfo;
        }
        return null;
    }

    public static String uploadImg(String newAccessToken, String filePath, String fileName) {
        if (newAccessToken != null) {
            String requestUrl = upload_img_commodity_url.replace("ACCESS_TOKEN", newAccessToken).replace("IMG_NAME", fileName);
            try {
                byte[] fileByte = JwProductAPI.fileData(String.valueOf(filePath) + fileName);
                JSONObject result = WxstoreUtils.httpRequest2(requestUrl, "POST", fileByte);
                if (result.getInt("errcode") == 0) {
                    return result.getString("image_url");
                }
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private static byte[] fileData(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] imageByteArray = null;
        fis = new FileInputStream(file);
        imageByteArray = IOUtils.toByteArray((InputStream)fis);
        return imageByteArray;
    }

    public static CommodityRtnInfo doModproductstatus(String newAccessToken, String product_id, Integer status) {
        if (newAccessToken != null) {
            String requestUrl = modproductstatus_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"product_id\":\"" + product_id + "\",\"status\": " + status + "}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", json);
            CommodityRtnInfo commodityRtnInfo = (CommodityRtnInfo)JSONObject.toBean((JSONObject)result, CommodityRtnInfo.class);
            return commodityRtnInfo;
        }
        return null;
    }

    public static List<CateInfo> getCateSub(String newAccessToken, Integer cate_id) {
        if (newAccessToken != null) {
            String requestUrl = getsub_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"cate_id\": " + cate_id + "}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", json);
            List<CateInfo> cateInfos = null;
            JSONArray info = result.getJSONArray("cate_list");
            cateInfos = JSONHelper.toList(info, CateInfo.class);
            return cateInfos;
        }
        return null;
    }

    public static List<SkuInfo> getCateSubSku(String newAccessToken, Integer cate_id) {
        if (newAccessToken != null) {
            String requestUrl = getsku_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"cate_id\": " + cate_id + "}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", json);
            List<SkuInfo> skuInfos = null;
            JSONArray info = result.getJSONArray("sku_table");
            skuInfos = JSONHelper.toList(info, SkuInfo.class);
            return skuInfos;
        }
        return null;
    }

    public static List<PropertiesInfo> getPropertyByCateId(String newAccessToken, Integer cate_id) {
        if (newAccessToken != null) {
            String requestUrl = getproperty_commodity_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"cate_id\": " + cate_id + "}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", json);
            List<PropertiesInfo> propertiesInfos = null;
            JSONArray info = result.getJSONArray("properties");
            propertiesInfos = JSONHelper.toList(info, PropertiesInfo.class);
            return propertiesInfos;
        }
        return null;
    }
}

