/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxsendmsg;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.kfaccount.KfOnlineAccountList;
import org.jeewx.api.core.req.model.kfaccount.KfaccountAdd;
import org.jeewx.api.core.req.model.kfaccount.KfaccountDel;
import org.jeewx.api.core.req.model.kfaccount.KfaccountList;
import org.jeewx.api.core.req.model.kfaccount.KfaccountUpdate;
import org.jeewx.api.core.req.model.kfaccount.KfaccountUploadheadimg;
import org.jeewx.api.core.req.model.kfaccount.KfcustomSend;
import org.jeewx.api.core.util.WeiXinConstant;
import org.jeewx.api.wxsendmsg.model.WxKfaccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwKfaccountAPI {
    private static Logger logger = LoggerFactory.getLogger(JwKfaccountAPI.class);

    public static String addKfacount(String accessToken, String kf_account, String nickname, String password) throws WexinReqException {
        KfaccountAdd kf = new KfaccountAdd();
        kf.setAccess_token(accessToken);
        kf.setKf_account(kf_account);
        kf.setNickname(nickname);
        kf.setPassword(password);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kf);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static String modifyKfaccount(String accessToken, String kf_account, String nickname, String password) throws WexinReqException {
        KfaccountUpdate kfUp = new KfaccountUpdate();
        kfUp.setAccess_token(accessToken);
        kfUp.setKf_account(kf_account);
        kfUp.setNickname(nickname);
        kfUp.setPassword(password);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfUp);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static String deleteKfaccount(String accessToken, String kf_account, String nickname, String password) throws WexinReqException {
        KfaccountDel kfdel = new KfaccountDel();
        kfdel.setAccess_token(accessToken);
        kfdel.setKf_account(kf_account);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfdel);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static String uploadKfaccountHeadimg(String accessToken, String kf_account, String filePathName) throws WexinReqException {
        KfaccountUploadheadimg kfUpload = new KfaccountUploadheadimg();
        kfUpload.setAccess_token(accessToken);
        kfUpload.setFilePathName(filePathName);
        kfUpload.setKf_account(kf_account);
        kfUpload.setType("image");
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfUpload);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static List<WxKfaccount> getAllKfaccount(String accessToken) throws WexinReqException {
        KfaccountList kfGet = new KfaccountList();
        kfGet.setAccess_token(accessToken);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfGet);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        ArrayList<WxKfaccount> lstWxKfaccount = null;
        JSONArray kf_list = result.getJSONArray("kf_list");
        lstWxKfaccount = new ArrayList<WxKfaccount>();
        WxKfaccount kfaccount = null;
        int i = 0;
        while (i < kf_list.size()) {
            kfaccount = (WxKfaccount)JSONObject.toBean((JSONObject)kf_list.getJSONObject(i), WxKfaccount.class);
            lstWxKfaccount.add(kfaccount);
            ++i;
        }
        return lstWxKfaccount;
    }

    public static String sendKfMessage(KfcustomSend kfcustomSend) throws WexinReqException {
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfcustomSend);
        String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
        return msg;
    }

    public static List<WxKfaccount> getAllOnlineKfaccount(String accessToken) throws WexinReqException {
        KfOnlineAccountList kfGet = new KfOnlineAccountList();
        kfGet.setAccess_token(accessToken);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(kfGet);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        ArrayList<WxKfaccount> lstWxKfaccount = null;
        JSONArray kf_list = result.getJSONArray("kf_online_list");
        lstWxKfaccount = new ArrayList<WxKfaccount>();
        WxKfaccount kfaccount = null;
        int i = 0;
        while (i < kf_list.size()) {
            kfaccount = (WxKfaccount)JSONObject.toBean((JSONObject)kf_list.getJSONObject(i), WxKfaccount.class);
            lstWxKfaccount.add(kfaccount);
            ++i;
        }
        return lstWxKfaccount;
    }

    public static void main(String[] args) {
        try {
            String s = "qQo8f2B0D0ZnlTP-8TKOMWoDcGiCoAhICn09S_QKxMgpSVp0VG8rgg_8PAJhy893z4lU-kY89DsZAsC3M54zxQBxuwTehg2nC_dO75VEGqw";
            List<WxKfaccount> ls = JwKfaccountAPI.getAllOnlineKfaccount(s);
            for (WxKfaccount a : ls) {
                System.out.println(String.valueOf(a.getKf_account()) + "---" + a.getKf_id() + a.getKf_nick());
                System.out.println(a.getKf_headimgurl());
            }
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

