/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.coupon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jeewx.api.core.common.AccessToken;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.coupon.manage.JwCardManageAPI;
import org.jeewx.api.coupon.manage.model.BatchGetCardRtnInfo;
import org.jeewx.api.coupon.manage.model.CardUpdate;
import org.jeewx.api.coupon.manage.model.CommCardRtnInfo;
import org.jeewx.api.coupon.manage.model.DelRtnInfo;
import org.jeewx.api.coupon.manage.model.GetCardDetailRtnInfo;
import org.jeewx.api.coupon.manage.model.GetCardRtnInfo;
import org.jeewx.api.coupon.qrcode.JwQrcodeAPI;
import org.jeewx.api.coupon.qrcode.model.GetticketRtn;

public class JwCardManageAPITest {
    private static String appid = "wxd2b52b8f4bd5af7f";
    private static String appscret = "1b982dba2c3f853c3396babcdfa6cb1e";

    public static void main1(String[] args) {
        AccessToken atoken = new AccessToken(appid, appscret);
        String newAccessToken = atoken.getNewAccessToken();
        List<String> ls = JwCardManageAPITest.getCardList(newAccessToken);
        for (String p : ls) {
            GetCardDetailRtnInfo rtnInfo = JwCardManageAPI.doGetCardDetail(newAccessToken, p);
            if (!rtnInfo.getCard().getCard_type().equals("CASH")) continue;
            System.out.println(rtnInfo.getCard().getCash().getReduce_cost() / 100);
        }
    }

    public static void main(String[] args) {
        AccessToken atoken = new AccessToken(appid, appscret);
        String newAccessToken = atoken.getNewAccessToken();
        try {
            GetticketRtn s = JwQrcodeAPI.doGetticket(newAccessToken);
            System.out.println(s.getTicket());
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getCardList(String newAccessToken) {
        BatchGetCardRtnInfo rtnInfo = null;
        rtnInfo = JwCardManageAPI.doBatchGetCard(newAccessToken, 0, 50);
        if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
            System.out.println("");
            System.out.println("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff1a card_id_list: " + rtnInfo.getCard_id_list());
            return rtnInfo.getCard_id_list();
        }
        System.out.println("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a[" + rtnInfo.getErrmsg() + "]");
        return null;
    }

    public static boolean doBatchGetCardTest(String newAccessToken) {
        BatchGetCardRtnInfo rtnInfo = null;
        Map<String, Integer> onecase = null;
        List<Map<String, Integer>> testCases = JwCardManageAPITest.doBatchGetCardParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doBatchGetCard[\u6279\u91cf\u67e5\u8be2\u5361\u5217\u8868]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doBatchGetCard(newAccessToken, onecase.get("offset"), onecase.get("count"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("card_id_list: " + rtnInfo.getCard_id_list());
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doBatchGetCard[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doBatchGetCard\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, Integer>> doBatchGetCardParam() {
        HashMap<String, Integer> onecase = null;
        ArrayList<Map<String, Integer>> testCases = new ArrayList<Map<String, Integer>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, Integer>();
            onecase.put("offset", JwCardManageAPITest.randomInt(1));
            onecase.put("count", JwCardManageAPITest.randomInt(2));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doDelCardTest(String newAccessToken) {
        DelRtnInfo rtnInfo = null;
        Map<String, String> onecase = null;
        List<Map<String, String>> testCases = JwCardManageAPITest.doDelCardParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doDelCard[\u5220\u9664\u5361\u5238]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doDelCard(newAccessToken, onecase.get("card_id"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doDelCard[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doDelCard[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doDelCard\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, String>> doDelCardParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, String>> testCases = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doGetCardDetailTest(String newAccessToken) {
        GetCardDetailRtnInfo rtnInfo = null;
        Map<String, String> onecase = null;
        List<Map<String, String>> testCases = JwCardManageAPITest.doGetCardDetailParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doGetCardDetail[\u67e5\u8be2\u5361\u5238\u8be6\u60c5]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doGetCardDetail(newAccessToken, onecase.get("card_id"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doGetCardDetail[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doGetCardDetail[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doGetCardDetail\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, String>> doGetCardDetailParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, String>> testCases = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doGetCardTest(String newAccessToken) {
        GetCardRtnInfo rtnInfo = null;
        Map<String, String> onecase = null;
        List<Map<String, String>> testCases = JwCardManageAPITest.doGetCardParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doGetCard[\u67e5\u8be2\u5361\u5238]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doGetCard(newAccessToken, onecase.get("code"), onecase.get("card_id"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doGetCard[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doGetCard[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doGetCard\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, String>> doGetCardParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, String>> testCases = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("code", JwCardManageAPITest.randomStr(32));
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doModifystockCardTest(String newAccessToken) {
        CommCardRtnInfo rtnInfo = null;
        Map<String, String> onecase = null;
        List<Map<String, String>> testCases = JwCardManageAPITest.doModifystockCardParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doModifystockCard[\u66f4\u6539\u5e93\u5b58]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doModifystockCard(newAccessToken, onecase.get("card_id"), Integer.parseInt(onecase.get("increase_stock_value")), Integer.parseInt(onecase.get("reduce_stock_value")));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doModifystockCard[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doModifystockCard[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doModifystockCard\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, String>> doModifystockCardParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, String>> testCases = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            onecase.put("increase_stock_value", "" + JwCardManageAPITest.randomInt(1));
            onecase.put("reduce_stock_value", "" + JwCardManageAPITest.randomInt(2));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doUnavailableCodeTest(String newAccessToken) {
        CommCardRtnInfo rtnInfo = null;
        Map<String, String> onecase = null;
        List<Map<String, String>> testCases = JwCardManageAPITest.doUnavailableCodeParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doUnavailableCode[\u5361\u5238\u8bbe\u7f6e\u4e3a\u5931\u6548\u72b6\u6001]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doUnavailableCode(newAccessToken, onecase.get("code"), onecase.get("card_id"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doUnavailableCode[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doUnavailableCode[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doUnavailableCode\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, String>> doUnavailableCodeParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, String>> testCases = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            onecase.put("code", JwCardManageAPITest.randomStr(32));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doUpdateCardTest(String newAccessToken) {
        CommCardRtnInfo rtnInfo = null;
        Map<String, Object> onecase = null;
        List<Map<String, Object>> testCases = JwCardManageAPITest.doUpdateCardParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doUpdateCard[\u66f4\u65b0\u5361\u5238]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doUpdateCard(newAccessToken, (CardUpdate)onecase.get("cardUpdate"));
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doUpdateCard[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doUpdateCard[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doUpdateCard\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, Object>> doUpdateCardParam() {
        HashMap<String, CardUpdate> onecase = null;
        ArrayList<Map<String, Object>> testCases = new ArrayList<Map<String, Object>>();
        CardUpdate cardUpdate = new CardUpdate();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, CardUpdate>();
            onecase.put("cardUpdate", cardUpdate);
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    public static boolean doUpdateCodeTest(String newAccessToken) {
        CommCardRtnInfo rtnInfo = null;
        Map<String, Object> onecase = null;
        List<Map<String, Object>> testCases = JwCardManageAPITest.doUpdateCodeParam();
        int len = testCases.size();
        int pass = 0;
        int fail = 0;
        try {
            System.out.println("=========JwCardManageAPI.doUpdateCode[\u66f4\u6539code]\u5f00\u59cb\u6d4b\u8bd5==========");
            int i = 0;
            while (i < len) {
                onecase = testCases.get(i);
                rtnInfo = JwCardManageAPI.doUpdateCode(newAccessToken, onecase.get("code").toString(), onecase.get("card_id").toString(), onecase.get("new_code").toString());
                if (Integer.parseInt(rtnInfo.getErrcode()) == 0) {
                    ++pass;
                    System.out.println("JwCardManageAPI.doUpdateCode[" + i + "]" + ":\u6210\u529f");
                } else {
                    ++fail;
                    System.out.println("JwCardManageAPI.doUpdateCode[" + i + "]" + ":\u5931\u8d25" + "[" + rtnInfo.getErrmsg() + "]");
                }
                Thread.sleep(1000L);
                ++i;
            }
            System.out.println("==============JwCardManageAPI.doUpdateCode\u6d4b\u8bd5\u7ed3\u679c=================");
            System.out.println("====================\u5171\u8ba1\u6d4b\u8bd5\u7528\u4f8b:[" + len + "\u4e2a]====================");
            System.out.println("====================\u6210\u529f\u6d4b\u8bd5\u7528\u4f8b:[" + pass + "\u4e2a]====================");
            System.out.println("====================\u5931\u8d25\u6d4b\u8bd5\u7528\u4f8b:[" + fail + "\u4e2a]====================");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static List<Map<String, Object>> doUpdateCodeParam() {
        HashMap<String, String> onecase = null;
        ArrayList<Map<String, Object>> testCases = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < 5) {
            onecase = new HashMap<String, String>();
            onecase.put("code", JwCardManageAPITest.randomStr(32));
            onecase.put("card_id", JwCardManageAPITest.randomStr(32));
            onecase.put("new_code", JwCardManageAPITest.randomStr(32));
            testCases.add(onecase);
            ++i;
        }
        return testCases;
    }

    private static String randomStr(int len) {
        String BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            int number = random.nextInt(BASE.length());
            sb.append(BASE.charAt(number));
            ++i;
        }
        return sb.toString();
    }

    private static Integer randomInt(int len) {
        String BASE = "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            int number = random.nextInt(BASE.length());
            sb.append(BASE.charAt(number));
            ++i;
        }
        return Integer.parseInt(sb.toString());
    }
}

