/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.util;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jeewx.api.core.handler.WeiXinReqHandler;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.WeixinReqConfig;
import org.jeewx.api.core.req.model.WeixinReqParam;
import org.jeewx.api.core.util.WeiXinConstant;

public class WeiXinReqUtil {
    private static Logger logger = Logger.getLogger(WeiXinReqUtil.class);
    private static Map<String, WeixinReqConfig> REQ_MAPPING = new HashMap<String, WeixinReqConfig>();
    private static Map<String, WeiXinReqHandler> MAPPING_HANDLER = new HashMap<String, WeiXinReqHandler>();
    private static Properties file_content_type = null;

    public static Object getObjectByClassName(String className) {
        Class<?> obj = null;
        try {
            obj = Class.forName(className);
            return obj.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static void initReqConfig(String configName) throws JDOMException, IOException {
        InputStream is = WeiXinReqService.class.getClassLoader().getResourceAsStream(configName);
        SAXBuilder xmlBuilder = new SAXBuilder();
        Document doc = xmlBuilder.build(is);
        Element objRoot = doc.getRootElement();
        List lstMapping = objRoot.getChildren("req");
        WeixinReqConfig objConfig = null;
        for (Element mapping : lstMapping) {
            String key = mapping.getAttribute("key").getValue();
            String method = mapping.getAttribute("method").getValue();
            String url = mapping.getAttribute("url").getValue();
            String mappingHandler = "org.jeewx.api.core.handler.impl.WeixinReqDefaultHandler";
            String datatype = WeiXinConstant.PARAM_DATA_TYPE;
            if (mapping.getAttribute("mappingHandler") != null) {
                mappingHandler = mapping.getAttribute("mappingHandler").getValue();
            }
            if (mapping.getAttribute("datatype") != null) {
                datatype = mapping.getAttribute("datatype").getValue();
            }
            objConfig = new WeixinReqConfig();
            objConfig.setKey(key);
            objConfig.setMappingHandler(mappingHandler);
            objConfig.setMethod(method);
            objConfig.setUrl(url);
            objConfig.setDatatype(datatype);
            WeiXinReqUtil.registerMapping(key, objConfig);
        }
    }

    public static void registerMapping(String key, WeixinReqConfig weixinReqConfig) {
        REQ_MAPPING.put(key, weixinReqConfig);
    }

    public static WeixinReqConfig getWeixinReqConfig(String key) {
        return REQ_MAPPING.get(key);
    }

    public static WeiXinReqHandler getMappingHander(String className) {
        WeiXinReqHandler handler = MAPPING_HANDLER.get(className);
        if (handler == null) {
            handler = (WeiXinReqHandler)WeiXinReqUtil.getObjectByClassName(className);
            MAPPING_HANDLER.put(className, handler);
        }
        return handler;
    }

    public static Map getWeixinReqParam(WeixinReqParam weixinReqParam) {
        Gson gson = new Gson();
        HashMap<String, String> params = null;
        try {
            String json = gson.toJson((Object)weixinReqParam);
            params = (HashMap<String, String>)gson.fromJson(json, Map.class);
        }
        catch (Exception e) {
            logger.error((Object)"\u5904\u7406\u53c2\u6570\u89e3\u6790\u51fa\u9519", (Throwable)e);
            params = new HashMap<String, String>();
            params.put("access_token", weixinReqParam.getAccess_token());
        }
        return params;
    }

    public static String getWeixinParamJson(WeixinReqParam weixinReqParam) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)weixinReqParam);
        return json;
    }

    public static String getFileContentType(String fileSuffix) {
        if (file_content_type == null) {
            file_content_type = new Properties();
            InputStream in = WeiXinReqService.class.getClassLoader().getResourceAsStream("fie-content-type.properties");
            try {
                file_content_type.load(in);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                file_content_type = new Properties();
            }
        }
        return (String)file_content_type.get(fileSuffix);
    }

    public static String getFileSuffix(String contentType) {
        if (file_content_type == null) {
            file_content_type = new Properties();
            InputStream in = WeiXinReqService.class.getClassLoader().getResourceAsStream("fie-content-type.properties");
            try {
                file_content_type.load(in);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String fileSuffix = "";
        Set<Map.Entry<Object, Object>> type = file_content_type.entrySet();
        for (Map.Entry<Object, Object> entity : type) {
            if (!entity.getValue().equals(contentType)) continue;
            fileSuffix = (String)entity.getKey();
            break;
        }
        return fileSuffix;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        String realPath = WeiXinReqUtil.class.getClassLoader().getResource("").getFile();
        System.out.println(realPath);
        WeiXinReqUtil.initReqConfig("weixin-reqcongfig.xml");
    }
}

