/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONObject;
import org.jeewx.api.core.common.MyX509TrustManager;
import org.jeewx.api.core.exception.WexinReqException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WxstoreUtils {
    private static Logger logger = LoggerFactory.getLogger(WxstoreUtils.class);

    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        logger.debug("*********HTTPREQUEST START********");
        logger.debug("*********requestUrl is " + requestUrl + " END AND requestMethod IS" + requestMethod + " END AND  outputStr" + outputStr + " END ********");
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
            if (jsonObject.containsKey((Object)"errcode") && jsonObject.getInt("errcode") != 0) {
                logger.debug("********* ERROR********{}", (Object)buffer.toString());
                logger.debug("*********HTTPREQUEST END********");
                throw new WexinReqException("httpRequest Method\uff01errcode=" + jsonObject.getString("errcode") + ",errmsg = " + jsonObject.getString("errmsg"));
            }
            logger.debug("********* SUCCESS END********");
        }
        catch (ConnectException ce) {
            System.out.println("Weixin server connection timed out.");
        }
        catch (Exception e) {
            System.out.println("https request error:{}" + e.getMessage());
        }
        return jsonObject;
    }

    public static JSONObject httpRequest2(String requestUrl, String requestMethod, byte[] outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr);
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
        }
        catch (ConnectException ce) {
            System.out.print("Weixin server connection timed out.");
        }
        catch (Exception e) {
            System.out.print("https request error:{}" + e.getMessage());
        }
        return jsonObject;
    }

    public static void saveHttpImage(String requestUrl, String requestMethod, String outputStr, File target) {
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            InputStream inStream = conn.getInputStream();
            byte[] data = WxstoreUtils.readInputStream(inStream);
            FileOutputStream outStream = new FileOutputStream(target);
            outStream.write(data);
            outStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String encode(byte[] bstr) {
        return new BASE64Encoder().encode(bstr);
    }

    public static byte[] decode(String str) {
        byte[] bt = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            bt = decoder.decodeBuffer(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bt;
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inStream.read(buffer)) != -1) {
            outstream.write(buffer, 0, len);
        }
        outstream.close();
        inStream.close();
        return outstream.toByteArray();
    }

    public static JSONObject uploadMediaFile(String requestUrl, File file, String content_type) {
        JSONObject jsonObject = null;
        StringBuffer bufferStr = new StringBuffer();
        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        URL submit = null;
        FilterOutputStream dos = null;
        BufferedInputStream bufin = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                submit = new URL(requestUrl);
                HttpURLConnection conn = (HttpURLConnection)submit.openConnection();
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setConnectTimeout(10000);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                dos = new DataOutputStream(conn.getOutputStream());
                ((DataOutputStream)dos).writeBytes(String.valueOf(twoHyphens) + boundary + end);
                ((DataOutputStream)dos).writeBytes("Content-Disposition: form-data; name=\"" + file + "\";filename=\"" + file.getName() + ";Content-Type=\"" + content_type + end);
                ((DataOutputStream)dos).writeBytes(end);
                bufin = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[8192];
                int count = 0;
                while ((count = bufin.read(buffer)) != -1) {
                    ((DataOutputStream)dos).write(buffer, 0, count);
                }
                bufin.close();
                ((DataOutputStream)dos).writeBytes(end);
                ((DataOutputStream)dos).writeBytes(String.valueOf(twoHyphens) + boundary + twoHyphens + end);
                ((DataOutputStream)dos).flush();
                InputStream inputStream = conn.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                String str = null;
                while ((str = bufferedReader.readLine()) != null) {
                    bufferStr.append(str);
                }
                jsonObject = JSONObject.fromObject((Object)bufferStr.toString());
            }
            catch (Exception e) {
                System.err.println("\u5f02\u5e38\u9519\u8bef:" + e.toString());
                System.err.println("\u8fde\u63a5\u5730\u5740\u662f:" + requestUrl);
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return jsonObject;
    }

    public static JSONObject uploadMediaFileNews(String requestUrl, File file, String content_type) {
        String result = null;
        JSONObject jsonObject = null;
        URL submit = null;
        if (!file.exists() || !file.isFile()) {
            logger.info("------------\u6587\u4ef6\u4e0d\u5b58\u5728------------------------");
        } else {
            try {
                submit = new URL(requestUrl);
                HttpURLConnection conn = (HttpURLConnection)submit.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Charset", "UTF-8");
                String BOUNDARY = "----------" + System.currentTimeMillis();
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"media\";filename=\"" + file.getName() + "\"\r\n");
                sb.append("Content-Type:application/octet-stream\r\n\r\n");
                byte[] head = sb.toString().getBytes("utf-8");
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                ((OutputStream)out).write(head);
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = in.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                in.close();
                byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
                ((OutputStream)out).write(foot);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line);
                        }
                        result = buffer.toString();
                    }
                    catch (IOException e) {
                        logger.info("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                        e.printStackTrace();
                        throw new IOException("\u6570\u636e\u8bfb\u53d6\u5f02\u5e38");
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                jsonObject = JSONObject.fromObject((Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        String url = "https://api.weibo.com/oauth2/access_token?client_id=3016130400&client_secret=70f22fb9106282e6b5fb55a354f6da43&grant_type=authorization_code&code=9c15c07ea807274c7c413e1d9055d92d&redirect_uri=http://open.weibo.com";
        JSONObject httpRequest = WxstoreUtils.httpRequest(url, "POST", null);
        System.err.println(httpRequest);
    }
}

