/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.custservice.multicustservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import org.jeewx.api.core.common.JSONHelper;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.custservice.multicustservice.model.ChatRecord;
import org.jeewx.api.custservice.multicustservice.model.CustService;

public class JwMultiCustomerAPI {
    private static final String TRANSFER_CUSTOMER_SERVICE = "transfer_customer_service";
    private static String GET_ONLINE_CUSTSEVICE_URL = "https://api.weixin.qq.com/cgi-bin/customservice/getonlinekflist?access_token=ACCESS_TOKEN";
    private static String GET_CUSTSEVICE_ROCORD_LIST_URL = "https://api.weixin.qq.com/cgi-bin/customservice/getrecord?access_token=ACCESS_TOKEN";

    public String getMultiCustServcieMessage(String toUserName, String fromUserName) {
        StringBuilder custServiceMessage = new StringBuilder();
        custServiceMessage.append("<xml>");
        custServiceMessage.append("<ToUserName><![CDATA[" + toUserName + "]]></ToUserName>");
        custServiceMessage.append("<FromUserName><![CDATA[" + fromUserName + "]]></FromUserName>");
        custServiceMessage.append("<CreateTime>" + new Date().getTime() + "</CreateTime>");
        custServiceMessage.append("<MsgType><![CDATA[transfer_customer_service]]></MsgType>");
        custServiceMessage.append("</xml>");
        return custServiceMessage.toString();
    }

    public String getSpecCustServcie(String accessToken, String toUserName, String fromUserName, String kfAccount) {
        if (this.isOnlineCustServiceAvailable(accessToken, kfAccount)) {
            StringBuilder custServiceMessage = new StringBuilder();
            custServiceMessage.append("<xml>");
            custServiceMessage.append("<ToUserName><![CDATA[" + toUserName + "]]></ToUserName>");
            custServiceMessage.append("<FromUserName><![CDATA[" + fromUserName + "]]></FromUserName>");
            custServiceMessage.append("<CreateTime>" + new Date().getTime() + "</CreateTime>");
            custServiceMessage.append("<MsgType><![CDATA[transfer_customer_service]]></MsgType>");
            custServiceMessage.append("<TransInfo>");
            custServiceMessage.append("<KfAccount><![CDATA[" + kfAccount + "]]></KfAccount>");
            custServiceMessage.append("</TransInfo>");
            custServiceMessage.append("</xml>");
            return custServiceMessage.toString();
        }
        return null;
    }

    public boolean isOnlineCustServiceAvailable(String accessToken, String kfAccount) {
        String requestUrl;
        JSONObject result;
        List<CustService> custServices = null;
        if (accessToken != null && (result = WxstoreUtils.httpRequest(requestUrl = GET_ONLINE_CUSTSEVICE_URL.replace("ACCESS_TOKEN", accessToken), "GET", null)) != null) {
            JSONArray info = result.getJSONArray("kf_online_list");
            custServices = JSONHelper.toList(info, CustService.class);
        }
        if (custServices != null && !custServices.isEmpty()) {
            for (CustService custService : custServices) {
                if (custService == null || !custService.getKfAccount().equals(kfAccount) || custService.getStatus() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<ChatRecord> getCustServiceRecordList(String accessToken, String openId, long startTime, long endTime, int pageSize, int pageIndex) {
        List<ChatRecord> chatRecods = null;
        if (accessToken != null && startTime >= 0L && endTime >= 0L && pageSize >= 0 && pageIndex > 0) {
            String requestUrl = GET_CUSTSEVICE_ROCORD_LIST_URL.replace("ACCESS_TOKEN", accessToken);
            StringBuilder jsonStrBuilder = new StringBuilder();
            jsonStrBuilder.append("{");
            jsonStrBuilder.append("\"starttime\":" + startTime + ",");
            jsonStrBuilder.append("\"endtime\":" + endTime + ",");
            if (openId != null && !openId.equals("")) {
                jsonStrBuilder.append("\"openid\":\"" + openId + "\",");
            }
            jsonStrBuilder.append("\"pagesize\":" + pageSize + ",");
            jsonStrBuilder.append("\"pageindex\":" + pageIndex + ",");
            jsonStrBuilder.append("}");
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", jsonStrBuilder.toString());
            if (result != null) {
                JSONArray info = result.getJSONArray("recordlist");
                chatRecods = JSONHelper.toList(info, ChatRecord.class);
            }
            return chatRecods;
        }
        return null;
    }
}

