/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.p3.cg.factory;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.cg.ColumnData;
import org.jeecgframework.p3.cg.CommonPageParser;
import org.jeecgframework.p3.cg.CreateBean;
import org.jeecgframework.p3.cg.def.CodeResourceUtil;
import org.jeecgframework.p3.cg.def.FreemarkerEngine;

public class CodeGenerateFactory {
    private static final Log log = LogFactory.getLog(CodeGenerateFactory.class);
    private static String url = CodeResourceUtil.URL;
    private static String username = CodeResourceUtil.USERNAME;
    private static String passWord = CodeResourceUtil.PASSWORD;
    private static String buss_package = CodeResourceUtil.bussiPackage;

    public static void codeGenerateByVM(String tableName, String codeName, String keyType) {
        try {
            CreateBean createBean = new CreateBean();
            createBean.setMysqlInfo(url, username, passWord);
            String className = createBean.getTablesNameToClassName(tableName);
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            String tableNameUpper = tableName.toUpperCase();
            String tablesAsName = createBean.getTablesASName(tableName);
            if (StringUtils.isEmpty((String)codeName)) {
                Map<String, String> tableCommentMap = createBean.getTableCommentMap();
                codeName = tableCommentMap.get(tableNameUpper);
            }
            String sqlmapPathSrc = CodeResourceUtil.getConfigInfo("sqlmap_path_src");
            String domainPathSrc = CodeResourceUtil.getConfigInfo("domain_path_src");
            String daoPathSrc = CodeResourceUtil.getConfigInfo("dao_path_src");
            String daoImplPathSrc = CodeResourceUtil.getConfigInfo("dao_impl_path_src");
            String managerPathSrc = CodeResourceUtil.getConfigInfo("manager_path_src");
            String managerImplPathSrc = CodeResourceUtil.getConfigInfo("manager_impl_path_src");
            String servicePathSrc = CodeResourceUtil.getConfigInfo("service_path_src");
            String serviceImplPathSrc = CodeResourceUtil.getConfigInfo("service_impl_path_src");
            String sqlmapPackage = CodeResourceUtil.getConfigInfo("sqlmap_path");
            String domainPackage = CodeResourceUtil.getConfigInfo("domain_path");
            String daoPackage = CodeResourceUtil.getConfigInfo("dao_path");
            String daoImplPackage = CodeResourceUtil.getConfigInfo("dao_impl_path");
            String managerPackage = CodeResourceUtil.getConfigInfo("manager_path");
            String managerImplPackage = CodeResourceUtil.getConfigInfo("manager_impl_path");
            String servicePackage = CodeResourceUtil.getConfigInfo("service_path");
            String serviceImplPackage = CodeResourceUtil.getConfigInfo("service_impl_path");
            String sqlMapperPath = String.valueOf(sqlmapPackage.replace(".", "\\")) + "\\" + tableNameUpper + ".xml";
            String domainPath = String.valueOf(domainPackage.replace(".", "\\")) + "\\" + className + ".java";
            String daoPath = String.valueOf(daoPackage.replace(".", "\\")) + "\\" + className + "Dao.java";
            String daoImplPath = String.valueOf(daoImplPackage.replace(".", "\\")) + "\\" + className + "DaoImpl.java";
            String managerPath = String.valueOf(managerPackage.replace(".", "\\")) + "\\" + className + "Manager.java";
            String managerImplPath = String.valueOf(managerImplPackage.replace(".", "\\")) + "\\" + className + "ManagerImpl.java";
            String servicePath = String.valueOf(servicePackage.replace(".", "\\")) + "\\" + className + "Service.java";
            String serviceImplPath = String.valueOf(serviceImplPackage.replace(".", "\\")) + "\\" + className + "ServiceImpl.java";
            String sqlMapperFlag = CodeResourceUtil.getConfigInfo("sqlmap_flag");
            String domainFlag = CodeResourceUtil.getConfigInfo("domain_flag");
            String daoFlag = CodeResourceUtil.getConfigInfo("dao_flag");
            String daoImplFlag = CodeResourceUtil.getConfigInfo("dao_impl_flag");
            String managerFlag = CodeResourceUtil.getConfigInfo("manager_flag");
            String managerImplFlag = CodeResourceUtil.getConfigInfo("manager_impl_flag");
            String serviceFlag = CodeResourceUtil.getConfigInfo("service_flag");
            String serviceImplFlag = CodeResourceUtil.getConfigInfo("service_impl_flag");
            VelocityContext context = new VelocityContext();
            context.put("className", (Object)className);
            context.put("lowerName", (Object)lowerName);
            context.put("codeName", (Object)codeName);
            context.put("tableName", (Object)tableName);
            context.put("tableNameUpper", (Object)tableNameUpper);
            context.put("tablesAsName", (Object)tablesAsName);
            context.put("bussPackage", (Object)buss_package);
            context.put("domainPackage", (Object)domainPackage);
            context.put("daoPackage", (Object)daoPackage);
            context.put("daoImplPackage", (Object)daoImplPackage);
            context.put("managerPackage", (Object)managerPackage);
            context.put("managerImplPackage", (Object)managerImplPackage);
            context.put("servicePackage", (Object)servicePackage);
            context.put("serviceImplPackage", (Object)serviceImplPackage);
            context.put("keyType", (Object)keyType);
            context.put("feilds", (Object)createBean.getBeanFeilds(tableName, className));
            Map<String, Object> sqlMap = createBean.getAutoCreateSql(tableName);
            List<ColumnData> columnDatas = createBean.getColumnDatas(tableName);
            context.put("columnDatas", columnDatas);
            List<ColumnData> columnKeyDatas = createBean.getColumnKeyDatas(columnDatas);
            context.put("columnKeyDatas", columnKeyDatas);
            context.put("SQL", sqlMap);
            if ("Y".equals(sqlMapperFlag)) {
                CommonPageParser.WriterPage(context, "sqlmap.vm", sqlmapPathSrc, sqlMapperPath);
            }
            if ("Y".equals(domainFlag)) {
                CommonPageParser.WriterPage(context, "domainClass.vm", domainPathSrc, domainPath);
            }
            if ("Y".equals(daoFlag)) {
                CommonPageParser.WriterPage(context, "daoClass.vm", daoPathSrc, daoPath);
            }
            if ("Y".equals(daoImplFlag)) {
                CommonPageParser.WriterPage(context, "daoImplClass.vm", daoImplPathSrc, daoImplPath);
            }
            if ("Y".equals(managerFlag)) {
                CommonPageParser.WriterPage(context, "managerClass.vm", managerPathSrc, managerPath);
            }
            if ("Y".equals(managerImplFlag)) {
                CommonPageParser.WriterPage(context, "managerImplClass.vm", managerImplPathSrc, managerImplPath);
            }
            if ("Y".equals(serviceFlag)) {
                CommonPageParser.WriterPage(context, "serviceClass.vm", servicePathSrc, servicePath);
            }
            if ("Y".equals(serviceImplFlag)) {
                CommonPageParser.WriterPage(context, "serviceImplClass.vm", serviceImplPathSrc, serviceImplPath);
            }
            log.info((Object)"----------------------------\u4ee3\u7801\u751f\u6210\u5b8c\u6bd5---------------------------");
            System.out.println("----------------------------\u4ee3\u7801\u751f\u6210\u5b8c\u6bd5---------------------------");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void codeGenerateByFTL(String tableName, String codeName, String keyType) {
        try {
            CreateBean createBean = new CreateBean();
            createBean.setMysqlInfo(url, username, passWord);
            String className = createBean.getTablesNameToClassName(tableName);
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            String tableNameUpper = tableName.toUpperCase();
            String tablesAsName = createBean.getTablesASName(tableName);
            if (StringUtils.isEmpty((String)codeName)) {
                Map<String, String> tableCommentMap = createBean.getTableCommentMap();
                codeName = tableCommentMap.get(tableNameUpper);
            }
            String pathSrc = CodeResourceUtil.getConfigInfo("path_src");
            String source_root_package = CodeResourceUtil.getConfigInfo("source_root_package");
            pathSrc = String.valueOf(pathSrc) + File.separator + source_root_package.replace(".", File.separator);
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            String projectName = CodeResourceUtil.getConfigInfo("project_name");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String bussiPackage = CodeResourceUtil.getConfigInfo("bussi_package");
            String author = CodeResourceUtil.getConfigInfo("author");
            String baseDao = CodeResourceUtil.getConfigInfo("baseDao");
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String daoImplPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao.impl";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String serviceImplPackage = String.valueOf(basePackage) + "." + bussiPackage + ".service.impl";
            String controllerPackage = String.valueOf(basePackage) + "." + bussiPackage + ".web";
            String domainQueryPackage = String.valueOf(basePackage) + "." + bussiPackage + ".vo";
            String pagePackage = "content." + projectName + "." + bussiPackage;
            String sqlPackage = String.valueOf(basePackage) + "." + bussiPackage + ".sql";
            String domainPath = String.valueOf(domainPackage.replace(".", File.separator)) + File.separator + className + "Entity.java";
            String daoPath = String.valueOf(daoPackage.replace(".", File.separator)) + File.separator + className + "Dao.java";
            String daoImplPath = String.valueOf(daoImplPackage.replace(".", File.separator)) + File.separator + className + "DaoImpl.java";
            String servicePath = String.valueOf(servicePackage.replace(".", File.separator)) + File.separator + className + "Service.java";
            String serviceImplPath = String.valueOf(serviceImplPackage.replace(".", File.separator)) + File.separator + className + "ServiceImpl.java";
            String controllerPath = String.valueOf(controllerPackage.replace(".", File.separator)) + File.separator + className + "Controller.java";
            String domainQueryPath = String.valueOf(domainQueryPackage.replace(".", File.separator)) + File.separator + className + "Vo.java";
            String pageIndexPath = String.valueOf(pagePackage.replace(".", File.separator)) + File.separator + lowerName + "-list.vm";
            String pageAddPath = String.valueOf(pagePackage.replace(".", File.separator)) + File.separator + lowerName + "-add.vm";
            String pageEditPath = String.valueOf(pagePackage.replace(".", File.separator)) + File.separator + lowerName + "-edit.vm";
            String pageDetailPath = String.valueOf(pagePackage.replace(".", File.separator)) + File.separator + lowerName + "-detail.vm";
            String sqlConditionPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_condition.sql";
            String sqlGetAllPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_getAll.sql";
            String sqlInsertPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_insert.sql";
            String sqlUpdatePath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_update.sql";
            String sqlMapperFlag = CodeResourceUtil.getConfigInfo("sqlmap_flag");
            String domainFlag = CodeResourceUtil.getConfigInfo("domain_flag");
            String daoFlag = CodeResourceUtil.getConfigInfo("dao_flag");
            String daoImplFlag = CodeResourceUtil.getConfigInfo("dao_impl_flag");
            String serviceFlag = CodeResourceUtil.getConfigInfo("service_flag");
            String serviceImplFlag = CodeResourceUtil.getConfigInfo("service_impl_flag");
            String controllerFlag = CodeResourceUtil.getConfigInfo("controller_flag");
            String domainQueryFlag = CodeResourceUtil.getConfigInfo("domain_query_flag");
            String pageFlag = CodeResourceUtil.getConfigInfo("page_flag");
            String sqlFlag = CodeResourceUtil.getConfigInfo("sql_flag");
            Map<String, Object> sqlMap = createBean.getAutoCreateSql(tableName);
            List<ColumnData> columnDatas = createBean.getColumnDatas(tableName);
            List<ColumnData> columnKeyDatas = createBean.getColumnKeyDatas(columnDatas);
            String columnKeyParam = createBean.getColumnKeyParam(columnKeyDatas);
            String columnKeyUseParam = createBean.getColumnKeyUseParam(columnKeyDatas);
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2 E ");
            String nowDate = dateformat.format(new Date());
            System.out.println("\u65f6\u95f4:" + nowDate);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("author", author);
            root.put("baseDao", baseDao);
            root.put("className", className);
            root.put("lowerName", lowerName);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("tableNameUpper", tableNameUpper);
            root.put("tablesAsName", tablesAsName);
            root.put("bussPackage", bussiPackage);
            root.put("projectName", projectName);
            root.put("domainPackage", domainPackage);
            root.put("domainQueryPackage", domainQueryPackage);
            root.put("daoPackage", daoPackage);
            root.put("daoImplPackage", daoImplPackage);
            root.put("servicePackage", servicePackage);
            root.put("serviceImplPackage", serviceImplPackage);
            root.put("controllerPackage", controllerPackage);
            root.put("keyType", keyType);
            root.put("nowDate", nowDate);
            root.put("feilds", createBean.getBeanFeilds(tableName, className));
            root.put("queryfeilds", createBean.getQueryBeanFeilds(tableName, className));
            root.put("columnDatas", columnDatas);
            root.put("columnKeyDatas", columnKeyDatas);
            root.put("columnKeyParam", columnKeyParam);
            root.put("columnKeyUseParam", columnKeyUseParam);
            root.put("SQL", sqlMap);
            Configuration cfg = new Configuration();
            String templateBasePath = String.valueOf(CodeGenerateFactory.getClassPath()) + CodeResourceUtil.getConfigInfo("templatepath_ftl");
            cfg.setDirectoryForTemplateLoading(new File(templateBasePath));
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            if ("Y".equals(domainFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "domainClass.ftl", pathSrc, domainPath);
            }
            if ("Y".equals(daoFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "daoClass.ftl", pathSrc, daoPath);
            }
            if ("Y".equals(daoImplFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "daoImplClass.ftl", pathSrc, daoImplPath);
            }
            if ("Y".equals(serviceFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "serviceClass.ftl", pathSrc, servicePath);
            }
            if ("Y".equals(serviceImplFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "serviceImplClass.ftl", pathSrc, serviceImplPath);
            }
            if ("Y".equals(controllerFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "controllerClass.ftl", pathSrc, controllerPath);
            }
            if ("Y".equals(domainQueryFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "domainQueryClass.ftl", pathSrc, domainQueryPath);
            }
            if ("Y".equals(sqlFlag)) {
                FreemarkerEngine.createFileByFTL(cfg, root, "minidaoConditionSql.ftl", pathSrc, sqlConditionPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "minidaoGetAllSql.ftl", pathSrc, sqlGetAllPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "minidaoInsertSql.ftl", pathSrc, sqlInsertPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "minidaoUpdateSql.ftl", pathSrc, sqlUpdatePath);
            }
            if ("Y".equals(pageFlag)) {
                columnDatas = createBean.getPageColumnDatas(tableName);
                root.put("columnDatas", columnDatas);
                FreemarkerEngine.createFileByFTL(cfg, root, "pageIndex.ftl", pathSrc, pageIndexPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "pageAdd.ftl", pathSrc, pageAddPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "pageDetail.ftl", pathSrc, pageDetailPath);
                FreemarkerEngine.createFileByFTL(cfg, root, "pageEdit.ftl", pathSrc, pageEditPath);
            }
            log.info((Object)"----------------------------\u4ee3\u7801\u751f\u6210\u5b8c\u6bd5---------------------------");
            System.out.println("----------------------------\u4ee3\u7801\u751f\u6210\u5b8c\u6bd5---------------------------");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static String getProjectPath() {
        String path = String.valueOf(System.getProperty("user.dir").replace("\\", File.separator)) + File.separator;
        return path;
    }

    public static String getClassPath() {
        String path = new CodeGenerateFactory().getClass().getResource("/").getPath();
        return path;
    }
}

