/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgreport.service.impl.excel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.web.cgreport.service.excel.CgReportExcelServiceI;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cgReportExcelService")
@Transactional
public class CgReportExcelServiceImpl
extends CommonServiceImpl
implements CgReportExcelServiceI {
    @Override
    public HSSFWorkbook exportExcel(String title, Collection<?> titleSet, Collection<?> dataSet) {
        HSSFWorkbook workbook = null;
        try {
            if (titleSet == null || titleSet.size() == 0) {
                throw new Exception("\u8bfb\u53d6\u8868\u5934\u5931\u8d25\uff01");
            }
            if (title == null) {
                title = "";
            }
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(title);
            int rindex = 0;
            int cindex = 0;
            Row row = sheet.createRow(rindex);
            row.setHeight((short)450);
            HSSFCellStyle titleStyle = CgReportExcelServiceImpl.getTitleStyle(workbook);
            List titleList = (List)titleSet;
            Iterator<?> itData = dataSet.iterator();
            for (Map titleM : titleList) {
                String titleContent = (String)titleM.get("field_txt");
                Cell cell = row.createCell(cindex);
                HSSFRichTextString text = new HSSFRichTextString(titleContent);
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle((CellStyle)titleStyle);
                ++cindex;
            }
            HSSFCellStyle bodyStyle = CgReportExcelServiceImpl.getOneStyle(workbook);
            while (itData.hasNext()) {
                cindex = 0;
                row = sheet.createRow(++rindex);
                Map dataM = (Map)itData.next();
                for (Map titleM : titleList) {
                    String field = (String)titleM.get("field_name");
                    String content = dataM.get(field) == null ? "" : dataM.get(field).toString();
                    Cell cell = row.createCell(cindex);
                    HSSFRichTextString text = new HSSFRichTextString(content);
                    cell.setCellStyle((CellStyle)bodyStyle);
                    cell.setCellValue((RichTextString)text);
                    ++cindex;
                }
            }
            int i = 0;
            while (i < titleList.size()) {
                sheet.autoSizeColumn(i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setBorderLeft((short)1);
        titleStyle.setBorderRight((short)1);
        titleStyle.setBorderBottom((short)1);
        titleStyle.setBorderTop((short)1);
        titleStyle.setAlignment((short)2);
        titleStyle.setFillForegroundColor((short)22);
        titleStyle.setFillPattern((short)1);
        return titleStyle;
    }

    public static void setBlankRows(int rows, int columns, HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        HSSFCellStyle cellStyle = CgReportExcelServiceImpl.getOneStyle(workbook);
        int i = 1;
        while (i <= rows) {
            Row row = sheet.createRow(i);
            int j = 0;
            while (j < columns) {
                row.createCell(j).setCellStyle((CellStyle)cellStyle);
                ++j;
            }
            ++i;
        }
    }

    public static HSSFCellStyle getTwoStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        return style;
    }

    public static HSSFCellStyle getOneStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        return style;
    }
}

