/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgreport.service.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jeecgframework.core.common.dao.jdbc.JdbcDao;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgreport.dao.core.CgReportDao;
import org.jeecgframework.web.cgreport.entity.core.CgreportConfigHeadEntity;
import org.jeecgframework.web.cgreport.entity.core.CgreportConfigParamEntity;
import org.jeecgframework.web.cgreport.service.core.CgReportServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cgReportService")
@Transactional
public class CgReportServiceImpl
extends CommonServiceImpl
implements CgReportServiceI {
    @Autowired
    private JdbcDao jdbcDao;
    @Autowired
    private CgReportDao cgReportDao;

    @Override
    public Map<String, Object> queryCgReportConfig(String reportId) {
        HashMap<String, Object> cgReportM = new HashMap<String, Object>(0);
        Map<String, Object> mainM = this.queryCgReportMainConfig(reportId);
        List<Map<String, Object>> itemsM = this.queryCgReportItems(reportId);
        List<String> params = this.queryCgReportParam(reportId);
        cgReportM.put("main", mainM);
        cgReportM.put("items", itemsM);
        cgReportM.put("params", params);
        return cgReportM;
    }

    @Override
    public Map<String, Object> queryCgReportMainConfig(String reportId) {
        return this.cgReportDao.queryCgReportMainConfig(reportId);
    }

    @Override
    public List<Map<String, Object>> queryCgReportItems(String reportId) {
        return this.cgReportDao.queryCgReportItems(reportId);
    }

    public List<String> queryCgReportParam(String reportId) {
        ArrayList<String> list = null;
        String hql0 = "from CgreportConfigParamEntity where 1 = 1 AND cgrheadId = ? ";
        CgreportConfigHeadEntity cgreportConfigHead = (CgreportConfigHeadEntity)this.findUniqueByProperty(CgreportConfigHeadEntity.class, "code", reportId);
        List cgreportConfigParamList = this.findHql(hql0, new Object[]{cgreportConfigHead.getId()});
        if (cgreportConfigParamList != null & cgreportConfigParamList.size() > 0) {
            list = new ArrayList<String>();
            for (CgreportConfigParamEntity cgreportConfigParam : cgreportConfigParamList) {
                list.add(cgreportConfigParam.getParamName());
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryByCgReportSql(String sql, Map params, int page, int rows) {
        String querySql = this.getFullSql(sql, params);
        List result = null;
        result = page == -1 && rows == -1 ? this.jdbcDao.findForJdbc(querySql, new Object[0]) : this.jdbcDao.findForJdbc(querySql, page, rows);
        return result;
    }

    private String getFullSql(String sql, Map params) {
        StringBuilder sqlB = new StringBuilder();
        sqlB.append("SELECT t.* FROM ( ");
        sqlB.append(String.valueOf(sql) + " ");
        sqlB.append(") t ");
        if (params.size() >= 1) {
            sqlB.append("WHERE 1=1  ");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = String.valueOf(params.get(key));
                if (StringUtil.isEmpty((String)value) || "null".equals(value)) continue;
                sqlB.append(" AND ");
                sqlB.append(" " + key + value);
            }
        }
        return sqlB.toString();
    }

    @Override
    public long countQueryByCgReportSql(String sql, Map params) {
        String querySql = this.getFullSql(sql, params);
        querySql = "SELECT COUNT(*) FROM (" + querySql + ") t2";
        long result = this.jdbcDao.findForLong(querySql, new HashMap(0));
        return result;
    }

    @Override
    public List<String> getSqlFields(String sql) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        List result = this.jdbcDao.findForJdbc(sql, 1, 1);
        if (result.size() < 1) {
            throw new BusinessException("\u8be5\u62a5\u8868sql\u6ca1\u6709\u6570\u636e");
        }
        Set fieldsSet = ((Map)result.get(0)).keySet();
        ArrayList<String> fileds = new ArrayList<String>(fieldsSet);
        return fileds;
    }
}

