/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgreport.controller.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.enums.SysThemesEnum;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.DynamicDBUtil;
import org.jeecgframework.core.util.SqlUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.SysThemesUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgreport.exception.CgReportNotFoundException;
import org.jeecgframework.web.cgreport.service.core.CgReportServiceI;
import org.jeecgframework.web.cgreport.util.CgReportQueryParamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cgReportController"})
public class CgReportController
extends BaseController {
    @Autowired
    private CgReportServiceI cgReportService;

    @RequestMapping(params={"list"})
    public void list(String id, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(id);
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        this.loadVars(cgReportMap, request);
        cgReportMap.put("config_iframe", this.getHtmlHead(request));
        String html = viewEngine.parseTemplate("/org/jeecgframework/web/cgreport/engine/core/cgreportlist.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getHtmlHead(HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        String lang = (String)session.getAttribute("lang");
        StringBuilder sb = new StringBuilder("");
        SysThemesEnum sysThemesEnum = SysThemesUtil.getSysTheme((HttpServletRequest)request);
        sb.append("<script type=\"text/javascript\" src=\"plug-in/jquery/jquery-1.8.3.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/dataformat.js\"></script>");
        sb.append(SysThemesUtil.getEasyUiTheme((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/easyui/themes/icon.css\" type=\"text/css\"></link>");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/accordion.css\">");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/icons.css\">");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/jquery.easyui.min.1.3.2.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/locale/zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/syUtil.js\"></script>");
        sb.append(SysThemesUtil.getLhgdialogTheme((SysThemesEnum)sysThemesEnum));
        sb.append(StringUtil.replace((String)"<script type=\"text/javascript\" src=\"plug-in/tools/curdtools_{0}.js\"></script>", (String)"{0}", (String)lang));
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/easyuiextend.js\"></script>");
        return sb.toString();
    }

    @RequestMapping(params={"popup"})
    public void popup(String id, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(id);
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        this.loadVars(cgReportMap, request);
        cgReportMap.put("config_iframe", this.getHtmlHead(request));
        String html = viewEngine.parseTemplate("/org/jeecgframework/web/cgreport/engine/core/cgreportlistpopup.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadVars(Map<String, Object> cgReportMap, HttpServletRequest request) {
        Map mainM = (Map)cgReportMap.get("main");
        List fieldList = (List)cgReportMap.get("items");
        List paramList = (List)cgReportMap.get("params");
        ArrayList<Map> queryList = new ArrayList<Map>(0);
        for (Map fl : fieldList) {
            fl.put("field_name", ((String)fl.get("field_name")).toLowerCase());
            String isQuery = (String)fl.get("search_flag");
            if (!"Y".equalsIgnoreCase(isQuery)) continue;
            this.loadDic(fl, fl);
            queryList.add(fl);
        }
        StringBuilder sb = new StringBuilder("");
        if (paramList != null && paramList.size() > 0) {
            queryList = new ArrayList(0);
            for (String param : paramList) {
                sb.append("&").append(param).append("=");
                String value = request.getParameter(param);
                if (!StringUtil.isNotEmpty((Object)value)) continue;
                sb.append(value);
            }
        }
        cgReportMap.put("config_id", mainM.get("code"));
        cgReportMap.put("config_name", mainM.get("name"));
        cgReportMap.put("config_fieldList", fieldList);
        cgReportMap.put("config_queryList", queryList);
        cgReportMap.put("config_params", sb.toString());
    }

    private void dealDic(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            String dict_code = (String)bean.get("dict_code");
            if (StringUtil.isEmpty((String)dict_code)) continue;
            List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
            for (Map<String, Object> r : result) {
                String value = String.valueOf(r.get(bean.get("field_name")));
                for (Map<String, Object> m : dicDatas) {
                    String typecode = String.valueOf(m.get("typecode"));
                    String typename = String.valueOf(m.get("typename"));
                    if (!value.equalsIgnoreCase(typecode)) continue;
                    r.put((String)bean.get("field_name"), typename);
                }
            }
        }
    }

    private void dealReplace(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            try {
                String[] groups;
                String replace = (String)bean.get("replace_value");
                if (StringUtil.isEmpty((String)replace)) continue;
                String[] stringArray = groups = replace.split(",");
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    String g = stringArray[n2];
                    String[] items = g.split("_");
                    String v = items[0];
                    String txt = items[1];
                    for (Map<String, Object> r : result) {
                        String value = String.valueOf(r.get(bean.get("field_name")));
                        if (!value.equalsIgnoreCase(v)) continue;
                        r.put((String)bean.get("field_name"), txt);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("\u53d6\u503c\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(String configId, String page, String field, String rows, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(configId);
            if (cgReportMap.size() <= 0) {
                throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u67e5\u627e\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u5931\u8d25!" + e.getMessage());
        }
        Map configM = (Map)cgReportMap.get("main");
        String querySql = (String)configM.get("cgreport_sql");
        List items = (List)cgReportMap.get("items");
        List paramList = (List)cgReportMap.get("params");
        LinkedHashMap queryparams = new LinkedHashMap();
        if (paramList != null && paramList.size() > 0) {
            for (String param : paramList) {
                String value = request.getParameter(param);
                value = value == null ? "" : value;
                querySql = querySql.replace("${" + param + "}", value);
            }
        } else {
            for (Map item : items) {
                String isQuery = (String)item.get("search_flag");
                if (!"Y".equalsIgnoreCase(isQuery)) continue;
                CgReportQueryParamUtil.loadQueryParams(request, item, queryparams);
            }
        }
        int p = page == null ? 1 : Integer.parseInt(page);
        int r = rows == null ? 99999 : Integer.parseInt(rows);
        String dbKey = (String)configM.get("db_source");
        List result = null;
        Long size = 0L;
        if (StringUtils.isNotBlank((String)dbKey)) {
            result = DynamicDBUtil.findList((String)dbKey, (String)SqlUtil.jeecgCreatePageSql((String)dbKey, (String)querySql, queryparams, (int)p, (int)r), (Object[])new Object[0]);
            Map map = (Map)DynamicDBUtil.findOne((String)dbKey, (String)SqlUtil.getCountSql((String)querySql, null), (Object[])new Object[0]);
            if (map.get("COUNT(*)") instanceof BigDecimal) {
                BigDecimal count = (BigDecimal)map.get("COUNT(*)");
                size = count.longValue();
            } else {
                size = (Long)map.get("COUNT(*)");
            }
        } else {
            result = this.cgReportService.queryByCgReportSql(querySql, queryparams, p, r);
            size = this.cgReportService.countQueryByCgReportSql(querySql, queryparams);
        }
        this.dealDic(result, items);
        this.dealReplace(result, items);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(CgReportQueryParamUtil.getJson(result, size));
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"getFields"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getSqlFields(String sql, String dbKey) {
        List<String> fields = null;
        List<String> params = null;
        HashMap<String, Object> reJson = new HashMap<String, Object>();
        try {
            fields = this.getFields(sql, dbKey);
            params = this.getSqlParams(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorInfo = "\u89e3\u6790\u5931\u8d25!<br><br>\u5931\u8d25\u539f\u56e0\uff1a";
            int i = e.getMessage().indexOf("Connection refused: connect");
            errorInfo = i != -1 ? String.valueOf(errorInfo) + "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25." : String.valueOf(errorInfo) + "SQL\u8bed\u6cd5\u9519\u8bef.";
            reJson.put("status", "error");
            reJson.put("datas", errorInfo);
            return reJson;
        }
        reJson.put("status", "success");
        reJson.put("fields", fields);
        reJson.put("params", params);
        return reJson;
    }

    private List<String> getFields(String sql, String dbKey) {
        List<String> fields = null;
        sql = this.getSql(sql);
        if (StringUtils.isNotBlank((String)dbKey)) {
            List dataList = DynamicDBUtil.findList((String)dbKey, (String)SqlUtil.jeecgCreatePageSql((String)dbKey, (String)sql, null, (int)1, (int)1), null);
            if (dataList.size() < 1) {
                throw new BusinessException("\u8be5\u62a5\u8868sql\u6ca1\u6709\u6570\u636e");
            }
            Set fieldsSet = ((Map)dataList.get(0)).keySet();
            fields = new ArrayList(fieldsSet);
        } else {
            fields = this.cgReportService.getSqlFields(sql);
        }
        return fields;
    }

    private String getSql(String sql) {
        String whereParam;
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            whereParam = m.group();
            System.out.println(whereParam);
            sql = sql.replace(whereParam, "'' or 1=1 or 1=''");
            sql = sql.replace("'''", "''");
            System.out.println(sql);
        }
        regex = "\\{\\w+\\}";
        p = Pattern.compile(regex);
        m = p.matcher(sql);
        while (m.find()) {
            whereParam = m.group();
            System.out.println(whereParam);
            sql = sql.replace(whereParam, " 1=1 ");
            System.out.println(sql);
        }
        return sql;
    }

    public List<String> getSqlParams(String sql) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String whereParam = m.group();
            params.add(whereParam.substring(whereParam.indexOf("{") + 1, whereParam.indexOf("}")));
        }
        return params;
    }

    private void loadDic(Map m, Map<String, Object> cgReportMap) {
        String dict_code = (String)cgReportMap.get("dict_code");
        if (StringUtil.isEmpty((String)dict_code)) {
            m.put("field_dictlist", new ArrayList(0));
            return;
        }
        List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
        m.put("field_dictlist", dicDatas);
    }

    private List<Map<String, Object>> queryDic(String diccode) {
        StringBuilder dicSql = new StringBuilder();
        dicSql.append(" SELECT TYPECODE,TYPENAME FROM");
        dicSql.append(" t_s_type");
        dicSql.append(" WHERE TYPEGROUPID = ");
        dicSql.append(" (SELECT ID FROM t_s_typegroup WHERE TYPEGROUPCODE = '" + diccode + "' )");
        List dicDatas = this.cgReportService.findForJdbc(dicSql.toString(), new Object[0]);
        return dicDatas;
    }
}

