/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.web.cgform.entity.template.CgformTemplateEntity;

public class TemplateUtil {
    public static final String BASE_DIR = "online/template/";
    public static final String TEMPLET_CODE_DEFAULT = "ledefault";
    public static final String TEMPLET_ONE_DEFAULT = "jform.ftl";
    public static final String TEMPLET_ONE_MANY_DEFAULT = "jformunion.ftl";
    public static final String TEMPLET_VIEW_DIR_DEFAULT = "html";
    public static final String TEMPLET_LIST = "autolist.ftl";

    public static String getTempletPath(CgformTemplateEntity entity, Integer formType, TemplateType type) {
        if (entity == null || StringUtils.isBlank((String)entity.getTemplateCode())) {
            entity = new CgformTemplateEntity();
            entity.setTemplateCode(TEMPLET_CODE_DEFAULT);
            entity.setTemplateListName(TEMPLET_LIST);
            if (2 == formType) {
                entity.setTemplateAddName(TEMPLET_ONE_MANY_DEFAULT);
                entity.setTemplateUpdateName(TEMPLET_ONE_MANY_DEFAULT);
                entity.setTemplateDetailName(TEMPLET_ONE_MANY_DEFAULT);
            } else {
                entity.setTemplateAddName(TEMPLET_ONE_DEFAULT);
                entity.setTemplateUpdateName(TEMPLET_ONE_DEFAULT);
                entity.setTemplateDetailName(TEMPLET_ONE_DEFAULT);
            }
        }
        String templateCode = entity.getTemplateCode();
        String templateName = null;
        switch (type) {
            case ADD: {
                templateName = entity.getTemplateAddName();
                break;
            }
            case UPDATE: {
                templateName = entity.getTemplateUpdateName();
                break;
            }
            case LIST: {
                templateName = entity.getTemplateListName();
                break;
            }
            case DETAIL: {
                templateName = entity.getTemplateDetailName();
                break;
            }
            default: {
                templateName = entity.getTemplateListName();
            }
        }
        StringBuffer buffer = new StringBuffer(BASE_DIR + templateCode + "/");
        buffer.append("html/");
        buffer.append(templateName);
        return buffer.toString();
    }

    public Map<String, Object> processor(String content) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JSONObject jsonObj = JSONObject.fromObject((Object)content);
            String template = (String)jsonObj.get("template");
            String parseHtml = (String)jsonObj.get("parse");
            new JSONArray();
            JSONArray jsonArray = JSONArray.fromObject((Object)jsonObj.get("data"));
            map.put("template", template);
            String rexEg = "(<input[^>]*>)";
            Pattern p = Pattern.compile(rexEg);
            Matcher m = p.matcher(parseHtml);
            ArrayList<String> result = new ArrayList<String>();
            while (m.find()) {
                result.add(m.group());
            }
            HashMap<String, Object> tableData = null;
            int index = 0;
            int i = 0;
            while (i < result.size()) {
                String ctrlExp = "(listctrl)";
                Pattern ctrlP = Pattern.compile(ctrlExp);
                Matcher ctrlM = ctrlP.matcher((CharSequence)result.get(i));
                if (ctrlM.find()) {
                    tableData = new HashMap<String, Object>();
                    int j = index;
                    while (j < jsonArray.size()) {
                        JSONObject item = jsonArray.getJSONObject(j);
                        if ("listctrl".equals(item.getString("leipiplugins"))) {
                            String tempHtml = TemplateUtil.GetListctrl(jsonArray.getJSONObject(j), tableData, "");
                            parseHtml = parseHtml.replace((CharSequence)result.get(i), tempHtml);
                            index = j + 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            map.put("parseHtml", parseHtml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static String GetListctrl(JSONObject item, Map<String, Object> formData, String action) {
        String valuetest = "{\"data_110\":[\"1\",\"2\"],\"data_111\":[\"21\",\"22\",\"22\"]}";
        String name = item.getString("name").toString();
        String value = formData.get(name) == null ? null : formData.get(name).toString();
        String temp_html = "";
        String orgSum = item.getString("orgsum").toString();
        String orgUnit = item.getString("orgunit").toString();
        String orgTitle = item.getString("orgtitle").toString();
        String title = item.getString("title").toString();
        String style = item.getString("style").toString();
        String orgcolvalue = item.getString("orgcolvalue").toString();
        String orgcoltype = item.getString("orgcoltype").toString();
        List<String> listTitle = Arrays.asList(orgTitle.split("`"));
        List<String> listSum = Arrays.asList(orgSum.split("`"));
        List<String> listUnit = Arrays.asList(orgUnit.split("`"));
        List<String> listValue = Arrays.asList(orgcolvalue.split("`"));
        List<String> listType = Arrays.asList(orgcoltype.split("`"));
        int tdCount = listTitle.size();
        String tableNm = String.valueOf(name) + "_table";
        String temp = "<table id=\"" + tableNm + "\" bindTable=\"true\" cellspacing=\"0\" class=\"table table-bordered table-condensed\" style=\"" + style + "\"><thead>{0}</thead><tbody>{1}</tbody>{2}</table>";
        String btnAdd = "<span class=\"pull-right\"><button id='listAdd' class=\"btn btn-small btn-success listAdd\" type=\"button\" tbname=\"" + name + "\">\u6dfb\u52a0\u4e00\u884c</button></span>";
        String theader = "<tr><th colspan=\"{0}\">{1}{2}</th></tr>{3}";
        boolean isExistSum = false;
        String trTitle = "";
        int i = 0;
        while (i < tdCount) {
            trTitle = String.valueOf(trTitle) + MessageFormat.format("<th>{0}</th>", listTitle.get(i));
            if (i + 1 == tdCount) {
                trTitle = String.valueOf(trTitle) + MessageFormat.format("<th>{0}</th>", "\u64cd\u4f5c");
            }
            ++i;
        }
        trTitle = "<tr>" + trTitle + "</tr>";
        JSONObject dataValue = JSONObject.fromObject((Object)valuetest);
        int rowCount = dataValue != null ? dataValue.size() : 1;
        StringBuilder sbTr = new StringBuilder();
        String tdSum = "";
        TreeMap<Integer, Float> SumValueDic = new TreeMap<Integer, Float>();
        int row = 0;
        while (row < rowCount) {
            JSONArray rowValue = dataValue != null && dataValue.has(String.valueOf(name) + row) ? dataValue.getJSONArray(String.valueOf(name) + row) : null;
            String tr = "";
            int i2 = 0;
            while (i2 < tdCount) {
                String tdname = String.valueOf(name) + "[" + i2 + "]";
                String sum = "1".equals(listSum.get(i2)) ? "sum=\"" + tdname + "\"" : "";
                String tdValue = "";
                if (i2 < listValue.size()) {
                    tdValue = StringUtils.isBlank((String)listValue.get(i2)) ? "" : listValue.get(i2);
                }
                tdValue = rowValue != null && rowValue.size() > i2 ? rowValue.getString(i2).toString() : tdValue;
                String type = listType.get(i2);
                if (sum != "") {
                    float tempTdValue = 0.0f;
                    if (SumValueDic.containsKey(i2)) {
                        tempTdValue = ((Float)SumValueDic.get(i2)).floatValue();
                    }
                    try {
                        float resultTdTemp = 0.0f;
                        resultTdTemp = Float.parseFloat(tdValue);
                        tempTdValue += resultTdTemp;
                    }
                    catch (Exception e) {
                        tdValue = "0";
                    }
                    if (SumValueDic.containsKey(i2)) {
                        SumValueDic.subMap(i2, i2);
                    } else {
                        SumValueDic.put(i2, Float.valueOf(tempTdValue));
                    }
                }
                if ("text".equals(type)) {
                    tr = String.valueOf(tr) + MessageFormat.format("<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}[]\" {2}></td>", tdValue, tdname, sum);
                } else if ("int".equals(type)) {
                    tr = String.valueOf(tr) + MessageFormat.format("<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}[]\" {2}></td>", tdValue, tdname, sum);
                } else if ("textarea".equals(type)) {
                    tr = String.valueOf(tr) + MessageFormat.format("<td><textarea class=\"input-medium\" name=\"{0}\" >{1}</textarea></td>", tdname, tdValue, sum);
                } else if ("calc".equals(type)) {
                    tr = String.valueOf(tr) + MessageFormat.format("<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}[]\" {2}></td>", tdValue, tdname, sum);
                }
                if (i2 + 1 == tdCount) {
                    tr = row == 0 ? String.valueOf(tr) + "<td></td>" : String.valueOf(tr) + "<td><a href=\"javascript:void(0);\" class=\"delrow \">\u5220\u9664</a></td>";
                }
                if (row == 0) {
                    if (sum != "") {
                        isExistSum = true;
                        tdSum = String.valueOf(tdSum) + MessageFormat.format("<td>\u5408\u8ba1\uff1a<input class=\"input-small\" type=\"text\" value=\"value{0}\" name=\"{1}[total]\" {2}\">{3}</td>", i2, tdname, sum, "");
                    } else {
                        tdSum = String.valueOf(tdSum) + "<td></td>";
                    }
                }
                ++i2;
            }
            sbTr.append(MessageFormat.format("<tr class=\"template\">{0}</tr>", tr));
            ++row;
        }
        if (!StringUtils.isBlank((String)tdSum)) {
            for (Integer i3 : SumValueDic.keySet()) {
                tdSum = tdSum.replace("value" + i3, ((Float)SumValueDic.get(i3)).toString());
                tdSum = MessageFormat.format("<tbody class=\"sum\"><tr>{0}</tr></tbody>", tdSum);
            }
        }
        theader = MessageFormat.format(theader, tdCount + 1, title, btnAdd, trTitle);
        temp_html = MessageFormat.format(temp, theader, sbTr.toString(), tdSum);
        temp_html = String.valueOf(temp_html) + "<script type=\"text/javascript\">";
        temp_html = String.valueOf(temp_html) + "$(function(){";
        temp_html = String.valueOf(temp_html) + "$(\"#listAdd\").click(function(){";
        temp_html = String.valueOf(temp_html) + "var tbHtml ='<tr>'+ $(\"#" + tableNm + " tr\").eq(2).html().replace('<td></td>',\"<td><a href='javascript:void(0);' class='delrow'>\u5220\u9664</a></td>\")+'</tr>';";
        temp_html = isExistSum ? String.valueOf(temp_html) + "$(\"#" + tableNm + " tr\").eq(-2).after(tbHtml);" : String.valueOf(temp_html) + "$(\"#" + tableNm + " tr:last\").after(tbHtml);";
        temp_html = String.valueOf(temp_html) + "$(\".delrow\").die().live(\"click\",function(){$(this).parent().parent().remove();});";
        temp_html = String.valueOf(temp_html) + "});";
        temp_html = String.valueOf(temp_html) + "$(\".delrow\").click(function(){$(this).parent().parent().remove();});";
        temp_html = String.valueOf(temp_html) + "});</script>";
        return temp_html;
    }

    public static enum TemplateType {
        ADD("add"),
        UPDATE("update"),
        LIST("list"),
        DETAIL("detail");

        private String name;

        private TemplateType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static TemplateType getVal(String type) {
            if ("add".equals(type)) {
                return ADD;
            }
            if ("update".equals(type)) {
                return UPDATE;
            }
            if ("detail".equals(type)) {
                return DETAIL;
            }
            if ("list".equals(type)) {
                return LIST;
            }
            return null;
        }
    }
}

