/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.util;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeecgframework.core.util.DBTypeUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;

public class QueryParamUtil {
    public static void loadQueryParams(HttpServletRequest request, CgFormFieldEntity b, Map params) {
        if ("N".equalsIgnoreCase(b.getIsQuery())) {
            return;
        }
        if ("single".equals(b.getQueryMode())) {
            String value = request.getParameter(b.getFieldName());
            try {
                if (StringUtil.isEmpty((String)value)) {
                    return;
                }
                String uri = request.getQueryString();
                if (uri.contains(String.valueOf(b.getFieldName()) + "=")) {
                    String contiansChinesevalue;
                    value = contiansChinesevalue = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return;
            }
            QueryParamUtil.sql_inj_throw(value);
            value = QueryParamUtil.applyType(b.getType(), value);
            if (!StringUtil.isEmpty((String)value)) {
                if (value.contains("*")) {
                    value = value.replaceAll("\\*", "%");
                    params.put(b.getFieldName(), " LIKE " + value);
                } else {
                    params.put(b.getFieldName(), " = " + value);
                }
            }
        } else if ("group".equals(b.getQueryMode())) {
            String begin = request.getParameter(String.valueOf(b.getFieldName()) + "_begin");
            QueryParamUtil.sql_inj_throw(begin);
            begin = QueryParamUtil.applyType(b.getType(), begin);
            String end = request.getParameter(String.valueOf(b.getFieldName()) + "_end");
            QueryParamUtil.sql_inj_throw(end);
            end = QueryParamUtil.applyType(b.getType(), end);
            if (!StringUtil.isEmpty((String)begin)) {
                String re = " >= " + begin;
                if (!StringUtil.isEmpty((String)end)) {
                    re = String.valueOf(re) + " AND " + b.getFieldName() + " <= " + end;
                }
                params.put(b.getFieldName(), re);
            } else if (!StringUtil.isEmpty((String)end)) {
                String re = " <= " + end;
                params.put(b.getFieldName(), re);
            }
        }
    }

    public static String applyType(String fieldType, String value) {
        if (!StringUtil.isEmpty((String)value)) {
            String result = "";
            if ("String".equalsIgnoreCase(fieldType)) {
                if (ResourceUtil.fuzzySearch && !value.contains("*")) {
                    value = "*" + value + "*";
                }
                result = "'" + value + "'";
            } else {
                result = "Date".equalsIgnoreCase(fieldType) ? QueryParamUtil.getDateFunction(value, "yyyy-MM-dd") : ("Double".equalsIgnoreCase(fieldType) ? value : ("Integer".equalsIgnoreCase(fieldType) ? value : value));
            }
            return result;
        }
        return "";
    }

    public static boolean sql_inj(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        String inj_str = "'|and|exec|insert|select|delete|update|count|chr|mid|master|truncate|char|declare|;|or|+|,";
        String[] inj_stra = inj_str.split("\\|");
        int i = 0;
        while (i < inj_stra.length) {
            if (str.indexOf(" " + inj_stra[i] + " ") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void sql_inj_throw(String str) {
        if (QueryParamUtil.sql_inj(str)) {
            throw new RuntimeException("\u8bf7\u6ce8\u610f,\u586b\u5165\u7684\u53c2\u6570\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165!");
        }
    }

    public static String getDBType() {
        return DBTypeUtil.getDBType();
    }

    public static String getDateFunction(String dateStr, String dateFormat) {
        String dbType = QueryParamUtil.getDBType();
        String dateFunction = "";
        dateFunction = "mysql".equalsIgnoreCase(dbType) ? "'" + dateStr + "'" : ("oracle".equalsIgnoreCase(dbType) ? "TO_DATE('" + dateStr + "','" + dateFormat + "')" : ("sqlserver".equalsIgnoreCase(dbType) ? "(CONVERT(VARCHAR,'" + dateStr + "') as DATETIME)" : ("postgres".equalsIgnoreCase(dbType) ? "'" + dateStr + "'::date " : dateStr)));
        return dateFunction;
    }

    public static String getJson(List<Map<String, Object>> result, Long size) {
        JSONObject main = new JSONObject();
        JSONArray rows = new JSONArray();
        main.put((Object)"total", (Object)size);
        for (Map<String, Object> m : result) {
            JSONObject item = new JSONObject();
            for (String key : m.keySet()) {
                String value = String.valueOf(m.get(key));
                if ((key = key.toLowerCase()).contains("time") || key.contains("date")) {
                    value = QueryParamUtil.datatimeFormat(value);
                }
                item.put((Object)key, (Object)value);
            }
            rows.add((Object)item);
        }
        main.put((Object)"rows", (Object)rows);
        return main.toString();
    }

    public static String getJson(List<Map<String, Object>> result) {
        JSONArray rows = new JSONArray();
        for (Map<String, Object> m : result) {
            JSONObject item = new JSONObject();
            for (String key : m.keySet()) {
                String value = String.valueOf(m.get(key));
                if ((key = key.toLowerCase()).contains("time") || key.contains("date")) {
                    value = QueryParamUtil.datatimeFormat(value);
                }
                item.put((Object)key, (Object)value);
            }
            rows.add((Object)item);
        }
        return rows.toString();
    }

    public static String datatimeFormat(String datetime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        SimpleDateFormat dateFormatTo = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = null;
        try {
            d = dateFormat.parse(datetime);
            return dateFormatTo.format(d);
        }
        catch (Exception e) {
            return datetime;
        }
    }
}

