/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.util;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.DateUtils;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgreport.entity.core.CgreportConfigHeadEntity;
import org.jeecgframework.web.cgreport.service.core.CgreportConfigHeadServiceI;
import org.jeecgframework.web.system.manager.ClientManager;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.MutiLangServiceI;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AutoFormTemplateParseUtil {
    public static String OP_ADD = "add";
    public static String OP_UPDATE = "update";
    public static String OP_ADD_OR_UPDATE = "addorupdate";
    public static String OP_VIEW = "view";
    private static MutiLangServiceI mutiLangService;
    private static CgreportConfigHeadServiceI cgreportConfigHeadService;

    public static String parseHtmlForView(String content, Map<String, List<Map<String, Object>>> paras) {
        JSONObject jsonObj = JSONObject.fromObject((Object)content);
        if (jsonObj.isNullObject() || jsonObj.isEmpty()) {
            return "";
        }
        String html = (String)jsonObj.get("parse");
        List<Map<String, Object>> list = AutoFormTemplateParseUtil.getAllInputAttr(jsonObj);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> atrrMap : list) {
                html = AutoFormTemplateParseUtil.createHtml(html, atrrMap, paras);
            }
        }
        return html;
    }

    public static String parseHtmlForAdd(String content, Map<String, List<Map<String, Object>>> paras) {
        JSONObject jsonObj = JSONObject.fromObject((Object)content);
        if (jsonObj.isNullObject() || jsonObj.isEmpty()) {
            return "";
        }
        String html = (String)jsonObj.get("parse");
        List<Map<String, Object>> list = AutoFormTemplateParseUtil.getAllInputAttr(jsonObj);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> atrrMap : list) {
                html = AutoFormTemplateParseUtil.createHtml(html, atrrMap, paras);
            }
        }
        return html;
    }

    public static String parseHtmlForUpdate(String content, Map<String, List<Map<String, Object>>> paras) {
        JSONObject jsonObj = JSONObject.fromObject((Object)content);
        if (jsonObj.isNullObject() || jsonObj.isEmpty()) {
            return "";
        }
        String html = (String)jsonObj.get("parse");
        List<Map<String, Object>> list = AutoFormTemplateParseUtil.getAllInputAttr(jsonObj);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> atrrMap : list) {
                html = AutoFormTemplateParseUtil.createHtml(html, atrrMap, paras);
            }
        }
        return html;
    }

    public static String parseHtmlForAddOrUpdate(String content, Map<String, List<Map<String, Object>>> paras) {
        JSONObject jsonObj = JSONObject.fromObject((Object)content);
        if (jsonObj.isNullObject() || jsonObj.isEmpty()) {
            return "";
        }
        String html = (String)jsonObj.get("parse");
        List<Map<String, Object>> list = AutoFormTemplateParseUtil.getAllInputAttr(jsonObj);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> atrrMap : list) {
                html = AutoFormTemplateParseUtil.createHtml(html, atrrMap, paras);
            }
        }
        return html;
    }

    private static String createHtml(String html, Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String leipiplugins = (String)atrrMap.get("leipiplugins");
        String content = (String)atrrMap.get("content");
        if ("listctrl".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getListctrl(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("text".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getText(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("textarea".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getTextarea(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("select".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getSelect(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("radios".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getRadio(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("checkboxs".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getCheckbox(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("popup".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getPopup(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if ("macros".equals(leipiplugins)) {
            String tempHtml = AutoFormTemplateParseUtil.getMacros(atrrMap, paras);
            html = html.replace(content, tempHtml);
        } else if (leipiplugins == null) {
            String tempHtml = AutoFormTemplateParseUtil.getHiddenText(atrrMap, paras);
            html = html.replace(content, tempHtml);
        }
        return html;
    }

    private static String getListctrl(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        int rowCount;
        String name = (String)atrrMap.get("name");
        String temp_html = "";
        String autofield = (String)atrrMap.get("autofield");
        String orgSum = (String)atrrMap.get("orgsum");
        String orgUnit = (String)atrrMap.get("orgunit");
        String orgTitle = (String)atrrMap.get("orgtitle");
        String title = (String)atrrMap.get("title");
        String style = (String)atrrMap.get("style");
        String orgcolvalue = (String)atrrMap.get("orgcolvalue");
        String orgcoltype = (String)atrrMap.get("orgcoltype");
        String pkid = (String)atrrMap.get("pkid");
        String fkdsid = (String)atrrMap.get("fkdsid");
        String isHides = (String)atrrMap.get("ishide");
        String ruletypes = (String)atrrMap.get("ruletype");
        String dicts = (String)atrrMap.get("dict");
        String lenths = (String)atrrMap.get("length");
        if (autofield == null) {
            autofield = "";
        }
        List<String> listAutofield = Arrays.asList(autofield.split("`"));
        List<String> listTitle = Arrays.asList(orgTitle.split("`"));
        List<String> listSum = Arrays.asList(orgSum.split("`"));
        List<String> listUnit = Arrays.asList(orgUnit.split("`"));
        List<String> listValue = Arrays.asList(orgcolvalue.split("`"));
        List<String> listType = Arrays.asList(orgcoltype.split("`"));
        List<String> listIsHide = Arrays.asList(isHides.split("`"));
        List<String> listruletype = Arrays.asList(ruletypes.split("`"));
        List<String> listdict = Arrays.asList(dicts.split("`"));
        List<String> listlength = Arrays.asList(lenths.split("`"));
        int tdCount = listTitle.size();
        String tableId = String.valueOf(name) + "_table";
        String dsName = AutoFormTemplateParseUtil.getListDsName(listAutofield);
        boolean isExistSum = false;
        String listfk = "<input type=\"hidden\" name=\"listctrl_fk_" + dsName + "\" value=\"" + pkid + "\">";
        String listfkdsid = "<input type=\"hidden\" name=\"listctrl_fkdsid_" + dsName + "\" value=\"" + fkdsid + "\">";
        String rowTemplet = AutoFormTemplateParseUtil.getListctrlRowTemplet(name, atrrMap);
        String temp = String.valueOf(listfk) + listfkdsid + rowTemplet + "<table id=\"" + name + "_table\" bindTable=\"true\" cellspacing=\"0\" class=\"table table-bordered table-condensed\" style=\"" + style + "\"><thead>{0}</thead><tbody>{1}</tbody>{2}</table><input type=\"hidden\" id=\"tableId\" name=\"tableId\" value=\"" + tableId + "\">";
        String btnAdd = "<span class=\"pull-right\"><button id='" + name + "_listAdd' class=\"btn btn-small btn-success listAdd\" type=\"button\" tbname=\"" + name + "\">\u6dfb\u52a0\u4e00\u884c</button></span>";
        String theader = "<tr><th colspan=\"{0}\">{1}{2}</th></tr>{3}";
        String trTitle = "";
        int i = 0;
        while (i < tdCount) {
            String isHide = listIsHide.get(i);
            trTitle = !"1".equals(isHide) ? String.valueOf(trTitle) + MessageFormat.format("<th>{0}</th>", listTitle.get(i)) : String.valueOf(trTitle) + MessageFormat.format("<th style=\"display:none\">{0}</th>", listTitle.get(i));
            if (i + 1 == tdCount) {
                trTitle = String.valueOf(trTitle) + MessageFormat.format("<th><span style='width:60px;display:block;'>{0}</span></th>", "\u64cd\u4f5c");
            }
            ++i;
        }
        trTitle = "<tr>" + trTitle + "</tr>";
        List<Object> list = new ArrayList();
        if (StringUtil.isNotEmpty((Object)dsName)) {
            list = paras.get(dsName);
        }
        int n = rowCount = list != null ? list.size() : 1;
        if (rowCount < 1) {
            rowCount = 1;
        }
        StringBuilder sbTr = new StringBuilder();
        String tdSum = "";
        TreeMap<Integer, Float> SumValueDic = new TreeMap<Integer, Float>();
        int headerColspan = tdCount;
        int row = 0;
        while (row < rowCount) {
            Map dataMap = null;
            if (list != null && list.size() > 0) {
                dataMap = (Map)list.get(row);
                String tr = "";
                String tdContent = "";
                int i2 = 0;
                while (i2 < tdCount) {
                    String rowName = listAutofield.get(i2);
                    Object rowValue = AutoFormTemplateParseUtil.getListFieldValue(dataMap, listAutofield.get(i2));
                    String isHide = listIsHide.get(i2);
                    String ruletype = "0".equals(listruletype.get(i2)) ? "" : listruletype.get(i2);
                    String dict = "0".equals(listdict.get(i2)) ? "" : listdict.get(i2);
                    String length = "#".equals(listlength.get(i2)) ? "" : listlength.get(i2);
                    String unit = "";
                    if (listUnit != null && listUnit.size() == tdCount && !"#".equals(listUnit.get(i2))) {
                        unit = AutoFormTemplateParseUtil.getTypename("units", listUnit.get(i2));
                    }
                    String flag = "0";
                    if ("1".equals(isHide)) {
                        flag = "1";
                    }
                    String tdname = String.valueOf(rowName) + "[" + row + "]";
                    String sum = "1".equals(listSum.get(i2)) ? "sum=\"" + rowName + "\"" : "";
                    Object tdValue = "";
                    Object object = tdValue = rowValue != null ? rowValue : "";
                    if (tdValue instanceof Date) {
                        SimpleDateFormat sformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        tdValue = DateUtils.date2Str((Date)((Date)tdValue), (SimpleDateFormat)sformat);
                    }
                    String type = listType.get(i2);
                    if (sum != "") {
                        float tempTdValue = 0.0f;
                        if (SumValueDic.containsKey(i2)) {
                            tempTdValue = ((Float)SumValueDic.get(i2)).floatValue();
                        }
                        try {
                            float resultTdTemp = 0.0f;
                            resultTdTemp = Float.parseFloat((String)tdValue);
                            tempTdValue += resultTdTemp;
                        }
                        catch (Exception e) {
                            tdValue = "0";
                        }
                        if (SumValueDic.containsKey(i2)) {
                            SumValueDic.subMap(i2, i2);
                        } else {
                            SumValueDic.put(i2, Float.valueOf(tempTdValue));
                        }
                    }
                    if (!"1".equals(flag)) {
                        CgreportConfigHeadEntity cgreportConfigHeadEntity;
                        if ("text".equals(type)) {
                            tdContent = "<td><input class=\"input-medium\" type=\"text\"";
                            if (StringUtils.isNotBlank((String)ruletype)) {
                                tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                            } else if (StringUtils.isNotBlank((String)length)) {
                                tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                            }
                            tdContent = String.valueOf(tdContent) + "value=\"{0}\" name=\"{1}\" {2}>";
                            if (!"#".equals(unit)) {
                                tdContent = String.valueOf(tdContent) + unit;
                            }
                            tdContent = String.valueOf(tdContent) + "</td>";
                            tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                        } else if ("int".equals(type)) {
                            tdContent = "<td><input class=\"input-medium\" type=\"text\"";
                            if (StringUtils.isNotBlank((String)ruletype)) {
                                tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                            } else if (StringUtils.isNotBlank((String)length)) {
                                tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                            }
                            tdContent = String.valueOf(tdContent) + "value=\"{0}\" name=\"{1}\" {2}>";
                            if (!"#".equals(unit)) {
                                tdContent = String.valueOf(tdContent) + unit;
                            }
                            tdContent = String.valueOf(tdContent) + "</td>";
                            tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue, tdname, sum);
                        } else if ("textarea".equals(type)) {
                            tdContent = "<td><textarea  ";
                            if (StringUtils.isNotBlank((String)ruletype)) {
                                tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                            } else if (StringUtils.isNotBlank((String)length)) {
                                tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                            }
                            tdContent = String.valueOf(tdContent) + " name=\"{1}\" {2}>{0}</textarea></td>";
                            tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                        } else if ("calc".equals(type)) {
                            tdContent = "<td><input class=\"input-medium\" type=\"text\"";
                            if (StringUtils.isNotBlank((String)ruletype)) {
                                tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                            } else if (StringUtils.isNotBlank((String)length)) {
                                tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                            }
                            tdContent = String.valueOf(tdContent) + "value=\"{0}\" name=\"{1}\" {2}></td>";
                            tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue, tdname, sum);
                        } else if ("radio".equals(type)) {
                            StringBuffer radioBuff = new StringBuffer();
                            if (StringUtils.isNotBlank((String)dict)) {
                                radioBuff.append("<td>");
                                radioBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "radio", tdValue));
                                radioBuff.append("</td>");
                                tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdname);
                            } else {
                                radioBuff.append("<td><input class=\"input-medium\" type=\"radio\" value=\"{0}\" name=\"{1}\"></td>");
                                tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdValue, tdname);
                            }
                        } else if ("select".equals(type)) {
                            StringBuffer selectBuff = new StringBuffer();
                            if (StringUtils.isNotBlank((String)dict)) {
                                selectBuff.append("<td><select name=\"{0}\">");
                                selectBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "select", tdValue));
                                selectBuff.append("</select></td>");
                            } else {
                                selectBuff.append("<td><select class=\"input-medium\" name=\"{0}\"></select></td>");
                            }
                            tr = String.valueOf(tr) + MessageFormat.format(selectBuff.toString(), tdname);
                        } else if ("checkbox".equals(type)) {
                            StringBuffer checkboxBuff = new StringBuffer();
                            if (StringUtils.isNotBlank((String)dict)) {
                                checkboxBuff.append("<td>");
                                checkboxBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "checkbox", tdValue));
                                checkboxBuff.append("</td>");
                                tr = String.valueOf(tr) + MessageFormat.format(checkboxBuff.toString(), tdname);
                            } else {
                                checkboxBuff.append("<td><input class=\"input-medium\" type=\"checkbox\" value=\"{0}\" name=\"{1}\"></td>");
                                tr = String.valueOf(tr) + MessageFormat.format(checkboxBuff.toString(), tdValue, tdname);
                            }
                        } else if ("popup".equals(type) && (cgreportConfigHeadEntity = AutoFormTemplateParseUtil.getCgreportConfigHeadEntity(dict)) != null) {
                            StringBuffer radioBuff = new StringBuffer();
                            radioBuff.append("<td><input id=\"{0}\" name=\"{0}\" type=\"text\"  class=\"input-medium\" style=\"background: url(plug-in/easyui/themes/default/images/searchbox_button.png) 100% 50% no-repeat rgb(255, 255, 255);\" onClick='inputClick(this,\"" + cgreportConfigHeadEntity.getReturnValField() + "\",\"" + dict + "\");'  value=\"{1}\"></td>");
                            tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdname, tdValue);
                        }
                    } else {
                        --headerColspan;
                        tr = String.valueOf(tr) + MessageFormat.format("<td style=\"display:none\"><input class=\"input-medium\" type=\"hidden\" value=\"{0}\" name=\"{1}\" {2}></td>", tdValue, tdname, sum);
                    }
                    if (i2 + 1 == tdCount) {
                        tr = String.valueOf(tr) + "<td><button class=\"btn btn-small btn-success delrow\" type=\"button\">\u5220\u9664</button></td>";
                    }
                    if (row == 0 && !"1".equals(flag)) {
                        if (sum != "") {
                            isExistSum = true;
                            tdSum = String.valueOf(tdSum) + MessageFormat.format("<td>\u5408\u8ba1\uff1a<input class=\"input-small\" type=\"text\" value=\"value{0}\" name=\"{1}[total]\" {2}\">{3}</td>", i2, tdname, sum, "");
                        } else {
                            tdSum = String.valueOf(tdSum) + "<td></td>";
                        }
                    }
                    ++i2;
                }
                sbTr.append(MessageFormat.format("<tr class=\"template\">{0}</tr>", tr));
            }
            ++row;
        }
        if (!StringUtils.isBlank((String)tdSum)) {
            for (Integer i3 : SumValueDic.keySet()) {
                tdSum = tdSum.replace("value" + i3, ((Float)SumValueDic.get(i3)).toString());
                tdSum = MessageFormat.format("<tbody class=\"sum\"><tr>{0}</tr></tbody>", tdSum);
            }
        }
        theader = MessageFormat.format(theader, headerColspan + 1, title, btnAdd, trTitle);
        temp_html = MessageFormat.format(temp, theader, sbTr.toString(), tdSum);
        String divId = String.valueOf(name) + "_row_templet";
        temp_html = String.valueOf(temp_html) + "<script type=\"text/javascript\">";
        temp_html = String.valueOf(temp_html) + "$(function(){";
        temp_html = String.valueOf(temp_html) + "$(\"#" + name + "_listAdd\").click(function(){";
        temp_html = String.valueOf(temp_html) + "var tbHtml ='<tr>'+ $(\"#" + divId + "\").val().replace(/#textarea#/g,'textarea')+'</tr>';";
        temp_html = isExistSum ? String.valueOf(temp_html) + "$(\"#" + name + "_table" + " tbody\").eq(0).append(tbHtml);" : String.valueOf(temp_html) + "$(\"#" + name + "_table" + " tbody\").eq(0).append(tbHtml);";
        temp_html = String.valueOf(temp_html) + "$(\".delrow\").die().live(\"click\",function(){$(this).parent().parent().remove();" + name + "_resetTrNum();});" + name + "_resetTrNum();";
        temp_html = String.valueOf(temp_html) + "});";
        temp_html = String.valueOf(temp_html) + "$(\".delrow\").click(function(){$(this).parent().parent().remove();" + name + "_resetTrNum();});";
        temp_html = String.valueOf(temp_html) + "});";
        temp_html = String.valueOf(temp_html) + "function " + name + "_resetTrNum() {";
        temp_html = String.valueOf(temp_html) + "$(\"#" + name + "_table tbody tr\").each(function(i) {";
        temp_html = String.valueOf(temp_html) + "\t$(':input, select,a', this).each(function() {";
        temp_html = String.valueOf(temp_html) + "\tvar $this = $(this), name = $this.attr('name'), val = $this.val();";
        temp_html = String.valueOf(temp_html) + "\tif (name != null) {";
        temp_html = String.valueOf(temp_html) + "\t    if(name.indexOf('[')){";
        temp_html = String.valueOf(temp_html) + "            var subnames = name.split('[');";
        temp_html = String.valueOf(temp_html) + "            var newname = subnames[0]+'['+(i)+']';";
        temp_html = String.valueOf(temp_html) + "            $this.attr('name',newname); ";
        temp_html = String.valueOf(temp_html) + "}else{";
        temp_html = String.valueOf(temp_html) + "         var newname = name+  '['+i+']';";
        temp_html = String.valueOf(temp_html) + "         $this.attr('name',newname);";
        temp_html = String.valueOf(temp_html) + "      }";
        temp_html = String.valueOf(temp_html) + "\t }";
        temp_html = String.valueOf(temp_html) + " });";
        temp_html = String.valueOf(temp_html) + "});";
        temp_html = String.valueOf(temp_html) + "}";
        temp_html = String.valueOf(temp_html) + "</script>";
        return temp_html;
    }

    private static String getListctrlRowTemplet(String name, Map<String, Object> atrrMap) {
        String autofield = (String)atrrMap.get("autofield");
        String orgcoltype = (String)atrrMap.get("orgcoltype");
        String isHides = (String)atrrMap.get("ishide");
        String ruletypes = (String)atrrMap.get("ruletype");
        String dicts = (String)atrrMap.get("dict");
        String lenths = (String)atrrMap.get("length");
        String orgUnit = (String)atrrMap.get("orgunit");
        if (autofield == null) {
            autofield = "";
        }
        List<String> listAutofield = Arrays.asList(autofield.split("`"));
        List<String> listType = Arrays.asList(orgcoltype.split("`"));
        List<String> listIsHide = Arrays.asList(isHides.split("`"));
        List<String> listruletype = Arrays.asList(ruletypes.split("`"));
        List<String> listdict = Arrays.asList(dicts.split("`"));
        List<String> listlength = Arrays.asList(lenths.split("`"));
        List<String> listUnit = Arrays.asList(orgUnit.split("`"));
        StringBuilder rowTempletDiv = new StringBuilder();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String tr = "";
        int tdCount = listAutofield.size();
        int i = 0;
        while (i < tdCount) {
            String rowName = listAutofield.get(i);
            Object rowValue = AutoFormTemplateParseUtil.getListFieldValue(dataMap, listAutofield.get(i));
            String ruletype = "0".equals(listruletype.get(i)) ? "" : listruletype.get(i);
            String isHide = listIsHide.get(i);
            String flag = "0";
            if ("1".equals(isHide)) {
                flag = "1";
            }
            String length = "#".equals(listlength.get(i)) ? "" : listlength.get(i);
            String dict = "0".equals(listdict.get(i)) ? "" : listdict.get(i);
            String unit = "";
            if (listUnit != null && listUnit.size() == tdCount && !"#".equals(listUnit.get(i))) {
                unit = AutoFormTemplateParseUtil.getTypename("units", listUnit.get(i));
            }
            String tdname = String.valueOf(rowName) + "[#index#]";
            String sum = "";
            Object tdValue = "";
            Object object = tdValue = rowValue != null ? rowValue : "";
            if (tdValue instanceof Date) {
                SimpleDateFormat sformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                tdValue = DateUtils.date2Str((Date)((Date)tdValue), (SimpleDateFormat)sformat);
            }
            String type = listType.get(i);
            String tdContent = "";
            if (!"1".equals(flag)) {
                CgreportConfigHeadEntity cgreportConfigHeadEntity;
                if ("text".equals(type)) {
                    tdContent = String.valueOf(tdContent) + "<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}\" {2}";
                    if (StringUtils.isNotBlank((String)ruletype)) {
                        tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                    } else if (StringUtils.isNotBlank((String)length)) {
                        tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                    }
                    tdContent = String.valueOf(tdContent) + ">";
                    if (!"#".equals(unit)) {
                        tdContent = String.valueOf(tdContent) + unit;
                    }
                    tdContent = String.valueOf(tdContent) + "</td>";
                    tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                } else if ("int".equals(type)) {
                    tdContent = String.valueOf(tdContent) + "<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}\" {2}";
                    if (StringUtils.isNotBlank((String)ruletype)) {
                        tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                    } else if (StringUtils.isNotBlank((String)length)) {
                        tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                    }
                    tdContent = String.valueOf(tdContent) + ">";
                    if (!"#".equals(unit)) {
                        tdContent = String.valueOf(tdContent) + unit;
                    }
                    tdContent = String.valueOf(tdContent) + "</td>";
                    tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                } else if ("textarea".equals(type)) {
                    tdContent = "<td><#textarea#  ";
                    if (StringUtils.isNotBlank((String)ruletype)) {
                        tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                    } else if (StringUtils.isNotBlank((String)length)) {
                        tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                    }
                    tdContent = String.valueOf(tdContent) + " name=\"{1}\" {2}>{0}</#textarea#></td>";
                    tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                } else if ("calc".equals(type)) {
                    tdContent = String.valueOf(tdContent) + "<td><input class=\"input-medium\" type=\"text\" value=\"{0}\" name=\"{1}\" {2}";
                    if (StringUtils.isNotBlank((String)ruletype)) {
                        tdContent = String.valueOf(tdContent) + " datatype=\"" + ruletype + "\" ";
                    } else if (StringUtils.isNotBlank((String)length)) {
                        tdContent = String.valueOf(tdContent) + " style=\"width:" + length + "px\"";
                    }
                    tdContent = String.valueOf(tdContent) + "></td>";
                    tr = String.valueOf(tr) + MessageFormat.format(tdContent, tdValue.toString(), tdname, sum);
                } else if ("radio".equals(type)) {
                    StringBuffer radioBuff = new StringBuffer();
                    if (StringUtils.isNotBlank((String)dict)) {
                        radioBuff.append("<td>");
                        radioBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "radio", null));
                        radioBuff.append("</td>");
                        tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdname);
                    } else {
                        radioBuff.append("<td><input class=\"input-medium\" type=\"radio\" value=\"{0}\" name=\"{1}\"></td>");
                        tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdValue, tdname);
                    }
                } else if ("select".equals(type)) {
                    StringBuffer selectBuff = new StringBuffer();
                    if (StringUtils.isNotBlank((String)dict)) {
                        selectBuff.append("<td><select name=\"{0}\">");
                        selectBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "select", null));
                        selectBuff.append("</select></td>");
                    } else {
                        selectBuff.append("<td><select class=\"input-medium\" name=\"{0}\"></select></td>");
                    }
                    tr = String.valueOf(tr) + MessageFormat.format(selectBuff.toString(), tdname);
                } else if ("checkbox".equals(type)) {
                    StringBuffer checkboxBuff = new StringBuffer();
                    if (StringUtils.isNotBlank((String)dict)) {
                        checkboxBuff.append("<td>");
                        checkboxBuff.append(AutoFormTemplateParseUtil.getDicts(dict, "checkbox", null));
                        checkboxBuff.append("</td>");
                        tr = String.valueOf(tr) + MessageFormat.format(checkboxBuff.toString(), tdname);
                    } else {
                        checkboxBuff.append("<td><input class=\"input-medium\" type=\"checkbox\" value=\"{0}\" name=\"{1}\"></td>");
                        tr = String.valueOf(tr) + MessageFormat.format(checkboxBuff.toString(), tdValue, tdname);
                    }
                } else if ("popup".equals(type) && (cgreportConfigHeadEntity = AutoFormTemplateParseUtil.getCgreportConfigHeadEntity(dict)) != null) {
                    StringBuffer radioBuff = new StringBuffer();
                    radioBuff.append("<td><input id=\"{0}\" name=\"{0}\" type=\"text\"  class=\"input-medium\" style=\"background: url(plug-in/easyui/themes/default/images/searchbox_button.png) 100% 50% no-repeat rgb(255, 255, 255);\" onClick='inputClick(this,\"" + cgreportConfigHeadEntity.getReturnValField() + "\",\"" + dict + "\");' value=\"\"></td>");
                    tr = String.valueOf(tr) + MessageFormat.format(radioBuff.toString(), tdname);
                }
            } else {
                tr = String.valueOf(tr) + MessageFormat.format("<td style=\"display:none\"><input class=\"input-medium\" type=\"hidden\" value=\"{0}\" name=\"{1}\" {2}></td>", tdValue, tdname, sum);
            }
            if (i + 1 == tdCount) {
                tr = String.valueOf(tr) + "<td><button class=\"btn btn-small btn-success delrow\" type=\"button\">\u5220\u9664</button></td>";
            }
            ++i;
        }
        String divId = String.valueOf(name) + "_row_templet";
        rowTempletDiv.append(MessageFormat.format("<textarea id=\"" + divId + "\" style=\"display:none\" disabled=\"true\" >{0}</textarea>", tr));
        return rowTempletDiv.toString();
    }

    private static String getText(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String style = (String)atrrMap.get("style");
        String title = (String)atrrMap.get("title");
        String name = (String)atrrMap.get("name");
        String orghide = (String)atrrMap.get("orghide");
        String orgtype = (String)atrrMap.get("orgtype");
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        if ("1".equals(orghide)) {
            sb.append(" type=").append("\"").append("hidden").append("\"");
        } else if ("standardDate".equals(orgtype) || "fullDate".equals(orgtype)) {
            sb.append(" type=").append("\"text\"");
            if ("fullDate".equals(orgtype)) {
                sb.append(" class=\"Wdate\" onClick=\"WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});\"");
            } else if ("standardDate".equals(orgtype)) {
                sb.append(" class=\"Wdate\" onClick=\"WdatePicker({dateFmt:'yyyy-MM-dd'});\"");
            }
        } else {
            sb.append(" type=").append("\"").append(orgtype).append("\"");
        }
        sb.append(" style=").append("\"").append(style).append("\"");
        sb.append(" title=").append("\"").append(title).append("\"");
        sb.append(" name=").append("\"").append(name).append("\"");
        sb.append(" value=").append("\"").append(AutoFormTemplateParseUtil.getSingleValue(autofield, paras)).append("\"");
        if (StringUtils.isNotBlank((String)datatype)) {
            sb.append(" datatype=").append("\"").append(datatype).append("\"");
        }
        sb.append(" />");
        html = sb.toString();
        return html;
    }

    private static String getTextarea(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String style = (String)atrrMap.get("style");
        String title = (String)atrrMap.get("title");
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        StringBuilder sb = new StringBuilder();
        sb.append("<textarea ");
        sb.append(" style=").append("\"").append(style).append("\"");
        sb.append(" title=").append("\"").append(title).append("\"");
        sb.append(" name=").append("\"").append(autofield).append("\"");
        if (StringUtils.isNotBlank((String)datatype)) {
            sb.append(" datatype=").append("\"").append(datatype).append("\"");
        }
        sb.append(" >");
        sb.append(AutoFormTemplateParseUtil.getSingleValue(autofield, paras));
        sb.append("</textarea>");
        html = sb.toString();
        return html;
    }

    private static String getHiddenText(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String name = (String)atrrMap.get("name");
        String autofield = (String)atrrMap.get("autofield");
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        sb.append(" type=").append("\"").append("hidden").append("\"");
        sb.append(" name=").append("\"").append(name).append("\"");
        sb.append(" value=").append("\"").append(AutoFormTemplateParseUtil.getSingleValue(autofield, paras)).append("\"");
        sb.append(" />");
        html = sb.toString();
        return html;
    }

    private static String getPopup(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String style = (String)atrrMap.get("style");
        String title = (String)atrrMap.get("title");
        String name = (String)atrrMap.get("name");
        String orgwidth = (String)atrrMap.get("orgwidth");
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        String dictionary = (String)atrrMap.get("dictionary");
        String[] dicts = dictionary.split(",");
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        sb.append(" type=").append("\"text\"");
        sb.append(" style=").append("\"").append("width: auto; background: url(plug-in/easyui/themes/default/images/searchbox_button.png) 100% 50% no-repeat rgb(255, 255, 255);").append("\"");
        sb.append(" title=").append("\"").append(title).append("\"");
        sb.append(" name=").append("\"").append(name).append("\"");
        sb.append(" value=").append("\"").append(AutoFormTemplateParseUtil.getSingleValue(autofield, paras)).append("\"");
        if (StringUtils.isNotBlank((String)datatype)) {
            sb.append(" datatype=").append("\"").append(datatype).append("\"");
        }
        if (dicts.length == 3) {
            sb.append(" onClick=").append("\"").append("inputClick(this,'" + dicts[1] + "','" + dicts[0] + "');").append("\"");
        }
        sb.append(" />");
        html = sb.toString();
        return html;
    }

    private static String getCheckbox(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        StringBuilder sb = new StringBuilder();
        JSONArray options = (JSONArray)atrrMap.get("options");
        List list = new ArrayList();
        list = JSONHelper.toList((JSONArray)options);
        for (Map map : list) {
            Object datavalue;
            String checkedtext = (String)map.get("checkedtext");
            String value = (String)map.get("value");
            sb.append("<input type=\"checkbox\"");
            sb.append(" name=\"").append(autofield).append("\"");
            sb.append(" value=\"").append(value).append("\"");
            if (StringUtils.isNotBlank((String)datatype)) {
                sb.append(" datatype=").append("\"").append(datatype).append("\"");
            }
            if ((datavalue = AutoFormTemplateParseUtil.getSingleValue(autofield, paras)) != null && datavalue.equals(value)) {
                sb.append(" checked=\"checked\"");
            }
            sb.append(">").append(checkedtext).append("&nbsp;");
        }
        html = sb.toString();
        return html;
    }

    private static String getRadio(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        StringBuilder sb = new StringBuilder();
        JSONArray options = (JSONArray)atrrMap.get("options");
        List list = new ArrayList();
        list = JSONHelper.toList((JSONArray)options);
        for (Map map : list) {
            Object datavalue;
            String checkedtext = (String)map.get("checkedtext");
            String value = (String)map.get("value");
            sb.append("<input type=\"radio\"");
            sb.append(" name=\"").append(autofield).append("\"");
            sb.append(" value=\"").append(value).append("\"");
            if (StringUtils.isNotBlank((String)datatype)) {
                sb.append(" datatype=").append("\"").append(datatype).append("\"");
            }
            if ((datavalue = AutoFormTemplateParseUtil.getSingleValue(autofield, paras)) != null && datavalue.equals(value)) {
                sb.append(" checked=\"checked\"");
            }
            sb.append(">").append(checkedtext).append("&nbsp;");
        }
        html = sb.toString();
        return html;
    }

    private static String getSelect(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String style = (String)atrrMap.get("style");
        String title = (String)atrrMap.get("title");
        String size = (String)atrrMap.get("size");
        String autofield = (String)atrrMap.get("autofield");
        String datatype = (String)atrrMap.get("datatype");
        StringBuilder sb = new StringBuilder();
        String content = (String)atrrMap.get("content");
        sb.append("<select ");
        sb.append("style=").append("\"").append(style).append("\"");
        sb.append(" size=").append("\"").append(size).append("\"");
        sb.append(" title=").append("\"").append(title).append("\"");
        sb.append(" name=").append("\"").append(autofield).append("\"");
        if (StringUtils.isNotBlank((String)datatype)) {
            sb.append(" datatype=").append("\"").append(datatype).append("\"");
        }
        sb.append(">");
        sb.append(AutoFormTemplateParseUtil.getSelectOption(content, (String)AutoFormTemplateParseUtil.getSingleValue(autofield, paras)));
        sb.append("</select>");
        html = sb.toString();
        return html;
    }

    private static String getSelectOption(String content, String value) {
        StringBuilder option = new StringBuilder();
        Document doc = Jsoup.parse((String)content);
        Elements selectElements = doc.getElementsByTag("select").select("option");
        for (Element el : selectElements) {
            if (el.attr("value").equals(value)) {
                option.append(" <option value=\"").append(el.attr("value")).append("\" selected>").append(el.text()).append("</option>");
                continue;
            }
            option.append(" <option value=\"").append(el.attr("value")).append("\">").append(el.text()).append("</option>");
        }
        return option.toString();
    }

    private static String getMacros(Map<String, Object> atrrMap, Map<String, List<Map<String, Object>>> paras) {
        String html = "";
        String orgtype = (String)atrrMap.get("orgtype");
        String title = (String)atrrMap.get("title");
        String orghide = (String)atrrMap.get("orghide");
        String name = (String)atrrMap.get("name");
        String style = (String)atrrMap.get("style");
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        if ("1".equals(orghide)) {
            sb.append("type=").append("\"").append("hidden").append("\"");
        } else {
            sb.append("type=").append("\"text\"");
        }
        sb.append("style=").append("\"").append(style).append("\"");
        sb.append("title=").append("\"").append(title).append("\"");
        sb.append("name=").append("\"").append(name).append("\"");
        sb.append("value=").append("\"").append(AutoFormTemplateParseUtil.getFormat(orgtype)).append("\"");
        sb.append(" readonly=\"true\" />");
        html = sb.toString();
        return html;
    }

    private static String getFormat(String orgtype) {
        String orgName = "";
        TSUser user = ClientManager.getInstance().getClient().getUser();
        SimpleDateFormat format = null;
        if ("sys_datetime".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            orgName = format.format(new Date());
        } else if ("sys_date".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy-MM-dd");
            orgName = format.format(new Date());
        } else if ("sys_date_cn".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            orgName = format.format(new Date());
        } else if ("sys_date_cn_short1".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy\u5e74MM\u6708");
            orgName = format.format(new Date());
        } else if ("sys_date_cn_short4".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy");
            orgName = format.format(new Date());
        } else if ("sys_date_cn_short3".equals(orgtype)) {
            format = new SimpleDateFormat("yyyy\u5e74");
            orgName = format.format(new Date());
        } else if ("sys_date_cn_short2".equals(orgtype)) {
            format = new SimpleDateFormat("MM\u6708dd\u65e5");
            orgName = format.format(new Date());
        } else if ("sys_time".equals(orgtype)) {
            format = new SimpleDateFormat("HH:mm:ss");
            orgName = format.format(new Date());
        } else if ("sys_week".equals(orgtype)) {
            orgName = AutoFormTemplateParseUtil.getWeekDay();
        } else if ("sys_userid".equals(orgtype)) {
            orgName = user.getUserName();
        } else if ("sys_realname".equals(orgtype)) {
            orgName = user.getRealName();
        } else if ("sys_dept".equals(orgtype)) {
            orgName = user.getCurrentDepart().getDepartname();
        }
        return orgName;
    }

    private static String getWeekDay() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(System.currentTimeMillis()));
        int dayOfWeek = c.get(7);
        String day = "";
        switch (dayOfWeek) {
            case 1: {
                day = "\u661f\u671f\u65e5";
            }
            case 2: {
                day = "\u661f\u671f\u4e00";
            }
            case 3: {
                day = "\u661f\u671f\u4e8c";
            }
            case 4: {
                day = "\u661f\u671f\u4e09";
            }
            case 5: {
                day = "\u661f\u671f\u56db";
            }
            case 6: {
                day = "\u661f\u671f\u4e94";
            }
            case 7: {
                day = "\u661f\u671f\u516d";
            }
        }
        return day;
    }

    private static List<Map<String, Object>> getAllInputAttr(JSONObject jsonObj) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        list = JSONHelper.toList((Object)jsonObj.get("data"));
        return list;
    }

    private static Object getSingleValue(String autofield, Map<String, List<Map<String, Object>>> paras) {
        Map<String, Object> map;
        List<Map<String, Object>> list;
        String[] name;
        Object value = "";
        if (autofield == null) {
            autofield = "";
        }
        if ((name = autofield.split("\\.")).length == 2 && (list = paras.get(name[0])) != null && list.size() > 0 && (map = list.get(0)) != null && (value = map.get(name[1])) == null) {
            value = "";
        }
        return value;
    }

    private static String getListDsName(List<String> listAutofield) {
        String dsName = null;
        if (listAutofield != null && listAutofield.size() > 0) {
            for (String dsAtrr : listAutofield) {
                String[] dsNames;
                if (!StringUtil.isNotEmpty((Object)dsAtrr) || (dsNames = dsAtrr.split("\\.")).length != 2) continue;
                dsName = dsNames[0];
                break;
            }
        }
        return dsName;
    }

    private static String getListFieldName(String field) {
        String[] names;
        String name = null;
        if (StringUtil.isNotEmpty((Object)field) && (names = field.split("\\.")).length == 2) {
            name = names[1];
        }
        return name;
    }

    private static Object getListFieldValue(Map<String, Object> dataMap, String field) {
        Object obj = "";
        String fieldName = AutoFormTemplateParseUtil.getListFieldName(field);
        if (fieldName != null && (obj = dataMap.get(fieldName)) == null) {
            obj = "";
        }
        return obj;
    }

    private static String getDicts(String typeGroupCode, String type, Object tdValue) {
        List types = (List)TSTypegroup.allTypes.get(typeGroupCode.toLowerCase());
        StringBuffer content = new StringBuffer();
        if (types.size() > 0) {
            for (TSType tSType : types) {
                if ("select".equals(type)) {
                    content.append("<option value=\"").append(tSType.getTypecode()).append("\"");
                    if (tdValue != null && tdValue.equals(tSType.getTypecode())) {
                        content.append(" selected=\"selected\"");
                    }
                    content.append(">");
                    content.append(AutoFormTemplateParseUtil.getMutiLang(tSType.getTypename())).append("</option>");
                    continue;
                }
                if ("radio".equals(type)) {
                    content.append("<input type=\"radio\" name=\"{0}\" value=\"").append(tSType.getTypecode()).append("\"");
                    if (tdValue != null && tdValue.equals(tSType.getTypecode())) {
                        content.append(" checked=\"checked\"");
                    }
                    content.append(">").append(AutoFormTemplateParseUtil.getMutiLang(tSType.getTypename()));
                    continue;
                }
                if (!"checkbox".equals(type)) continue;
                content.append("<input type=\"checkbox\" name=\"{0}\" value=\"").append(tSType.getTypecode()).append("\"");
                if (tdValue != null && tdValue.equals(tSType.getTypecode())) {
                    content.append(" checked=\"checked\"");
                }
                content.append(">").append(AutoFormTemplateParseUtil.getMutiLang(tSType.getTypename()));
            }
        }
        return content.toString();
    }

    private static String getMutiLang(String key) {
        if (mutiLangService == null) {
            mutiLangService = (MutiLangServiceI)ApplicationContextUtil.getContext().getBean(MutiLangServiceI.class);
        }
        String lang_context = mutiLangService.getLang(key);
        return lang_context;
    }

    private static String getTypename(String typeGroupCode, String code) {
        TSTypegroup typeGroup = (TSTypegroup)TSTypegroup.allTypeGroups.get(typeGroupCode.toLowerCase());
        List types = (List)TSTypegroup.allTypes.get(typeGroupCode.toLowerCase());
        String codename = "";
        for (TSType tSType : types) {
            if (!tSType.getTypecode().equals(code)) continue;
            codename = tSType.getTypename();
            break;
        }
        return codename;
    }

    private static CgreportConfigHeadEntity getCgreportConfigHeadEntity(String code) {
        CgreportConfigHeadEntity cgreportConfigHeadEntity = null;
        if (cgreportConfigHeadService == null) {
            cgreportConfigHeadService = (CgreportConfigHeadServiceI)ApplicationContextUtil.getContext().getBean(CgreportConfigHeadServiceI.class);
        }
        cgreportConfigHeadEntity = (CgreportConfigHeadEntity)cgreportConfigHeadService.findUniqueByProperty(CgreportConfigHeadEntity.class, "code", code);
        return cgreportConfigHeadEntity;
    }
}

