/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.generate;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.core.util.PropertiesUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.cgformftl.CgformFtlServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.util.TemplateUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="templetContextWord")
public class TempletContextWord {
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private CgformFtlServiceI cgformFtlService;
    @Resource(name="freemarkerWord")
    private Configuration freemarker;
    private Map<String, TemplateDirectiveModel> tags;
    private static final String ENCODING = "UTF-8";
    private static Cache ehCache;
    private static String _sysMode;

    static {
        _sysMode = null;
        PropertiesUtil util = new PropertiesUtil("sysConfig.properties");
        _sysMode = util.readProperty("sqlReadMode");
        if ("PUB".equalsIgnoreCase(_sysMode)) {
            ehCache = CacheManager.getInstance().getCache("dictCache");
        }
    }

    @PostConstruct
    public void init() {
        if (this.tags == null) {
            return;
        }
        for (String key : this.tags.keySet()) {
            this.freemarker.setSharedVariable(key, (TemplateModel)this.tags.get(key));
        }
    }

    public Locale getLocale() {
        return this.freemarker.getLocale();
    }

    public Template getTemplate(String tableName, String ftlVersion) {
        Template template = null;
        if (tableName == null) {
            return null;
        }
        String oldTableName = tableName;
        if (ftlVersion != null && ftlVersion.length() > 0) {
            tableName = String.valueOf(tableName) + "&ftlVersion=" + ftlVersion;
        }
        try {
            if ("DEV".equalsIgnoreCase(_sysMode)) {
                template = this.freemarker.getTemplate(tableName, this.freemarker.getLocale(), ENCODING);
            } else if ("PUB".equalsIgnoreCase(_sysMode)) {
                String version = this.cgFormFieldService.getCgFormVersionByTableName(oldTableName);
                template = this.getTemplateFromCache(tableName, ENCODING, version);
            } else {
                throw new RuntimeException("sysConfig.properties\u7684freeMarkerMode\u914d\u7f6e\u9519\u8bef\uff1a(PUB:\u751f\u4ea7\u6a21\u5f0f\uff0cDEV:\u5f00\u53d1\u6a21\u5f0f)");
            }
            return template;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Template getTemplateFromCache(String tableName, String encoding, String version) {
        Template template = null;
        try {
            String cacheKey = String.valueOf(FreemarkerHelper.class.getName()) + ".getTemplateFormCache." + tableName + "." + version;
            Element element = ehCache.get((Serializable)((Object)cacheKey));
            if (element == null) {
                template = this.freemarker.getTemplate(tableName, this.freemarker.getLocale(), ENCODING);
                element = new Element((Object)cacheKey, (Object)template);
                ehCache.put(element);
            } else {
                template = (Template)element.getObjectValue();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return template;
    }

    public Configuration getFreemarker() {
        return this.freemarker;
    }

    public void setFreemarker(Configuration freemarker) {
        this.freemarker = freemarker;
    }

    public Map<String, TemplateDirectiveModel> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, TemplateDirectiveModel> tags) {
        this.tags = tags;
    }

    public String autoFormGenerateHtml(String tableName, String id, String mode) {
        String html = this.autoFormViewGenerateHtml(tableName, id, mode);
        html = html.replace("<html xmlns:m=\"http://schemas.microsoft.com/office/2004/12/omml\">", "<%@ page language=\"java\" import=\"java.util.*\" contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\"%><br><%@include file=\"/context/mytags.jsp\"%>");
        html = html.replace("cgFormBuildController.do?saveOrUpdate", "@@{entityName?uncap_first}Controller.do?doAdd");
        html = html.replace("@@@", "${'$'}");
        html = html.replace("@{onlineCodeGenereateEntityKey@", "${'$'}{${entityName?uncap_first}Page");
        html = html.replace("onlineCodeGenereateEntityKey", "${entityName?uncap_first}Page");
        html = html.replace("@@", "$");
        return html;
    }

    private String autoFormViewGenerateHtml(String tableName, String id, String mode) {
        String subTableStr;
        HashMap<Object, Object> data = new HashMap();
        String templateName = String.valueOf(tableName) + "_";
        TemplateUtil.TemplateType templateType = TemplateUtil.TemplateType.LIST;
        if (StringUtils.isBlank((String)id)) {
            templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.ADD.getName();
            templateType = TemplateUtil.TemplateType.ADD;
        } else if ("read".equals(mode)) {
            templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.DETAIL.getName();
            templateType = TemplateUtil.TemplateType.DETAIL;
        } else {
            templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.UPDATE.getName();
            templateType = TemplateUtil.TemplateType.UPDATE;
        }
        String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
        Map<String, Object> configData = this.cgFormFieldService.getFtlFormConfig(tableName, version);
        data = new HashMap<String, Object>(configData);
        CgFormHeadEntity head = (CgFormHeadEntity)data.get("head");
        Map<Object, Object> dataForm = new HashMap();
        if (StringUtils.isNotEmpty((String)id)) {
            dataForm = this.dataBaseService.findOneForJdbc(tableName, id);
        }
        for (Map.Entry entry : dataForm.entrySet()) {
            String ok = (String)entry.getKey();
            Object ov = entry.getValue();
            data.put(ok, ov);
        }
        HashMap<String, Cloneable> tableData = new HashMap<String, Cloneable>();
        tableData.put(tableName, (Cloneable)((Object)dataForm));
        if (StringUtils.isNotEmpty((String)id) && head.getJformType() == 2 && StringUtils.isNotEmpty((String)(subTableStr = head.getSubTableStr()))) {
            String[] subTables = subTableStr.split(",");
            List<Object> subTableData = new ArrayList();
            String[] stringArray = subTables;
            int n = subTables.length;
            int n2 = 0;
            while (n2 < n) {
                String subTable = stringArray[n2];
                subTableData = this.cgFormFieldService.getSubTableData(tableName, subTable, id);
                tableData.put(subTable, (Cloneable)((Object)subTableData));
                ++n2;
            }
        }
        data.put("data", tableData);
        data.put("id", id);
        data.put("head", head);
        String content = null;
        content = this.getTableTemplate(templateName, data);
        return content;
    }

    private String replaceAddJSP(String cgformJspHtml) {
        while (cgformJspHtml.indexOf("#{") > 0) {
            String key = cgformJspHtml.substring(cgformJspHtml.indexOf("#{"), cgformJspHtml.indexOf("}", cgformJspHtml.indexOf("#{")) + 1);
            String realKey = key.substring(2, key.length() - 1);
            cgformJspHtml = cgformJspHtml.replace(key, "<input id='" + JeecgReadTable.formatField((String)realKey) + "' name='" + JeecgReadTable.formatField((String)realKey) + "' type='text' value='${'$'}{${entityName?uncap_first}." + JeecgReadTable.formatField((String)realKey) + "}' style='width: 150px' class='inputxt' >");
        }
        return cgformJspHtml;
    }

    private String getTableTemplate(String templateName, Map data) {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(stringWriter);
        String ftlVersion = oConvertUtils.getString(data.get("version"));
        Template template = this.getTemplate(templateName, ftlVersion);
        try {
            template.process((Object)data, (Writer)writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }
}

