/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.generate;

import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;

public class FormHtmlUtilWord {
    public static String getFormHTML(CgFormFieldEntity cgFormFieldEntity) {
        String html = "";
        html = cgFormFieldEntity.getShowType().equals("text") ? FormHtmlUtilWord.getTextFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("password") ? FormHtmlUtilWord.getPwdFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("radio") ? FormHtmlUtilWord.getRadioFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("checkbox") ? FormHtmlUtilWord.getCheckboxFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("list") ? FormHtmlUtilWord.getListFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("date") ? FormHtmlUtilWord.getDateFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("datetime") ? FormHtmlUtilWord.getDatetimeFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("file") ? FormHtmlUtilWord.getFileFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("textarea") ? FormHtmlUtilWord.getTextAreaFormHtml(cgFormFieldEntity) : (cgFormFieldEntity.getShowType().equals("popup") ? FormHtmlUtilWord.getPopupFormHtml(cgFormFieldEntity) : FormHtmlUtilWord.getTextFormHtml(cgFormFieldEntity))))))))));
        return html;
    }

    private static String getTextAreaFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<textarea  style=\"width: 300px\" rows=\"6\" ");
        html.append("id=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        html.append("name=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\>");
        html.append("\\${").append(cgFormFieldEntity.getFieldName()).append("?if_exists?html}</textarea> ");
        return html.toString();
    }

    private static String getTextFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"text\" ");
        html.append("id=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        html.append("name=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(cgFormFieldEntity.getFieldName()).append("}\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else if ("int".equals(cgFormFieldEntity.getType())) {
            html.append("datatype=\"n\" ");
        } else if ("double".equals(cgFormFieldEntity.getType())) {
            html.append("datatype=\"\\/^(-?\\\\d+)(\\\\.\\\\d+)?\\$\\/\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\/>");
        return html.toString();
    }

    private static String getPwdFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"password\" ");
        html.append("id=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        html.append("name=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(cgFormFieldEntity.getFieldName()).append("}\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\/>");
        return html.toString();
    }

    private static String getRadioFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        if (StringUtil.isEmpty((String)cgFormFieldEntity.getDictField())) {
            return FormHtmlUtilWord.getTextFormHtml(cgFormFieldEntity);
        }
        StringBuilder html = new StringBuilder("");
        html.append("<@DictData name=\"" + cgFormFieldEntity.getDictField() + "\"");
        if (!StringUtil.isEmpty((String)cgFormFieldEntity.getDictTable())) {
            html.append(" tablename=\"" + cgFormFieldEntity.getDictTable() + "\"");
        }
        html.append(" var=\"dictDataList\">");
        html.append("<#list dictDataList as dictdata>");
        html.append(" <input type=\"radio\" value=\"\\${dictdata.typecode?if_exists?html}\" name=\"" + cgFormFieldEntity.getFieldName() + "\" ");
        html.append("<c:if test=\"@@@{onlineCodeGenereateEntityKey." + cgFormFieldEntity.getFieldName() + "=='\\${dictdata.typecode?if_exists?html}'}\" >");
        html.append(" checked=\"true\" ");
        html.append("</c:if>");
        html.append(">");
        html.append("\\${dictdata.typename?if_exists?html}");
        html.append("</#list> ");
        html.append("</@DictData> ");
        return html.toString();
    }

    private static String getCheckboxFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        if (StringUtil.isEmpty((String)cgFormFieldEntity.getDictField())) {
            return FormHtmlUtilWord.getTextFormHtml(cgFormFieldEntity);
        }
        StringBuilder html = new StringBuilder("");
        html.append("<#assign checkboxstr>\\${data['").append(cgFormFieldEntity.getFieldName()).append("']?if_exists?html}</#assign>");
        html.append("<#assign checkboxlist=checkboxstr?split(\",\")> ");
        html.append("<@DictData name=\"" + cgFormFieldEntity.getDictField() + "\"");
        if (!StringUtil.isEmpty((String)cgFormFieldEntity.getDictTable())) {
            html.append(" tablename=\"" + cgFormFieldEntity.getDictTable() + "\"");
        }
        html.append(" var=\"dictDataList\">");
        html.append("<#list dictDataList as dictdata>");
        html.append(" <input type=\"checkbox\" value=\"\\${dictdata.typecode?if_exists?html}\" name=\"" + cgFormFieldEntity.getFieldName() + "\" ");
        html.append("<c:if test=\"@@@{onlineCodeGenereateEntityKey." + cgFormFieldEntity.getFieldName() + "=='\\${dictdata.typecode?if_exists?html}'}\" >");
        html.append(" checked=\"true\" ");
        html.append("</c:if>");
        html.append("<#if dictdata.typecode=='\\${").append(cgFormFieldEntity.getFieldName()).append("?if_exists?html}'>");
        html.append(" checked=\"true\" ");
        html.append("</#if> ");
        html.append(">");
        html.append("\\${dictdata.typename?if_exists?html}");
        html.append("</#list> ");
        html.append("</@DictData> ");
        return html.toString();
    }

    private static String getListFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        if (StringUtil.isEmpty((String)cgFormFieldEntity.getDictField())) {
            return FormHtmlUtilWord.getTextFormHtml(cgFormFieldEntity);
        }
        StringBuilder html = new StringBuilder("");
        html.append("<@DictData name=\"" + cgFormFieldEntity.getDictField() + "\"");
        if (!StringUtil.isEmpty((String)cgFormFieldEntity.getDictText())) {
            html.append(" text=\"" + cgFormFieldEntity.getDictText() + "\"");
        }
        if (!StringUtil.isEmpty((String)cgFormFieldEntity.getDictTable())) {
            html.append(" tablename=\"" + cgFormFieldEntity.getDictTable() + "\"");
        }
        html.append(" var=\"dictDataList\">");
        html.append("<select name=\"" + JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName()) + "\" id=\"" + JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName()) + "\"> ");
        html.append("<#list dictDataList as dictdata>");
        html.append(" <option value=\"\\${dictdata.typecode?if_exists?html}\" ");
        html.append("<c:if test=\"@@@{onlineCodeGenereateEntityKey." + JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName()) + "=='\\${dictdata.typecode?if_exists?html}'}\" >");
        html.append(" selected=\"selected\" ");
        html.append("</c:if>");
        html.append(">");
        html.append("\\${dictdata.typename?if_exists?html}");
        html.append("</option> ");
        html.append("</#list> ");
        html.append("</select>");
        html.append("</@DictData> ");
        return html.toString();
    }

    private static String getDateFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"text\" ");
        html.append("id=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("name=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("class=\"Wdate\" ");
        html.append("onClick=\"WdatePicker()\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("}\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\/>");
        return html.toString();
    }

    private static String getDatetimeFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"text\" ");
        html.append("id=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("name=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("class=\"Wdate\" ");
        html.append("onClick=\"WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("}\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\/>");
        return html.toString();
    }

    private static String getFileFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"text\" ");
        html.append("id=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("name=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("}\" ");
        html.append("\\/>");
        return html.toString();
    }

    private static String getPopupFormHtml(CgFormFieldEntity cgFormFieldEntity) {
        StringBuilder html = new StringBuilder("");
        html.append("<input type=\"text\" readonly=\"readonly\" class=\"searchbox-inputtext\" ");
        html.append("id=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        html.append("name=\"").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("\" ");
        if (cgFormFieldEntity.getFieldLength() != null && cgFormFieldEntity.getFieldLength() > 0) {
            html.append("style=\"width:").append(cgFormFieldEntity.getFieldLength()).append("px\" ");
        }
        html.append("value=\"\\@{onlineCodeGenereateEntityKey@.").append(JeecgReadTable.formatField((String)cgFormFieldEntity.getFieldName())).append("}\" ");
        html.append("onclick=\"inputClick(this,'" + cgFormFieldEntity.getDictText() + "','" + cgFormFieldEntity.getDictTable() + "');\" ");
        if ("Y".equals(cgFormFieldEntity.getIsNull())) {
            html.append("ignore=\"ignore\" ");
        }
        if (cgFormFieldEntity.getFieldValidType() != null && cgFormFieldEntity.getFieldValidType().length() > 0) {
            html.append("datatype=\"").append(cgFormFieldEntity.getFieldValidType()).append("\" ");
        } else {
            html.append("datatype=\"*\" ");
        }
        html.append("\\/>");
        return html.toString();
    }
}

