/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.jeecgframework.web.cgform.service.config.DbTableHandleI;
import org.jeecgframework.web.cgform.service.config.DbTableServiceI;
import org.jeecgframework.web.cgform.service.impl.config.DbTableMysqlHandleImpl;
import org.jeecgframework.web.cgform.service.impl.config.DbTableOracleHandleImpl;
import org.jeecgframework.web.cgform.service.impl.config.DbTablePostgresHandleImpl;
import org.jeecgframework.web.cgform.service.impl.config.DbTableServiceMysqlImpl;
import org.jeecgframework.web.cgform.service.impl.config.TableSQLServerHandleImpl;

public class DbTableUtil {
    public static Map<String, Object> getColumnMap(List<Map<String, Object>> queryForList) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        int i = 0;
        while (i < queryForList.size()) {
            columnMap.put(queryForList.get(i).get("column_name").toString(), queryForList.get(i));
            ++i;
        }
        return columnMap;
    }

    public static String translatorToDbField(String fileName) {
        return fileName;
    }

    public static DbTableServiceI getTableUtil(Session session) {
        DbTableServiceMysqlImpl tableUtil = null;
        String dialect = ((SessionImpl)session).getFactory().getDialect().getClass().getName();
        if (dialect.equals("org.hibernate.dialect.MySQLDialect")) {
            tableUtil = new DbTableServiceMysqlImpl();
        }
        return tableUtil;
    }

    public static DbTableHandleI getTableHandle(Session session) {
        DbTableHandleI dbTableHandle = null;
        String dialect = ((SessionImpl)session).getFactory().getDialect().getClass().getName();
        if (dialect.equals("org.hibernate.dialect.MySQLDialect")) {
            dbTableHandle = new DbTableMysqlHandleImpl();
        } else if (dialect.contains("Oracle")) {
            dbTableHandle = new DbTableOracleHandleImpl();
        } else if (dialect.equals("org.hibernate.dialect.PostgreSQLDialect")) {
            dbTableHandle = new DbTablePostgresHandleImpl();
        } else if (dialect.equals("org.hibernate.dialect.SQLServerDialect")) {
            dbTableHandle = new TableSQLServerHandleImpl();
        }
        return dbTableHandle;
    }

    public static String getDataType(Session session) {
        String dataType = "MYSQL";
        String dialect = ((SessionImpl)session).getFactory().getDialect().getClass().getName();
        if (dialect.equals("org.hibernate.dialect.MySQLDialect")) {
            dataType = "MYSQL";
        } else if (dialect.contains("Oracle")) {
            dataType = "ORACLE";
        } else if (dialect.equals("org.hibernate.dialect.PostgreSQLDialect")) {
            dataType = "POSTGRESQL";
        } else if (dialect.equals("org.hibernate.dialect.SQLServerDialect")) {
            dataType = "SQLSERVER";
        }
        return dataType;
    }
}

