/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.build;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.DBTypeUtil;
import org.jeecgframework.core.util.DateUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.common.CommUtils;
import org.jeecgframework.web.cgform.enhance.CgformEnhanceJavaInter;
import org.jeecgframework.web.cgform.entity.button.CgformButtonSqlEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.enhance.CgformEnhanceJavaEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataBaseService")
@Transactional(rollbackFor={Exception.class})
public class DataBaseServiceImpl
extends CommonServiceImpl
implements DataBaseService {
    private static final Logger logger = Logger.getLogger(DataBaseServiceImpl.class);
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private AbstractRoutingDataSource dataSource;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public void insertTable(String tableName, Map<String, Object> data) throws BusinessException {
        CgFormHeadEntity cgFormHeadEntity = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        this.fillInsertSysVar(data);
        this.keyAdapter(cgFormHeadEntity, data);
        this.dataAdapter(tableName, data);
        String comma = "";
        StringBuffer insertKey = new StringBuffer();
        StringBuffer insertValue = new StringBuffer();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!this.isContainsFieled(tableName, entry.getKey())) continue;
            insertKey.append(String.valueOf(comma) + entry.getKey());
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                insertValue.append(String.valueOf(comma) + ":" + entry.getKey());
            } else {
                insertValue.append(String.valueOf(comma) + "null");
            }
            comma = ", ";
        }
        String sql = "INSERT INTO " + tableName + " (" + insertKey + ") VALUES (" + insertValue + ")";
        Object key = null;
        key = this.executeSqlReturnKey(sql, data);
        if (key != null && key instanceof Long) {
            data.put("id", key);
        }
        if (cgFormHeadEntity != null) {
            this.executeSqlExtend(cgFormHeadEntity.getId(), "add", data);
            this.executeJavaExtend(cgFormHeadEntity.getId(), "add", data);
        }
    }

    private void keyAdapter(CgFormHeadEntity cgFormHeadEntity, Map<String, Object> data) {
        String pkType = cgFormHeadEntity.getJformPkType();
        String dbType = DBTypeUtil.getDBType();
        if (("NATIVE".equalsIgnoreCase(pkType) || "SEQUENCE".equalsIgnoreCase(pkType)) && "sqlserver".equalsIgnoreCase(dbType)) {
            data.remove("id");
        }
    }

    private Map<String, Object> dataAdapter(String tableName, Map<String, Object> data) {
        Map<String, CgFormFieldEntity> fieldConfigs = this.cgFormFieldService.getAllCgFormFieldByTableName(tableName);
        for (String key : fieldConfigs.keySet()) {
            Object beforeV = data.get(key.toString().toLowerCase());
            if (oConvertUtils.isNotEmpty((Object)beforeV)) {
                Object newV;
                CgFormFieldEntity fieldConfig = fieldConfigs.get(key);
                String type = fieldConfig.getType();
                if ("date".equalsIgnoreCase(type)) {
                    newV = String.valueOf(beforeV);
                    try {
                        String dateType = fieldConfig.getShowType();
                        if ("datetime".equalsIgnoreCase(dateType)) {
                            newV = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(beforeV));
                        } else if ("date".equalsIgnoreCase(dateType)) {
                            newV = new SimpleDateFormat("yyyy-MM-dd").parse(String.valueOf(beforeV));
                        }
                        if (!data.containsKey(key)) continue;
                        data.put(String.valueOf(key), newV);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if ("int".equalsIgnoreCase(type)) {
                    newV = null;
                    try {
                        newV = Integer.parseInt(String.valueOf(beforeV));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!data.containsKey(key)) continue;
                    data.put(String.valueOf(key), newV);
                    continue;
                }
                if (!"double".equalsIgnoreCase(type)) continue;
                newV = new Double(0.0);
                try {
                    newV = Double.parseDouble(String.valueOf(beforeV));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!data.containsKey(key)) continue;
                data.put(String.valueOf(key), newV);
                continue;
            }
            if (!oConvertUtils.isNotEmpty((Object)fieldConfigs.get(key).getFieldDefault())) continue;
            data.remove(key.toString().toLowerCase());
        }
        return data;
    }

    @Override
    public int updateTable(String tableName, Object id, Map<String, Object> data) throws BusinessException {
        this.fillUpdateSysVar(data);
        this.dataAdapter(tableName, data);
        String comma = "";
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update ").append(tableName).append(" set ");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!this.isContainsFieled(tableName, entry.getKey())) continue;
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                sqlBuffer.append(comma).append(entry.getKey()).append("=:" + entry.getKey() + " ");
            } else {
                sqlBuffer.append(comma).append(entry.getKey()).append("=null");
            }
            comma = ", ";
        }
        if (id instanceof String) {
            sqlBuffer.append(" where id='").append(id).append("'");
        } else {
            sqlBuffer.append(" where id=").append(id);
        }
        CgFormHeadEntity cgFormHeadEntity = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        int num = this.executeSql(sqlBuffer.toString(), data);
        if (cgFormHeadEntity != null) {
            this.executeSqlExtend(cgFormHeadEntity.getId(), "update", data);
            this.executeJavaExtend(cgFormHeadEntity.getId(), "update", data);
        }
        return num;
    }

    @Override
    public Map<String, Object> findOneForJdbc(String tableName, String id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select * from ").append(tableName);
        sqlBuffer.append(" where id= ? ");
        Map map = this.commonDao.findOneForJdbc(sqlBuffer.toString(), new Object[]{id});
        return map;
    }

    @Override
    public void executeSqlExtend(String formId, String buttonCode, Map<String, Object> data) {
        String sqlPlugin;
        CgformButtonSqlEntity cgformButtonSqlVo = this.getCgformButtonSqlByCodeFormId(buttonCode, formId);
        if (cgformButtonSqlVo != null && StringUtils.isNotEmpty((String)(sqlPlugin = cgformButtonSqlVo.getCgbSqlStr()))) {
            String[] sqls;
            String[] stringArray = sqls = sqlPlugin.split(";");
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                if (sql.toLowerCase().indexOf("insert") != -1 || sql.toLowerCase().indexOf("update") != -1) {
                    logger.debug((Object)("sql plugin -------->" + sql));
                    sql = this.formateSQl(sql, data);
                    logger.debug((Object)("sql plugin -------->" + sql));
                    int num = this.executeSql(sql, new Object[0]);
                    if (num > 0) {
                        logger.debug((Object)("sql plugin --execute success------>" + sql));
                    } else {
                        logger.debug((Object)("sql plugin --execute fail------>" + sql));
                    }
                }
                ++n2;
            }
        }
    }

    private CgformButtonSqlEntity getCgformButtonSqlByCodeFormId(String buttonCode, String formId) {
        StringBuilder hql = new StringBuilder("");
        hql.append(" from CgformButtonSqlEntity t");
        hql.append(" where t.formId=?");
        hql.append(" and  t.buttonCode =?");
        List list = this.findHql(hql.toString(), new Object[]{formId, buttonCode});
        if (list != null && list.size() > 0) {
            return (CgformButtonSqlEntity)list.get(0);
        }
        return null;
    }

    private String formateSQl(String sql, Map<String, Object> params) {
        sql = this.replaceExtendSqlSysVar(sql);
        if (params == null) {
            return sql;
        }
        if (sql.toLowerCase().indexOf("insert") != -1) {
            sql = sql.replace("#{UUID}", UUIDGenerator.generate());
        }
        for (String key : params.keySet()) {
            sql = sql.replace("#{" + key + "}", String.valueOf(params.get(key)));
        }
        return sql;
    }

    @Override
    public Map<String, Object> insertTableMore(Map<String, List<Map<String, Object>>> mapMore, String mainTableName) throws BusinessException {
        Map mainMap = mapMore.get(mainTableName).get(0);
        String[] filterName = new String[]{"tableName", "saveOrUpdateMore"};
        if ((mainMap = CommUtils.attributeMapFilter(mainMap, filterName)).get("id") == null || "".equals((String)mainMap.get("id"))) {
            Object pkValue = this.getPkValue(mainTableName);
            mainMap.put("id", pkValue);
        }
        this.insertTable(mainTableName, mainMap);
        String[] filterMainTable = new String[]{mainTableName};
        mapMore = CommUtils.attributeMapFilter(mapMore, filterMainTable);
        for (Map.Entry entry : mapMore.entrySet()) {
            String ok = (String)entry.getKey();
            List ov = (List)entry.getValue();
            for (Map<String, Object> fieldMap : ov) {
                List<Map<String, Object>> fkFieldList = this.getFKField(mainTableName, ok);
                Object subPkValue = this.getPkValue(ok);
                fieldMap.put("id", subPkValue);
                fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                this.insertTable(ok, fieldMap);
            }
        }
        return mainMap;
    }

    @Override
    public boolean updateTableMore(Map<String, List<Map<String, Object>>> mapMore, String mainTableName) throws BusinessException {
        Map mainMap = mapMore.get(mainTableName).get(0);
        Object mainTableId = mainMap.get("id");
        String[] filterName = new String[]{"tableName", "saveOrUpdateMore", "id"};
        mainMap = CommUtils.attributeMapFilter(mainMap, filterName);
        this.updateTable(mainTableName, mainTableId, mainMap);
        mainMap.put("id", mainTableId);
        String[] filterMainTable = new String[]{mainTableName};
        mapMore = CommUtils.attributeMapFilter(mapMore, filterMainTable);
        for (Map.Entry entry : mapMore.entrySet()) {
            Object subId;
            String ok = (String)entry.getKey();
            List ov = (List)entry.getValue();
            List<Map<String, Object>> fkFieldList = this.getFKField(mainTableName, ok);
            Map<Object, Map<String, Object>> subTableDateMap = this.getSubTableData(fkFieldList, mainTableName, ok, mainTableId);
            for (Map fieldMap : ov) {
                Object object = subId = fieldMap.get("id") == null ? "" : fieldMap.get("id");
                if (subId == null || "".equals(String.valueOf(subId))) {
                    fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                    fieldMap.put((String)"id", (Object)this.getPkValue(ok));
                    this.insertTable(ok, fieldMap);
                    continue;
                }
                fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                String[] subFilterName = new String[]{"id"};
                fieldMap = CommUtils.attributeMapFilter(fieldMap, subFilterName);
                this.updateTable(ok, subId, fieldMap);
                if (!subTableDateMap.containsKey(subId)) continue;
                subTableDateMap.remove(subId);
            }
            if (subTableDateMap.size() <= 0) continue;
            for (Map.Entry<Object, Map<String, Object>> entrySub : subTableDateMap.entrySet()) {
                subId = entrySub.getKey();
                this.deleteSubTableDataById(subId, ok);
            }
        }
        return true;
    }

    private List<Map<String, Object>> getFKField(String mainTableName, String subTableName) {
        StringBuilder sql1 = new StringBuilder("");
        sql1.append("select f.* from cgform_field f ,cgform_head h");
        sql1.append(" where f.table_id = h.id ");
        sql1.append(" and h.table_name=? ");
        sql1.append(" and f.main_table=? ");
        List list = this.findForJdbc(sql1.toString(), new Object[]{subTableName, mainTableName});
        return list;
    }

    private Map<Object, Map<String, Object>> getSubTableData(List<Map<String, Object>> fkFieldList, String mainTableName, String subTableName, Object mainTableId) {
        StringBuilder sql2 = new StringBuilder("");
        sql2.append("select sub.* from ").append(subTableName).append(" sub ");
        sql2.append(", ").append(mainTableName).append(" main ");
        sql2.append("where 1=1 ");
        if (fkFieldList != null && fkFieldList.size() > 0) {
            for (Map<String, Object> map : fkFieldList) {
                if (map.get("main_field") == null) continue;
                sql2.append(" and sub.").append((String)map.get("field_name")).append("=").append("main.").append((String)map.get("main_field"));
            }
        }
        sql2.append(" and main.id= ? ");
        List subTableDataList = this.findForJdbc(sql2.toString(), new Object[]{mainTableId});
        HashMap<Object, Map<String, Object>> dataMap = new HashMap<Object, Map<String, Object>>();
        if (subTableDataList != null) {
            for (Map map : subTableDataList) {
                dataMap.put(map.get("id"), map);
            }
        }
        return dataMap;
    }

    @Override
    public Object getPkValue(String tableName) {
        Object pkValue = null;
        CgFormHeadEntity cghead = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        String dbType = DBTypeUtil.getDBType();
        String pkType = cghead.getJformPkType();
        String pkSequence = cghead.getJformPkSequence();
        if (StringUtil.isNotEmpty((Object)pkType) && "UUID".equalsIgnoreCase(pkType)) {
            pkValue = UUIDGenerator.generate();
        } else if (StringUtil.isNotEmpty((Object)pkType) && "NATIVE".equalsIgnoreCase(pkType)) {
            if (StringUtil.isNotEmpty((Object)dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer((DataSource)this.dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else if (StringUtil.isNotEmpty((Object)dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer((DataSource)this.dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else if (StringUtil.isNotEmpty((Object)pkType) && "SEQUENCE".equalsIgnoreCase(pkType)) {
            if (StringUtil.isNotEmpty((Object)dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer((DataSource)this.dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else if (StringUtil.isNotEmpty((Object)dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer((DataSource)this.dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else {
            pkValue = UUIDGenerator.generate();
        }
        return pkValue;
    }

    private void deleteSubTableDataById(Object subId, String subTableName) {
        StringBuilder sql = new StringBuilder("");
        sql.append(" delete from ").append(subTableName).append(" where id = ? ");
        this.executeSql(sql.toString(), new Object[]{subId});
    }

    private void fillUpdateSysVar(Map<String, Object> data) {
        if (data.containsKey("update_date")) {
            data.put("update_date", DateUtils.formatDate());
        }
        if (data.containsKey("update_time")) {
            data.put("update_time", DateUtils.formatTime());
        }
        if (data.containsKey("update_by")) {
            data.put("update_by", ResourceUtil.getUserSystemData((String)"sysUserCode"));
        }
        if (data.containsKey("update_name")) {
            data.put("update_name", ResourceUtil.getUserSystemData((String)"sysUserName"));
        }
    }

    private void fillInsertSysVar(Map<String, Object> data) {
        if (data.containsKey("create_date")) {
            data.put("create_date", DateUtils.formatDate());
        }
        if (data.containsKey("create_time")) {
            data.put("create_time", DateUtils.formatTime());
        }
        if (data.containsKey("create_by")) {
            data.put("create_by", ResourceUtil.getUserSystemData((String)"sysUserCode"));
        }
        if (data.containsKey("create_name")) {
            data.put("create_name", ResourceUtil.getUserSystemData((String)"sysUserName"));
        }
        if (data.containsKey("sys_company_code")) {
            data.put("sys_company_code", ResourceUtil.getUserSystemData((String)"sysCompanyCode"));
        }
        if (data.containsKey("sys_org_code")) {
            data.put("sys_org_code", ResourceUtil.getUserSystemData((String)"sysOrgCode"));
        }
        if (data.containsKey("sys_user_code")) {
            data.put("sys_user_code", ResourceUtil.getUserSystemData((String)"sysUserCode"));
        }
    }

    private String replaceExtendSqlSysVar(String sql) {
        sql = sql.replace("{sys_user_code}", ResourceUtil.getUserSystemData((String)"sysUserCode")).replace("{sys_user_name}", ResourceUtil.getUserSystemData((String)"sysUserName")).replace("{sys_org_code}", ResourceUtil.getUserSystemData((String)"sysOrgCode")).replace("{sys_company_code}", ResourceUtil.getUserSystemData((String)"sysCompanyCode")).replace("{sys_date}", DateUtils.formatDate()).replace("{sys_time}", DateUtils.formatTime());
        return sql;
    }

    private Map<String, CgFormFieldEntity> getAllFieldByTableName(String tableName) {
        String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
        Map<String, CgFormFieldEntity> map = this.cgFormFieldService.getAllCgFormFieldByTableName(tableName, version);
        return map;
    }

    private boolean isContainsFieled(String tableName, String fieledName) {
        boolean flag = false;
        if (this.getAllFieldByTableName(tableName).containsKey(fieledName)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void executeJavaExtend(String formId, String buttonCode, Map<String, Object> data) throws BusinessException {
        CgformEnhanceJavaEntity cgformEnhanceJavaEntity = this.getCgformEnhanceJavaEntityByCodeFormId(buttonCode, formId);
        if (cgformEnhanceJavaEntity != null) {
            String cgJavaType = cgformEnhanceJavaEntity.getCgJavaType();
            String cgJavaValue = cgformEnhanceJavaEntity.getCgJavaValue();
            if (StringUtil.isNotEmpty((Object)cgJavaValue)) {
                Object obj = null;
                try {
                    if ("class".equals(cgJavaType)) {
                        obj = MyClassLoader.getClassByScn((String)cgJavaValue).newInstance();
                    } else if ("spring".equals(cgJavaType)) {
                        obj = ApplicationContextUtil.getContext().getBean(cgJavaValue);
                    }
                    if (obj instanceof CgformEnhanceJavaInter) {
                        CgformEnhanceJavaInter javaInter = (CgformEnhanceJavaInter)obj;
                        javaInter.execute(data);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    throw new BusinessException("\u6267\u884cJAVA\u589e\u5f3a\u51fa\u73b0\u5f02\u5e38\uff01");
                }
            }
        }
    }

    public CgformEnhanceJavaEntity getCgformEnhanceJavaEntityByCodeFormId(String buttonCode, String formId) {
        StringBuilder hql = new StringBuilder("");
        hql.append(" from CgformEnhanceJavaEntity t");
        hql.append(" where t.formId='").append(formId).append("'");
        hql.append(" and  t.buttonCode ='").append(buttonCode).append("'");
        List list = this.findHql(hql.toString(), new Object[0]);
        if (list != null && list.size() > 0) {
            return (CgformEnhanceJavaEntity)list.get(0);
        }
        return null;
    }
}

