/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.autolist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.annotation.Ehcache;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.enhance.CgformEnhanceJsEntity;
import org.jeecgframework.web.cgform.service.autolist.ConfigServiceI;
import org.jeecgframework.web.cgform.service.button.CgformButtonServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.enhance.CgformEnhanceJsServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="configService")
@Transactional
public class ConfigServiceImpl
implements ConfigServiceI {
    @Autowired
    private CgFormFieldServiceI tablePropertyService;
    @Autowired
    private CgformButtonServiceI cgformButtonService;
    @Autowired
    private CgformEnhanceJsServiceI cgformEnhanceJsService;

    @Override
    @Ehcache
    public Map<String, Object> queryConfigs(String tableName, String jversion) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        CgFormHeadEntity tableEntity = null;
        try {
            tableEntity = (CgFormHeadEntity)this.tablePropertyService.findByProperty(CgFormHeadEntity.class, "tableName", tableName).get(0);
            this.loadConfigs(configs, tableEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u8be5\u52a8\u6001\u5217\u8868");
        }
        return configs;
    }

    private void loadConfigs(Map<String, Object> configs, CgFormHeadEntity tableEntity) {
        List<CgFormFieldEntity> columns = tableEntity.getColumns();
        configs.put("config_id", tableEntity.getTableName());
        configs.put("config_name", tableEntity.getContent());
        configs.put("tableName", tableEntity.getTableName());
        configs.put("config_ischeckbox", tableEntity.getIsCheckbox());
        configs.put("config_ispagination", tableEntity.getIsPagination());
        configs.put("config_istree", tableEntity.getIsTree());
        configs.put("config_querymode", tableEntity.getQuerymode());
        configs.put("fileds", columns);
        configs.put("jformVersion", tableEntity.getJformVersion());
        configs.put("tree_parentid_fieldname", tableEntity.getTreeParentIdFieldName());
        configs.put("tree_id_fieldname", tableEntity.getTreeIdFieldname());
        configs.put("tree_fieldname", tableEntity.getTreeFieldname());
        configs.put("tableType", tableEntity.getJformType());
        configs.put("subTables", tableEntity.getSubTableStr());
        String formId = tableEntity.getId();
        ArrayList buttons = this.cgformButtonService.getCgformButtonListByFormId(formId);
        configs.put("config_buttons", buttons.size() > 0 ? buttons : new ArrayList(0));
        String jsCode = "";
        CgformEnhanceJsEntity jsEnhance = this.cgformEnhanceJsService.getCgformEnhanceJsByTypeFormId("list", formId);
        if (jsEnhance != null && StringUtil.isEmpty((String)(jsCode = jsEnhance.getCgJsStr()))) {
            jsCode = "";
        }
        configs.put("config_jsenhance", jsCode);
    }
}

