/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.autoform;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.DateUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.autoform.AutoFormServiceI;
import org.jeecgframework.web.cgform.util.AutoFormTemplateParseUtil;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="autoFormService")
@Transactional(rollbackFor={Exception.class})
public class AutoFormServiceImpl
extends CommonServiceImpl
implements AutoFormServiceI {
    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((AutoFormEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((AutoFormEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((AutoFormEntity)entity);
    }

    @Override
    public boolean doAddSql(AutoFormEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(AutoFormEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(AutoFormEntity t) {
        return true;
    }

    public String replaceVal(String sql, AutoFormEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{form_name}", String.valueOf(t.getFormName()));
        sql = sql.replace("#{form_desc}", String.valueOf(t.getFormDesc()));
        sql = sql.replace("#{form_style_id}", String.valueOf(t.getFormStyleId()));
        sql = sql.replace("#{form_content}", String.valueOf(t.getFormContent()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_by}", String.valueOf(t.getCreateBy()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_by}", String.valueOf(t.getUpdateBy()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{sys_org_code}", String.valueOf(t.getSysOrgCode()));
        sql = sql.replace("#{sys_company_code}", String.valueOf(t.getSysCompanyCode()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public void doAddTable(String formName, Map<String, Map<String, Object>> dataMap) throws BusinessException {
        if (dataMap != null) {
            for (Map.Entry<String, Map<String, Object>> entry1 : dataMap.entrySet()) {
                String dsName = entry1.getKey();
                if (dsName.indexOf("[") != -1) {
                    dsName = dsName.substring(0, dsName.indexOf("["));
                }
                Map<String, Object> data = entry1.getValue();
                String hql = "select afd from AutoFormEntity af,AutoFormDbEntity afd where af.id=afd.autoFormId and af.formName=? and afd.dbName=?";
                List list = this.findHql(hql, new Object[]{formName, dsName});
                if (list == null || list.size() <= 0) continue;
                AutoFormDbEntity autoFormDbEntity = (AutoFormDbEntity)list.get(0);
                String tbDbKey = autoFormDbEntity.getTbDbKey();
                if (StringUtil.isNotEmpty((Object)tbDbKey)) {
                    throw new BusinessException("\u6682\u4e0d\u652f\u6301\u975e\u5e73\u53f0\u586b\u62a5\u6570\u636e\u6e90");
                }
                String tbDbTableName = autoFormDbEntity.getTbDbTableName();
                String comma = "";
                StringBuffer insertKey = new StringBuffer();
                StringBuffer insertValue = new StringBuffer();
                for (Map.Entry<String, Object> entry2 : data.entrySet()) {
                    insertKey.append(String.valueOf(comma) + entry2.getKey());
                    if (entry2.getValue() != null && entry2.getValue().toString().length() > 0) {
                        insertValue.append(String.valueOf(comma) + ":" + entry2.getKey());
                    } else {
                        insertValue.append(String.valueOf(comma) + "null");
                    }
                    comma = ", ";
                }
                try {
                    String sql = "INSERT INTO " + tbDbTableName + " (" + insertKey + ") VALUES (" + insertValue + ")";
                    this.executeSqlReturnKey(sql, data);
                }
                catch (DuplicateKeyException e) {
                    throw new BusinessException("\u6570\u636e\u5df2\u5b58\u5728");
                }
                catch (UncategorizedSQLException e) {
                    throw new BusinessException("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                }
            }
        }
    }

    private void fillInsertSysVar(Map<String, Object> data) {
        if (data.containsKey("create_date")) {
            data.put("create_date", DateUtils.formatDate());
        }
        if (data.containsKey("create_time")) {
            data.put("create_time", DateUtils.formatTime());
        }
        if (data.containsKey("create_by")) {
            data.put("create_by", ResourceUtil.getUserSystemData((String)"sysUserCode"));
        }
        if (data.containsKey("create_name")) {
            data.put("create_name", ResourceUtil.getUserSystemData((String)"sysUserName"));
        }
        if (data.containsKey("sys_company_code")) {
            data.put("sys_company_code", ResourceUtil.getUserSystemData((String)"sysCompanyCode"));
        }
        if (data.containsKey("sys_org_code")) {
            data.put("sys_org_code", ResourceUtil.getUserSystemData((String)"sysOrgCode"));
        }
        if (data.containsKey("sys_user_code")) {
            data.put("sys_user_code", ResourceUtil.getUserSystemData((String)"sysUserCode"));
        }
    }

    @Override
    public String doUpdateTable(String formName, Map<String, Map<String, Object>> dataMap, Map<String, List<Map<String, Object>>> oldDataMap) throws BusinessException {
        HashSet<String> listDsName = new HashSet<String>();
        if (dataMap != null) {
            for (Map.Entry<String, Map<String, Object>> entry1 : dataMap.entrySet()) {
                String dsName = entry1.getKey();
                String fkid = "";
                String fkdsid = "";
                if (dsName.indexOf("[") != -1) {
                    dsName = dsName.substring(0, dsName.indexOf("["));
                    listDsName.add(dsName);
                    Map<String, Object> param = dataMap.get("param");
                    fkid = param.get("listctrl_fk_" + dsName) == null ? "" : (String)param.get("listctrl_fk_" + dsName);
                    fkdsid = param.get("listctrl_fkdsid_" + dsName) == null ? "" : (String)param.get("listctrl_fkdsid_" + dsName);
                }
                Map<String, Object> data = entry1.getValue();
                String hql = "select afd from AutoFormEntity af,AutoFormDbEntity afd where af.id=afd.autoFormId and af.formName=? and afd.dbName=?";
                List list = this.findHql(hql, new Object[]{formName, dsName});
                if (list == null || list.size() <= 0) continue;
                AutoFormDbEntity autoFormDbEntity = (AutoFormDbEntity)list.get(0);
                String tbDbKey = autoFormDbEntity.getTbDbKey();
                if (StringUtil.isNotEmpty((Object)tbDbKey)) {
                    throw new BusinessException("\u6682\u4e0d\u652f\u6301\u975e\u5e73\u53f0\u6570\u636e\u6e90");
                }
                String tbDbTableName = autoFormDbEntity.getTbDbTableName();
                String id = null;
                String comma = "";
                StringBuffer updateSqlBuffer = new StringBuffer();
                updateSqlBuffer.append("update ").append(tbDbTableName).append(" set ");
                StringBuffer insertKey = new StringBuffer();
                StringBuffer insertValue = new StringBuffer();
                for (Map.Entry<String, Object> entry2 : data.entrySet()) {
                    if (entry2.getValue() != null && entry2.getValue().toString().length() > 0) {
                        updateSqlBuffer.append(comma).append(entry2.getKey()).append("=:" + entry2.getKey() + " ");
                    } else {
                        updateSqlBuffer.append(comma).append(entry2.getKey()).append("=null");
                    }
                    if ("id".equalsIgnoreCase(entry2.getKey())) {
                        String string = id = entry2.getValue() == null ? "" : (String)entry2.getValue();
                        if (id == null || id.toString().equals("")) {
                            id = UUIDGenerator.generate();
                            entry2.setValue(id);
                        }
                    }
                    insertKey.append(String.valueOf(comma) + entry2.getKey());
                    if (entry2.getValue() != null && entry2.getValue().toString().length() > 0) {
                        insertValue.append(String.valueOf(comma) + ":" + entry2.getKey());
                    } else if (StringUtil.isNotEmpty((Object)fkid) && fkid.equalsIgnoreCase(entry2.getKey())) {
                        insertValue.append(String.valueOf(comma) + ":" + entry2.getKey());
                    } else {
                        insertValue.append(String.valueOf(comma) + "null");
                    }
                    comma = ", ";
                }
                String sql = "";
                boolean isAdd = true;
                List<Map<String, Object>> oldData = oldDataMap.get(dsName);
                int i = 0;
                while (i < oldData.size()) {
                    Map<String, Object> subMap = oldData.get(i);
                    String oid = this.getId(subMap);
                    if (StringUtil.isNotEmpty((Object)id) && id.equals(oid)) {
                        isAdd = false;
                    }
                    ++i;
                }
                if (isAdd && StringUtil.isNotEmpty((Object)fkid)) {
                    Map<String, Object> param = dataMap.get("param");
                    String fkidValue = "";
                    if (StringUtil.isEmpty((String)fkidValue)) {
                        fkidValue = this.getDsPropertyValue(dataMap, fkdsid);
                    }
                    if (StringUtil.isEmpty((String)fkidValue)) {
                        fkidValue = this.getId(param);
                    }
                    if (data.get(fkid) == null) {
                        insertKey.append(",").append(fkid);
                        insertValue.append(",").append(":").append(fkid);
                    }
                    data.put(fkid, fkidValue);
                }
                if (isAdd) {
                    if (id == null || id.toString().equals("")) {
                        insertKey.append(",").append("id");
                        insertValue.append(",").append("'").append(UUIDGenerator.generate()).append("'");
                    }
                    sql = "INSERT INTO " + tbDbTableName + " (" + insertKey + ") VALUES (" + insertValue + ")";
                    this.executeSqlReturnKey(sql, data);
                    continue;
                }
                if (id instanceof String) {
                    updateSqlBuffer.append(" where ID='").append(id).append("'");
                } else {
                    updateSqlBuffer.append(" where ID=").append(id);
                }
                sql = updateSqlBuffer.toString();
                try {
                    this.executeSql(sql, data);
                }
                catch (UncategorizedSQLException e) {
                    throw new BusinessException("\u6570\u636e\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                }
            }
        }
        this.doDeletTable(formName, dataMap, oldDataMap, listDsName);
        String id = "";
        String op = this.getDsPropertyValue(dataMap, "param.op");
        if (AutoFormTemplateParseUtil.OP_ADD.equals(op)) {
            AutoFormEntity autoFormEntity = (AutoFormEntity)this.findUniqueByProperty(AutoFormEntity.class, "formName", formName);
            String idkey = String.valueOf(autoFormEntity.getMainTableSource()) + ".id";
            id = this.getDsPropertyValueNoGenerator(dataMap, idkey);
            if (StringUtil.isEmpty((String)id)) {
                throw new BusinessException("\u4e3b\u6570\u636e\u6e90\u4e3b\u952e\u83b7\u53d6\u5931\u8d25");
            }
        } else {
            id = this.getDsPropertyValue(dataMap, "param.id");
        }
        return id;
    }

    private String getDsPropertyValueNoGenerator(Map<String, Map<String, Object>> dataMap, String key) {
        String value = "";
        String[] keys = key.split("\\.");
        if (keys.length == 2) {
            Map<String, Object> data = dataMap.get(keys[0]);
            if (data == null) {
                return value;
            }
            Object obj = data.get(keys[1]);
            if (obj == null) {
                obj = data.get(keys[1].toUpperCase());
            }
            value = obj == null ? "" : obj.toString();
        }
        return value;
    }

    private String getDsPropertyValue(Map<String, Map<String, Object>> dataMap, String key) {
        String value = "";
        String[] keys = key.split("\\.");
        if (keys.length == 2) {
            Map<String, Object> data = dataMap.get(keys[0]);
            Object obj = data.get(keys[1]);
            if (obj == null || obj.toString().toString().length() <= 0) {
                value = UUIDGenerator.generate();
                data.put(keys[1], value);
            } else {
                value = obj == null ? "" : obj.toString();
            }
        }
        return value;
    }

    private String getId(Map<String, Object> dateMap) {
        String id = "";
        String string = id = dateMap.get("id") == null ? "" : (String)dateMap.get("id");
        if (StringUtil.isEmpty((String)id)) {
            id = dateMap.get("ID") == null ? "" : (String)dateMap.get("ID");
        }
        return id;
    }

    private void doDeletTable(String formName, Map<String, Map<String, Object>> dataMap, Map<String, List<Map<String, Object>>> oldDataMap, Set<String> listDsName) throws BusinessException {
        for (Map.Entry<String, List<Map<String, Object>>> entry1 : oldDataMap.entrySet()) {
            List<Map<String, Object>> olddata = entry1.getValue();
            String dsName = entry1.getKey();
            Map<String, Object> param = dataMap.get("param");
            if (!listDsName.contains(dsName) && param.get("listctrl_fk_" + dsName) == null) {
                return;
            }
            String hql = "select afd from AutoFormEntity af,AutoFormDbEntity afd where af.id=afd.autoFormId and af.formName=? and afd.dbName=?";
            List list = this.findHql(hql, new Object[]{formName, dsName});
            if (list == null || list.size() <= 0) continue;
            AutoFormDbEntity autoFormDbEntity = (AutoFormDbEntity)list.get(0);
            String tbDbKey = autoFormDbEntity.getTbDbKey();
            if (StringUtil.isNotEmpty((Object)tbDbKey)) {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u975e\u5e73\u53f0\u6570\u636e\u6e90");
            }
            String tbDbTableName = autoFormDbEntity.getTbDbTableName();
            for (Map<String, Object> item : olddata) {
                String itemId = this.getId(item);
                if (StringUtil.isEmpty((String)itemId)) continue;
                this.isDeleteDate(dsName, tbDbTableName, itemId, dataMap);
            }
        }
    }

    private void isDeleteDate(String itemDsName, String tableName, String itemId, Map<String, Map<String, Object>> dataMap) {
        boolean exist = false;
        if (dataMap != null) {
            for (Map.Entry<String, Map<String, Object>> entry1 : dataMap.entrySet()) {
                String dsName = entry1.getKey();
                boolean listctrflag = false;
                if (dsName.indexOf("[") != -1) {
                    dsName = dsName.substring(0, dsName.indexOf("["));
                    listctrflag = true;
                }
                if (!listctrflag || !itemDsName.equals(dsName)) continue;
                Map<String, Object> data = entry1.getValue();
                String id = this.getId(data);
                if (!StringUtil.isNotEmpty((Object)itemId) || !itemId.equals(id)) continue;
                exist = true;
            }
        }
        if (!exist) {
            StringBuffer deleteSqlBuffer = new StringBuffer();
            deleteSqlBuffer.append("delete from ").append(tableName).append(" where ");
            deleteSqlBuffer.append(" ID = '").append(itemId).append("'");
            this.executeSql(deleteSqlBuffer.toString(), new Object[0]);
        }
    }
}

