/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.autoform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecgframework.core.common.dao.jdbc.JdbcDao;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbFieldEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormParamEntity;
import org.jeecgframework.web.cgform.service.autoform.AutoFormDbServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="autoFormDbService")
@Transactional
public class AutoFormDbServiceImpl
extends CommonServiceImpl
implements AutoFormDbServiceI {
    @Autowired
    private JdbcDao jdbcDao;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((AutoFormDbEntity)entity);
    }

    @Override
    public void addMain(AutoFormDbEntity autoFormDb, List<AutoFormDbFieldEntity> autoFormDbFieldList, List<AutoFormParamEntity> autoFormParamList) {
        this.save(autoFormDb);
        for (AutoFormDbFieldEntity autoFormDbField : autoFormDbFieldList) {
            autoFormDbField.setAutoFormDbId(autoFormDb.getId());
            this.save(autoFormDbField);
        }
        for (AutoFormParamEntity autoFormParam : autoFormParamList) {
            autoFormParam.setAutoFormDbId(autoFormDb.getId());
            this.save(autoFormParam);
        }
        this.doAddSql(autoFormDb);
    }

    @Override
    public void updateMain(AutoFormDbEntity autoFormDb, List<AutoFormDbFieldEntity> autoFormDbFieldList, List<AutoFormParamEntity> autoFormParamList) {
        this.saveOrUpdate(autoFormDb);
        String id0 = autoFormDb.getId();
        String id1 = autoFormDb.getId();
        String hql0 = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
        List autoFormDbFieldOldList = this.findHql(hql0, new Object[]{id0});
        for (AutoFormDbFieldEntity oldE : autoFormDbFieldOldList) {
            boolean isUpdate = false;
            for (AutoFormDbFieldEntity sendE : autoFormDbFieldList) {
                if (!oldE.getId().equals(sendE.getId())) continue;
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)sendE, (Object)oldE);
                    this.saveOrUpdate(oldE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException(e.getMessage());
                }
                isUpdate = true;
                break;
            }
            if (isUpdate) continue;
            super.delete((Object)oldE);
        }
        for (AutoFormDbFieldEntity autoFormDbField : autoFormDbFieldList) {
            if (!oConvertUtils.isEmpty((Object)autoFormDbField.getId())) continue;
            autoFormDbField.setAutoFormDbId(autoFormDb.getId());
            this.save(autoFormDbField);
        }
        String hql1 = "from AutoFormParamEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
        List autoFormParamOldList = this.findHql(hql1, new Object[]{id1});
        for (AutoFormParamEntity oldE : autoFormParamOldList) {
            boolean isUpdate = false;
            for (AutoFormParamEntity sendE : autoFormParamList) {
                if (!oldE.getId().equals(sendE.getId())) continue;
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)sendE, (Object)oldE);
                    this.saveOrUpdate(oldE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException(e.getMessage());
                }
                isUpdate = true;
                break;
            }
            if (isUpdate) continue;
            super.delete((Object)oldE);
        }
        for (AutoFormParamEntity autoFormParam : autoFormParamList) {
            if (!oConvertUtils.isEmpty((Object)autoFormParam.getId())) continue;
            autoFormParam.setAutoFormDbId(autoFormDb.getId());
            this.save(autoFormParam);
        }
        this.doUpdateSql(autoFormDb);
    }

    @Override
    public void delMain(AutoFormDbEntity autoFormDb) {
        this.delete(autoFormDb);
        String id0 = autoFormDb.getId();
        String id1 = autoFormDb.getId();
        String hql0 = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
        List autoFormDbFieldOldList = this.findHql(hql0, new Object[]{id0});
        this.deleteAllEntitie(autoFormDbFieldOldList);
        String hql1 = "from AutoFormParamEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
        List autoFormParamOldList = this.findHql(hql1, new Object[]{id1});
        this.deleteAllEntitie(autoFormParamOldList);
    }

    @Override
    public boolean doAddSql(AutoFormDbEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(AutoFormDbEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(AutoFormDbEntity t) {
        return true;
    }

    public String replaceVal(String sql, AutoFormDbEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_by}", String.valueOf(t.getCreateBy()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_by}", String.valueOf(t.getUpdateBy()));
        sql = sql.replace("#{sys_org_code}", String.valueOf(t.getSysOrgCode()));
        sql = sql.replace("#{sys_company_code}", String.valueOf(t.getSysCompanyCode()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{db_name}", String.valueOf(t.getDbName()));
        sql = sql.replace("#{db_type}", String.valueOf(t.getDbType()));
        sql = sql.replace("#{db_table_name}", String.valueOf(t.getDbTableName()));
        sql = sql.replace("#{db_dyn_sql}", String.valueOf(t.getDbDynSql()));
        sql = sql.replace("#{db_dyn_sql}", String.valueOf(t.getDbDynSql()));
        sql = sql.replace("#{auto_form_id}", String.valueOf(t.getAutoFormId()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public List<String> getSqlFields(String sql) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        List result = this.jdbcDao.findForJdbc(sql = this.getSql(sql), 1, 1);
        if (result.size() < 1) {
            throw new BusinessException("\u8be5\u62a5\u8868sql\u6ca1\u6709\u6570\u636e");
        }
        Set fieldsSet = ((Map)result.get(0)).keySet();
        ArrayList<String> fileds = new ArrayList<String>(fieldsSet);
        return fileds;
    }

    private String getSql(String sql) {
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String whereParam = m.group();
            System.out.println(whereParam);
            sql = sql.replace(whereParam, "'' or 1=1 or 1=''");
            sql = sql.replace("'''", "''");
            System.out.println(sql);
        }
        return sql;
    }

    @Override
    public List<String> getSqlParams(String sql) {
        if (oConvertUtils.isEmpty((Object)sql)) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        String regex = "\\$\\{\\w+\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String whereParam = m.group();
            params.add(whereParam.substring(whereParam.indexOf("{") + 1, whereParam.indexOf("}")));
        }
        return params;
    }
}

