/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.engine.tag;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.web.system.service.MutiLangServiceI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mutiLangTag")
public class MutiLangTag
implements TemplateDirectiveModel {
    private static final Logger LOG = LoggerFactory.getLogger(MutiLangTag.class);
    @Autowired
    private static MutiLangServiceI mutiLangService;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String langKey = this.getAttribute(params, "langKey");
        if (langKey == null) {
            throw new TemplateException("Can not find attribute 'name' in data tag", env);
        }
        String langArg = this.getAttribute(params, "langArg");
        if (mutiLangService == null) {
            mutiLangService = (MutiLangServiceI)ApplicationContextUtil.getContext().getBean(MutiLangServiceI.class);
        }
        String lang_context = mutiLangService.getLang(langKey, langArg);
        Writer out = env.getOut();
        out.append(lang_context);
    }

    private String getAttribute(Map params, String name) {
        String value = null;
        if (params.containsKey(name)) {
            TemplateModel paramValue = (TemplateModel)params.get(name);
            try {
                value = ((TemplateScalarModel)paramValue).getAsString();
            }
            catch (TemplateModelException e) {
                LOG.error("get attribute '{}' error", (Object)name, (Object)e);
            }
        }
        return value;
    }
}

