/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.engine.tag;

import freemarker.core.Environment;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dictDataTag")
public class DictDataTag
implements TemplateDirectiveModel {
    private static final Logger LOG = LoggerFactory.getLogger(DictDataTag.class);
    @Autowired
    private SystemService systemService;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String name = this.getAttribute(params, "name");
        if (name == null) {
            throw new TemplateException("Can not find attribute 'name' in data tag", env);
        }
        String text = this.getAttribute(params, "text");
        String tablename = this.getAttribute(params, "tablename");
        String var = this.getAttribute(params, "var");
        String string = var = var != null ? var : name;
        if (tablename == null || tablename.trim().length() <= 0) {
            ArrayList dataList = (ArrayList)TSTypegroup.allTypes.get(name.toLowerCase());
            if (dataList == null) {
                dataList = new ArrayList();
            }
            for (TSType s : dataList) {
                String names = s.getTypename();
                s.setTypename(MutiLangUtil.getMutiLangInstance().getLang(names));
            }
            env.setGlobalVariable(var, (TemplateModel)new SimpleCollection(dataList));
        } else {
            StringBuilder sql = new StringBuilder("");
            sql.append("select distinct ").append(name).append(" as typecode, ");
            if (text == null || text.trim().length() <= 0) {
                sql.append(name).append(" as typename ");
            } else {
                sql.append(text).append(" as typename ");
            }
            sql.append(" from ").append(tablename);
            sql.append(" order by ").append(name);
            List dataList = this.systemService.findForJdbc(sql.toString(), new Object[0]);
            env.setGlobalVariable(var, (TemplateModel)new SimpleCollection((Collection)dataList));
        }
        body.render(env.getOut());
    }

    private String getAttribute(Map params, String name) {
        String value = null;
        if (params.containsKey(name)) {
            TemplateModel paramValue = (TemplateModel)params.get(name);
            try {
                value = ((TemplateScalarModel)paramValue).getAsString();
            }
            catch (TemplateModelException e) {
                LOG.error("get attribute '{}' error", (Object)name, (Object)e);
            }
        }
        return value;
    }
}

