/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.engine;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jeecgframework.core.util.PropertiesUtil;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="templetContext")
public class TempletContext {
    @Resource(name="freemarker")
    private Configuration freemarker;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    private Map<String, TemplateDirectiveModel> tags;
    private static final String ENCODING = "UTF-8";
    private static Cache ehCache;
    private static String _sysMode;

    static {
        _sysMode = null;
        PropertiesUtil util = new PropertiesUtil("sysConfig.properties");
        _sysMode = util.readProperty("sqlReadMode");
        if ("PUB".equalsIgnoreCase(_sysMode)) {
            ehCache = CacheManager.getInstance().getCache("dictCache");
        }
    }

    @PostConstruct
    public void init() {
        if (this.tags == null) {
            return;
        }
        for (String key : this.tags.keySet()) {
            this.freemarker.setSharedVariable(key, (TemplateModel)this.tags.get(key));
        }
    }

    public Locale getLocale() {
        return this.freemarker.getLocale();
    }

    public Template getTemplate(String tableName, String ftlVersion) {
        Template template = null;
        if (tableName == null) {
            return null;
        }
        String oldTableName = tableName;
        if (ftlVersion != null && ftlVersion.length() > 0) {
            tableName = String.valueOf(tableName) + "&ftlVersion=" + ftlVersion;
        }
        try {
            if ("DEV".equalsIgnoreCase(_sysMode)) {
                template = this.freemarker.getTemplate(tableName, this.freemarker.getLocale(), ENCODING);
            } else if ("PUB".equalsIgnoreCase(_sysMode)) {
                String version = this.cgFormFieldService.getCgFormVersionByTableName(oldTableName);
                template = this.getTemplateFromCache(tableName, ENCODING, version);
            } else {
                throw new RuntimeException("sysConfig.properties\u7684freeMarkerMode\u914d\u7f6e\u9519\u8bef\uff1a(PUB:\u751f\u4ea7\u6a21\u5f0f\uff0cDEV:\u5f00\u53d1\u6a21\u5f0f)");
            }
            return template;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Template getTemplateFromCache(String tableName, String encoding, String version) {
        Template template = null;
        try {
            String cacheKey = String.valueOf(FreemarkerHelper.class.getName()) + ".getTemplateFormCache." + tableName + "." + version;
            Element element = ehCache.get((Serializable)((Object)cacheKey));
            if (element == null) {
                template = this.freemarker.getTemplate(tableName, this.freemarker.getLocale(), ENCODING);
                element = new Element((Object)cacheKey, (Object)template);
                ehCache.put(element);
            } else {
                template = (Template)element.getObjectValue();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return template;
    }

    public Configuration getFreemarker() {
        return this.freemarker;
    }

    public void setFreemarker(Configuration freemarker) {
        this.freemarker = freemarker;
    }

    public Map<String, TemplateDirectiveModel> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, TemplateDirectiveModel> tags) {
        this.tags = tags;
    }

    public void clearCache() {
        try {
            ehCache.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

