/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.trans;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.pojo.Columnt;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/cgformTransController"})
public class CgformTransController {
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    @RequestMapping(params={"trans"})
    public ModelAndView trans(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/trans/transList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String tableName = request.getParameter("id");
        List<String> list = new ArrayList();
        try {
            list = new JeecgReadTable().readAllTableNames();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        String html = "";
        Collections.sort(list, new StringSort(dataGrid.getOrder()));
        List tables = this.cgFormFieldService.findByQueryString("select tableName from CgFormHeadEntity");
        list.removeAll(tables);
        ArrayList<String> index = new ArrayList<String>();
        if (StringUtil.isNotEmpty((Object)tableName)) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).contains(tableName)) {
                    index.add(list.get(i));
                }
                ++i;
            }
            html = CgformTransController.getJson(index, index.size());
        } else {
            html = CgformTransController.getJson(list, list.size());
        }
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"transEditor"})
    @ResponseBody
    public AjaxJson transEditor(HttpServletRequest request, String id) throws Exception {
        AjaxJson j = new AjaxJson();
        String[] ids = id.split(",");
        String no = "";
        String yes = "";
        int i = 0;
        while (i < ids.length) {
            if (StringUtil.isNotEmpty((Object)ids[i])) {
                List cffList = this.cgFormFieldService.findByProperty(CgFormHeadEntity.class, "tableName", ids[i]);
                if (cffList.size() > 0) {
                    if (no != "") {
                        no = String.valueOf(no) + ",";
                    }
                    no = String.valueOf(no) + ids[i];
                } else {
                    List list = new JeecgReadTable().readOriginalTableColumn(ids[i]);
                    CgFormHeadEntity cgFormHead = new CgFormHeadEntity();
                    cgFormHead.setJformType(1);
                    cgFormHead.setIsCheckbox("Y");
                    cgFormHead.setIsDbSynch("Y");
                    cgFormHead.setIsTree("N");
                    cgFormHead.setQuerymode("group");
                    cgFormHead.setTableName(ids[i].toLowerCase());
                    cgFormHead.setIsPagination("Y");
                    cgFormHead.setContent(ids[i]);
                    cgFormHead.setJformVersion("1");
                    ArrayList<CgFormFieldEntity> columnsList = new ArrayList<CgFormFieldEntity>();
                    int k = 0;
                    while (k < list.size()) {
                        Columnt columnt = (Columnt)list.get(k);
                        String fieldName = columnt.getFieldDbName();
                        CgFormFieldEntity cgFormField = new CgFormFieldEntity();
                        cgFormField.setFieldName(columnt.getFieldDbName().toLowerCase());
                        if (StringUtil.isNotEmpty((Object)columnt.getFiledComment())) {
                            cgFormField.setContent(columnt.getFiledComment());
                        } else {
                            cgFormField.setContent(columnt.getFieldName());
                        }
                        cgFormField.setIsKey("N");
                        cgFormField.setIsShow("Y");
                        cgFormField.setIsShowList("Y");
                        cgFormField.setOrderNum(k + 2);
                        cgFormField.setQueryMode("group");
                        cgFormField.setLength(0);
                        cgFormField.setFieldLength(120);
                        cgFormField.setPointLength(0);
                        cgFormField.setShowType("text");
                        cgFormField.setIsNull(columnt.getNullable());
                        if ("id".equalsIgnoreCase(fieldName)) {
                            String[] pkTypeArr = new String[]{"java.lang.Integer", "java.lang.Long"};
                            String idFiledType = columnt.getFieldType();
                            if (Arrays.asList(pkTypeArr).contains(idFiledType)) {
                                cgFormHead.setJformPkType("NATIVE");
                            } else {
                                cgFormHead.setJformPkType("UUID");
                            }
                            cgFormField.setIsKey("Y");
                            cgFormField.setIsShow("N");
                            cgFormField.setIsShowList("N");
                        }
                        if ("java.lang.Integer".equalsIgnoreCase(columnt.getFieldType())) {
                            cgFormField.setType("int");
                        } else if ("java.lang.Long".equalsIgnoreCase(columnt.getFieldType())) {
                            cgFormField.setType("int");
                        } else if ("java.util.Date".equalsIgnoreCase(columnt.getFieldType())) {
                            cgFormField.setType("Date");
                            cgFormField.setShowType("date");
                        } else if ("java.lang.Double".equalsIgnoreCase(columnt.getFieldType()) || "java.lang.Float".equalsIgnoreCase(columnt.getFieldType())) {
                            cgFormField.setType("double");
                        } else if ("java.math.BigDecimal".equalsIgnoreCase(columnt.getFieldType())) {
                            cgFormField.setType("BigDecimal");
                        } else if (columnt.getFieldType().contains("blob")) {
                            cgFormField.setType("Blob");
                            columnt.setCharmaxLength(null);
                        } else {
                            cgFormField.setType("string");
                        }
                        if (StringUtil.isNotEmpty((Object)columnt.getCharmaxLength())) {
                            if (Long.valueOf(columnt.getCharmaxLength()) >= 3000L) {
                                cgFormField.setType("Text");
                                cgFormField.setShowType("textarea");
                                try {
                                    cgFormField.setLength(Integer.valueOf(columnt.getCharmaxLength()));
                                }
                                catch (Exception exception) {}
                            } else {
                                cgFormField.setLength(Integer.valueOf(columnt.getCharmaxLength()));
                            }
                        } else {
                            if (StringUtil.isNotEmpty((Object)columnt.getPrecision())) {
                                cgFormField.setLength(Integer.valueOf(columnt.getPrecision()));
                            } else if (cgFormField.getType().equals("int")) {
                                cgFormField.setLength(10);
                            }
                            if (StringUtil.isNotEmpty((Object)columnt.getScale())) {
                                cgFormField.setPointLength(Integer.valueOf(columnt.getScale()));
                            }
                        }
                        columnsList.add(cgFormField);
                        ++k;
                    }
                    cgFormHead.setColumns(columnsList);
                    this.cgFormFieldService.saveTable(cgFormHead, "");
                    if (yes != "") {
                        yes = String.valueOf(yes) + ",";
                    }
                    yes = String.valueOf(yes) + ids[i];
                }
            }
            ++i;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("no", no);
        map.put("yes", yes);
        j.setObj(map);
        return j;
    }

    public static String getJson(List<String> result, Integer size) {
        JSONObject main = new JSONObject();
        JSONArray rows = new JSONArray();
        main.put((Object)"total", (Object)size);
        for (String m : result) {
            JSONObject item = new JSONObject();
            item.put((Object)"id", (Object)m);
            rows.add((Object)item);
        }
        main.put((Object)"rows", (Object)rows);
        return main.toString();
    }

    private class StringSort
    implements Comparator<String> {
        private SortDirection sortOrder;

        public StringSort(SortDirection sortDirection) {
            this.sortOrder = sortDirection;
        }

        @Override
        public int compare(String prev, String next) {
            return this.sortOrder.equals((Object)SortDirection.asc) ? prev.compareTo(next) : next.compareTo(prev);
        }
    }
}

