/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.StreamUtil;
import jodd.io.ZipUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.FileUtils;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.template.CgformTemplateEntity;
import org.jeecgframework.web.cgform.service.template.CgformTemplateServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgformTemplateController"})
public class CgformTemplateController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgformTemplateController.class);
    @Autowired
    private CgformTemplateServiceI cgformTemplateService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"cgformTemplate"})
    public ModelAndView cgformTemplate(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/template/cgformTemplateList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CgformTemplateEntity cgformTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CgformTemplateEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)cgformTemplate, (Map)request.getParameterMap());
        cq.add();
        this.cgformTemplateService.getDataGridReturn(cq, true);
        List dataList = dataGrid.getResults();
        if (dataList != null && dataList.size() > 0) {
            for (CgformTemplateEntity entity : dataList) {
                entity.setTemplatePic("cgformTemplateController.do?showPic&code=" + entity.getTemplateCode() + "&path=" + entity.getTemplatePic());
            }
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(CgformTemplateEntity cgformTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgformTemplate = (CgformTemplateEntity)this.systemService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)cgformTemplate.getId()));
        this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u5220\u9664\u6210\u529f";
        try {
            this.cgformTemplateService.delete(cgformTemplate);
            if (cgformTemplate.getTemplateCode() != null) {
                this.delTemplate(request, cgformTemplate.getTemplateCode());
            }
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    private void delTemplate(HttpServletRequest request, String code) {
        String dirPath = String.valueOf(this.getUploadBasePath(request)) + File.separator + code;
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(dirPath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                CgformTemplateEntity cgformTemplate = (CgformTemplateEntity)this.systemService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)id));
                this.cgformTemplateService.delete(cgformTemplate);
                if (cgformTemplate.getTemplateCode() != null) {
                    this.delTemplate(request, cgformTemplate.getTemplateCode());
                }
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(CgformTemplateEntity cgformTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u6dfb\u52a0\u6210\u529f";
        try {
            this.cgformTemplateService.save(cgformTemplate);
            String basePath = this.getUploadBasePath(request);
            File templeDir = new File(String.valueOf(basePath) + File.separator + cgformTemplate.getTemplateCode());
            if (!templeDir.exists()) {
                templeDir.mkdirs();
            }
            this.removeZipFile(String.valueOf(basePath) + File.separator + "temp" + File.separator + cgformTemplate.getTemplateZipName(), templeDir.getAbsolutePath());
            this.removeIndexFile(String.valueOf(basePath) + File.separator + "temp" + File.separator + cgformTemplate.getTemplatePic(), templeDir.getAbsolutePath());
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    private void removeIndexFile(String templateIndexPath, String templateDir) {
        File indexFile = new File(templateIndexPath);
        if (indexFile.exists() && !indexFile.isDirectory()) {
            File destIndexFile;
            File destDir = new File(String.valueOf(templateDir) + File.separator + "images");
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            if ((destIndexFile = new File(destDir, indexFile.getName())).exists()) {
                FileUtils.delete((String)destIndexFile.getAbsolutePath());
            }
            try {
                try {
                    FileCopyUtils.copy((File)indexFile, (File)destIndexFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileUtils.delete((String)indexFile.getAbsolutePath());
                }
            }
            finally {
                FileUtils.delete((String)indexFile.getAbsolutePath());
            }
        }
    }

    private void removeZipFile(String zipFilePath, String templateDir) {
        File zipFile = new File(zipFilePath);
        if (zipFile.exists() && !zipFile.isDirectory()) {
            try {
                try {
                    this.unZipFiles(zipFile, templateDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FileUtils.delete((String)zipFilePath);
                }
            }
            finally {
                FileUtils.delete((String)zipFilePath);
            }
        }
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(CgformTemplateEntity cgformTemplate, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u66f4\u65b0\u6210\u529f";
        CgformTemplateEntity t = (CgformTemplateEntity)this.cgformTemplateService.get(CgformTemplateEntity.class, (Serializable)((Object)cgformTemplate.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)cgformTemplate, (Object)t);
            String basePath = this.getUploadBasePath(request);
            File templeDir = new File(String.valueOf(basePath) + File.separator + t.getTemplateCode());
            if (!templeDir.exists()) {
                templeDir.mkdirs();
            }
            this.removeZipFile(String.valueOf(basePath) + File.separator + "temp" + File.separator + t.getTemplateZipName(), templeDir.getAbsolutePath());
            this.removeIndexFile(String.valueOf(basePath) + File.separator + "temp" + File.separator + t.getTemplatePic(), templeDir.getAbsolutePath());
            this.cgformTemplateService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u81ea\u5b9a\u4e49\u6a21\u677f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(CgformTemplateEntity cgformTemplate, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)cgformTemplate.getId())) {
            cgformTemplate = (CgformTemplateEntity)this.cgformTemplateService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)cgformTemplate.getId()));
            req.setAttribute("cgformTemplatePage", (Object)cgformTemplate);
        }
        return new ModelAndView("jeecg/cgform/template/cgformTemplate-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(CgformTemplateEntity cgformTemplate, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)cgformTemplate.getId())) {
            cgformTemplate = (CgformTemplateEntity)this.cgformTemplateService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)cgformTemplate.getId()));
            req.setAttribute("cgformTemplatePage", (Object)cgformTemplate);
        }
        return new ModelAndView("jeecg/cgform/template/cgformTemplate-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        req.setAttribute("controller_name", (Object)"cgformTemplateController");
        return new ModelAndView("common/upload/pub_excel_upload");
    }

    @RequestMapping(params={"exportXls"})
    public String exportXls(CgformTemplateEntity cgformTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid, ModelMap modelMap) {
        CriteriaQuery cq = new CriteriaQuery(CgformTemplateEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)cgformTemplate, (Map)request.getParameterMap());
        List cgformTemplates = this.cgformTemplateService.getListByCriteriaQuery(cq, false);
        modelMap.put((Object)"fileName", (Object)"\u81ea\u5b9a\u4e49\u6a21\u677f");
        modelMap.put((Object)"entity", CgformTemplateEntity.class);
        modelMap.put((Object)"params", (Object)new ExportParams("\u81ea\u5b9a\u4e49\u6a21\u677f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"));
        modelMap.put((Object)"data", (Object)cgformTemplates);
        return "jeecgExcelView";
    }

    @RequestMapping(params={"checkTemplate"})
    @ResponseBody
    public boolean checkTemplate(String id, HttpServletRequest request) {
        File dirFile;
        CgformTemplateEntity entity;
        boolean flag = false;
        if (StringUtils.isNotBlank((String)id) && (entity = (CgformTemplateEntity)this.cgformTemplateService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)id))) != null && entity.getTemplateCode() != null && (dirFile = new File(String.valueOf(this.getUploadBasePath(request)) + "/" + entity.getTemplateCode())).exists() && dirFile.isDirectory()) {
            flag = true;
        }
        return flag;
    }

    @RequestMapping(params={"downloadTemplate"})
    public void downloadTemplate(String id, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((String)id)) {
            File zipFile;
            CgformTemplateEntity entity = (CgformTemplateEntity)this.cgformTemplateService.getEntity(CgformTemplateEntity.class, (Serializable)((Object)id));
            if (entity != null && entity.getTemplateCode() != null && (zipFile = this.zipFile(entity.getTemplateCode(), request)) != null && zipFile.exists()) {
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(zipFile);
                        this.downLoadFile(inputStream, String.valueOf(entity.getTemplateName()) + ".zip", zipFile.length(), response);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        FileUtils.delete((String)zipFile.getAbsolutePath());
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    FileUtils.delete((String)zipFile.getAbsolutePath());
                }
            }
        } else {
            return;
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listCgformTemplateEntitys = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), CgformTemplateEntity.class, (ImportParams)params);
                    for (CgformTemplateEntity cgformTemplate : listCgformTemplateEntitys) {
                        this.cgformTemplateService.save(cgformTemplate);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"uploadPic"})
    @ResponseBody
    public AjaxJson uploadPic(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        File picTempFile = null;
        File tempDir = new File(this.getUploadBasePath(request), "temp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            picTempFile = new File(tempDir.getAbsolutePath(), "/index_" + request.getSession().getId() + "." + FileUtils.getExtend((String)file.getOriginalFilename()));
            try {
                if (picTempFile.exists()) {
                    org.apache.commons.io.FileUtils.forceDelete((File)picTempFile);
                }
                FileCopyUtils.copy((byte[])file.getBytes(), (File)picTempFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                j.setMsg("\u9884\u89c8\u56fe\u4e0a\u4f20\u5931\u8d25\uff01");
                j.setSuccess(false);
            }
            j.setObj((Object)picTempFile.getName());
        }
        j.setMsg("\u56fe\u7247\u4e0a\u4f20\u6210\u529f\uff01");
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"uploadZip"})
    @ResponseBody
    public AjaxJson uploadZip(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        File picTempFile = null;
        File tempDir = new File(this.getUploadBasePath(request), "temp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            picTempFile = new File(tempDir.getAbsolutePath(), "/zip_" + request.getSession().getId() + "." + FileUtils.getExtend((String)file.getOriginalFilename()));
            try {
                if (picTempFile.exists()) {
                    org.apache.commons.io.FileUtils.forceDelete((File)picTempFile);
                }
                FileCopyUtils.copy((byte[])file.getBytes(), (File)picTempFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                j.setMsg("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                j.setSuccess(false);
            }
            j.setObj((Object)picTempFile.getName());
        }
        j.setMsg("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01");
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"showPic"})
    public void showPic(HttpServletRequest request, String code, String path, HttpServletResponse response) {
        block15: {
            String defaultPath = "default.jpg";
            String defaultCode = "default/images/";
            if (path == null) {
                path = defaultPath;
                code = defaultCode;
            } else {
                code = code == null ? "temp/" : String.valueOf(code) + "/images/";
            }
            FileInputStream fis = null;
            response.setContentType("image/" + FileUtils.getExtend((String)path));
            try {
                try {
                    ServletOutputStream out = response.getOutputStream();
                    File file = new File(this.getUploadBasePath(request), String.valueOf(code) + path);
                    if (!file.exists() || file.isDirectory()) {
                        file = new File(this.getUploadBasePath(request), String.valueOf(defaultCode) + defaultPath);
                    }
                    fis = new FileInputStream(file);
                    byte[] b = new byte[fis.available()];
                    fis.read(b);
                    out.write(b);
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String getUploadBasePath(HttpServletRequest request) {
        String path = String.valueOf(((Object)((Object)this)).getClass().getResource("/").getPath()) + "online/template";
        return path;
    }

    @RequestMapping(params={"checkCode"})
    @ResponseBody
    public AjaxJson checkCode(String param) {
        Assert.notNull((Object)param);
        AjaxJson j = new AjaxJson();
        Long count = this.cgformTemplateService.getCountForJdbcParam("select count(id) from cgform_template where template_code=?  ", new Object[]{param});
        if (count == null || count <= 0L) {
            j.setSuccess(true);
        } else {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"getTemplate"})
    @ResponseBody
    public AjaxJson getTemplate(String type) {
        Assert.notNull((Object)type);
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        j.setObj(this.cgformTemplateService.getTemplateListByType(type));
        return j;
    }

    private void unZipFiles(File zipFile, String descDir) throws IOException {
        ZipUtil.unzip((File)zipFile, (File)new File(descDir));
    }

    private File zipFile(String templateCode, HttpServletRequest request) {
        String dirPath = String.valueOf(this.getUploadBasePath(request)) + "/" + templateCode;
        ZipOutputStream zos = null;
        File zipFile = null;
        try {
            try {
                File dir = new File(dirPath);
                if (dir.exists() && dir.isDirectory()) {
                    zipFile = new File(dir + "_" + request.getSession().getId() + ".zip");
                    File[] files = dir.listFiles();
                    if (files != null) {
                        zos = ZipUtil.createZip((File)zipFile);
                        File[] fileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            ZipUtil.addToZip((ZipOutputStream)zos, (File)file);
                            ++n2;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (zos != null) {
                    StreamUtil.close(zos);
                }
            }
        }
        finally {
            if (zos != null) {
                StreamUtil.close(zos);
            }
        }
        return zipFile;
    }

    private void downLoadFile(InputStream inputStream, String fileName, long size, HttpServletResponse response) {
        block15: {
            try {
                fileName = new String(fileName.getBytes("utf-8"), "iso-8859-1");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            if (size > 0L) {
                response.addHeader("Content-Length", String.valueOf(size));
            }
            ServletOutputStream stream = null;
            try {
                try {
                    stream = response.getOutputStream();
                    FileCopyUtils.copy((InputStream)inputStream, (OutputStream)stream);
                    stream.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (stream == null) break block15;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

