/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.handler.impl.ExcelDataHandlerDefaultImpl;
import org.jeecgframework.poi.handler.inter.IExcelDataHandler;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.service.autolist.CgTableServiceI;
import org.jeecgframework.web.cgform.service.autolist.ConfigServiceI;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.impl.config.util.FieldNumComparator;
import org.jeecgframework.web.cgform.util.QueryParamUtil;
import org.jeecgframework.web.system.pojo.base.DictEntity;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/excelTempletController"})
public class ExcelTempletController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ExcelTempletController.class);
    private String message;
    @Autowired
    private ConfigServiceI configService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private CgTableServiceI cgTableService;
    @Autowired
    private SystemService systemService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"exportXls"})
    public String exportXls(HttpServletRequest request, ModelMap modelMap, HttpServletResponse response, String field, DataGrid dataGrid) {
        String codedFileName = "\u6587\u4ef6";
        String sheetName = "\u5bfc\u51fa\u4fe1\u606f";
        List lists = null;
        if (StringUtil.isNotEmpty((Object)request.getParameter("tableName"))) {
            String subTableStr;
            String configId = request.getParameter("tableName");
            String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
            Map<String, Object> configs = this.configService.queryConfigs(configId, jversion);
            HashMap params = new HashMap();
            List beans = (List)configs.get("fileds");
            for (CgFormFieldEntity b : beans) {
                QueryParamUtil.loadQueryParams(request, b, params);
            }
            List result = this.cgTableService.querySingle(configId, field.toString(), params, null, null, 1, 99999);
            lists = (List)configs.get("fileds");
            int i = lists.size() - 1;
            while (i >= 0) {
                if (!field.contains(((CgFormFieldEntity)lists.get(i)).getFieldName())) {
                    lists.remove(i);
                }
                --i;
            }
            this.handlePageDic(beans, result);
            this.dealDic(result, beans);
            sheetName = (String)configs.get("config_name");
            String tableName = (String)configs.get("tableName");
            codedFileName = String.valueOf(sheetName) + "_" + tableName + "-v" + (String)configs.get("jformVersion");
            List<ExcelExportEntity> entityList = this.convertToExportEntity(lists);
            if (2 == Integer.parseInt(configs.get("tableType").toString()) && StringUtils.isNotEmpty((String)(subTableStr = configs.get("subTables").toString()))) {
                String[] subTables;
                String[] stringArray = subTables = subTableStr.split(",");
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    this.addAllSubTableDate(subTable, configs, result, entityList);
                    ++n2;
                }
            }
            modelMap.put((Object)"data", entityList);
            modelMap.put((Object)"mapList", (Object)result);
            modelMap.put((Object)"fileName", (Object)codedFileName);
            modelMap.put((Object)"params", (Object)new ExportParams(null, sheetName));
            return "jeecgMapExcelView";
        }
        throw new BusinessException("\u53c2\u6570\u9519\u8bef");
    }

    private List<ExcelExportEntity> convertToExportEntity(List<CgFormFieldEntity> lists) {
        Collections.sort(lists, new FieldNumComparator());
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        int i = 0;
        while (i < lists.size()) {
            if (lists.get(i).getIsShow().equals("Y")) {
                int columnWidth;
                ExcelExportEntity entity = new ExcelExportEntity(lists.get(i).getContent(), (Object)lists.get(i).getFieldName());
                int n = lists.get(i).getLength() == 0 ? 12 : (columnWidth = lists.get(i).getLength() > 30 ? 30 : lists.get(i).getLength());
                if (lists.get(i).getShowType().equals("date")) {
                    entity.setFormat("yyyy-MM-dd");
                } else if (lists.get(i).getShowType().equals("datetime")) {
                    entity.setFormat("yyyy-MM-dd HH:mm:ss");
                }
                entity.setWidth((double)columnWidth);
                entityList.add(entity);
            }
            ++i;
        }
        return entityList;
    }

    private void addAllSubTableDate(String subTable, Map<String, Object> configs, List<Map<String, Object>> result, List<ExcelExportEntity> entityList) {
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(subTable);
        Map<String, Object> subConfigs = this.configService.queryConfigs(subTable, jversion);
        ExcelExportEntity tableEntity = new ExcelExportEntity(subConfigs.get("config_name").toString(), (Object)subTable);
        List beans = (List)subConfigs.get("fileds");
        tableEntity.setList(this.convertToExportEntity(beans));
        entityList.add(tableEntity);
        int i = 0;
        while (i < result.size()) {
            List<Map<String, Object>> subResult = this.cgFormFieldService.getSubTableData(configs.get("config_id").toString(), subTable, result.get(i).get("id"));
            this.handlePageDic(beans, subResult);
            this.dealDic(subResult, beans);
            result.get(i).put(subTable, subResult);
            ++i;
        }
    }

    private void handlePageDic(List<CgFormFieldEntity> beans, List<Map<String, Object>> result) {
        HashMap dicMap = new HashMap();
        for (CgFormFieldEntity b : beans) {
            this.loadDic(dicMap, b);
            List dicList = (List)dicMap.get("field_dictlist");
            if (dicList.size() <= 0) continue;
            for (Map<String, Object> resultMap : result) {
                String[] arrayVal;
                StringBuffer sb = new StringBuffer();
                String value = (String)resultMap.get(b.getFieldName());
                if (oConvertUtils.isEmpty((Object)value) || (arrayVal = value.split(",")).length <= 1) continue;
                String[] stringArray = arrayVal;
                int n = arrayVal.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    for (DictEntity dictEntity : dicList) {
                        if (!val.equals(dictEntity.getTypecode())) continue;
                        sb.append(dictEntity.getTypename());
                        sb.append(",");
                    }
                    ++n2;
                }
                resultMap.put(b.getFieldName(), sb.toString().substring(0, sb.toString().length() - 1));
            }
        }
    }

    @RequestMapping(params={"goImplXls"}, method={RequestMethod.GET})
    public ModelAndView goImplXls(HttpServletRequest request) {
        request.setAttribute("tableName", (Object)request.getParameter("tableName"));
        return new ModelAndView("jeecg/cgform/excel/upload");
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        String message = "\u4e0a\u4f20\u6210\u529f";
        AjaxJson j = new AjaxJson();
        String configId = request.getParameter("tableName");
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
        Map<String, Object> configs = this.configService.queryConfigs(configId, jversion);
        String version = (String)configs.get("jformVersion");
        List lists = (List)configs.get("fileds");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String docVersion = ExcelTempletController.getDocVersion(file.getOriginalFilename());
            if (docVersion.equals(version)) {
                try {
                    ImportParams params = new ImportParams();
                    params.setDataHanlder((IExcelDataHandler)new CgFormExcelHandler(lists));
                    List listDate = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), Map.class, (ImportParams)params);
                    if (listDate == null) {
                        message = "\u8bc6\u522b\u6a21\u7248\u6570\u636e\u9519\u8bef";
                        logger.error((Object)message);
                        continue;
                    }
                    for (Map map : listDate) {
                        map.put("id", UUIDGenerator.generate());
                        this.dataBaseService.insertTable(configId, map);
                    }
                    message = "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01";
                }
                catch (Exception e) {
                    message = "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01";
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                }
                continue;
            }
            message = "\u6a21\u7248\u6587\u4ef6\u7248\u672c\u548c\u8868\u8fbe\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u7248";
            logger.error((Object)message);
        }
        j.setMsg(message);
        return j;
    }

    private static String getDocVersion(String docName) {
        if (docName.indexOf("(") > 0) {
            return docName.substring(docName.indexOf("-v") + 2, docName.indexOf("(")).trim();
        }
        return docName.substring(docName.indexOf("-v") + 2, docName.indexOf(".")).trim();
    }

    private void loadDic(Map m, CgFormFieldEntity bean) {
        String dicT = bean.getDictTable();
        String dicF = bean.getDictField();
        String dicText = bean.getDictText();
        if (StringUtil.isEmpty((String)dicT) && StringUtil.isEmpty((String)dicF)) {
            m.put("field_dictlist", new ArrayList(0));
            return;
        }
        if (!bean.getShowType().equals("popup")) {
            List<DictEntity> dicDatas = this.queryDic(dicT, dicF, dicText);
            m.put("field_dictlist", dicDatas);
        } else {
            m.put("field_dictlist", new ArrayList(0));
        }
    }

    private List<DictEntity> queryDic(String dicTable, String dicCode, String dicText) {
        return this.systemService.queryDict(dicTable, dicCode, dicText);
    }

    private void dealDic(List<Map<String, Object>> result, List<CgFormFieldEntity> beans) {
        for (CgFormFieldEntity bean : beans) {
            String dicTable = bean.getDictTable();
            String dicCode = bean.getDictField();
            String dicText = bean.getDictText();
            if (StringUtil.isEmpty((String)dicTable) && StringUtil.isEmpty((String)dicCode) || bean.getShowType().equals("popup")) continue;
            List<DictEntity> dicDataList = this.queryDic(dicTable, dicCode, dicText);
            for (Map<String, Object> r : result) {
                String value = String.valueOf(r.get(bean.getFieldName()));
                for (DictEntity dictEntity : dicDataList) {
                    if (!value.equalsIgnoreCase(dictEntity.getTypecode())) continue;
                    r.put(bean.getFieldName(), MutiLangUtil.getMutiLangInstance().getLang(dictEntity.getTypename()));
                }
            }
        }
    }

    private class CgFormExcelHandler
    extends ExcelDataHandlerDefaultImpl {
        Map<String, CgFormFieldEntity> fieldMap;

        public CgFormExcelHandler(List<CgFormFieldEntity> lists) {
            this.fieldMap = this.convertDate(lists);
        }

        private Map<String, CgFormFieldEntity> convertDate(List<CgFormFieldEntity> lists) {
            HashMap<String, CgFormFieldEntity> maps = new HashMap<String, CgFormFieldEntity>();
            for (CgFormFieldEntity cgFormFieldEntity : lists) {
                maps.put(cgFormFieldEntity.getContent(), cgFormFieldEntity);
            }
            return maps;
        }

        public void setMapValue(Map<String, Object> map, String originKey, Object value) {
            if (value instanceof Double) {
                map.put(this.getRealKey(originKey), PoiPublicUtil.doubleToString((Double)((Double)value)));
            } else {
                map.put(this.getRealKey(originKey), value.toString());
            }
        }

        private String getRealKey(String originKey) {
            if (this.fieldMap.containsKey(originKey)) {
                return this.fieldMap.get(originKey).getFieldName();
            }
            return originKey;
        }
    }
}

