/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.config.JformGraphreportHeadEntity;
import org.jeecgframework.web.cgform.entity.config.JformGraphreportHeadPage;
import org.jeecgframework.web.cgform.entity.config.JformGraphreportItemEntity;
import org.jeecgframework.web.cgform.service.config.JformGraphreportHeadServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/jformGraphreportHeadController"})
public class JformGraphreportHeadController
extends BaseController {
    private static final Logger logger = Logger.getLogger(JformGraphreportHeadController.class);
    @Autowired
    private JformGraphreportHeadServiceI jformGraphreportHeadService;
    @Autowired
    private SystemService systemService;

    @RequestMapping(params={"jformGraphreportHead"})
    public ModelAndView jformGraphreportHead(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/graphreport/jformGraphreportHeadList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(JformGraphreportHeadEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)jformGraphreportHead);
        cq.add();
        this.jformGraphreportHeadService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        jformGraphreportHead = (JformGraphreportHeadEntity)this.systemService.getEntity(JformGraphreportHeadEntity.class, (Serializable)((Object)jformGraphreportHead.getId()));
        String message = "\u56fe\u8868\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            this.jformGraphreportHeadService.delMain(jformGraphreportHead);
            this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u56fe\u8868\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u56fe\u8868\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                JformGraphreportHeadEntity jformGraphreportHead = (JformGraphreportHeadEntity)this.systemService.getEntity(JformGraphreportHeadEntity.class, (Serializable)((Object)id));
                this.jformGraphreportHeadService.delMain(jformGraphreportHead);
                this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u56fe\u8868\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(JformGraphreportHeadEntity jformGraphreportHead, JformGraphreportHeadPage jformGraphreportHeadPage, HttpServletRequest request) {
        List<JformGraphreportItemEntity> jformGraphreportItemList = jformGraphreportHeadPage.getJformGraphreportItemList();
        AjaxJson j = new AjaxJson();
        String message = "\u6dfb\u52a0\u6210\u529f";
        try {
            this.jformGraphreportHeadService.addMain(jformGraphreportHead, jformGraphreportItemList);
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u56fe\u8868\u914d\u7f6e\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(JformGraphreportHeadEntity jformGraphreportHead, JformGraphreportHeadPage jformGraphreportHeadPage, HttpServletRequest request) {
        List<JformGraphreportItemEntity> jformGraphreportItemList = jformGraphreportHeadPage.getJformGraphreportItemList();
        AjaxJson j = new AjaxJson();
        String message = "\u66f4\u65b0\u6210\u529f";
        try {
            this.jformGraphreportHeadService.updateMain(jformGraphreportHead, jformGraphreportItemList);
            this.systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u66f4\u65b0\u56fe\u8868\u914d\u7f6e\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)jformGraphreportHead.getId())) {
            jformGraphreportHead = (JformGraphreportHeadEntity)this.jformGraphreportHeadService.getEntity(JformGraphreportHeadEntity.class, (Serializable)((Object)jformGraphreportHead.getId()));
            req.setAttribute("jformGraphreportHeadPage", (Object)jformGraphreportHead);
        }
        return new ModelAndView("jeecg/cgform/graphreport/jformGraphreportHead-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)jformGraphreportHead.getId())) {
            jformGraphreportHead = (JformGraphreportHeadEntity)this.jformGraphreportHeadService.getEntity(JformGraphreportHeadEntity.class, (Serializable)((Object)jformGraphreportHead.getId()));
            req.setAttribute("jformGraphreportHeadPage", (Object)jformGraphreportHead);
        }
        return new ModelAndView("jeecg/cgform/graphreport/jformGraphreportHead-update");
    }

    @RequestMapping(params={"jformGraphreportItemList"})
    public ModelAndView jformGraphreportItemList(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest req) {
        String id0 = jformGraphreportHead.getId();
        String hql0 = "from JformGraphreportItemEntity where 1 = 1 AND cGREPORT_HEAD_ID = ? ";
        try {
            List jformGraphreportItemEntityList = this.systemService.findHql(hql0, new Object[]{id0});
            req.setAttribute("jformGraphreportItemList", (Object)jformGraphreportItemEntityList);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        return new ModelAndView("jeecg/cgform/graphreport/jformGraphreportItemList");
    }

    @RequestMapping(params={"exportXls"})
    public String exportXls(JformGraphreportHeadEntity jformGraphreportHead, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid, ModelMap map) {
        CriteriaQuery cq = new CriteriaQuery(JformGraphreportHeadEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)jformGraphreportHead);
        List dataList = this.jformGraphreportHeadService.getListByCriteriaQuery(cq, false);
        ArrayList<JformGraphreportHeadPage> pageList = new ArrayList<JformGraphreportHeadPage>();
        if (dataList != null && dataList.size() > 0) {
            String hql0 = "from JformGraphreportItemEntity where 1 = 1 AND cGREPORT_HEAD_ID = ? ";
            for (JformGraphreportHeadEntity headEntity : dataList) {
                List itemEntities = this.systemService.findHql(hql0, new Object[]{headEntity.getId()});
                pageList.add(new JformGraphreportHeadPage(itemEntities, headEntity));
            }
        }
        map.put((Object)"fileName", (Object)"\u56fe\u8868\u914d\u7f6e");
        map.put((Object)"entity", JformGraphreportHeadPage.class);
        map.put((Object)"params", (Object)new ExportParams("\u56fe\u8868\u914d\u7f6e", "\u5bfc\u51fa\u4fe1\u606f"));
        map.put((Object)"data", pageList);
        return "jeecgExcelView";
    }

    @RequestMapping(params={"goImportExcel"})
    public String goImportExcel() {
        return "jeecg/cgform/graphreport/jformGraphreportUpload";
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(1);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listCourses = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), JformGraphreportHeadPage.class, (ImportParams)params);
                    for (JformGraphreportHeadPage page : listCourses) {
                        JformGraphreportHeadEntity headEntity = page.getJformGraphreportHeadEntity();
                        List<JformGraphreportItemEntity> itemEntities = page.getJformGraphreportItemList();
                        if (headEntity == null || itemEntities == null) continue;
                        this.jformGraphreportHeadService.addMain(headEntity, itemEntities);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

