/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.engine.TempletContext;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldVO;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.impl.config.util.FieldNumComparator;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgFormHeadController"})
public class CgFormHeadController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgFormHeadController.class);
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private TempletContext templetContext;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"cgFormHeadList"})
    public ModelAndView cgFormHeadList(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/config/cgFormHeadList");
    }

    @RequestMapping(params={"cgForms"})
    public ModelAndView cgForms(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/config/cgForms");
    }

    @RequestMapping(params={"goCgFormSynChoice"})
    public ModelAndView goCgFormSynChoice(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/config/cgformSynChoice");
    }

    @RequestMapping(params={"popmenulink"})
    public ModelAndView popmenulink(ModelMap modelMap, @RequestParam String url, @RequestParam String title, HttpServletRequest request) {
        modelMap.put((Object)"title", (Object)title);
        modelMap.put((Object)"url", (Object)url);
        return new ModelAndView("jeecg/cgform/config/popmenulink");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CgFormHeadEntity cgFormHead, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CgFormHeadEntity.class, dataGrid);
        String jformCategory = request.getParameter("jformCategory");
        if (StringUtil.isNotEmpty((Object)jformCategory)) {
            cq.eq("jformCategory", (Object)jformCategory);
            cq.add();
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)cgFormHead);
        this.cgFormFieldService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.cgFormFieldService.deleteCgForm(cgFormHead);
        this.cgFormFieldService.removeSubTableStr4Main(cgFormHead);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"rem"})
    @ResponseBody
    public AjaxJson rem(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.message = "\u79fb\u9664\u6210\u529f";
        this.cgFormFieldService.delete(cgFormHead);
        this.cgFormFieldService.removeSubTableStr4Main(cgFormHead);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delField"})
    @ResponseBody
    public AjaxJson delField(CgFormFieldEntity cgFormField, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormField = (CgFormFieldEntity)this.systemService.getEntity(CgFormFieldEntity.class, (Serializable)((Object)cgFormField.getId()));
        this.message = String.valueOf(cgFormField.getFieldName()) + "\u5220\u9664\u6210\u529f";
        this.cgFormFieldService.delete(cgFormField);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doDbSynch"})
    @ResponseBody
    public AjaxJson doDbSynch(CgFormHeadEntity cgFormHead, String synMethod, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        try {
            boolean bl = this.cgFormFieldService.dbSynch(cgFormHead, synMethod);
            if (!bl) {
                this.message = "\u540c\u6b65\u5931\u8d25";
                j.setMsg(this.message);
                return j;
            }
            this.cgFormFieldService.appendSubTableStr4Main(cgFormHead);
            this.message = "\u540c\u6b65\u6210\u529f";
            j.setMsg(this.message);
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            return j;
        }
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        this.templetContext.clearCache();
        AjaxJson j = new AjaxJson();
        CgFormHeadEntity oldTable = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.cgFormFieldService.removeSubTableStr4Main(oldTable);
        CgFormHeadEntity table = this.judgeTableIsNotExit(cgFormHead, oldTable);
        this.refreshFormFieldOrderNum(cgFormHead);
        if (StringUtil.isNotEmpty((Object)cgFormHead.getId()) && table != null) {
            List<CgFormFieldEntity> formFieldEntities = table.getColumns();
            for (CgFormFieldEntity cgFormFieldEntity : formFieldEntities) {
                if (!StringUtil.isEmpty((String)cgFormFieldEntity.getOldFieldName()) || !StringUtil.isNotEmpty((Object)cgFormFieldEntity.getFieldName())) continue;
                cgFormFieldEntity.setFieldName(cgFormFieldEntity.getFieldName().toLowerCase());
                cgFormFieldEntity.setOldFieldName(cgFormFieldEntity.getFieldName());
            }
            this.cgFormFieldService.updateTable(table, null);
            this.cgFormFieldService.appendSubTableStr4Main(table);
            this.cgFormFieldService.sortSubTableStr(table);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else if (StringUtil.isEmpty((String)cgFormHead.getId()) && table == null) {
            List<CgFormFieldEntity> formFieldEntities = cgFormHead.getColumns();
            for (CgFormFieldEntity cgFormFieldEntity : formFieldEntities) {
                if (!StringUtil.isEmpty((String)cgFormFieldEntity.getOldFieldName())) continue;
                cgFormFieldEntity.setFieldName(cgFormFieldEntity.getFieldName().toLowerCase());
                cgFormFieldEntity.setOldFieldName(cgFormFieldEntity.getFieldName());
            }
            this.cgFormFieldService.saveTable(cgFormHead);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    private void refreshFormFieldOrderNum(CgFormHeadEntity cgFormHead) {
        Collections.sort(cgFormHead.getColumns(), new FieldNumComparator());
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            cgFormHead.getColumns().get(i).setOrderNum(i + 1);
            ++i;
        }
    }

    private CgFormHeadEntity judgeTableIsNotExit(CgFormHeadEntity cgFormHead, CgFormHeadEntity oldTable) {
        CgFormHeadEntity table = (CgFormHeadEntity)this.cgFormFieldService.findUniqueByProperty(CgFormHeadEntity.class, "tableName", cgFormHead.getTableName());
        if (StringUtil.isNotEmpty((Object)cgFormHead.getId())) {
            if (table != null && !oldTable.getTableName().equals(cgFormHead.getTableName())) {
                this.message = "\u91cd\u547d\u540d\u7684\u8868\u5df2\u7ecf\u5b58\u5728";
                table = null;
            } else {
                if (table == null) {
                    cgFormHead.setIsDbSynch("N");
                }
                table = table == null ? oldTable : table;
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)cgFormHead, (Object)table);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.message = "\u4fee\u6539\u6210\u529f";
            }
        } else {
            this.message = table != null ? "\u8868\u5df2\u7ecf\u5b58\u5728" : "\u521b\u5efa\u6210\u529f";
        }
        return table;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CgFormHeadEntity cgFormHead, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)cgFormHead.getId())) {
            cgFormHead = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
            req.setAttribute("cgFormHeadPage", (Object)cgFormHead);
        }
        List typeList = (List)TSTypegroup.allTypes.get(MutiLangUtil.getMutiLangInstance().getLang("bdfl"));
        req.setAttribute("typeList", (Object)typeList);
        return new ModelAndView("jeecg/cgform/config/cgFormHead");
    }

    @RequestMapping(params={"getColumnList"})
    @ResponseBody
    public List<CgFormFieldEntity> getColumnList(CgFormHeadEntity cgFormHead, String type, HttpServletRequest req) {
        List<Object> columnList = new ArrayList();
        if (StringUtil.isNotEmpty((Object)cgFormHead.getId())) {
            CriteriaQuery cq = new CriteriaQuery(CgFormFieldEntity.class);
            cq.eq("table.id", (Object)cgFormHead.getId());
            cq.add();
            columnList = this.cgFormFieldService.getListByCriteriaQuery(cq, false);
            Collections.sort(columnList, new FieldNumComparator());
        } else {
            columnList = this.getInitDataList();
        }
        return columnList;
    }

    private List<CgFormFieldEntity> getInitDataList() {
        ArrayList<CgFormFieldEntity> columnList = new ArrayList<CgFormFieldEntity>();
        columnList.add(this.initCgFormFieldEntityId());
        columnList.add(this.initCgFormFieldEntityString("create_name", "\u521b\u5efa\u4eba\u540d\u79f0"));
        columnList.add(this.initCgFormFieldEntityString("create_by", "\u521b\u5efa\u4eba\u767b\u5f55\u540d\u79f0"));
        columnList.add(this.initCgFormFieldEntityTime("create_date", "\u521b\u5efa\u65e5\u671f"));
        columnList.add(this.initCgFormFieldEntityString("update_name", "\u66f4\u65b0\u4eba\u540d\u79f0"));
        columnList.add(this.initCgFormFieldEntityString("update_by", "\u66f4\u65b0\u4eba\u767b\u5f55\u540d\u79f0"));
        columnList.add(this.initCgFormFieldEntityTime("update_date", "\u66f4\u65b0\u65e5\u671f"));
        columnList.add(this.initCgFormFieldEntityString("sys_org_code", "\u6240\u5c5e\u90e8\u95e8"));
        columnList.add(this.initCgFormFieldEntityString("sys_company_code", "\u6240\u5c5e\u516c\u53f8"));
        columnList.add(this.initCgFormFieldEntityBpmStatus());
        return columnList;
    }

    private CgFormFieldEntity initCgFormFieldEntityId() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("id");
        field.setLength(36);
        field.setContent("\u4e3b\u952e");
        field.setIsKey("Y");
        field.setIsNull("N");
        field.setOrderNum(1);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityBpmStatus() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("bpm_status");
        field.setLength(32);
        field.setContent("\u6d41\u7a0b\u72b6\u6001");
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(1);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("Y");
        field.setFieldLength(120);
        field.setDictField("bpm_status");
        field.setFieldDefault("1");
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityString(String fieldName, String content) {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName(fieldName);
        field.setLength(50);
        field.setContent(content);
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(2);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityTime(String fieldName, String content) {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName(fieldName);
        field.setLength(20);
        field.setContent(content);
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(3);
        field.setType("Date");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        field.setShowType("date");
        return field;
    }

    @RequestMapping(params={"checkIsExit"})
    @ResponseBody
    public AjaxJson checkIsExit(String name, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(this.cgFormFieldService.judgeTableIsExit(name).booleanValue());
        return j;
    }

    @RequestMapping(params={"sqlPlugin"})
    public ModelAndView sqlPlugin(String id, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        request.setAttribute("bean", (Object)bean);
        return new ModelAndView("jeecg/cgform/config/cgFormSqlPlugin");
    }

    @RequestMapping(params={"sqlPluginSave"})
    @ResponseBody
    public AjaxJson sqlPluginSave(String id, String sql_plug_in, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        this.cgFormFieldService.updateTable(bean, null);
        this.message = "\u4fdd\u5b58\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        AjaxJson j = new AjaxJson();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"jsPlugin"})
    public ModelAndView jsPlugin(String id, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        request.setAttribute("bean", (Object)bean);
        return new ModelAndView("jeecg/cgform/config/cgFormJsPlugin");
    }

    @RequestMapping(params={"jsPluginSave"})
    @ResponseBody
    public AjaxJson jsPluginSave(String id, String js_plug_in, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        this.cgFormFieldService.updateTable(bean, null);
        this.message = "\u4fdd\u5b58\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        AjaxJson j = new AjaxJson();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"importExcel"})
    @ResponseBody
    public AjaxJson importExcel(String headId, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            CgFormHeadEntity cgFormHead;
            ImportParams params;
            MultipartFile file;
            block23: {
                file = (MultipartFile)entity.getValue();
                params = new ImportParams();
                params.setTitleRows(0);
                params.setHeadRows(1);
                params.setNeedSave(false);
                cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)headId));
                if (cgFormHead != null) break block23;
                j.setMsg("\u8868\u6570\u636e\u5f02\u5e38\uff01");
                AjaxJson ajaxJson = j;
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return ajaxJson;
            }
            try {
                try {
                    List fieldList = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), CgFormFieldVO.class, (ImportParams)params);
                    String hql = "from CgFormFieldEntity where table.id = ? ";
                    ArrayList<CgFormFieldEntity> list = this.systemService.findHql(hql, new Object[]{headId});
                    if (list == null) {
                        list = new ArrayList<CgFormFieldEntity>();
                    }
                    CgFormFieldEntity fieldEntity = null;
                    StringBuilder sb = new StringBuilder("");
                    ArrayList<CgFormFieldEntity> saveList = new ArrayList<CgFormFieldEntity>();
                    for (CgFormFieldVO field : fieldList) {
                        System.out.println("-------------field------------" + field);
                        if (StringUtil.isEmpty((String)field.getFieldName())) continue;
                        if (this.existField(field.getFieldName(), list)) {
                            sb.append(field.getFieldName()).append(",");
                            continue;
                        }
                        fieldEntity = new CgFormFieldEntity();
                        fieldEntity.setTable(cgFormHead);
                        fieldEntity.setFieldName(field.getFieldName());
                        String content = field.getContent();
                        if (StringUtil.isEmpty((String)content)) {
                            content = field.getFieldName();
                        }
                        fieldEntity.setContent(content);
                        String type = field.getType();
                        if (StringUtil.isEmpty((String)type)) {
                            type = "string";
                        }
                        fieldEntity.setType(type);
                        String length = field.getLength();
                        if (StringUtil.isEmpty((String)length)) {
                            length = "32";
                        }
                        fieldEntity.setLength(Integer.valueOf(length));
                        String pointLength = field.getPointLength();
                        if (StringUtil.isEmpty((String)pointLength)) {
                            pointLength = "0";
                        }
                        fieldEntity.setPointLength(Integer.valueOf(pointLength));
                        fieldEntity.setFieldDefault(field.getFieldDefault());
                        fieldEntity.setIsKey("N");
                        String isNull = field.getIsNull();
                        isNull = "\u5426".equals(isNull) ? "N" : "Y";
                        fieldEntity.setIsNull(isNull);
                        fieldEntity.setOrderNum(1);
                        fieldEntity.setIsShow("Y");
                        fieldEntity.setIsShowList("Y");
                        fieldEntity.setFieldLength(120);
                        list.add(fieldEntity);
                        saveList.add(fieldEntity);
                    }
                    this.systemService.batchSave(saveList);
                    if (StringUtil.isEmpty((String)sb.toString())) {
                        j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                    } else {
                        j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u91cd\u590d\u5b57\u6bb5\u3010" + sb.toString() + "\u3011\u5ffd\u7565");
                    }
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    private boolean existField(String field, List<CgFormFieldEntity> list) {
        boolean flag = false;
        for (CgFormFieldEntity entity : list) {
            if (!field.equalsIgnoreCase(entity.getFieldName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @RequestMapping(params={"upload"})
    public String upload(String id, HttpServletRequest request) {
        request.setAttribute("headId", (Object)id);
        return "jeecg/cgform/config/cgformColUpload";
    }
}

