/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.build;

import com.thoughtworks.xstream.XStream;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.common.DBTable;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.dao.config.CgFormVersionDao;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.pojo.config.CgFormHeadPojo;
import org.jeecgframework.web.cgform.service.migrate.MigrateForm;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgformSqlController"})
public class CgformSqlController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgformSqlController.class);
    @Autowired
    private CgFormVersionDao cgFormVersionDao;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    @Qualifier(value="namedParameterJdbcTemplate")
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"doMigrateOut"})
    public void doMigrateOut(HttpServletRequest request, HttpServletResponse response) {
        String ids = request.getParameter("ids");
        try {
            List<DBTable> dbTables = MigrateForm.buildExportDbTableList(ids, this.jdbcTemplate);
            String ls_id = "";
            ls_id = ids.indexOf(",") > 0 ? ids.substring(0, ids.indexOf(",")) : ids;
            CgFormHeadEntity cgFormHeadEntity = this.cgFormVersionDao.getCgFormById(ls_id);
            String ls_filename = cgFormHeadEntity.getTableName();
            String destFileDir = String.valueOf(ResourceUtil.getSystempPath()) + "/" + ls_filename;
            MigrateForm.generateXmlDataOutFlieContent(dbTables, destFileDir);
            ls_filename = MigrateForm.zip(null, "", destFileDir);
            File file = new File(ls_filename);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(ls_filename));
            response.reset();
            response.setContentType("text/html;charset=utf-8");
            request.setCharacterEncoding("UTF-8");
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes("utf-8"), "ISO8859-1"));
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)fis).read(buffer, 0, 8192)) != -1) {
                ((OutputStream)toClient).write(buffer, 0, bytesRead);
            }
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
            ((InputStream)fis).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"toCgformMigrate"})
    public ModelAndView toCgformMigrate(HttpServletRequest req) {
        return new ModelAndView("jeecg/cgform/config/cgformMigrateSqlInclude");
    }

    @RequestMapping(params={"doMigrateIn"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doMigrateIn(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String ls_file = "";
        UploadFile uploadFile = new UploadFile(request, (Object)ls_file);
        uploadFile.setCusPath("");
        uploadFile.setSwfpath("");
        String uploadbasepath = uploadFile.getBasePath();
        if (uploadbasepath == null) {
            uploadbasepath = ResourceUtil.getConfigByName((String)"uploadpath");
        }
        String path = String.valueOf(uploadbasepath) + "\\";
        String realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("\\")) + path;
        this.message = null;
        try {
            File file = new File(realPath);
            if (!file.exists()) {
                file.mkdir();
            }
            uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
            MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
            Map fileMap = multipartRequest.getFileMap();
            String fileName = "";
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                fileName = mf.getOriginalFilename();
                String savePath = String.valueOf(realPath) + fileName;
                File savefile = new File(savePath);
                String ls_tmp = savefile.getName();
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                MigrateForm.unzip(savePath, "");
                String sqlFileDir = String.valueOf(realPath) + ls_tmp.substring(0, ls_tmp.lastIndexOf("."));
                File sqlDirFile = new File(sqlFileDir);
                String sqlfilename = String.valueOf(sqlDirFile.getPath()) + "/";
                if (sqlDirFile.isDirectory()) {
                    sqlfilename = String.valueOf(sqlfilename) + sqlDirFile.list()[0];
                }
                XStream xStream = new XStream();
                xStream.processAnnotations(DBTable.class);
                List dbTables = (List)xStream.fromXML(new File(sqlfilename));
                if (dbTables.isEmpty() || dbTables.size() <= 0) continue;
                for (DBTable dbTable : dbTables) {
                    this.mergeMigrateInComponent(dbTable);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            LogUtil.error((String)e1.toString());
            this.message = e1.toString();
        }
        if (StringUtil.isNotEmpty((Object)this.message)) {
            j.setMsg("SQL\u6587\u4ef6\u5bfc\u5165\u5931\u8d25," + this.message);
        } else {
            j.setMsg("SQL\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        return j;
    }

    private <T> void mergeMigrateInComponent(DBTable<T> dbTable) {
        Class clazz = dbTable.getClass1();
        if (clazz != null) {
            List dataList = dbTable.getTableData();
            if (dataList == null || dataList.size() < 1) {
                return;
            }
            HashMap<String, String> idMap = new HashMap<String, String>();
            String id = "";
            String countSql = "";
            List idList = new ArrayList();
            for (Object t : dataList) {
                PropertyDescriptor[] pds;
                ReflectHelper reflectHelper = new ReflectHelper(t);
                ArrayList<String> ignores = new ArrayList<String>();
                ignores.add("class");
                PropertyDescriptor[] propertyDescriptorArray = pds = BeanUtils.getPropertyDescriptors((Class)clazz);
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    if (reflectHelper.getMethodValue(pd.getName()) == null) {
                        ignores.add(pd.getName());
                    }
                    ++n2;
                }
                if (t instanceof CgFormHeadPojo) {
                    reflectHelper.setMethodValue("isDbsynch", (Object)"N");
                }
                id = (String)reflectHelper.getMethodValue("id");
                countSql = "select id from " + dbTable.getTableName() + " where id=?";
                if (t instanceof CgFormHeadPojo) {
                    countSql = "select id from " + dbTable.getTableName() + " where table_name=?";
                    id = oConvertUtils.getString((Object)reflectHelper.getMethodValue("tableName"));
                }
                idList = this.jdbcTemplate.queryForList(countSql, new Object[]{id});
                SqlParameterSource sqlParameterSource = MigrateForm.generateParameterMap(t, ignores);
                if (idList.size() > 0 && t instanceof CgFormHeadPojo) {
                    idMap.put("id", oConvertUtils.getString(((Map)idList.get(0)).get("id")));
                    this.namedJdbcTemplate.update("delete from cgform_field where table_id=:id", idMap);
                    this.namedJdbcTemplate.update("delete from cgform_head where id=:id", idMap);
                    this.namedJdbcTemplate.update(MigrateForm.generateInsertSql(dbTable.getTableName(), clazz, ignores), sqlParameterSource);
                    continue;
                }
                if (idList.size() > 0) {
                    this.namedJdbcTemplate.update(MigrateForm.generateUpdateSql(dbTable.getTableName(), clazz, ignores), sqlParameterSource);
                    continue;
                }
                this.namedJdbcTemplate.update(MigrateForm.generateInsertSql(dbTable.getTableName(), clazz, ignores), sqlParameterSource);
            }
        }
    }
}

