/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.build;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.enums.SysThemesEnum;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.SysThemesUtil;
import org.jeecgframework.web.cgform.engine.TempletContext;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.upload.CgUploadEntity;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.util.TemplateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgform"})
public class CgFormBuildRestController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgFormBuildRestController.class);
    private String message;
    @Autowired
    private TempletContext templetContext;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(value={"/form/{configId}"}, method={RequestMethod.GET})
    public void ftlForm(@PathVariable String configId, HttpServletRequest request, HttpServletResponse response) {
        this.ftlForm(configId, null, request, response);
    }

    @RequestMapping(value={"/form/{configId}/{id}"}, method={RequestMethod.GET})
    public void ftlForm(@PathVariable String configId, @PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        try {
            String subTableStr;
            long start = System.currentTimeMillis();
            String tableName = configId;
            String mode = request.getParameter("mode");
            String templateName = String.valueOf(tableName) + "_";
            templateName = StringUtils.isBlank((String)id) ? String.valueOf(templateName) + TemplateUtil.TemplateType.ADD.getName() : ("read".equals(mode) ? String.valueOf(templateName) + TemplateUtil.TemplateType.DETAIL.getName() : String.valueOf(templateName) + TemplateUtil.TemplateType.UPDATE.getName());
            String ftlVersion = request.getParameter("ftlVersion");
            Template template = this.templetContext.getTemplate(templateName, ftlVersion);
            StringWriter stringWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(stringWriter);
            HashMap<Object, Object> data = new HashMap();
            String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
            Map<String, Object> configData = this.cgFormFieldService.getFtlFormConfig(tableName, version);
            data = new HashMap<String, Object>(configData);
            CgFormHeadEntity head = (CgFormHeadEntity)data.get("head");
            Map<Object, Object> dataForm = new HashMap();
            if (StringUtils.isNotEmpty((String)id)) {
                dataForm = this.dataBaseService.findOneForJdbc(tableName, id);
            }
            for (Map.Entry entry : dataForm.entrySet()) {
                String ok = (String)entry.getKey();
                Object ov = entry.getValue();
                data.put(ok, ov);
            }
            HashMap<String, Cloneable> tableData = new HashMap<String, Cloneable>();
            tableData.put(tableName, (Cloneable)((Object)dataForm));
            if (StringUtils.isNotEmpty((String)id) && head.getJformType() == 2 && StringUtils.isNotEmpty((String)(subTableStr = head.getSubTableStr()))) {
                String[] subTables = subTableStr.split(",");
                List<Object> subTableData = new ArrayList();
                String[] stringArray = subTables;
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    subTableData = this.cgFormFieldService.getSubTableData(tableName, subTable, id);
                    tableData.put(subTable, (Cloneable)((Object)subTableData));
                    ++n2;
                }
            }
            data.put("data", tableData);
            data.put("id", id);
            data.put("head", head);
            data.put("config_iframe", this.getHtmlHead(request));
            this.pushFiles(data, id);
            template.process(data, (Writer)writer);
            String content = stringWriter.toString();
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(content);
            long end = System.currentTimeMillis();
            logger.debug((Object)("\u81ea\u5b9a\u4e49\u8868\u5355\u751f\u6210\u8017\u65f6\uff1a" + (end - start) + " ms"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private String getHtmlHead(HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        String lang = (String)session.getAttribute("lang");
        StringBuilder sb = new StringBuilder("");
        sb.append("<base href=\"" + request.getContextPath() + "/\"/>");
        SysThemesEnum sysThemesEnum = SysThemesUtil.getSysTheme((HttpServletRequest)request);
        sb.append("<script type=\"text/javascript\" src=\"plug-in/jquery/jquery-1.8.3.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/dataformat.js\"></script>");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/accordion.css\">");
        sb.append(SysThemesUtil.getEasyUiTheme((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/easyui/themes/icon.css\" type=\"text/css\"></link>");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/icons.css\">");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/jquery.easyui.min.1.3.2.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/locale/zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/syUtil.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/My97DatePicker/WdatePicker.js\"></script>");
        sb.append(SysThemesUtil.getCommonTheme((SysThemesEnum)sysThemesEnum));
        sb.append(SysThemesUtil.getLhgdialogTheme((SysThemesEnum)sysThemesEnum));
        sb.append(StringUtil.replace((String)"<script type=\"text/javascript\" src=\"plug-in/tools/curdtools_{0}.js\"></script>", (String)"{0}", (String)lang));
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/easyuiextend.js\"></script>");
        sb.append(SysThemesUtil.getEasyUiMainTheme((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/uploadify/css/uploadify.css\" type=\"text/css\"></link>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/uploadify/jquery.uploadify-3.1.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/Map.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/Validform_v5.3.1_min_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/Validform_Datatype_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/datatype_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/plugin/passwordStrength/passwordStrength-min.js\"></script>");
        sb.append(SysThemesUtil.getValidformStyleTheme((SysThemesEnum)sysThemesEnum));
        sb.append(SysThemesUtil.getValidformTablefrom((SysThemesEnum)sysThemesEnum));
        return sb.toString();
    }

    private void pushFiles(Map<String, Object> data, String id) {
        List uploadBeans = this.cgFormFieldService.findByProperty(CgUploadEntity.class, "cgformId", id);
        ArrayList files = new ArrayList(0);
        for (CgUploadEntity b : uploadBeans) {
            String title = b.getAttachmenttitle();
            String fileKey = b.getId();
            String path = b.getRealpath();
            String field = b.getCgformField();
            HashMap<String, String> file = new HashMap<String, String>();
            file.put("title", title);
            file.put("fileKey", fileKey);
            file.put("path", path);
            file.put("field", field == null ? "" : field);
            files.add(file);
        }
        data.put("filesList", files);
    }
}

