/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.build;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.enums.SysThemesEnum;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.SysThemesUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.common.CommUtils;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgform.engine.TempletContext;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.template.CgformTemplateEntity;
import org.jeecgframework.web.cgform.entity.upload.CgUploadEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.template.CgformTemplateServiceI;
import org.jeecgframework.web.cgform.util.TemplateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgFormBuildController"})
public class CgFormBuildController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgFormBuildController.class);
    private String message;
    @Autowired
    private TempletContext templetContext;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private CgformTemplateServiceI cgformTemplateService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goAddFtlForm"})
    public void goAddFtlForm(HttpServletRequest request, HttpServletResponse response) {
        this.ftlForm(request, response);
    }

    @RequestMapping(params={"goUpdateFtlForm"})
    public void goUpdateFtlForm(HttpServletRequest request, HttpServletResponse response) {
        this.ftlForm(request, response);
    }

    @RequestMapping(params={"goDatilFtlForm"})
    public void goDatilFtlForm(HttpServletRequest request, HttpServletResponse response) {
        this.ftlForm(request, response);
    }

    @RequestMapping(params={"mobileForm"})
    public void mobileForm(HttpServletRequest request, HttpServletResponse response) {
        String urlTemplateName;
        String tableName = request.getParameter("tableName");
        String sql = "select form_template_mobile from cgform_head where table_name = '" + tableName + "'";
        Map mp = this.cgFormFieldService.findOneForJdbc(sql, new Object[0]);
        if (mp.containsKey("form_template_mobile") && oConvertUtils.isNotEmpty(mp.get("form_template_mobile")) && oConvertUtils.isEmpty((Object)(urlTemplateName = request.getParameter("olstylecode")))) {
            request.setAttribute("olstylecode", (Object)mp.get("form_template_mobile").toString().trim());
        }
        this.ftlForm(request, response);
    }

    @RequestMapping(params={"ftlForm"})
    public void ftlForm(HttpServletRequest request, HttpServletResponse response) {
        try {
            String subTableStr;
            long start = System.currentTimeMillis();
            String tableName = request.getParameter("tableName");
            HashMap<Object, Object> data = new HashMap();
            String id = request.getParameter("id");
            String mode = request.getParameter("mode");
            String templateName = String.valueOf(tableName) + "_";
            TemplateUtil.TemplateType templateType = TemplateUtil.TemplateType.LIST;
            if (StringUtils.isBlank((String)id)) {
                templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.ADD.getName();
                templateType = TemplateUtil.TemplateType.ADD;
            } else if ("read".equals(mode)) {
                templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.DETAIL.getName();
                templateType = TemplateUtil.TemplateType.DETAIL;
            } else {
                templateName = String.valueOf(templateName) + TemplateUtil.TemplateType.UPDATE.getName();
                templateType = TemplateUtil.TemplateType.UPDATE;
            }
            String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
            Map<String, Object> configData = this.cgFormFieldService.getFtlFormConfig(tableName, version);
            data = new HashMap<String, Object>(configData);
            CgFormHeadEntity head = (CgFormHeadEntity)data.get("head");
            Map<Object, Object> dataForm = new HashMap();
            if (StringUtils.isNotEmpty((String)id)) {
                dataForm = this.dataBaseService.findOneForJdbc(tableName, id);
            }
            for (Map.Entry entry : dataForm.entrySet()) {
                String ok = (String)entry.getKey();
                Object ov = entry.getValue();
                data.put(ok, ov);
            }
            HashMap<String, Cloneable> tableData = new HashMap<String, Cloneable>();
            tableData.put(tableName, (Cloneable)((Object)dataForm));
            if (StringUtils.isNotEmpty((String)id) && head.getJformType() == 2 && StringUtils.isNotEmpty((String)(subTableStr = head.getSubTableStr()))) {
                String[] subTables = subTableStr.split(",");
                List<Object> subTableData = new ArrayList();
                String[] stringArray = subTables;
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    subTableData = this.cgFormFieldService.getSubTableData(tableName, subTable, id);
                    tableData.put(subTable, (Cloneable)((Object)subTableData));
                    ++n2;
                }
            }
            data.put("data", tableData);
            data.put("id", id);
            data.put("head", head);
            data.put("config_iframe", this.getHtmlHead(request));
            this.pushFiles(data, id);
            this.pushImages(data, id);
            String content = null;
            response.setContentType("text/html;charset=utf-8");
            String urlTemplateName = request.getParameter("olstylecode");
            if (oConvertUtils.isEmpty((Object)urlTemplateName)) {
                urlTemplateName = (String)request.getAttribute("olstylecode");
            }
            if (StringUtils.isNotBlank((String)urlTemplateName)) {
                data.put("this_olstylecode", urlTemplateName);
                LogUtil.info((Object)("-------------urlTemplateName-----------" + urlTemplateName));
                content = this.getUrlTemplate(urlTemplateName, templateType, data);
            } else {
                data.put("this_olstylecode", head.getFormTemplate());
                LogUtil.info((Object)("-------------formTemplate-----------" + head.getFormTemplate()));
                content = this.getTableTemplate(templateName, request, data);
            }
            response.getWriter().print(content);
            long end = System.currentTimeMillis();
            logger.debug((Object)("\u81ea\u5b9a\u4e49\u8868\u5355\u751f\u6210\u8017\u65f6\uff1a" + (end - start) + " ms"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getUrlTemplate(String templateName, TemplateUtil.TemplateType templateType, Map dataMap) {
        String content = null;
        CgformTemplateEntity entity = this.cgformTemplateService.findByCode(templateName);
        if (entity != null) {
            FreemarkerHelper viewEngine = new FreemarkerHelper();
            dataMap.put("DictData", ApplicationContextUtil.getContext().getBean("dictDataTag"));
            content = viewEngine.parseTemplate(TemplateUtil.getTempletPath(entity, 0, templateType), dataMap);
        }
        return content;
    }

    private String getTableTemplate(String templateName, HttpServletRequest request, Map data) {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(stringWriter);
        String ftlVersion = request.getParameter("ftlVersion");
        Template template = this.templetContext.getTemplate(templateName, ftlVersion);
        try {
            template.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
            template.setDateFormat("yyyy-MM-dd");
            template.setTimeFormat("HH:mm:ss");
            template.process((Object)data, (Writer)writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    private String getHtmlHead(HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        String lang = (String)session.getAttribute("lang");
        StringBuilder sb = new StringBuilder("");
        SysThemesEnum sysThemesEnum = SysThemesUtil.getSysTheme((HttpServletRequest)request);
        sb.append("<script type=\"text/javascript\" src=\"plug-in/jquery/jquery-1.8.3.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/dataformat.js\"></script>");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/accordion.css\">");
        sb.append(SysThemesUtil.getEasyUiTheme((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/easyui/themes/icon.css\" type=\"text/css\"></link>");
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/icons.css\">");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/jquery.easyui.min.1.3.2.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/locale/zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/syUtil.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/My97DatePicker/WdatePicker.js\"></script>");
        sb.append(SysThemesUtil.getCommonTheme((SysThemesEnum)sysThemesEnum));
        sb.append(SysThemesUtil.getLhgdialogTheme((SysThemesEnum)sysThemesEnum));
        sb.append(StringUtil.replace((String)"<script type=\"text/javascript\" src=\"plug-in/tools/curdtools_{0}.js\"></script>", (String)"{0}", (String)lang));
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/easyuiextend.js\"></script>");
        sb.append(SysThemesUtil.getEasyUiMainTheme((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/uploadify/css/uploadify.css\" type=\"text/css\"></link>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/uploadify/jquery.uploadify-3.1.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/Map.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/Validform_v5.3.1_min_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/Validform_Datatype_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/js/datatype_zh-cn.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/Validform/plugin/passwordStrength/passwordStrength-min.js\"></script>");
        sb.append(SysThemesUtil.getValidformStyleTheme((SysThemesEnum)sysThemesEnum));
        sb.append(SysThemesUtil.getValidformTablefrom((SysThemesEnum)sysThemesEnum));
        sb.append("<link rel=\"stylesheet\" href=\"plug-in/umeditor/themes/default/css/umeditor.css\" type=\"text/css\"></link>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/umeditor/umeditor.config.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/umeditor/umeditor.min.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/umeditor/lang/zh-cn/zh-cn.js\"></script>");
        return sb.toString();
    }

    private void pushFiles(Map<String, Object> data, String id) {
        List uploadBeans = this.cgFormFieldService.findByProperty(CgUploadEntity.class, "cgformId", id);
        ArrayList files = new ArrayList(0);
        for (CgUploadEntity b : uploadBeans) {
            String title = b.getAttachmenttitle();
            String fileKey = b.getId();
            String path = b.getRealpath();
            String field = b.getCgformField();
            HashMap<String, String> file = new HashMap<String, String>();
            file.put("title", title);
            file.put("fileKey", fileKey);
            file.put("path", path);
            file.put("field", field == null ? "" : field);
            files.add(file);
        }
        data.put("filesList", files);
    }

    private void pushImages(Map<String, Object> data, String id) {
        List uploadBeans = this.cgFormFieldService.findByProperty(CgUploadEntity.class, "cgformId", id);
        ArrayList images = new ArrayList(0);
        for (CgUploadEntity b : uploadBeans) {
            String title = b.getAttachmenttitle();
            String fileKey = b.getId();
            String path = b.getRealpath();
            String field = b.getCgformField();
            HashMap<String, String> image = new HashMap<String, String>();
            image.put("title", title);
            image.put("fileKey", fileKey);
            image.put("path", path);
            image.put("field", field == null ? "" : field);
            images.add(image);
        }
        data.put("imageList", images);
    }

    @RequestMapping(params={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        Map data = request.getParameterMap();
        if (data != null) {
            String[] filterName;
            data = CommUtils.mapConvert(data);
            String tableName = (String)data.get("tableName");
            String id = (String)data.get("id");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String ok = entry.getKey();
                Object ov = entry.getValue() == null ? "" : entry.getValue();
                logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
            }
            if (StringUtils.isEmpty((String)id)) {
                filterName = new String[]{"tableName", "saveOrUpdate"};
                data = CommUtils.attributeMapFilter(data, filterName);
                try {
                    Object pkValue = null;
                    pkValue = this.dataBaseService.getPkValue(tableName);
                    data.put("id", pkValue);
                    try {
                        this.dataBaseService.insertTable(tableName, data);
                        j.setSuccess(true);
                        this.message = "\u4e1a\u52a1\u63d0\u4ea4\u6210\u529f";
                    }
                    catch (Exception e) {
                        j.setSuccess(false);
                        this.message = "\u4e1a\u52a1\u63d0\u4ea4\u5931\u8d25";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            } else {
                filterName = new String[]{"tableName", "saveOrUpdate", "id"};
                data = CommUtils.attributeMapFilter(data, filterName);
                try {
                    int num = this.dataBaseService.updateTable(tableName, id, data);
                    if (num > 0) {
                        j.setSuccess(true);
                        this.message = "\u4e1a\u52a1\u66f4\u65b0\u6210\u529f";
                    } else {
                        j.setSuccess(false);
                        this.message = "\u4e1a\u52a1\u66f4\u65b0\u5931\u8d25";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            }
        }
        j.setMsg(this.message);
        j.setObj(data);
        return j;
    }

    @RequestMapping(params={"saveOrUpdateMore"})
    @ResponseBody
    public AjaxJson saveOrUpdateMore(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        Map<String, Object> data = request.getParameterMap();
        if (data != null) {
            data = CommUtils.mapConvert(data);
            String tableName = (String)data.get("tableName");
            String id = (String)data.get("id");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String ok = entry.getKey();
                Object ov = entry.getValue() == null ? "" : entry.getValue();
                logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
            }
            Map<String, List<Map<String, Object>>> mapMore = CommUtils.mapConvertMore(data, tableName);
            if (StringUtils.isEmpty((String)id)) {
                logger.info((Object)"\u4e00\u5bf9\u591a\u6dfb\u52a0!!!!!");
                try {
                    Map<String, Object> result = this.dataBaseService.insertTableMore(mapMore, tableName);
                    data.put("id", result.get("id"));
                    j.setSuccess(true);
                    this.message = "\u6dfb\u52a0\u6210\u529f";
                }
                catch (BusinessException e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            } else {
                logger.info((Object)"\u4e00\u5bf9\u591a\u4fee\u6539!!!!!");
                try {
                    this.dataBaseService.updateTableMore(mapMore, tableName);
                    j.setSuccess(true);
                    this.message = "\u66f4\u65b0\u6210\u529f";
                }
                catch (BusinessException e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            }
        }
        j.setMsg(this.message);
        j.setObj(data);
        return j;
    }

    @RequestMapping(params={"doButton"})
    @ResponseBody
    public AjaxJson doButton(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String formId = request.getParameter("formId");
            String buttonCode = request.getParameter("buttonCode");
            String tableName = request.getParameter("tableName");
            String id = request.getParameter("id");
            Map<String, Object> data = this.dataBaseService.findOneForJdbc(tableName, id);
            if (data != null) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String ok = entry.getKey();
                    Object ov = entry.getValue() == null ? "" : entry.getValue();
                    logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
                }
                data = CommUtils.mapConvert(data);
                this.dataBaseService.executeSqlExtend(formId, buttonCode, data);
                this.dataBaseService.executeJavaExtend(formId, buttonCode, data);
            }
            j.setSuccess(true);
            this.message = "\u64cd\u4f5c\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25";
        }
        j.setMsg(this.message);
        return j;
    }
}

