/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.autolist;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.enums.SysThemesEnum;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.JeecgDataAutorUtils;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.SysThemesUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.template.CgformTemplateEntity;
import org.jeecgframework.web.cgform.service.autolist.CgTableServiceI;
import org.jeecgframework.web.cgform.service.autolist.ConfigServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.template.CgformTemplateServiceI;
import org.jeecgframework.web.cgform.util.QueryParamUtil;
import org.jeecgframework.web.cgform.util.TemplateUtil;
import org.jeecgframework.web.system.pojo.base.DictEntity;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cgAutoListController"})
public class CgAutoListController
extends BaseController {
    @Autowired
    private ConfigServiceI configService;
    @Autowired
    private CgTableServiceI cgTableService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private CgformTemplateServiceI cgformTemplateService;
    private static Logger log = Logger.getLogger(CgAutoListController.class);

    @RequestMapping(params={"list"})
    public void list(String id, HttpServletRequest request, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(id);
        Map<String, Object> configs = this.configService.queryConfigs(id, jversion);
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.loadVars(configs, paras, request);
        String template = request.getParameter("olstylecode");
        if (StringUtils.isBlank((String)template)) {
            CgFormHeadEntity head = this.cgFormFieldService.getCgFormHeadByTableName(id);
            template = head.getFormTemplate();
            paras.put("_olstylecode", "");
        } else {
            paras.put("_olstylecode", template);
        }
        paras.put("this_olstylecode", template);
        CgformTemplateEntity entity = this.cgformTemplateService.findByCode(template);
        String html = viewEngine.parseTemplate(TemplateUtil.getTempletPath(entity, 0, TemplateUtil.TemplateType.LIST), paras);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        log.debug((Object)("\u52a8\u6001\u5217\u8868\u751f\u6210\u8017\u65f6\uff1a" + (end - start) + " ms"));
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(String configId, String page, String field, String rows, String sort, String order, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String dataRuleSql = JeecgDataAutorUtils.loadDataSearchConditonSQLString();
        long start = System.currentTimeMillis();
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
        Map<String, Object> configs = this.configService.queryConfigs(configId, jversion);
        String table = (String)configs.get("tableName");
        HashMap<String, String> params = new HashMap<String, String>();
        List beans = (List)configs.get("fileds");
        HashMap<String, String[]> fieldMap = new HashMap<String, String[]>();
        for (CgFormFieldEntity b : beans) {
            QueryParamUtil.loadQueryParams(request, b, params);
            fieldMap.put(b.getFieldName(), new String[]{b.getType(), b.getFieldDefault()});
        }
        boolean isTree = configs.get("config_istree") == null ? false : "Y".equalsIgnoreCase(configs.get("config_istree").toString());
        String treeId = request.getParameter("id");
        String parentIdFieldName = null;
        String parentIdDefault = null;
        String parentIdFieldType = null;
        if (isTree) {
            parentIdFieldName = configs.get("tree_parentid_fieldname").toString();
            parentIdFieldType = ((String[])fieldMap.get(parentIdFieldName))[0];
            parentIdDefault = ((String[])fieldMap.get(parentIdFieldName))[1];
            if ("null".equalsIgnoreCase(parentIdDefault)) {
                parentIdDefault = null;
            }
            if (treeId == null) {
                treeId = parentIdDefault;
            } else if (parentIdFieldType.equalsIgnoreCase("String")) {
                treeId = "'" + treeId + "'";
            }
            if (treeId == null) {
                params.put(parentIdFieldName, " is null");
            } else {
                params.put(parentIdFieldName, "=" + treeId);
            }
        }
        int p = page == null ? 1 : Integer.parseInt(page);
        int r = rows == null ? 99999 : Integer.parseInt(rows);
        List result = null;
        result = isTree && treeId != null ? this.cgTableService.querySingle(table, field.toString(), params, sort, order, 1, 500) : this.cgTableService.querySingle(table, field.toString(), params, sort, order, p, r);
        if (isTree) {
            this.cgTableService.treeFromResultHandle(table, parentIdFieldName, parentIdFieldType, result);
        }
        HashMap dicMap = new HashMap();
        for (CgFormFieldEntity b : beans) {
            this.loadDic(dicMap, b);
            List dicList = (List)dicMap.get("field_dictlist");
            if (dicList.size() <= 0) continue;
            for (Map resultMap : result) {
                String[] arrayVal;
                StringBuffer sb = new StringBuffer();
                String value = (String)resultMap.get(b.getFieldName());
                if (oConvertUtils.isEmpty((Object)value) || (arrayVal = value.split(",")).length <= 1) continue;
                String[] stringArray = arrayVal;
                int n = arrayVal.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    for (DictEntity dictEntity : dicList) {
                        if (!val.equals(dictEntity.getTypecode())) continue;
                        sb.append(dictEntity.getTypename());
                        sb.append(",");
                    }
                    ++n2;
                }
                resultMap.put(b.getFieldName(), sb.toString().substring(0, sb.toString().length() - 1));
            }
        }
        Long size = this.cgTableService.getQuerySingleSize(table, field, params);
        this.dealDic(result, beans);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            if (isTree && treeId != null) {
                writer.println(QueryParamUtil.getJson(result));
            } else {
                writer.println(QueryParamUtil.getJson(result, size));
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        log.debug((Object)("\u52a8\u6001\u5217\u8868\u67e5\u8be2\u8017\u65f6\uff1a" + (end - start) + " ms"));
    }

    private void dealDic(List<Map<String, Object>> result, List<CgFormFieldEntity> beans) {
        for (CgFormFieldEntity bean : beans) {
            String dicTable = bean.getDictTable();
            String dicCode = bean.getDictField();
            String dicText = bean.getDictText();
            if (StringUtil.isEmpty((String)dicTable) && StringUtil.isEmpty((String)dicCode) || bean.getShowType().equals("popup")) continue;
            List<DictEntity> dicDataList = this.queryDic(dicTable, dicCode, dicText);
            for (Map<String, Object> r : result) {
                String value = String.valueOf(r.get(bean.getFieldName()));
                for (DictEntity dictEntity : dicDataList) {
                    if (!value.equalsIgnoreCase(dictEntity.getTypecode())) continue;
                    r.put(bean.getFieldName(), MutiLangUtil.getMutiLangInstance().getLang(dictEntity.getTypename()));
                }
            }
        }
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(String configId, String id, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
        String table = (String)this.configService.queryConfigs(configId, jversion).get("tableName");
        this.cgTableService.delete(table, id);
        String message = "\u5220\u9664\u6210\u529f";
        this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"delBatch"})
    @ResponseBody
    public AjaxJson delBatch(String configId, String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
        String table = (String)this.configService.queryConfigs(configId, jversion).get("tableName");
        String message = "\u5220\u9664\u6210\u529f";
        try {
            String[] id = ids.split(",");
            this.cgTableService.deleteBatch(table, id);
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(message);
        return j;
    }

    private Map loadVars(Map<String, Object> configs, Map<String, Object> paras, HttpServletRequest request) {
        paras.putAll(configs);
        ArrayList fieldList = new ArrayList();
        ArrayList<Map> queryList = new ArrayList<Map>();
        StringBuilder fileds = new StringBuilder();
        StringBuilder initQuery = new StringBuilder();
        Set operationCodes = (Set)request.getAttribute(Globals.OPERATIONCODES);
        HashMap<String, TSOperation> operationCodesMap = new HashMap<String, TSOperation>();
        if (operationCodes != null) {
            for (String id : operationCodes) {
                TSOperation tsOperation = (TSOperation)this.systemService.getEntity(TSOperation.class, (Serializable)((Object)id));
                if (tsOperation == null || tsOperation.getOperationType() != 0 || tsOperation.getStatus() != 0) continue;
                operationCodesMap.put(tsOperation.getOperationcode(), tsOperation);
            }
        }
        for (CgFormFieldEntity bean : (List)configs.get("fileds")) {
            if (operationCodesMap.containsKey(bean.getFieldName())) continue;
            HashMap<String, Object> fm = new HashMap<String, Object>();
            fm.put("field_id", bean.getFieldName());
            fm.put("field_title", bean.getContent());
            String isShowList = bean.getIsShowList();
            if (StringUtil.isEmpty((String)isShowList)) {
                isShowList = "id".equalsIgnoreCase(bean.getFieldName()) ? "N" : "Y";
            }
            fm.put("field_isShow", isShowList);
            fm.put("field_queryMode", bean.getQueryMode());
            fm.put("field_showType", bean.getShowType());
            fm.put("field_type", bean.getType());
            fm.put("field_length", bean.getFieldLength() == null ? "120" : bean.getFieldLength());
            fm.put("field_href", bean.getFieldHref() == null ? "" : bean.getFieldHref());
            this.loadDic(fm, bean);
            fieldList.add(fm);
            if ("Y".equals(bean.getIsQuery())) {
                HashMap<String, String> fmq = new HashMap<String, String>();
                fmq.put("field_id", bean.getFieldName());
                fmq.put("field_title", bean.getContent());
                fmq.put("field_queryMode", bean.getQueryMode());
                fmq.put("field_type", bean.getType());
                fmq.put("field_showType", bean.getShowType());
                fmq.put("field_dictField", bean.getDictField());
                fmq.put("field_dictTable", bean.getDictTable());
                fmq.put("field_isQuery", "Y");
                this.loadDefaultValue(fmq, bean, request);
                this.loadDic(fmq, bean);
                queryList.add(fmq);
            }
            this.loadUrlDataFilter(queryList, bean, request);
            this.loadInitQuery(initQuery, bean, request);
            fileds.append(bean.getFieldName()).append(",");
        }
        this.loadAuth(paras, request);
        this.loadIframeConfig(paras, request);
        paras.put("config_fieldList", fieldList);
        paras.put("config_queryList", queryList);
        paras.put("fileds", fileds);
        paras.put("initquery", initQuery);
        return paras;
    }

    private void loadIframeConfig(Map<String, Object> paras, HttpServletRequest request) {
        HttpSession session = ContextHolderUtils.getSession();
        String lang = (String)session.getAttribute("lang");
        StringBuilder sb = new StringBuilder("");
        if (!request.getQueryString().contains("isHref")) {
            SysThemesEnum sysThemesEnum = SysThemesUtil.getSysTheme((HttpServletRequest)request);
            sb.append("<script type=\"text/javascript\" src=\"plug-in/jquery/jquery-1.8.3.js\"></script>");
            sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/dataformat.js\"></script>");
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/accordion.css\">");
            sb.append(SysThemesUtil.getEasyUiTheme((SysThemesEnum)sysThemesEnum));
            sb.append(SysThemesUtil.getEasyUiIconTheme((SysThemesEnum)sysThemesEnum));
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"plug-in/accordion/css/icons.css\">");
            sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/jquery.easyui.min.1.3.2.js\"></script>");
            sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/locale/zh-cn.js\"></script>");
            sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/syUtil.js\"></script>");
            sb.append("<script type=\"text/javascript\" src=\"plug-in/My97DatePicker/WdatePicker.js\"></script>");
            sb.append(SysThemesUtil.getCommonTheme((SysThemesEnum)sysThemesEnum));
            sb.append(SysThemesUtil.getLhgdialogTheme((SysThemesEnum)sysThemesEnum));
            sb.append(StringUtil.replace((String)"<script type=\"text/javascript\" src=\"plug-in/tools/curdtools_{0}.js\"></script>", (String)"{0}", (String)lang));
            sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/easyuiextend.js\"></script>");
            sb.append(SysThemesUtil.getEasyUiMainTheme((SysThemesEnum)sysThemesEnum));
        }
        paras.put("config_iframe", sb.toString());
    }

    private void loadAuth(Map<String, Object> paras, HttpServletRequest request) {
        List nolist = (List)request.getAttribute(Globals.NOAUTO_OPERATIONCODES);
        if (ResourceUtil.getSessionUserName().getUserName().equals("admin") || !Globals.BUTTON_AUTHORITY_CHECK) {
            nolist = null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String nolistStr = "";
        if (nolist != null) {
            for (TSOperation operation : nolist) {
                nolistStr = String.valueOf(nolistStr) + operation.getOperationcode();
                nolistStr = String.valueOf(nolistStr) + ",";
                list.add(operation.getOperationcode());
            }
        }
        paras.put("config_nolist", list);
        paras.put("config_noliststr", nolistStr == null ? "" : nolistStr);
    }

    private void loadInitQuery(StringBuilder initQuery, CgFormFieldEntity bean, HttpServletRequest request) {
        if (bean.getFieldName().equalsIgnoreCase("id")) {
            return;
        }
        String paramV = request.getParameter(bean.getFieldName());
        String paramVbegin = request.getParameter(String.valueOf(bean.getFieldName()) + "_begin");
        String paramVend = request.getParameter(String.valueOf(bean.getFieldName()) + "_end");
        if (!StringUtil.isEmpty((String)(paramV = this.getSystemValue(paramV)))) {
            initQuery.append("&" + bean.getFieldName() + "=" + paramV);
        }
        if (!StringUtil.isEmpty((String)paramVbegin)) {
            initQuery.append("&" + bean.getFieldName() + "_begin=" + paramVbegin);
        }
        if (!StringUtil.isEmpty((String)paramVend)) {
            initQuery.append("&" + bean.getFieldName() + "_end=" + paramVend);
        }
    }

    private void loadUrlDataFilter(List<Map> queryList, CgFormFieldEntity bean, HttpServletRequest request) {
        String paramV = request.getParameter(bean.getFieldName());
        String paramVbegin = request.getParameter(String.valueOf(bean.getFieldName()) + "_begin");
        String paramVend = request.getParameter(String.valueOf(bean.getFieldName()) + "_end");
        if (bean.getFieldName().equalsIgnoreCase("id")) {
            return;
        }
        for (Map mq : queryList) {
            if (!mq.containsValue(bean.getFieldName())) continue;
            return;
        }
        if (!(StringUtil.isEmpty((String)paramV) && StringUtil.isEmpty((String)paramVbegin) && StringUtil.isEmpty((String)paramVend))) {
            HashMap<String, String> fmq = new HashMap<String, String>();
            fmq.put("field_id", bean.getFieldName());
            fmq.put("field_title", bean.getContent());
            fmq.put("field_queryMode", bean.getQueryMode());
            fmq.put("field_type", bean.getType());
            fmq.put("field_isQuery", "N");
            paramV = this.getSystemValue(paramV);
            fmq.put("field_value", paramV);
            paramVend = this.getSystemValue(paramVend);
            fmq.put("field_value_begin", StringUtil.isEmpty((String)paramVbegin) ? "" : paramVbegin);
            fmq.put("field_value_end", StringUtil.isEmpty((String)paramVend) ? "" : paramVend);
            queryList.add(fmq);
        }
    }

    private void loadDefaultValue(Map fmq, CgFormFieldEntity bean, HttpServletRequest request) {
        if (bean.getQueryMode().equalsIgnoreCase("single")) {
            String paramV = request.getParameter(bean.getFieldName());
            if (!StringUtil.isEmpty((String)paramV)) {
                paramV = this.getSystemValue(paramV);
                fmq.put("field_value", paramV);
            }
        } else if (bean.getQueryMode().equalsIgnoreCase("group")) {
            String paramVbegin = request.getParameter(String.valueOf(bean.getFieldName()) + "_begin");
            String paramVend = request.getParameter(String.valueOf(bean.getFieldName()) + "_end");
            fmq.put("field_value_begin", StringUtil.isEmpty((String)paramVbegin) ? "" : paramVbegin);
            fmq.put("field_value_end", StringUtil.isEmpty((String)paramVend) ? "" : paramVend);
        }
    }

    private void loadDic(Map m, CgFormFieldEntity bean) {
        String dicT = bean.getDictTable();
        String dicF = bean.getDictField();
        String dicText = bean.getDictText();
        if (StringUtil.isEmpty((String)dicT) && StringUtil.isEmpty((String)dicF)) {
            m.put("field_dictlist", new ArrayList(0));
            return;
        }
        if (!bean.getShowType().equals("popup")) {
            List<DictEntity> dicDatas = this.queryDic(dicT, dicF, dicText);
            m.put("field_dictlist", dicDatas);
        } else {
            m.put("field_dictlist", new ArrayList(0));
        }
    }

    private List<DictEntity> queryDic(String dicTable, String dicCode, String dicText) {
        return this.systemService.queryDict(dicTable, dicCode, dicText);
    }

    private String getSystemValue(String sysVarName) {
        if (StringUtil.isEmpty((String)sysVarName)) {
            return sysVarName;
        }
        if (sysVarName.contains("{") && sysVarName.contains("}")) {
            sysVarName = sysVarName.replaceAll("\\{", "");
            sysVarName = sysVarName.replaceAll("\\}", "");
            sysVarName = sysVarName.replace("sys.", "");
            return ResourceUtil.converRuleValue((String)sysVarName);
        }
        return sysVarName;
    }
}

