/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.autoform;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormStyleEntity;
import org.jeecgframework.web.cgform.service.autoform.AutoFormStyleServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/autoFormStyleController"})
public class AutoFormStyleController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AutoFormStyleController.class);
    @Autowired
    private AutoFormStyleServiceI autoFormStyleService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"autoFormStyle"})
    public ModelAndView autoFormStyle(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/autoform/autoFormStyleList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AutoFormStyleEntity autoFormStyle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AutoFormStyleEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)autoFormStyle, (Map)request.getParameterMap());
        cq.add();
        this.autoFormStyleService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(AutoFormStyleEntity autoFormStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        autoFormStyle = (AutoFormStyleEntity)this.systemService.getEntity(AutoFormStyleEntity.class, (Serializable)((Object)autoFormStyle.getId()));
        this.message = "\u8868\u5355\u6837\u5f0f\u8868\u5220\u9664\u6210\u529f";
        try {
            this.autoFormStyleService.delete(autoFormStyle);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u8868\u5355\u6837\u5f0f\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u8868\u5355\u6837\u5f0f\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                AutoFormStyleEntity autoFormStyle = (AutoFormStyleEntity)this.systemService.getEntity(AutoFormStyleEntity.class, (Serializable)((Object)id));
                this.autoFormStyleService.delete(autoFormStyle);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u8868\u5355\u6837\u5f0f\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(AutoFormStyleEntity autoFormStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u8868\u5355\u6837\u5f0f\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            this.autoFormStyleService.save(autoFormStyle);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u8868\u5355\u6837\u5f0f\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(AutoFormStyleEntity autoFormStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u8868\u5355\u6837\u5f0f\u8868\u66f4\u65b0\u6210\u529f";
        AutoFormStyleEntity t = (AutoFormStyleEntity)this.autoFormStyleService.get(AutoFormStyleEntity.class, (Serializable)((Object)autoFormStyle.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)autoFormStyle, (Object)t);
            this.autoFormStyleService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u8868\u5355\u6837\u5f0f\u8868\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(AutoFormStyleEntity autoFormStyle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormStyle.getId())) {
            autoFormStyle = (AutoFormStyleEntity)this.autoFormStyleService.getEntity(AutoFormStyleEntity.class, (Serializable)((Object)autoFormStyle.getId()));
            req.setAttribute("autoFormStylePage", (Object)autoFormStyle);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormStyle-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(AutoFormStyleEntity autoFormStyle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormStyle.getId())) {
            autoFormStyle = (AutoFormStyleEntity)this.autoFormStyleService.getEntity(AutoFormStyleEntity.class, (Serializable)((Object)autoFormStyle.getId()));
            req.setAttribute("autoFormStylePage", (Object)autoFormStyle);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormStyle-update");
    }

    @ResponseBody
    @RequestMapping(params={"checkStyleNm"})
    public JSONObject checkStyleNm(AutoFormStyleEntity autoFormStyle, HttpServletRequest req) {
        JSONObject jsonObject = new JSONObject();
        String param = req.getParameter("param");
        List list = new ArrayList();
        String hql = "";
        if (StringUtils.isNotBlank((CharSequence)autoFormStyle.getId())) {
            hql = "from AutoFormStyleEntity t where t.id != ? and t.styleDesc = ?";
            list = this.systemService.findHql(hql, new Object[]{autoFormStyle.getId(), param});
        } else {
            hql = "from AutoFormStyleEntity t where t.styleDesc = ?";
            list = this.systemService.findHql(hql, new Object[]{param});
        }
        if (list.size() > 0) {
            jsonObject.put("status", (Object)"n");
            jsonObject.put("info", (Object)"\u6837\u5f0f\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            return jsonObject;
        }
        jsonObject.put("status", (Object)"y");
        return jsonObject;
    }
}

