/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.autoform;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.pojo.Columnt;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DynamicDBUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.SqlUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbFieldEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbPage;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormParamEntity;
import org.jeecgframework.web.cgform.service.autoform.AutoFormDbServiceI;
import org.jeecgframework.web.system.pojo.base.DynamicDataSourceEntity;
import org.jeecgframework.web.system.service.DynamicDataSourceServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/autoFormDbController"})
public class AutoFormDbController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AutoFormDbController.class);
    @Autowired
    private AutoFormDbServiceI autoFormDbService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private DynamicDataSourceServiceI dynamicDataSourceServiceI;

    @RequestMapping(params={"autoFormDb"})
    public ModelAndView autoFormDb(HttpServletRequest request) {
        String autoFormId = request.getParameter("autoFormId");
        if (oConvertUtils.isNotEmpty((Object)autoFormId)) {
            request.setAttribute("autoFormId", (Object)autoFormId);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDbList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AutoFormDbEntity autoFormDb, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AutoFormDbEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)autoFormDb);
        cq.add();
        this.autoFormDbService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(AutoFormDbEntity autoFormDb, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        autoFormDb = (AutoFormDbEntity)this.systemService.getEntity(AutoFormDbEntity.class, (Serializable)((Object)autoFormDb.getId()));
        String message = "\u8868\u5355\u6570\u636e\u6e90\u5220\u9664\u6210\u529f";
        try {
            this.autoFormDbService.delMain(autoFormDb);
            this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u6570\u636e\u6e90\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8868\u5355\u6570\u636e\u6e90\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                AutoFormDbEntity autoFormDb = (AutoFormDbEntity)this.systemService.getEntity(AutoFormDbEntity.class, (Serializable)((Object)id));
                this.autoFormDbService.delMain(autoFormDb);
                this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u6570\u636e\u6e90\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(AutoFormDbEntity autoFormDb, AutoFormDbPage autoFormDbPage, HttpServletRequest request) {
        List<AutoFormDbFieldEntity> autoFormDbFieldList = autoFormDbPage.getAutoFormDbFieldList();
        List<AutoFormParamEntity> autoFormParamList = autoFormDbPage.getAutoFormParamList();
        AjaxJson j = new AjaxJson();
        String message = "\u6dfb\u52a0\u6210\u529f";
        try {
            this.autoFormDbService.addMain(autoFormDb, autoFormDbFieldList, autoFormParamList);
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u6570\u636e\u6e90\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(AutoFormDbEntity autoFormDb, AutoFormDbPage autoFormDbPage, HttpServletRequest request) {
        List<AutoFormDbFieldEntity> autoFormDbFieldList = autoFormDbPage.getAutoFormDbFieldList();
        List<AutoFormParamEntity> autoFormParamList = autoFormDbPage.getAutoFormParamList();
        AjaxJson j = new AjaxJson();
        String message = "\u66f4\u65b0\u6210\u529f";
        try {
            this.autoFormDbService.updateMain(autoFormDb, autoFormDbFieldList, autoFormParamList);
            this.systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u66f4\u65b0\u8868\u5355\u6570\u636e\u6e90\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormDb.getId())) {
            autoFormDb = (AutoFormDbEntity)this.autoFormDbService.getEntity(AutoFormDbEntity.class, (Serializable)((Object)autoFormDb.getId()));
        }
        req.setAttribute("autoFormDbPage", (Object)autoFormDb);
        Collection dynamicDataSourceEntitys = DynamicDataSourceEntity.DynamicDataSourceMap.values();
        req.setAttribute("dynamicDataSourceEntitys", dynamicDataSourceEntitys);
        try {
            List tableNames = new JeecgReadTable().readAllTableNames();
            req.setAttribute("tableNames", (Object)tableNames);
        }
        catch (SQLException e) {
            logger.info((Object)e.getMessage());
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDb-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormDb.getId())) {
            DynamicDataSourceEntity dynamicDataSourceEntity;
            autoFormDb = (AutoFormDbEntity)this.autoFormDbService.getEntity(AutoFormDbEntity.class, (Serializable)((Object)autoFormDb.getId()));
            List tableNames = null;
            if (StringUtils.isNotBlank((String)autoFormDb.getDbKey()) && "table".equals(autoFormDb.getDbType()) && (dynamicDataSourceEntity = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(autoFormDb.getDbKey())) != null) {
                tableNames = DynamicDBUtil.findList((String)autoFormDb.getDbKey(), (String)SqlUtil.getAllTableSql((String)dynamicDataSourceEntity.getDbType(), (String[])new String[]{"'" + dynamicDataSourceEntity.getDbName() + "'"}), String.class, (Object[])new Object[0]);
            }
            Collection dynamicDataSourceEntitys = DynamicDataSourceEntity.DynamicDataSourceMap.values();
            req.setAttribute("dynamicDataSourceEntitys", dynamicDataSourceEntitys);
            String dbKey = null;
            if ("table".equals(autoFormDb.getDbType())) {
                dbKey = autoFormDb.getDbKey();
            } else if ("SQL".equals(autoFormDb.getDbType())) {
                dbKey = autoFormDb.getTbDbKey();
            }
            if (StringUtils.isBlank((String)dbKey)) {
                try {
                    tableNames = new JeecgReadTable().readAllTableNames();
                }
                catch (SQLException sQLException) {}
            } else {
                DynamicDataSourceEntity dynamicDataSourceEntity2 = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(dbKey);
                if (dynamicDataSourceEntity2 != null) {
                    tableNames = DynamicDBUtil.findList((String)dbKey, (String)SqlUtil.getAllTableSql((String)dynamicDataSourceEntity2.getDbType(), (String[])new String[]{"'" + dynamicDataSourceEntity2.getDbName() + "'"}), String.class, (Object[])new Object[0]);
                }
            }
            req.setAttribute("tableNames", (Object)tableNames);
            req.setAttribute("autoFormDbPage", (Object)autoFormDb);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDb-update");
    }

    @RequestMapping(params={"autoFormDbFieldList"})
    public ModelAndView autoFormDbFieldList(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormDb.getId())) {
            String hql0 = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
            try {
                List autoFormDbFieldEntityList = this.systemService.findHql(hql0, new Object[]{autoFormDb.getId()});
                req.setAttribute("autoFormDbFieldList", (Object)autoFormDbFieldEntityList);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
            }
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDbFieldList");
    }

    @RequestMapping(params={"autoFormParamList"})
    public ModelAndView autoFormParamList(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormDb.getId())) {
            String hql1 = "from AutoFormParamEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
            try {
                List autoFormParamEntityList = this.systemService.findHql(hql1, new Object[]{autoFormDb.getId()});
                req.setAttribute("autoFormParamList", (Object)autoFormParamEntityList);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
            }
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormParamList");
    }

    @RequestMapping(params={"getFields"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getSqlFields(String sql) {
        List<String> files = null;
        List<String> params = null;
        HashMap<String, Object> reJson = new HashMap<String, Object>();
        try {
            files = this.autoFormDbService.getSqlFields(sql);
            params = this.autoFormDbService.getSqlParams(sql);
        }
        catch (Exception e) {
            LogUtil.error((String)e.toString());
            String errorInfo = "\u89e3\u6790\u5931\u8d25!<br><br>\u5931\u8d25\u539f\u56e0\uff1a";
            errorInfo = String.valueOf(errorInfo) + e.getMessage();
            reJson.put("status", "error");
            reJson.put("datas", errorInfo);
            return reJson;
        }
        reJson.put("status", "success");
        reJson.put("files", files);
        reJson.put("params", params);
        return reJson;
    }

    @RequestMapping(params={"autoFormDbFieldForTableList"})
    public ModelAndView autoFormDbFieldForTableList(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoFormDb.getId())) {
            String hql0 = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
            try {
                List autoFormDbFieldEntityList = this.systemService.findHql(hql0, new Object[]{autoFormDb.getId()});
                req.setAttribute("autoFormDbFieldList", (Object)autoFormDbFieldEntityList);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
            }
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDbFieldForTableList");
    }

    @RequestMapping(params={"getAllTableNames"})
    @ResponseBody
    public Object getAllTableNames(String dbKey) {
        HashMap<String, Object> reJson = new HashMap<String, Object>();
        List tableNames = null;
        try {
            if (StringUtils.isNotBlank((String)dbKey)) {
                DynamicDataSourceEntity dynamicDataSourceEntity = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(dbKey);
                if (dynamicDataSourceEntity != null) {
                    tableNames = DynamicDBUtil.findList((String)dbKey, (String)SqlUtil.getAllTableSql((String)dynamicDataSourceEntity.getDbType(), (String[])new String[]{"'" + dynamicDataSourceEntity.getDbName() + "'"}), String.class, (Object[])new Object[0]);
                }
            } else {
                tableNames = new JeecgReadTable().readAllTableNames();
            }
        }
        catch (Exception e) {
            reJson.put("status", "error");
            reJson.put("datas", "\u8868\u67e5\u8be2\u5931\u8d25\uff01");
            reJson.put("tableNames", new ArrayList());
        }
        reJson.put("status", "success");
        reJson.put("tableNames", tableNames);
        return reJson;
    }

    @RequestMapping(params={"getTableFields"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getTableFields(String dbKey, String tableName) {
        HashMap<String, Object> reJson = new HashMap<String, Object>();
        List<String> columnsNames = null;
        if (StringUtils.isNotBlank((String)dbKey)) {
            DynamicDataSourceEntity dynamicDataSourceEntity = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(dbKey);
            if (dynamicDataSourceEntity != null) {
                columnsNames = DynamicDBUtil.findList((String)dbKey, (String)SqlUtil.getAllCloumnSql((String)dynamicDataSourceEntity.getDbType(), (String[])new String[]{"'" + tableName + "'", "'" + dynamicDataSourceEntity.getDbName() + "'"}), String.class, (Object[])new Object[0]);
            }
        } else {
            try {
                List columns = new JeecgReadTable().readOriginalTableColumn(tableName);
                columnsNames = new ArrayList<String>();
                for (Columnt column : columns) {
                    columnsNames.add(column.getFieldDbName());
                }
            }
            catch (Exception e) {
                reJson.put("status", "error");
                reJson.put("datas", "\u5217\u67e5\u8be2\u5931\u8d25\uff01");
            }
        }
        reJson.put("status", "success");
        reJson.put("files", columnsNames);
        return reJson;
    }

    @RequestMapping(params={"goView"})
    public ModelAndView goView(@RequestParam String id, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)id)) {
            AutoFormDbEntity autoFormDbEntity = (AutoFormDbEntity)this.autoFormDbService.getEntity(AutoFormDbEntity.class, (Serializable)((Object)id));
            if (autoFormDbEntity != null) {
                String hql1 = "from AutoFormParamEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
                try {
                    List autoFormParamEntityList = this.systemService.findHql(hql1, new Object[]{id});
                    req.setAttribute("autoFormParamList", (Object)autoFormParamEntityList);
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
            }
            req.setAttribute("autoFormDbEntity", (Object)autoFormDbEntity);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoFormDb-view");
    }

    @RequestMapping(params={"view"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson view(AutoFormDbEntity autoFormDb, HttpServletRequest req) {
        String msg;
        AjaxJson j;
        block15: {
            j = new AjaxJson();
            msg = "";
            Map paramMap = req.getParameterMap();
            List map = null;
            String dbKey = autoFormDb.getDbKey();
            String dbType = autoFormDb.getDbType();
            String dbTableName = autoFormDb.getDbTableName();
            String dbDynSql = autoFormDb.getDbDynSql();
            if ("table".equals(dbType)) {
                String hqlField = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
                try {
                    List autoFormDbFieldEntityList = this.systemService.findHql(hqlField, new Object[]{autoFormDb.getId()});
                    if (autoFormDbFieldEntityList.size() > 0) {
                        StringBuffer hqlTable = new StringBuffer().append("select ");
                        for (AutoFormDbFieldEntity autoFormDbFieldEntity : autoFormDbFieldEntityList) {
                            hqlTable.append(String.valueOf(autoFormDbFieldEntity.getFieldName()) + ",");
                        }
                        hqlTable.deleteCharAt(hqlTable.length() - 1).append(" from " + dbTableName);
                        if ("".equals(dbKey)) {
                            map = this.systemService.findForJdbc(hqlTable.toString(), new Object[0]);
                        } else {
                            DynamicDataSourceEntity dynamicDataSourceEntity = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(dbKey);
                            if (dynamicDataSourceEntity != null) {
                                map = DynamicDBUtil.findList((String)dbKey, (String)hqlTable.toString(), (Object[])new Object[0]);
                            }
                        }
                        j.setObj((Object)map);
                        msg = "\u8868\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01";
                        break block15;
                    }
                    j.setSuccess(false);
                    msg = "\u8868\u5c5e\u6027\u914d\u7f6e\u6709\u8bef\uff01";
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
            } else if ("sql".equals(dbType)) {
                List<String> params = this.autoFormDbService.getSqlParams(dbDynSql);
                for (String param : params) {
                    String[] paramValue = (String[])paramMap.get("#" + param);
                    dbDynSql = dbDynSql.replaceAll("\\$\\{" + param + "\\}", paramValue[0]);
                }
                if (dbDynSql.contains("\\$")) {
                    j.setSuccess(false);
                    msg = "\u52a8\u6001SQL\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01";
                } else {
                    try {
                        map = this.systemService.findForJdbc(dbDynSql, new Object[0]);
                        msg = "\u52a8\u6001SQL\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01";
                        j.setObj((Object)map);
                    }
                    catch (Exception e) {
                        logger.info((Object)e.getMessage());
                        j.setSuccess(false);
                        msg = "\u52a8\u6001SQL\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01";
                    }
                }
            }
        }
        j.setMsg(msg);
        return j;
    }

    @ResponseBody
    @RequestMapping(params={"checkDbName"})
    public JSONObject checkDbName(HttpServletRequest req, String cVal) {
        JSONObject jsonObject = new JSONObject();
        String param = req.getParameter("param");
        if (StringUtils.isNotBlank((String)cVal) && cVal.equals(param)) {
            jsonObject.put("info", (Object)"\u9a8c\u8bc1\u901a\u8fc7\uff01");
            jsonObject.put("status", (Object)"y");
            return jsonObject;
        }
        List list = new ArrayList();
        String hql = "from AutoFormDbEntity t where t.dbName = ?";
        list = this.systemService.findHql(hql, new Object[]{param});
        if (list.size() > 0) {
            jsonObject.put("status", (Object)"n");
            jsonObject.put("info", (Object)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            return jsonObject;
        }
        jsonObject.put("info", (Object)"\u9a8c\u8bc1\u901a\u8fc7\uff01");
        jsonObject.put("status", (Object)"y");
        return jsonObject;
    }
}

