/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.autoform;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DynamicDBUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormDbFieldEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormParamEntity;
import org.jeecgframework.web.cgform.entity.autoform.AutoFormStyleEntity;
import org.jeecgframework.web.cgform.service.autoform.AutoFormDbServiceI;
import org.jeecgframework.web.cgform.service.autoform.AutoFormServiceI;
import org.jeecgframework.web.cgform.util.AutoFormCommUtil;
import org.jeecgframework.web.cgform.util.AutoFormTemplateParseUtil;
import org.jeecgframework.web.cgform.util.TemplateUtil;
import org.jeecgframework.web.system.pojo.base.DynamicDataSourceEntity;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.service.DynamicDataSourceServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/autoFormController"})
public class AutoFormController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AutoFormController.class);
    @Autowired
    private AutoFormServiceI autoFormService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private AutoFormDbServiceI autoFormDbService;
    @Autowired
    private DynamicDataSourceServiceI dynamicDataSourceServiceI;

    @RequestMapping(params={"autoForm"})
    public ModelAndView autoForm(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/autoform/autoFormList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AutoFormEntity autoForm, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AutoFormEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)autoForm, (Map)request.getParameterMap());
        cq.add();
        this.autoFormService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(AutoFormEntity autoForm, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        autoForm = (AutoFormEntity)this.systemService.getEntity(AutoFormEntity.class, (Serializable)((Object)autoForm.getId()));
        String message = "\u8868\u5355\u8868\u5220\u9664\u6210\u529f";
        try {
            this.autoFormService.delete(autoForm);
            this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            this.delFormDb(autoForm.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8868\u5355\u8868\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                AutoFormEntity autoForm = (AutoFormEntity)this.systemService.getEntity(AutoFormEntity.class, (Serializable)((Object)id));
                this.autoFormService.delete(autoForm);
                this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                this.delFormDb(id);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u8868\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(AutoFormEntity autoForm, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8868\u5355\u8868\u6dfb\u52a0\u6210\u529f";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getFormContent())) {
                JSONObject jsonObj = JSONObject.fromObject((Object)autoForm.getFormContent());
                String html = (String)jsonObj.get("template");
                autoForm.setFormContent(html);
                autoForm.setFormParse(autoForm.getFormContent());
            }
            autoForm.setCreateDate(new Date());
            autoForm.setCreateName(ResourceUtil.getSessionUserName().getRealName());
            autoForm.setCreateBy(ResourceUtil.getSessionUserName().getUserName());
            this.autoFormService.save(autoForm);
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u8868\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(autoForm.getId());
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(AutoFormEntity autoForm, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        try {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getId())) {
                AutoFormEntity t = (AutoFormEntity)this.autoFormService.get(AutoFormEntity.class, (Serializable)((Object)autoForm.getId()));
                MyBeanUtils.copyBeanNotNull2Bean((Object)autoForm, (Object)t);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getFormContent())) {
                    JSONObject jsonObj = JSONObject.fromObject((Object)autoForm.getFormContent());
                    String html = (String)jsonObj.get("template");
                    this.validateId(html);
                    t.setFormContent(html);
                    t.setFormParse(autoForm.getFormContent());
                }
                autoForm.setUpdateDate(new Date());
                autoForm.setUpdateName(ResourceUtil.getSessionUserName().getRealName());
                autoForm.setUpdateBy(ResourceUtil.getSessionUserName().getUserName());
                this.autoFormService.saveOrUpdate(t);
                attributes.put("id", t.getId());
                j.setAttributes(attributes);
                message = "\u8868\u5355\u66f4\u65b0\u6210\u529f";
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)autoForm.getMainTableSource())) {
                    message = String.valueOf(message) + ",\u4e3b\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u4e3b\u6570\u636e\u6e90\uff01";
                }
            } else {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getFormContent())) {
                    JSONObject jsonObj = JSONObject.fromObject((Object)autoForm.getFormContent());
                    String html = (String)jsonObj.get("template");
                    this.validateId(html);
                    autoForm.setFormContent(html);
                    autoForm.setFormParse(autoForm.getFormContent());
                }
                this.autoFormService.save(autoForm);
                attributes.put("id", autoForm.getId());
                j.setAttributes(attributes);
                message = "\u8868\u5355\u6dfb\u52a0\u6210\u529f";
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)autoForm.getMainTableSource())) {
                    message = String.valueOf(message) + ",\u4e3b\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u4e3b\u6570\u636e\u6e90\uff01";
                }
            }
            this.systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            j.setSuccess(false);
            message = "\u8868\u5355\u4fdd\u5b58\u5931\u8d25!" + e.getMessage();
        }
        j.setMsg(message);
        return j;
    }

    private void validateId(String html) {
        if (StringUtil.isEmpty((String)html)) {
            return;
        }
        Document doc = Jsoup.parse((String)html);
        HashMap<String, String> map = new HashMap<String, String>();
        Elements IDs = doc.select("input[name$=.ID]");
        for (Element el : IDs) {
            String name = el.attr("name");
            System.out.println(name);
            if (map.get(name) != null) {
                throw new BusinessException("\u4e3b\u952eID\u6709\u91cd\u590d\u3010" + name + "\u3011,\u7f16\u8f91\u5668\u8fdb\u5165HTML\u6a21\u5f0f\u5220\u9664\u91cd\u590d\u7684\u4e3b\u952e");
            }
            map.put(name, name);
        }
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(AutoFormEntity autoForm, HttpServletRequest req) {
        JSONArray jsonArray = JSONArray.fromObject(this.getStyleList(""));
        req.setAttribute("styleSelect", (Object)jsonArray.toString());
        return new ModelAndView("jeecg/cgform/autoform/autoForm-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(AutoFormEntity autoForm, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)autoForm.getId())) {
            autoForm = (AutoFormEntity)this.autoFormService.getEntity(AutoFormEntity.class, (Serializable)((Object)autoForm.getId()));
            req.setAttribute("autoFormPage", (Object)autoForm);
        }
        JSONArray jsonArray = JSONArray.fromObject(this.getStyleList(autoForm.getFormStyleId()));
        req.setAttribute("styleSelect", (Object)jsonArray.toString());
        JSONArray dbArray = JSONArray.fromObject(this.getFormDbList(autoForm.getId()));
        req.setAttribute("dbDate", (Object)dbArray.toString());
        return new ModelAndView("jeecg/cgform/autoform/autoForm-update");
    }

    private List<Map<String, Object>> getStyleList(String styleid) {
        String hql = "from AutoFormStyleEntity";
        List list = this.systemService.findHql(hql, new Object[0]);
        ArrayList<Map<String, Object>> dateList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = null;
        for (AutoFormStyleEntity style : list) {
            map = new HashMap<String, Object>();
            map.put("id", style.getId());
            map.put("name", style.getStyleDesc());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)styleid) && styleid.equals(style.getId())) {
                map.put("checked", true);
            } else {
                map.put("checked", false);
            }
            dateList.add(map);
        }
        return dateList;
    }

    @RequestMapping(params={"treeReload"})
    @ResponseBody
    public AjaxJson treeReload(AutoFormDbEntity autoFormdb, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        JSONArray jsonArray = JSONArray.fromObject(this.getFormDbList(autoFormdb.getAutoFormId()));
        j.setMsg(jsonArray.toString());
        return j;
    }

    private List<Map<String, Object>> getFormDbList(String autoFormId) {
        List list = this.systemService.findByProperty(AutoFormDbEntity.class, "autoFormId", (Object)autoFormId);
        ArrayList<Map<String, Object>> dateList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = null;
        for (AutoFormDbEntity dbForm : list) {
            List fieldlist;
            map = new HashMap<String, Object>();
            map.put("id", dbForm.getId());
            map.put("name", String.valueOf(dbForm.getDbChName()) + "(" + dbForm.getDbName() + ")");
            map.put("dbCode", dbForm.getDbName());
            map.put("pid", "0");
            dateList.add(map);
            if ("table".equals(dbForm.getDbType())) {
                fieldlist = this.systemService.findByProperty(AutoFormDbFieldEntity.class, "autoFormDbId", (Object)dbForm.getId());
                for (AutoFormDbFieldEntity field : fieldlist) {
                    map = new HashMap();
                    map.put("id", field.getId());
                    map.put("name", org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getFieldText()) || "null".equals(field.getFieldText()) ? field.getFieldName() : String.valueOf(field.getFieldText()) + "(" + field.getFieldName() + ")");
                    map.put("pId", dbForm.getId());
                    map.put("nocheck", true);
                    dateList.add(map);
                }
                continue;
            }
            if (!"sql".equals(dbForm.getDbType())) continue;
            fieldlist = this.systemService.findByProperty(AutoFormDbFieldEntity.class, "autoFormDbId", (Object)dbForm.getId());
            if (fieldlist.size() > 0) {
                for (AutoFormDbFieldEntity field : fieldlist) {
                    map = new HashMap();
                    map.put("id", field.getId());
                    map.put("name", org.apache.commons.lang3.StringUtils.isBlank((CharSequence)field.getFieldText()) || "null".equals(field.getFieldText()) ? field.getFieldName() : String.valueOf(field.getFieldText()) + "(" + field.getFieldName() + ")");
                    map.put("pId", dbForm.getId());
                    map.put("nocheck", true);
                    dateList.add(map);
                }
                continue;
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getDbDynSql())) continue;
            List<String> files = this.autoFormDbService.getSqlFields(dbForm.getDbDynSql());
            for (String filed : files) {
                map = new HashMap();
                map.put("id", "");
                map.put("name", filed);
                map.put("pId", dbForm.getId());
                map.put("nocheck", true);
                dateList.add(map);
            }
        }
        return dateList;
    }

    @RequestMapping(params={"docreateCode"})
    @ResponseBody
    public AjaxJson docreateCode(String formdbId, String styleId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        AutoFormStyleEntity styleEntity = (AutoFormStyleEntity)this.systemService.get(AutoFormStyleEntity.class, (Serializable)((Object)styleId));
        String content = styleEntity.getStyleContent();
        String[] ids = formdbId.split(",");
        ArrayList<Map<String, Object>> dsList = new ArrayList<Map<String, Object>>();
        if (ids.length > 0) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                List columns;
                String hql;
                String autoFormDbId = stringArray[n2];
                HashMap<String, Object> dsData = new HashMap<String, Object>();
                AutoFormDbEntity db = (AutoFormDbEntity)this.systemService.findUniqueByProperty(AutoFormDbEntity.class, "id", (Object)autoFormDbId);
                dsData.put("dsName", db.getDbName());
                dsList.add(dsData);
                if ("table".equals(db.getDbType())) {
                    hql = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?";
                    columns = this.systemService.findHql(hql, new Object[]{autoFormDbId});
                    dsData.put("columns", columns);
                } else if ("sql".equals(db.getDbType())) {
                    hql = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?";
                    columns = this.systemService.findHql(hql, new Object[]{autoFormDbId});
                    if (columns.size() > 0) {
                        dsData.put("columns", columns);
                    } else {
                        List<String> fileds = this.autoFormDbService.getSqlFields(db.getDbDynSql());
                        ArrayList column = new ArrayList();
                        for (String filed : fileds) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("fieldName", filed.toLowerCase());
                            column.add(map);
                        }
                        dsData.put("columns", column);
                    }
                }
                ++n2;
            }
        }
        String result = this.createFtl(content, dsList);
        j.setMsg(result.replaceAll("\"", "&quot;"));
        return j;
    }

    private String createFtl(String content, List<Map<String, Object>> dsList) {
        String result = "";
        try {
            Configuration cfg = new Configuration();
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate("autoformTemplete", content);
            cfg.setTemplateLoader((TemplateLoader)stringLoader);
            Template template = cfg.getTemplate("autoformTemplete", "utf-8");
            HashMap<String, List<Map<String, Object>>> root = new HashMap<String, List<Map<String, Object>>>();
            root.put("dsList", dsList);
            StringWriter writer = new StringWriter();
            template.process(root, (Writer)writer);
            result = writer.toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(params={"parse"})
    public ModelAndView parse(AutoFormEntity autoForm, HttpServletRequest req) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getId())) {
            autoForm = (AutoFormEntity)this.systemService.findUniqueByProperty(AutoFormEntity.class, "id", (Object)autoForm.getId());
            List<String> paramList = this.getFormParams(autoForm.getId());
            req.setAttribute("paramList", paramList);
            req.setAttribute("autoFormPage", (Object)autoForm);
        }
        return new ModelAndView("jeecg/cgform/autoform/autoForm-view");
    }

    private List<String> getFormParams(String fromId) {
        ArrayList<String> paramList = new ArrayList<String>();
        List formDbList = this.systemService.findByProperty(AutoFormDbEntity.class, "autoFormId", (Object)fromId);
        for (AutoFormDbEntity dbEntity : formDbList) {
            if ("sql".equals(dbEntity.getDbType())) {
                List params = this.systemService.findByProperty(AutoFormParamEntity.class, "autoFormDbId", (Object)dbEntity.getId());
                if (params.size() <= 0) continue;
                for (AutoFormParamEntity entity : params) {
                    if (paramList.contains(entity.getParamName())) continue;
                    paramList.add(entity.getParamName());
                }
                continue;
            }
            if (!"table".equals(dbEntity.getDbType())) continue;
            paramList.add("id");
        }
        return paramList;
    }

    @RequestMapping(params={"viewContent"})
    public ModelAndView viewContent(AutoFormEntity autoForm, HttpServletRequest req) {
        String message = "";
        try {
            Map tem = req.getParameterMap();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (String key : tem.keySet()) {
                paramMap.put(key, tem.get(key));
            }
            String op = req.getParameter("op");
            if (StringUtil.isEmpty((String)op)) {
                op = AutoFormTemplateParseUtil.OP_VIEW;
            }
            HashMap<String, List<Map<String, Object>>> paras = new HashMap();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)autoForm.getFormName())) {
                if ((autoForm = (AutoFormEntity)this.systemService.findUniqueByProperty(AutoFormEntity.class, "formName", (Object)autoForm.getFormName())) == null) {
                    return new ModelAndView("jeecg/cgform/autoform/autoForm-error").addObject("message", (Object)"\u8868\u5355\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
                }
            } else {
                return new ModelAndView("jeecg/cgform/autoform/autoForm-error").addObject("message", (Object)"formName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<String> paramList = this.getFormParams(autoForm.getId());
            if (paramList != null && paramList.size() > 0) {
                for (String param : paramList) {
                    String paramValue = req.getParameter(param);
                    if (paramValue != null) continue;
                    return new ModelAndView("jeecg/cgform/autoform/autoForm-error").addObject("message", (Object)("\u7f3a\u5c11\u8868\u5355\u53c2\u6570\uff1a" + param));
                }
            }
            req.setAttribute("formName", (Object)autoForm.getFormName());
            req.setAttribute("param", paramMap);
            String ftlContent = autoForm.getFormParse();
            if (AutoFormTemplateParseUtil.OP_VIEW.equals(op)) {
                paras = this.getFormData(autoForm, paramMap);
                ftlContent = AutoFormTemplateParseUtil.parseHtmlForView(ftlContent, paras);
            } else {
                if (AutoFormTemplateParseUtil.OP_ADD.equals(op)) {
                    ftlContent = AutoFormTemplateParseUtil.parseHtmlForAdd(ftlContent, paras);
                    req.setAttribute("formContent", (Object)ftlContent);
                    req.setAttribute("op", (Object)op);
                    return new ModelAndView("jeecg/cgform/autoform/autoForm-review-add");
                }
                if (AutoFormTemplateParseUtil.OP_UPDATE.equals(op)) {
                    paras = this.getFormData(autoForm, paramMap);
                    String id = req.getParameter("id");
                    if (StringUtil.isEmpty((String)id)) {
                        throw new BusinessException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    ftlContent = AutoFormTemplateParseUtil.parseHtmlForUpdate(ftlContent, paras);
                    req.setAttribute("formContent", (Object)ftlContent);
                    req.setAttribute("op", (Object)op);
                    return new ModelAndView("jeecg/cgform/autoform/autoForm-review-update");
                }
                if (AutoFormTemplateParseUtil.OP_ADD_OR_UPDATE.equals(op)) {
                    paras = this.getFormData(autoForm, paramMap);
                    ftlContent = AutoFormTemplateParseUtil.parseHtmlForAddOrUpdate(ftlContent, paras);
                    req.setAttribute("formContent", (Object)ftlContent);
                    req.setAttribute("op", (Object)op);
                    return new ModelAndView("jeecg/cgform/autoform/autoForm-review-addorupdate");
                }
            }
            req.setAttribute("formContent", (Object)ftlContent);
            req.setAttribute("op", (Object)op);
            return new ModelAndView("jeecg/cgform/autoform/autoForm-review");
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5355\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage();
            return new ModelAndView("jeecg/cgform/autoform/autoForm-error").addObject("message", (Object)message);
        }
    }

    private Map<String, List<Map<String, Object>>> getFormData(AutoFormEntity autoForm, Map<String, Object> paramMap) {
        String message = "";
        HashMap<String, List<Map<String, Object>>> paras = new HashMap<String, List<Map<String, Object>>>();
        List formDbList = this.systemService.findByProperty(AutoFormDbEntity.class, "autoFormId", (Object)autoForm.getId());
        for (AutoFormDbEntity formDb : formDbList) {
            Object value;
            List data = new ArrayList();
            List<Map<String, Object>> typeList = this.getColumnTypes(formDb.getTbDbTableName(), formDb.getDbKey());
            if ("table".equals(formDb.getDbType())) {
                String hqlField = "from AutoFormDbFieldEntity where 1 = 1 AND aUTO_FORM_DB_ID = ? ";
                try {
                    List autoFormDbFieldEntityList = this.systemService.findHql(hqlField, new Object[]{formDb.getId()});
                    if (autoFormDbFieldEntityList.size() > 0) {
                        StringBuffer hqlTable = new StringBuffer().append("select ");
                        for (AutoFormDbFieldEntity autoFormDbFieldEntity : autoFormDbFieldEntityList) {
                            boolean flag = false;
                            for (Map<String, Object> typeMap : typeList) {
                                String dataType = typeMap.get("dataType").toString().toUpperCase();
                                String columnNm = typeMap.get("columnNm").toString().toUpperCase();
                                if (!dataType.contains("BLOB") || !columnNm.equals(autoFormDbFieldEntity.getFieldName().toUpperCase())) continue;
                                hqlTable.append("CONVERT(GROUP_CONCAT(" + autoFormDbFieldEntity.getFieldName() + ") USING utf8) as " + autoFormDbFieldEntity.getFieldName() + ",");
                                flag = true;
                            }
                            if (flag) continue;
                            hqlTable.append(String.valueOf(autoFormDbFieldEntity.getFieldName()) + ",");
                        }
                        hqlTable.deleteCharAt(hqlTable.length() - 1).append(" from " + formDb.getDbTableName());
                        String id = "";
                        value = paramMap.get("id");
                        if (value instanceof String[]) {
                            String[] paramValue = (String[])value;
                            id = paramValue[0];
                        } else {
                            id = value.toString();
                        }
                        hqlTable.append(" where ID ='").append(id).append("'");
                        if ("".equals(formDb.getDbKey())) {
                            data = this.systemService.findForJdbc(hqlTable.toString(), new Object[0]);
                        } else {
                            DynamicDataSourceEntity dynamicDataSourceEntity = this.dynamicDataSourceServiceI.getDynamicDataSourceEntityForDbKey(formDb.getDbKey());
                            if (dynamicDataSourceEntity != null) {
                                data = DynamicDBUtil.findList((String)formDb.getDbKey(), (String)hqlTable.toString(), (Object[])new Object[0]);
                            }
                        }
                    } else {
                        message = "\u8868\u5c5e\u6027\u914d\u7f6e\u6709\u8bef\uff01";
                        throw new BusinessException(message);
                    }
                    paras.put(formDb.getDbName(), data);
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
                continue;
            }
            if (!"sql".equals(formDb.getDbType())) continue;
            String dbDynSql = formDb.getDbDynSql();
            List<String> params = this.autoFormDbService.getSqlParams(dbDynSql);
            for (String param : params) {
                Object paramValue;
                value = paramMap.get(param);
                if (value instanceof String[]) {
                    paramValue = (String[])value;
                    dbDynSql = dbDynSql.replaceAll("\\$\\{" + param + "\\}", paramValue[0]);
                    continue;
                }
                paramValue = value.toString();
                dbDynSql = dbDynSql.replaceAll("\\$\\{" + param + "\\}", (String)paramValue);
            }
            if (dbDynSql.contains("\\$")) {
                message = "\u52a8\u6001SQL\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01";
                throw new BusinessException(message);
            }
            try {
                data = this.systemService.findForJdbc(dbDynSql, new Object[0]);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                message = "\u52a8\u6001SQL\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01";
                throw new BusinessException(message);
            }
            paras.put(formDb.getDbName(), this.formatData(typeList, data));
        }
        return paras;
    }

    private List<Map<String, Object>> getColumnTypes(String dbTableNm, String dbkey) {
        List list = new ArrayList();
        String sql = "select  DATA_TYPE as dataType,COLUMN_NAME as columnNm from information_schema.COLUMNS where TABLE_NAME='" + dbTableNm + "'";
        list = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbkey) ? DynamicDBUtil.findList((String)dbkey, (String)sql, (Object[])new Object[0]) : this.systemService.findForJdbc(sql, new Object[0]);
        return list;
    }

    private List<Map<String, Object>> formatData(List<Map<String, Object>> typeList, List<Map<String, Object>> data) {
        for (Map<String, Object> hashmap : data) {
            Map.Entry<String, Object> entry2 = null;
            for (Map.Entry<String, Object> entry2 : hashmap.entrySet()) {
                for (Map<String, Object> typeMap : typeList) {
                    String dataType = typeMap.get("dataType").toString().toUpperCase();
                    String columnNm = typeMap.get("columnNm").toString().toUpperCase();
                    if (!dataType.contains("BLOB") || !columnNm.equals(entry2.getKey().toString().toUpperCase())) continue;
                    try {
                        String srt2 = new String((byte[])entry2.getValue(), "UTF-8");
                        hashmap.put(entry2.getKey().toString(), srt2);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return data;
    }

    @RequestMapping(params={"review"})
    public ModelAndView review(AutoFormEntity autoForm, HttpServletRequest req) {
        TemplateUtil tool = new TemplateUtil();
        Map<String, Object> map = tool.processor(autoForm.getFormContent());
        req.setAttribute("formContent", map.get("parseHtml"));
        return new ModelAndView("jeecg/cgform/autoform/autoForm-review");
    }

    @ResponseBody
    @RequestMapping(params={"getFormDb"})
    public AjaxJson getFormDb(AutoFormDbEntity dbForm, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String message = "";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getAutoFormId())) {
            List dbFormList = this.systemService.findByProperty(AutoFormDbEntity.class, "autoFormId", (Object)dbForm.getAutoFormId());
            if (dbFormList.size() > 0) {
                message = "<option value='' selected='selected'>\u8bf7\u9009\u62e9\u6570\u636e\u6e90</option>";
                for (AutoFormDbEntity entity : dbFormList) {
                    message = String.valueOf(message) + "<option value='" + entity.getDbName() + "'>" + (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getDbChName()) ? entity.getDbName() : entity.getDbChName()) + "</option>";
                }
                j.setSuccess(true);
                j.setMsg(message);
            } else {
                j.setSuccess(false);
                message = "<option value='' selected='selected'>\u8bf7\u5148\u6dfb\u52a0\u6570\u636e\u6e90</option>";
                j.setMsg(message);
            }
        } else {
            j.setSuccess(false);
            message = "<option  value='' selected='selected'>\u8bf7\u5148\u6dfb\u52a0\u6570\u636e\u6e90</option>";
            j.setMsg(message);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(params={"getFormField"})
    public AjaxJson getFormField(AutoFormDbEntity dbForm, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String message = "";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getDbName()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getAutoFormId())) {
            String hqlList = "from AutoFormDbEntity t where t.dbName = ? and autoFormId = ?";
            List list = this.systemService.findHql(hqlList, new Object[]{dbForm.getDbName(), dbForm.getAutoFormId()});
            if (list.size() == 1) {
                String string;
                dbForm = (AutoFormDbEntity)list.get(0);
                List columns = new ArrayList();
                if ("table".equals(dbForm.getDbType())) {
                    String string2 = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?";
                    columns = this.systemService.findHql(string2, new Object[]{dbForm.getId()});
                } else if ("sql".equals(dbForm.getDbType()) && (columns = this.systemService.findHql(string = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?", new Object[]{dbForm.getId()})).size() == 0) {
                    List<String> fileds = this.autoFormDbService.getSqlFields(dbForm.getDbDynSql());
                    for (String filed : fileds) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("fieldName", filed);
                        columns.add(map);
                    }
                }
                if (columns.size() > 0) {
                    message = "<option value='' selected='selected'>\u8bf7\u9009\u62e9\u5b57\u6bb5</option>";
                    for (Map map : columns) {
                        message = String.valueOf(message) + "<option value='" + map.get("fieldName") + "'>" + (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)map.get("fieldText"))) ? map.get("fieldName") : map.get("fieldText")) + "</option>";
                    }
                    j.setSuccess(true);
                    j.setMsg(message);
                } else {
                    j.setSuccess(false);
                    message = "<option value='' selected='selected'>\u8bf7\u5148\u6dfb\u52a0\u5b57\u6bb5</option>";
                    j.setMsg(message);
                }
            } else {
                j.setSuccess(false);
                message = "<option value='' selected='selected'>\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90</option>";
                j.setMsg(message);
            }
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(params={"getTrList"})
    public AjaxJson getTrList(AutoFormDbEntity dbForm, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String message = "";
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getDbName()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getAutoFormId())) {
            String hqlList = "from AutoFormDbEntity t where t.dbName = ? and autoFormId = ?";
            List list = this.systemService.findHql(hqlList, new Object[]{dbForm.getDbName(), dbForm.getAutoFormId()});
            if (list.size() == 1) {
                String hql;
                dbForm = (AutoFormDbEntity)list.get(0);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbForm.getDbChName())) {
                    attributes.put("dbName", dbForm.getDbChName());
                } else {
                    attributes.put("dbName", dbForm.getDbName());
                }
                List columns = new ArrayList();
                if ("table".equals(dbForm.getDbType())) {
                    hql = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?";
                    columns = this.systemService.findHql(hql, new Object[]{dbForm.getId()});
                } else if ("sql".equals(dbForm.getDbType()) && (columns = this.systemService.findHql(hql = "select new Map(t.fieldName as fieldName,t.fieldText as fieldText) from AutoFormDbFieldEntity t where t.autoFormDbId=?", new Object[]{dbForm.getId()})).size() == 0) {
                    List<String> fileds = this.autoFormDbService.getSqlFields(dbForm.getDbDynSql());
                    for (String filed : fileds) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("fieldName", filed);
                        columns.add(map);
                    }
                }
                StringBuilder options = null;
                StringBuilder trList = new StringBuilder();
                String headStr = "";
                String columnFiledNm = "";
                String optionFiledNm = "";
                String columnFiledTx = "";
                if (columns.size() > 0) {
                    StringBuffer datatypeList = new StringBuffer();
                    datatypeList.append("<option value=\"\" selected>\u65e0</option>");
                    List typeList = this.systemService.findByProperty(TSType.class, "TSTypegroup.id", (Object)"4028838850c35b6a0150c37251e00002");
                    for (TSType type : typeList) {
                        datatypeList.append("<option value=\"" + type.getTypecode() + "\">" + type.getTypename() + "</option>");
                    }
                    StringBuffer unitOptions = new StringBuffer();
                    unitOptions.append("<option value=\"#\" selected>\u65e0</option>");
                    List unitList = this.systemService.findByProperty(TSType.class, "TSTypegroup.id", (Object)"4028ab8c5134f1ed0151350f08d90003");
                    for (TSType type : unitList) {
                        unitOptions.append("<option value=\"" + type.getTypecode() + "\">" + type.getTypename() + "</option>");
                    }
                    int i = 0;
                    while (i < columns.size()) {
                        Map columnMap = (Map)columns.get(i);
                        columnFiledNm = columnMap.get("fieldName").toString();
                        columnFiledTx = columnMap.get("fieldText") == null ? "" : columnMap.get("fieldText").toString();
                        headStr = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)columnFiledTx) ? columnMap.get("fieldText").toString() : columnFiledNm;
                        options = new StringBuilder();
                        int m = 0;
                        while (m < columns.size()) {
                            Map map = (Map)columns.get(m);
                            optionFiledNm = map.get("fieldName").toString();
                            if (optionFiledNm.equals(columnFiledNm)) {
                                options.append("<option value=\"" + map.get("fieldName") + "\" selected>" + map.get("fieldName") + "</option>");
                            } else {
                                options.append("<option value=\"" + map.get("fieldName") + "\">" + map.get("fieldName") + "</option>");
                            }
                            ++m;
                        }
                        if ("ID".equals(columnFiledNm.toUpperCase())) {
                            trList.append("<tr>");
                            trList.append("<td><span class='badge'>" + (i + 1) + "</span></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><input id='item_" + (i + 1) + "' type='text' class='input-mini' value='" + headStr + "' style=\"width: 90%\" disabled></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'>");
                            trList.append("<select id='coltype_" + (i + 1) + "' class='input-medium' style=\"width: 100%\" disabled>");
                            trList.append("<option value='text'>\u5355\u884c\u8f93\u5165\u6846</option>");
                            trList.append("<option value='textarea'>\u591a\u884c\u8f93\u5165\u6846</option>");
                            trList.append("<option value='radio'>\u5355\u9009\u6309\u94ae</option>");
                            trList.append("<option value='select'>\u4e0b\u62c9\u6846</option>");
                            trList.append("<option value='checkbox'>\u590d\u9009\u6846</option>");
                            trList.append("<option value='popup'>popup\u63a7\u4ef6</option>");
                            trList.append("</select>");
                            trList.append("</td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><select id='field_" + (i + 1) + "' class=\"input-medium\"  onchange=\"changeValue(this.id,this.value,'" + dbForm.getId() + "')\" style=\"width: 100%\" disabled>");
                            trList.append((CharSequence)options);
                            trList.append("</select></label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><input type='text' style=\"width:40px\" id='length_" + (i + 1) + "' value='157' disabled><span style='font-size:18px;'>px</span> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'>");
                            trList.append("<select id='unit_" + (i + 1) + "' class='input-medium' style=\"width: 100%\" disabled>");
                            trList.append(unitOptions);
                            trList.append("</select>");
                            trList.append("</td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><input type='text' class='input-mini' id='dict_" + (i + 1) + "' value='' disabled> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label> <input type='checkbox' id='sum_" + (i + 1) + "' class='csum' value='3' disabled> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><input id='colvalue_" + (i + 1) + "'  type='text' class='input-mini' value='' disabled></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><select id='ruletype_" + (i + 1) + "' class='input-medium' style=\"width: 100%\" disabled>" + datatypeList.toString() + "</select></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><label> <input type=\"checkbox\" id='isHide_" + (i + 1) + "' value=\"1\"");
                            trList.append("checked=\"checked\"");
                            trList.append(" disabled> </label> </td>");
                            trList.append("<td></td>");
                            trList.append("</tr>");
                        } else {
                            trList.append("<tr>");
                            trList.append("<td><span class='badge'>" + (i + 1) + "</span></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><input id='item_" + (i + 1) + "' type='text' class='input-mini' value='" + headStr + "' style=\"width: 90%\"></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'>");
                            trList.append("<select id='coltype_" + (i + 1) + "' class='input-medium' style=\"width: 100%\">");
                            trList.append("<option value='text'>\u5355\u884c\u8f93\u5165\u6846</option>");
                            trList.append("<option value='textarea'>\u591a\u884c\u8f93\u5165\u6846</option>");
                            trList.append("<option value='radio'>\u5355\u9009\u6309\u94ae</option>");
                            trList.append("<option value='select'>\u4e0b\u62c9\u6846</option>");
                            trList.append("<option value='checkbox'>\u590d\u9009\u6846</option>");
                            trList.append("<option value='popup'>popup\u63a7\u4ef6</option>");
                            trList.append("</select>");
                            trList.append("</td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><select id='field_" + (i + 1) + "' class=\"input-medium\"  onchange=\"changeValue(this.id,this.value,'" + dbForm.getId() + "')\" style=\"width: 100%\">");
                            trList.append((CharSequence)options);
                            trList.append("</select></label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><input type='text' style=\"width:40px\" id='length_" + (i + 1) + "' value='157'><span style='font-size:18px;'>px</span> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'>");
                            trList.append("<select id='unit_" + (i + 1) + "' class='input-medium' style=\"width: 100%\">");
                            trList.append(unitOptions);
                            trList.append("</select>");
                            trList.append("</td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label><input type='text' class='input-mini' id='dict_" + (i + 1) + "' value=''> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'> <label> <input type='checkbox' id='sum_" + (i + 1) + "' class='csum' value='3'> </label> </td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><input id='colvalue_" + (i + 1) + "'  type='text' class='input-mini' value=''/></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><select id='ruletype_" + (i + 1) + "' class='input-medium' style=\"width: 100%\">" + datatypeList.toString() + "</select></td>");
                            trList.append("<td title='Tab\u952e\u5207\u6362\u8f93\u5165\u6846'><label> <input type=\"checkbox\" id='isHide_" + (i + 1) + "' value=\"1\"");
                            trList.append("> </label> </td>");
                            trList.append("<td><button class='btn btn-small btn-success delrow' type='button'>\u5220\u9664</button></td>");
                            trList.append("</tr>");
                        }
                        ++i;
                    }
                    trList.append("<script type=\"text/javascript\">");
                    trList.append("function changeValue(id,value,dbFormId){");
                    trList.append(" var index = id.split('_')[1];");
                    trList.append("$.post(");
                    trList.append("'autoFormController.do?getHead',");
                    trList.append("{column:value,autoFormId:dbFormId},");
                    trList.append("function(data){");
                    trList.append("var d = $.parseJSON(data);");
                    trList.append("if(d.success){");
                    trList.append("if(value == 'ID' || value == 'id'){$('#isHide_'+(index)).attr('checked',true);}");
                    trList.append("if(d.msg == null || d.msg == ''){");
                    trList.append("$('#item_'+(index)).val(index);");
                    trList.append("}else{");
                    trList.append("$('#item_'+(index)).val(d.msg);");
                    trList.append("}}");
                    trList.append("});");
                    trList.append("}");
                    trList.append("$(function(){");
                    trList.append("$(\".delrow\").live(\"click\",function(){$(this).parent().parent().remove();resetTrNum();});");
                    trList.append("});");
                    trList.append("</script>");
                    message = String.valueOf(message) + trList.toString();
                } else {
                    message = "<option value=\"\">\u65e0\u5b57\u6bb5</option>";
                }
                j.setSuccess(true);
                attributes.put("tableHtml", message);
                j.setAttributes(attributes);
            } else {
                j.setSuccess(true);
                attributes.put("dbName", "");
                attributes.put("tableHtml", "");
            }
        } else {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"getHead"})
    @ResponseBody
    public AjaxJson getHead(String column, String autoFormId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        try {
            AutoFormDbFieldEntity entry;
            String hqlList = "from AutoFormDbFieldEntity t where t.fieldName = ? and t.autoFormDbId = ?";
            List list = this.systemService.findHql(hqlList, new Object[]{column, autoFormId});
            if (list.size() > 0 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(entry = (AutoFormDbFieldEntity)list.get(0)).getFieldText())) {
                message = entry.getFieldText();
            }
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u8868\u5934\u83b7\u53d6\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"addForm"})
    @ResponseBody
    public AjaxJson addForm(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "";
        try {
            Map paramData = request.getParameterMap();
            String formName = request.getParameter("formName");
            if (paramData != null) {
                Map<String, Map<String, Object>> dataMap = AutoFormCommUtil.mapConvert(paramData);
                Map<String, Object> param = dataMap.get("param");
                AutoFormEntity autoForm = (AutoFormEntity)this.systemService.findUniqueByProperty(AutoFormEntity.class, "formName", (Object)formName);
                HashMap<String, List<Map<String, Object>>> oldDataMap = new HashMap();
                oldDataMap = this.getFormData(autoForm, param);
                String id = this.autoFormService.doUpdateTable(formName, dataMap, oldDataMap);
                j.setObj((Object)id);
                message = "\u8868\u5355\u6dfb\u52a0\u6210\u529f";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u8868\u5355\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage();
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"updateForm"})
    @ResponseBody
    public AjaxJson updateForm(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8868\u5355\u66f4\u65b0\u6210\u529f";
        try {
            Map paramData = request.getParameterMap();
            String formName = request.getParameter("formName");
            if (paramData != null) {
                Map<String, Map<String, Object>> dataMap = AutoFormCommUtil.mapConvert(paramData);
                Map<String, Object> param = dataMap.get("param");
                AutoFormEntity autoForm = (AutoFormEntity)this.systemService.findUniqueByProperty(AutoFormEntity.class, "formName", (Object)formName);
                HashMap<String, List<Map<String, Object>>> oldDataMap = new HashMap();
                oldDataMap = this.getFormData(autoForm, param);
                this.autoFormService.doUpdateTable(formName, dataMap, oldDataMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u8868\u5355\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage();
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"addorupdateForm"})
    @ResponseBody
    public AjaxJson addorupdateForm(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u8868\u5355\u4fdd\u5b58\u6210\u529f";
        try {
            Map paramData = request.getParameterMap();
            String formName = request.getParameter("formName");
            if (paramData != null) {
                Map<String, Map<String, Object>> dataMap = AutoFormCommUtil.mapConvert(paramData);
                Map<String, Object> param = dataMap.get("param");
                AutoFormEntity autoForm = (AutoFormEntity)this.systemService.findUniqueByProperty(AutoFormEntity.class, "formName", (Object)formName);
                HashMap<String, List<Map<String, Object>>> oldDataMap = new HashMap();
                oldDataMap = this.getFormData(autoForm, param);
                this.autoFormService.doUpdateTable(formName, dataMap, oldDataMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u8868\u5355\u4fdd\u5b58\u5931\u8d25";
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"checkTbCode"})
    @ResponseBody
    public com.alibaba.fastjson.JSONObject checkTbCode(String param, String cVal) {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        if (StringUtils.isNotBlank((String)cVal) && cVal.equals(param)) {
            jsonObject.put("info", (Object)"\u9a8c\u8bc1\u901a\u8fc7\uff01");
            jsonObject.put("status", (Object)"y");
            return jsonObject;
        }
        List list = new ArrayList();
        String hql = "from AutoFormEntity t where t.formName = ?";
        list = this.systemService.findHql(hql, new Object[]{param});
        if (list.size() > 0) {
            jsonObject.put("status", (Object)"n");
            jsonObject.put("info", (Object)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            return jsonObject;
        }
        jsonObject.put("info", (Object)"\u9a8c\u8bc1\u901a\u8fc7\uff01");
        jsonObject.put("status", (Object)"y");
        return jsonObject;
    }

    private void delFormDb(String autoFormId) {
        List list = this.systemService.findByProperty(AutoFormDbEntity.class, "autoFormId", (Object)autoFormId);
        if (list != null && list.size() > 0) {
            for (AutoFormDbEntity dbForm : list) {
                this.systemService.updateBySqlString("delete from auto_form_db_field where auto_form_db_id='" + dbForm.getId() + "'");
                this.systemService.delete((Object)dbForm);
            }
        }
    }
}

