/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.SlowEvent;
import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InetUtils.class);
    private static String selfIP;
    private static boolean useOnlySiteLocalInterface;
    private static boolean preferHostnameOverIP;
    private static final List<String> PREFERRED_NETWORKS;
    private static final List<String> IGNORED_INTERFACES;

    public static String getSelfIP() {
        return selfIP;
    }

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                LOG.debug("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                if (InetUtils.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    boolean isLegalIpVersion = IPUtil.PREFER_IPV6_ADDRESSES ? address instanceof Inet6Address : address instanceof Inet4Address;
                    if (!isLegalIpVersion || address.isLoopbackAddress() || !InetUtils.isPreferredAddress(address)) continue;
                    LOG.debug("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to retrieve localhost");
            return null;
        }
    }

    private static boolean isPreferredAddress(InetAddress address) {
        if (useOnlySiteLocalInterface) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress) {
                LOG.debug("Ignoring address: " + address.getHostAddress());
            }
            return siteLocalAddress;
        }
        if (PREFERRED_NETWORKS.isEmpty()) {
            return true;
        }
        for (String regex : PREFERRED_NETWORKS) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        return false;
    }

    private static boolean ignoreInterface(String interfaceName) {
        for (String regex : IGNORED_INTERFACES) {
            if (!interfaceName.matches(regex)) continue;
            LOG.debug("Ignoring interface: " + interfaceName);
            return true;
        }
        return false;
    }

    public static boolean isDomain(String str) {
        InetSocketAddress address = new InetSocketAddress(str, 0);
        boolean unResolved = address.isUnresolved();
        if (unResolved) {
            LOG.warn("the domain: '" + str + "' can not be resolved");
        }
        return !unResolved;
    }

    static {
        useOnlySiteLocalInterface = false;
        preferHostnameOverIP = false;
        PREFERRED_NETWORKS = new ArrayList<String>();
        IGNORED_INTERFACES = new ArrayList<String>();
        NotifyCenter.registerToSharePublisher(IPChangeEvent.class);
        useOnlySiteLocalInterface = Boolean.parseBoolean(EnvUtil.getProperty("nacos.inetutils.use-only-site-local-interfaces"));
        List<String> networks = EnvUtil.getPropertyList("nacos.inetutils.preferred-networks");
        PREFERRED_NETWORKS.addAll(networks);
        List<String> interfaces = EnvUtil.getPropertyList("nacos.inetutils.ignored-interfaces");
        IGNORED_INTERFACES.addAll(interfaces);
        long delayMs = Long.getLong("nacos.core.inet.auto-refresh", 30000L);
        Runnable ipAutoRefresh = new Runnable(){

            @Override
            public void run() {
                String tmpSelfIP;
                block11: {
                    String nacosIP = System.getProperty("nacos.server.ip");
                    if (StringUtils.isBlank((CharSequence)nacosIP)) {
                        nacosIP = EnvUtil.getProperty("nacos.inetutils.ip-address");
                    }
                    if (!(StringUtils.isBlank((CharSequence)nacosIP) || IPUtil.isIP((String)nacosIP) || InetUtils.isDomain(nacosIP))) {
                        throw new RuntimeException("nacos address " + nacosIP + " is not ip");
                    }
                    tmpSelfIP = nacosIP;
                    if (StringUtils.isBlank((CharSequence)tmpSelfIP)) {
                        preferHostnameOverIP = Boolean.getBoolean("nacos.preferHostnameOverIp");
                        if (!preferHostnameOverIP) {
                            preferHostnameOverIP = Boolean.parseBoolean(EnvUtil.getProperty("nacos.inetutils.prefer-hostname-over-ip"));
                        }
                        if (preferHostnameOverIP) {
                            try {
                                InetAddress inetAddress = InetAddress.getLocalHost();
                                if (inetAddress.getHostName().equals(inetAddress.getCanonicalHostName())) {
                                    tmpSelfIP = inetAddress.getHostName();
                                    break block11;
                                }
                                tmpSelfIP = inetAddress.getCanonicalHostName();
                            }
                            catch (UnknownHostException ignore) {
                                LOG.warn("Unable to retrieve localhost");
                            }
                        } else {
                            tmpSelfIP = Objects.requireNonNull(InetUtils.findFirstNonLoopbackAddress()).getHostAddress();
                        }
                    }
                }
                if (IPUtil.PREFER_IPV6_ADDRESSES && !tmpSelfIP.startsWith("[") && !tmpSelfIP.endsWith("]") && StringUtils.contains((CharSequence)(tmpSelfIP = "[" + tmpSelfIP + "]"), (CharSequence)"%")) {
                    tmpSelfIP = tmpSelfIP.substring(0, tmpSelfIP.indexOf("%")) + "]";
                }
                if (!Objects.equals(selfIP, tmpSelfIP) && Objects.nonNull(selfIP)) {
                    IPChangeEvent event = new IPChangeEvent();
                    event.setOldIP(selfIP);
                    event.setNewIP(tmpSelfIP);
                    NotifyCenter.publishEvent((Event)event);
                }
                selfIP = tmpSelfIP;
            }
        };
        ipAutoRefresh.run();
    }

    public static class IPChangeEvent
    extends SlowEvent {
        private String oldIP;
        private String newIP;

        public String getOldIP() {
            return this.oldIP;
        }

        public void setOldIP(String oldIP) {
            this.oldIP = oldIP;
        }

        public String getNewIP() {
            return this.newIP;
        }

        public void setNewIP(String newIP) {
            this.newIP = newIP;
        }

        public String toString() {
            return "IPChangeEvent{oldIP='" + this.oldIP + '\'' + ", newIP='" + this.newIP + '\'' + '}';
        }
    }
}

