/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateHolder;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/server"})
public class ServerStateController {
    private static final String ANNOUNCEMENT_FILE = "announcement.conf";

    @GetMapping(value={"/state"})
    public ResponseEntity<Map<String, String>> serverState() {
        HashMap serverState = new HashMap(4);
        for (ModuleState each : ModuleStateHolder.getInstance().getAllModuleStates()) {
            each.getStates().forEach((s, o) -> serverState.put(s, null == o ? null : o.toString()));
        }
        return ResponseEntity.ok().body(serverState);
    }

    @GetMapping(value={"/announcement"})
    public RestResult<String> getAnnouncement() {
        File announcementFile = new File(EnvUtil.getConfPath(), ANNOUNCEMENT_FILE);
        String announcement = null;
        if (announcementFile.exists() && announcementFile.isFile()) {
            announcement = DiskUtils.readFile((File)announcementFile);
        }
        return RestResultUtils.success(announcement);
    }
}

