/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.model.event.LocalDataChangeEvent;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class LongPollingService {
    private static final int FIXED_POLLING_INTERVAL_MS = 10000;
    private static final int SAMPLE_PERIOD = 100;
    private static final int SAMPLE_TIMES = 3;
    private static final String TRUE_STR = "true";
    private Map<String, Long> retainIps = new ConcurrentHashMap<String, Long>();
    public static final String LONG_POLLING_HEADER = "Long-Pulling-Timeout";
    public static final String LONG_POLLING_NO_HANG_UP_HEADER = "Long-Pulling-Timeout-No-Hangup";
    final Queue<ClientLongPolling> allSubs = new ConcurrentLinkedQueue<ClientLongPolling>();

    private static boolean isFixedPolling() {
        return SwitchService.getSwitchBoolean("isFixedPolling", false);
    }

    private static int getFixedPollingInterval() {
        return SwitchService.getSwitchInteger("fixedPollingInertval", 10000);
    }

    public boolean isClientLongPolling(String clientIp) {
        return this.getClientPollingRecord(clientIp) != null;
    }

    public Map<String, String> getClientSubConfigInfo(String clientIp) {
        ClientLongPolling record = this.getClientPollingRecord(clientIp);
        if (record == null) {
            return Collections.emptyMap();
        }
        return record.clientMd5Map;
    }

    public SampleResult getSubscribleInfo(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        SampleResult sampleResult = new SampleResult();
        HashMap<String, String> lisentersGroupkeyStatus = new HashMap<String, String>(50);
        for (ClientLongPolling clientLongPolling : this.allSubs) {
            if (!clientLongPolling.clientMd5Map.containsKey(groupKey)) continue;
            lisentersGroupkeyStatus.put(clientLongPolling.ip, clientLongPolling.clientMd5Map.get(groupKey));
        }
        sampleResult.setLisentersGroupkeyStatus(lisentersGroupkeyStatus);
        return sampleResult;
    }

    public SampleResult getSubscribleInfoByIp(String clientIp) {
        SampleResult sampleResult = new SampleResult();
        HashMap<String, String> lisentersGroupkeyStatus = new HashMap<String, String>(50);
        for (ClientLongPolling clientLongPolling : this.allSubs) {
            if (!clientLongPolling.ip.equals(clientIp) || lisentersGroupkeyStatus.equals(clientLongPolling.clientMd5Map)) continue;
            lisentersGroupkeyStatus.putAll(clientLongPolling.clientMd5Map);
        }
        sampleResult.setLisentersGroupkeyStatus(lisentersGroupkeyStatus);
        return sampleResult;
    }

    public SampleResult mergeSampleResult(List<SampleResult> sampleResults) {
        SampleResult mergeResult = new SampleResult();
        HashMap<String, String> lisentersGroupkeyStatus = new HashMap<String, String>(50);
        for (SampleResult sampleResult : sampleResults) {
            Map<String, String> lisentersGroupkeyStatusTmp = sampleResult.getLisentersGroupkeyStatus();
            for (Map.Entry<String, String> entry : lisentersGroupkeyStatusTmp.entrySet()) {
                lisentersGroupkeyStatus.put(entry.getKey(), entry.getValue());
            }
        }
        mergeResult.setLisentersGroupkeyStatus(lisentersGroupkeyStatus);
        return mergeResult;
    }

    public Map<String, Set<String>> collectApplicationSubscribeConfigInfos() {
        if (this.allSubs == null || this.allSubs.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> app2Groupkeys = new HashMap<String, Set<String>>(50);
        for (ClientLongPolling clientLongPolling : this.allSubs) {
            if (StringUtils.isEmpty((String)clientLongPolling.appName) || "unknown".equalsIgnoreCase(clientLongPolling.appName)) continue;
            Set<String> appSubscribeConfigs = app2Groupkeys.get(clientLongPolling.appName);
            Set<String> clientSubscribeConfigs = clientLongPolling.clientMd5Map.keySet();
            if (appSubscribeConfigs == null) {
                appSubscribeConfigs = new HashSet<String>(clientSubscribeConfigs.size());
            }
            appSubscribeConfigs.addAll(clientSubscribeConfigs);
            app2Groupkeys.put(clientLongPolling.appName, appSubscribeConfigs);
        }
        return app2Groupkeys;
    }

    public SampleResult getCollectSubscribleInfo(String dataId, String group, String tenant) {
        ArrayList<SampleResult> sampleResultLst = new ArrayList<SampleResult>(50);
        for (int i = 0; i < 3; ++i) {
            SampleResult sampleTmp = this.getSubscribleInfo(dataId, group, tenant);
            if (sampleTmp != null) {
                sampleResultLst.add(sampleTmp);
            }
            if (i >= 2) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LogUtil.CLIENT_LOG.error("sleep wrong", (Throwable)e);
            }
        }
        return this.mergeSampleResult(sampleResultLst);
    }

    public SampleResult getCollectSubscribleInfoByIp(String ip) {
        SampleResult sampleResult = new SampleResult();
        sampleResult.setLisentersGroupkeyStatus(new HashMap<String, String>(50));
        for (int i = 0; i < 3; ++i) {
            SampleResult sampleTmp = this.getSubscribleInfoByIp(ip);
            if (sampleTmp != null && sampleTmp.getLisentersGroupkeyStatus() != null && !sampleResult.getLisentersGroupkeyStatus().equals(sampleTmp.getLisentersGroupkeyStatus())) {
                sampleResult.getLisentersGroupkeyStatus().putAll(sampleTmp.getLisentersGroupkeyStatus());
            }
            if (i >= 2) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LogUtil.CLIENT_LOG.error("sleep wrong", (Throwable)e);
            }
        }
        return sampleResult;
    }

    private ClientLongPolling getClientPollingRecord(String clientIp) {
        if (this.allSubs == null) {
            return null;
        }
        for (ClientLongPolling clientLongPolling : this.allSubs) {
            HttpServletRequest request = (HttpServletRequest)clientLongPolling.asyncContext.getRequest();
            if (!clientIp.equals(RequestUtil.getRemoteIp(request))) continue;
            return clientLongPolling;
        }
        return null;
    }

    public void addLongPollingClient(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> clientMd5Map, int probeRequestSize) {
        String str = req.getHeader(LONG_POLLING_HEADER);
        String noHangUpFlag = req.getHeader(LONG_POLLING_NO_HANG_UP_HEADER);
        String appName = req.getHeader("Client-AppName");
        String tag = req.getHeader("Vipserver-Tag");
        int delayTime = SwitchService.getSwitchInteger("fixedDelayTime", 500);
        long timeout = Math.max(10000L, Long.parseLong(str) - (long)delayTime);
        if (LongPollingService.isFixedPolling()) {
            timeout = Math.max(10000, LongPollingService.getFixedPollingInterval());
        } else {
            long start = System.currentTimeMillis();
            List<String> changedGroups = MD5Util.compareMd5(req, rsp, clientMd5Map);
            if (changedGroups.size() > 0) {
                this.generateResponse(req, rsp, changedGroups);
                LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}", new Object[]{System.currentTimeMillis() - start, "instant", RequestUtil.getRemoteIp(req), "polling", clientMd5Map.size(), probeRequestSize, changedGroups.size()});
                return;
            }
            if (noHangUpFlag != null && noHangUpFlag.equalsIgnoreCase(TRUE_STR)) {
                LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}", new Object[]{System.currentTimeMillis() - start, "nohangup", RequestUtil.getRemoteIp(req), "polling", clientMd5Map.size(), probeRequestSize, changedGroups.size()});
                return;
            }
        }
        String ip = RequestUtil.getRemoteIp(req);
        AsyncContext asyncContext = req.startAsync();
        asyncContext.setTimeout(0L);
        ConfigExecutor.executeLongPolling(new ClientLongPolling(asyncContext, clientMd5Map, ip, probeRequestSize, timeout, appName, tag));
    }

    public static boolean isSupportLongPolling(HttpServletRequest req) {
        return null != req.getHeader(LONG_POLLING_HEADER);
    }

    public LongPollingService() {
        ConfigExecutor.scheduleLongPolling(new StatTask(), 0L, 10L, TimeUnit.SECONDS);
        NotifyCenter.registerToPublisher(LocalDataChangeEvent.class, (int)NotifyCenter.ringBufferSize);
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber(){

            public void onEvent(Event event) {
                if (!LongPollingService.isFixedPolling() && event instanceof LocalDataChangeEvent) {
                    LocalDataChangeEvent evt = (LocalDataChangeEvent)event;
                    ConfigExecutor.executeLongPolling(new DataChangeTask(evt.groupKey, evt.isBeta, evt.betaIps));
                }
            }

            public Class<? extends Event> subscribeType() {
                return LocalDataChangeEvent.class;
            }
        });
    }

    void generateResponse(HttpServletRequest request, HttpServletResponse response, List<String> changedGroups) {
        if (null == changedGroups) {
            return;
        }
        try {
            String respString = MD5Util.compareMd5ResultString(changedGroups);
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-cache,no-store");
            response.setStatus(200);
            response.getWriter().println(respString);
        }
        catch (Exception ex) {
            LogUtil.PULL_LOG.error(ex.toString(), (Throwable)ex);
        }
    }

    public Map<String, Long> getRetainIps() {
        return this.retainIps;
    }

    public void setRetainIps(Map<String, Long> retainIps) {
        this.retainIps = retainIps;
    }

    class ClientLongPolling
    implements Runnable {
        final AsyncContext asyncContext;
        final Map<String, String> clientMd5Map;
        final long createTime;
        final String ip;
        final String appName;
        final String tag;
        final int probeRequestSize;
        final long timeoutTime;
        Future<?> asyncTimeoutFuture;

        @Override
        public void run() {
            this.asyncTimeoutFuture = ConfigExecutor.scheduleLongPolling(new Runnable(){

                @Override
                public void run() {
                    try {
                        LongPollingService.this.getRetainIps().put(ClientLongPolling.this.ip, System.currentTimeMillis());
                        boolean removeFlag = LongPollingService.this.allSubs.remove(ClientLongPolling.this);
                        if (removeFlag) {
                            if (LongPollingService.isFixedPolling()) {
                                LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}", new Object[]{System.currentTimeMillis() - ClientLongPolling.this.createTime, "fix", RequestUtil.getRemoteIp((HttpServletRequest)ClientLongPolling.this.asyncContext.getRequest()), "polling", ClientLongPolling.this.clientMd5Map.size(), ClientLongPolling.this.probeRequestSize});
                                List<String> changedGroups = MD5Util.compareMd5((HttpServletRequest)ClientLongPolling.this.asyncContext.getRequest(), (HttpServletResponse)ClientLongPolling.this.asyncContext.getResponse(), ClientLongPolling.this.clientMd5Map);
                                if (changedGroups.size() > 0) {
                                    ClientLongPolling.this.sendResponse(changedGroups);
                                } else {
                                    ClientLongPolling.this.sendResponse(null);
                                }
                            } else {
                                LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}", new Object[]{System.currentTimeMillis() - ClientLongPolling.this.createTime, "timeout", RequestUtil.getRemoteIp((HttpServletRequest)ClientLongPolling.this.asyncContext.getRequest()), "polling", ClientLongPolling.this.clientMd5Map.size(), ClientLongPolling.this.probeRequestSize});
                                ClientLongPolling.this.sendResponse(null);
                            }
                        } else {
                            LogUtil.DEFAULT_LOG.warn("client subsciber's relations delete fail.");
                        }
                    }
                    catch (Throwable t) {
                        LogUtil.DEFAULT_LOG.error("long polling error:" + t.getMessage(), t.getCause());
                    }
                }
            }, this.timeoutTime, TimeUnit.MILLISECONDS);
            LongPollingService.this.allSubs.add(this);
        }

        void sendResponse(List<String> changedGroups) {
            if (null != this.asyncTimeoutFuture) {
                this.asyncTimeoutFuture.cancel(false);
            }
            this.generateResponse(changedGroups);
        }

        void generateResponse(List<String> changedGroups) {
            if (null == changedGroups) {
                this.asyncContext.complete();
                return;
            }
            HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
            try {
                String respString = MD5Util.compareMd5ResultString(changedGroups);
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Cache-Control", "no-cache,no-store");
                response.setStatus(200);
                response.getWriter().println(respString);
                this.asyncContext.complete();
            }
            catch (Exception ex) {
                LogUtil.PULL_LOG.error(ex.toString(), (Throwable)ex);
                this.asyncContext.complete();
            }
        }

        ClientLongPolling(AsyncContext ac, Map<String, String> clientMd5Map, String ip, int probeRequestSize, long timeoutTime, String appName, String tag) {
            this.asyncContext = ac;
            this.clientMd5Map = clientMd5Map;
            this.probeRequestSize = probeRequestSize;
            this.createTime = System.currentTimeMillis();
            this.ip = ip;
            this.timeoutTime = timeoutTime;
            this.appName = appName;
            this.tag = tag;
        }

        public String toString() {
            return "ClientLongPolling{clientMd5Map=" + this.clientMd5Map + ", createTime=" + this.createTime + ", ip='" + this.ip + '\'' + ", appName='" + this.appName + '\'' + ", tag='" + this.tag + '\'' + ", probeRequestSize=" + this.probeRequestSize + ", timeoutTime=" + this.timeoutTime + '}';
        }
    }

    class StatTask
    implements Runnable {
        StatTask() {
        }

        @Override
        public void run() {
            LogUtil.MEMORY_LOG.info("[long-pulling] client count " + LongPollingService.this.allSubs.size());
            MetricsMonitor.getLongPollingMonitor().set(LongPollingService.this.allSubs.size());
        }
    }

    class DataChangeTask
    implements Runnable {
        final String groupKey;
        final long changeTime = System.currentTimeMillis();
        final boolean isBeta;
        final List<String> betaIps;
        final String tag;

        @Override
        public void run() {
            try {
                ConfigCacheService.getContentBetaMd5(this.groupKey);
                Iterator iter = LongPollingService.this.allSubs.iterator();
                while (iter.hasNext()) {
                    ClientLongPolling clientSub = (ClientLongPolling)iter.next();
                    if (!clientSub.clientMd5Map.containsKey(this.groupKey) || this.isBeta && !CollectionUtils.contains(this.betaIps, (Object)clientSub.ip) || StringUtils.isNotBlank((String)this.tag) && !this.tag.equals(clientSub.tag)) continue;
                    LongPollingService.this.getRetainIps().put(clientSub.ip, System.currentTimeMillis());
                    iter.remove();
                    LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}", new Object[]{System.currentTimeMillis() - this.changeTime, "in-advance", RequestUtil.getRemoteIp((HttpServletRequest)clientSub.asyncContext.getRequest()), "polling", clientSub.clientMd5Map.size(), clientSub.probeRequestSize, this.groupKey});
                    clientSub.sendResponse(Arrays.asList(this.groupKey));
                }
            }
            catch (Throwable t) {
                LogUtil.DEFAULT_LOG.error("data change error: {}", (Object)ExceptionUtil.getStackTrace((Throwable)t));
            }
        }

        DataChangeTask(String groupKey, boolean isBeta, List<String> betaIps) {
            this(groupKey, isBeta, betaIps, null);
        }

        DataChangeTask(String groupKey, boolean isBeta, List<String> betaIps, String tag) {
            this.groupKey = groupKey;
            this.isBeta = isBeta;
            this.betaIps = betaIps;
            this.tag = tag;
        }
    }
}

