/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.minidao.aop.MiniDaoHandler;

public class FreemarkerParseFactory {
    private static final Logger logger = Logger.getLogger(MiniDaoHandler.class);
    private static final String ENCODE = "utf-8";
    private static final Configuration _tplConfig = new Configuration();
    private static final Configuration _sqlConfig = new Configuration();
    private static StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private static final Pattern p = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");

    static {
        _tplConfig.setClassForTemplateLoading(new FreemarkerParseFactory().getClass(), "/");
        _tplConfig.setNumberFormat("0.#####################");
        _sqlConfig.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        _sqlConfig.setNumberFormat("0.#####################");
    }

    public static boolean isExistTemplate(String tplName) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, "UTF-8");
            return mytpl != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String parseTemplate(String tplName, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tplName, ENCODE);
            mytpl.process(paras, (Writer)swriter);
            return FreemarkerParseFactory.getSqlText(swriter.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplName + " }"));
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            if (stringTemplateLoader.findTemplateSource("sql_" + tplContent.hashCode()) == null) {
                stringTemplateLoader.putTemplate("sql_" + tplContent.hashCode(), tplContent);
            }
            Template mytpl = _sqlConfig.getTemplate("sql_" + tplContent.hashCode(), ENCODE);
            mytpl.process(paras, (Writer)swriter);
            return FreemarkerParseFactory.getSqlText(swriter.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.fillInStackTrace());
            logger.error((Object)("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplContent + " }"));
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    private static String getSqlText(String sql) {
        sql = p.matcher(sql).replaceAll("");
        if ((sql = sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim()).endsWith("where") || sql.endsWith("where ")) {
            sql = sql.substring(0, sql.lastIndexOf("where"));
        }
        int index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((String)sql, (String)"where and", (int)index)) != -1) {
            sql = String.valueOf(sql.substring(0, index + 5)) + sql.substring(index + 9, sql.length());
        }
        index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((String)sql, (String)", where", (int)index)) != -1) {
            sql = String.valueOf(sql.substring(0, index)) + sql.substring(index + 1, sql.length());
        }
        if (sql.endsWith(",") || sql.endsWith(", ")) {
            sql = sql.substring(0, sql.lastIndexOf(","));
        }
        return sql;
    }
}

