/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.factory;

import java.lang.annotation.Annotation;
import org.jeecgframework.minidao.annotation.MiniDao;
import org.jeecgframework.minidao.aop.MiniDaoHandler;
import org.jeecgframework.minidao.factory.MiniDaoClassPathMapperScanner;
import org.jeecgframework.minidao.hibernate.dao.impl.GenericBaseCommonDao;
import org.jeecgframework.minidao.hibernate.util.MiniDaoHiberHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.util.StringUtils;

public class MiniDaoBeanScannerConfigurer
implements BeanDefinitionRegistryPostProcessor {
    private String basePackage;
    private Class<? extends Annotation> annotation = MiniDao.class;
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registerGenericBaseCommonDao(registry);
        this.registerRequestProxyHandler(registry);
        MiniDaoClassPathMapperScanner scanner = new MiniDaoClassPathMapperScanner(registry, this.annotation);
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void registerGenericBaseCommonDao(BeanDefinitionRegistry registry) {
        GenericBeanDefinition genericBaseCommonDaofinition = new GenericBeanDefinition();
        genericBaseCommonDaofinition.setBeanClass(GenericBaseCommonDao.class);
        registry.registerBeanDefinition("genericBaseCommonDao", (BeanDefinition)genericBaseCommonDaofinition);
        GenericBeanDefinition genericBaseCommonDaofinition2 = new GenericBeanDefinition();
        genericBaseCommonDaofinition2.setBeanClass(MiniDaoHiberHelper.class);
        registry.registerBeanDefinition("miniDaoHiberHelper", (BeanDefinition)genericBaseCommonDaofinition2);
    }

    private void registerRequestProxyHandler(BeanDefinitionRegistry registry) {
        GenericBeanDefinition jdbcDaoProxyDefinition = new GenericBeanDefinition();
        jdbcDaoProxyDefinition.setBeanClass(MiniDaoHandler.class);
        jdbcDaoProxyDefinition.getPropertyValues().add("formatSql", (Object)this.formatSql);
        jdbcDaoProxyDefinition.getPropertyValues().add("keyType", (Object)this.keyType);
        jdbcDaoProxyDefinition.getPropertyValues().add("showSql", (Object)this.showSql);
        jdbcDaoProxyDefinition.getPropertyValues().add("dbType", (Object)this.dbType);
        registry.registerBeanDefinition("miniDaoHandler", (BeanDefinition)jdbcDaoProxyDefinition);
    }

    public void setAnnotation(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }
}

