/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.minidao.annotation.Arguments;
import org.jeecgframework.minidao.annotation.ResultType;
import org.jeecgframework.minidao.annotation.Sql;
import org.jeecgframework.minidao.hibernate.util.MiniDaoHiberHelper;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.spring.rowMapper.MiniColumnMapRowMapper;
import org.jeecgframework.minidao.spring.rowMapper.MiniColumnOriginalMapRowMapper;
import org.jeecgframework.minidao.util.FreemarkerParseFactory;
import org.jeecgframework.minidao.util.MiniDaoUtil;
import org.jeecgframework.minidao.util.ParameterNameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;

public class MiniDaoHandler
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(MiniDaoHandler.class);
    @Autowired
    private MiniDaoHiberHelper miniDaoHiberHelper;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String UPPER_KEY = "upper";
    private String LOWER_KEY = "lower";
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String executeSql;
        Object returnObj;
        block4: {
            returnObj = null;
            String templateSql = null;
            HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
            MiniDaoPage pageSetting = new MiniDaoPage();
            HashMap rs = new HashMap();
            if (this.miniDaoHiberHelper.miniDaoHiber(rs, method, args)) {
                return rs.get("returnObj");
            }
            templateSql = this.installDaoMetaData(pageSetting, method, sqlParamsMap, args);
            executeSql = this.parseSqlTemplate(method, templateSql, sqlParamsMap);
            Map<String, Object> sqlMap = this.installPlaceholderSqlParam(executeSql, sqlParamsMap);
            try {
                returnObj = this.getReturnMinidaoResult(this.dbType, pageSetting, method, executeSql, sqlMap);
            }
            catch (Exception e) {
                returnObj = null;
                if (e instanceof EmptyResultDataAccessException) break block4;
                e.printStackTrace();
            }
        }
        if (this.showSql) {
            logger.info((Object)("MiniDao-SQL:\n\n" + executeSql));
        }
        return returnObj;
    }

    private static boolean checkActiveKey(String methodName) {
        String[] keys;
        String[] stringArray = keys = "insert,add,create,update,modify,store,delete,remove".split(",");
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (methodName.startsWith(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean checkBatchKey(String methodName) {
        String[] keys;
        String[] stringArray = keys = "batch".split(",");
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (methodName.startsWith(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addResulArray(int[] result, int index, int[] arr) {
        int length = arr.length;
        int i = 0;
        while (i < length) {
            result[index - length + i] = arr[i];
            ++i;
        }
    }

    private int[] batchUpdate(String executeSql) {
        String[] sqls = executeSql.split(";");
        if (sqls.length < 100) {
            return this.jdbcTemplate.batchUpdate(sqls);
        }
        int[] result = new int[sqls.length];
        ArrayList<String> sqlList = new ArrayList<String>();
        int i = 0;
        while (i < sqls.length) {
            sqlList.add(sqls[i]);
            if (i % 100 == 0) {
                this.addResulArray(result, i + 1, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
                sqlList.clear();
            }
            ++i;
        }
        this.addResulArray(result, sqls.length, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
        return result;
    }

    private RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        if (this.getKeyType().equalsIgnoreCase(this.LOWER_KEY)) {
            return new MiniColumnMapRowMapper();
        }
        if (this.getKeyType().equalsIgnoreCase(this.UPPER_KEY)) {
            return new ColumnMapRowMapper();
        }
        return new MiniColumnOriginalMapRowMapper();
    }

    private String getCountSql(String sql) {
        return "select count(0) from (" + sql + ") tmp_count";
    }

    public String getDbType() {
        return this.dbType;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    private Object getReturnMinidaoResult(String dbType, MiniDaoPage pageSetting, Method method, String executeSql, Map<String, Object> paramMap) {
        String methodName = method.getName();
        if (MiniDaoHandler.checkActiveKey(methodName)) {
            if (paramMap != null) {
                return this.namedParameterJdbcTemplate.update(executeSql, paramMap);
            }
            return this.jdbcTemplate.update(executeSql);
        }
        if (MiniDaoHandler.checkBatchKey(methodName)) {
            return this.batchUpdate(executeSql);
        }
        Class<Object> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            Number number = (Number)this.jdbcTemplate.queryForObject(executeSql, BigDecimal.class);
            if ("int".equals(returnType.getCanonicalName())) {
                return number.intValue();
            }
            if ("long".equals(returnType.getCanonicalName())) {
                return number.longValue();
            }
            if ("double".equals(returnType.getCanonicalName())) {
                return number.doubleValue();
            }
        } else {
            if (returnType.isAssignableFrom(List.class) || returnType.isAssignableFrom(MiniDaoPage.class)) {
                int page = pageSetting.getPage();
                int rows = pageSetting.getRows();
                if (page != 0 && rows != 0) {
                    if (returnType.isAssignableFrom(MiniDaoPage.class)) {
                        if (paramMap != null) {
                            pageSetting.setTotal((Integer)this.namedParameterJdbcTemplate.queryForObject(this.getCountSql(executeSql), paramMap, Integer.class));
                        } else {
                            pageSetting.setTotal((Integer)this.jdbcTemplate.queryForObject(this.getCountSql(executeSql), Integer.class));
                        }
                    }
                    executeSql = MiniDaoUtil.createPageSql(dbType, executeSql, page, rows);
                }
                RowMapper<?> resultType = this.getListRealType(method);
                List list = paramMap != null ? this.namedParameterJdbcTemplate.query(executeSql, paramMap, resultType) : this.jdbcTemplate.query(executeSql, resultType);
                if (returnType.isAssignableFrom(MiniDaoPage.class)) {
                    pageSetting.setResults(list);
                    return pageSetting;
                }
                return list;
            }
            if (returnType.isAssignableFrom(Map.class)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, this.getColumnMapRowMapper());
                }
                return this.jdbcTemplate.queryForObject(executeSql, this.getColumnMapRowMapper());
            }
            if (returnType.isAssignableFrom(String.class)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, String.class);
                }
                return this.jdbcTemplate.queryForObject(executeSql, String.class);
            }
            if (MiniDaoUtil.isWrapClass(returnType)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, returnType);
                }
                return this.jdbcTemplate.queryForObject(executeSql, returnType);
            }
            ParameterizedBeanPropertyRowMapper rm = ParameterizedBeanPropertyRowMapper.newInstance(returnType);
            if (paramMap != null) {
                return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, (RowMapper)rm);
            }
            return this.jdbcTemplate.queryForObject(executeSql, (RowMapper)rm);
        }
        return null;
    }

    private RowMapper<?> getListRealType(Method method) {
        ResultType resultType = method.getAnnotation(ResultType.class);
        if (resultType != null) {
            if (resultType.value().equals(Map.class)) {
                return this.getColumnMapRowMapper();
            }
            return ParameterizedBeanPropertyRowMapper.newInstance(resultType.value());
        }
        String genericReturnType = method.getGenericReturnType().toString();
        String realType = genericReturnType.replace("java.util.List", "").replace("<", "").replace(">", "");
        if (realType.contains("java.util.Map")) {
            return this.getColumnMapRowMapper();
        }
        if (realType.length() > 0) {
            try {
                return ParameterizedBeanPropertyRowMapper.newInstance(Class.forName(realType));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), e.fillInStackTrace());
                throw new RuntimeException("minidao get class error ,class name is:" + realType);
            }
        }
        return this.getColumnMapRowMapper();
    }

    private String installDaoMetaData(MiniDaoPage pageSetting, Method method, Map<String, Object> sqlParamsMap, Object[] args) throws Exception {
        String templateSql = null;
        boolean arguments_flag = method.isAnnotationPresent(Arguments.class);
        if (arguments_flag) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            logger.debug((Object)("@Arguments------------------------------------------" + Arrays.toString(arguments.value())));
            if (arguments.value().length != args.length) {
                throw new Exception("\u6ce8\u91ca\u6807\u7b7e@Arguments\u53c2\u6570\u6570\u76ee\uff0c\u4e0e\u65b9\u6cd5\u53c2\u6570\u6570\u76ee\u4e0d\u76f8\u7b49~");
            }
            int args_num = 0;
            String[] stringArray = arguments.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (v.equalsIgnoreCase("page")) {
                    pageSetting.setPage(Integer.parseInt(args[args_num].toString()));
                }
                if (v.equalsIgnoreCase("rows")) {
                    pageSetting.setRows(Integer.parseInt(args[args_num].toString()));
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
                ++n2;
            }
        } else if (args != null && args.length >= 1) {
            String[] params = ParameterNameUtils.getMethodParameterNamesByAnnotation(method);
            if (params == null || params.length == 0) {
                throw new Exception("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u5fc5\u987b\u4f7f\u7528\uff1a\u65b9\u6cd5\u6807\u7b7e@Arguments \u6216  \u53c2\u6570\u6807\u7b7e@param");
            }
            if (params.length != args.length) {
                throw new Exception("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u53c2\u6570\u5fc5\u987b\u4f7f\u7528\uff1a\u6807\u7b7e@param");
            }
            int args_num = 0;
            String[] stringArray = params;
            int n = params.length;
            int n3 = 0;
            while (n3 < n) {
                String v = stringArray[n3];
                if (v == null) {
                    throw new Exception("Dao\u63a5\u53e3\u5b9a\u4e49\uff0c\u6240\u6709\u53c2\u6570\u5fc5\u987b\u4f7f\u7528@param\u6807\u7b7e~");
                }
                if (v.equalsIgnoreCase("page")) {
                    pageSetting.setPage(Integer.parseInt(args[args_num].toString()));
                }
                if (v.equalsIgnoreCase("rows")) {
                    pageSetting.setRows(Integer.parseInt(args[args_num].toString()));
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
                ++n3;
            }
        } else if (args != null && args.length == 1) {
            sqlParamsMap.put("dto", args[0]);
        }
        if (method.isAnnotationPresent(Sql.class)) {
            Sql sql = method.getAnnotation(Sql.class);
            if (StringUtils.isNotEmpty((String)sql.value())) {
                templateSql = sql.value();
            }
            logger.debug((Object)("@Sql------------------------------------------" + sql.value()));
        }
        return templateSql;
    }

    private Map<String, Object> installPlaceholderSqlParam(String executeSql, Map sqlParamsMap) throws OgnlException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String regEx = ":[ tnx0Bfr]*[0-9a-z.A-Z]+";
        Pattern pat = Pattern.compile(regEx);
        Matcher m = pat.matcher(executeSql);
        while (m.find()) {
            logger.debug((Object)(" Match [" + m.group() + "] at positions " + m.start() + "-" + (m.end() - 1)));
            String ognl_key = m.group().replace(":", "").trim();
            map.put(ognl_key, Ognl.getValue((String)ognl_key, (Object)sqlParamsMap));
        }
        return map;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    private String parseSqlTemplate(Method method, String templateSql, Map<String, Object> sqlParamsMap) {
        String executeSql = null;
        if (StringUtils.isNotEmpty((String)templateSql)) {
            executeSql = FreemarkerParseFactory.parseTemplateContent(templateSql, sqlParamsMap);
        } else {
            String sqlTempletPath = String.valueOf(method.getDeclaringClass().getName().replace(".", "/").replace("/dao/", "/sql/")) + "_" + method.getName() + ".sql";
            if (!FreemarkerParseFactory.isExistTemplate(sqlTempletPath)) {
                sqlTempletPath = String.valueOf(method.getDeclaringClass().getName().replace(".", "/")) + "_" + method.getName() + ".sql";
            }
            logger.debug((Object)("MiniDao-SQL-Path:" + sqlTempletPath));
            executeSql = FreemarkerParseFactory.parseTemplate(sqlTempletPath, sqlParamsMap);
        }
        return executeSql;
    }

    public List<Object> procedureParamsList(Method method, Object[] args) throws Exception {
        ArrayList<Object> procedureParamsList = new ArrayList();
        boolean arguments_flag = method.isAnnotationPresent(Arguments.class);
        if (arguments_flag) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            logger.debug((Object)("@Arguments------------------------------------------" + Arrays.toString(arguments.value())));
            if (arguments.value().length > args.length) {
                throw new Exception("[\u6ce8\u91ca\u6807\u7b7e]\u53c2\u6570\u6570\u76ee\uff0c\u4e0d\u80fd\u5927\u4e8e[\u65b9\u6cd5\u53c2\u6570]\u53c2\u6570\u6570\u76ee");
            }
            int i = 0;
            while (i < arguments.value().length) {
                procedureParamsList.add(args[i]);
                ++i;
            }
        } else {
            System.out.println(StringUtils.join((Object[])args));
            procedureParamsList = Arrays.asList(args);
        }
        return procedureParamsList;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }
}

