/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.pagehelper.PageException;
import org.jeecgframework.minidao.pagehelper.dialect.AbstractHelperDialect;
import org.jeecgframework.minidao.pagehelper.dialect.PageAutoDialect;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.sqlparser.AbstractSqlProcessor;
import org.jeecgframework.minidao.sqlparser.impl.JsqlparserSqlProcessor;
import org.jeecgframework.minidao.sqlparser.impl.SimpleSqlProcessor;

public class MiniDaoUtil {
    private static final Log logger = LogFactory.getLog(MiniDaoUtil.class);
    static PageAutoDialect pageAutoDialect = new PageAutoDialect();
    public static final String DATABSE_TYPE_HSQLDB = "hsqldb";
    public static final String DATABSE_TYPE_H2 = "h2";
    public static final String DATABSE_TYPE_PHOENIX = "phoenix";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_MARIADB = "mariadb";
    public static final String DATABSE_TYPE_SQLITE = "sqlite";
    public static final String DATABSE_TYPE_HERDDB = "herddb";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_ORACLE9I = "oracle9i";
    public static final String DATABSE_TYPE_DM = "dm";
    public static final String DATABSE_TYPE_DB2 = "db2";
    public static final String DATABSE_TYPE_INFORMIX = "informix";
    public static final String DATABSE_TYPE_INFORMIX_SQLI = "informix-sqli";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String DATABSE_TYPE_SQLSERVER2012 = "sqlserver2012";
    public static final String DATABSE_TYPE_DERBY = "derby";
    public static final String DATABSE_TYPE_EDB = "edb";
    public static final String DATABSE_TYPE_OSCAR = "oscar";
    public static final String DATABSE_TYPE_KINGBASE = "kingbase";
    public static final String DATABSE_TYPE_CLICKHOUSE = "clickhouse";
    public static final String DATABSE_TYPE_HIGHGO = "highgo";
    public static final String DATABSE_TYPE_XUGU = "xugu";
    public static final String DATABSE_TYPE_ZENITH = "zenith";
    public static final String DATABSE_TYPE_POLARDB = "polardb";
    public static final String DATABSE_TYPE_TDENGINE = "taos";
    private static final boolean JSQLPARSER_AVAILABLE = MiniDaoUtil.checkJSqlParserAvailability();
    protected static AbstractSqlProcessor abstractSqlProcessor = MiniDaoUtil.isJSqlParserAvailable() ? new JsqlparserSqlProcessor() : new SimpleSqlProcessor();

    private static String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getDbType(String dbUrl) {
        String dbType = pageAutoDialect.getDialectKeyByJdbcUrl(dbUrl);
        if (dbType != null) {
            dbType = dbType.toLowerCase();
        }
        return dbType;
    }

    public static String getDbType(DataSource dataSource) {
        long startTime = System.currentTimeMillis();
        String dbUrl = MiniDaoUtil.getUrl(dataSource);
        String dbType = MiniDaoUtil.getDbType(dbUrl);
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("\u83b7\u53d6DB\u7c7b\u578b\uff1a" + dbType + "\uff0c\u8017\u65f6\uff1a" + (endTime - startTime) + "ms"));
        return dbType;
    }

    public static String createPageSql(String dbUrl, String sql, int page, int rows) {
        AbstractHelperDialect dialect = pageAutoDialect.getDialect(dbUrl);
        MiniDaoPage pageSetting = new MiniDaoPage();
        pageSetting.setPage(page);
        pageSetting.setRows(rows);
        String executePageSql = dialect.getPageSql(sql, pageSetting);
        return executePageSql;
    }

    public static String getCountSql(String sql) {
        try {
            sql = abstractSqlProcessor.getCountSql(sql);
        }
        catch (Exception e) {
            logger.warn((Object)("getCountSql error:" + e.getMessage()));
        }
        return sql;
    }

    public static String removeOrderBy(String sql) {
        try {
            sql = abstractSqlProcessor.removeOrderBy(sql);
        }
        catch (Exception e) {
            logger.warn((Object)("removeOrderBy error:" + e.getMessage()));
        }
        return sql;
    }

    public static String addOrderBy(String sql, String field, boolean isAsc) {
        try {
            sql = abstractSqlProcessor.addOrderBy(sql, field, isAsc);
        }
        catch (Exception e) {
            logger.warn((Object)("addOrderBy error:" + e.getMessage()));
        }
        return sql;
    }

    public static List<Map<String, Object>> parseSqlFields(String parsedSql) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        try {
            list = abstractSqlProcessor.parseSqlFields(parsedSql);
        }
        catch (Exception e) {
            logger.warn((Object)("parseSqlFields error:" + e.getMessage()));
        }
        return list;
    }

    public static boolean isJSqlParserAvailable() {
        return JSQLPARSER_AVAILABLE;
    }

    private static boolean checkJSqlParserAvailability() {
        try {
            Class.forName("net.sf.jsqlparser.statement.select.SelectBody");
            logger.debug((Object)"\u3010Sql Parser\u3011 The environment supports jsqlparser engine");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"\u3010Sql Parser\u3011 The environment does not support jsqlparser engine");
            return false;
        }
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public static String getFirstSmall(String name) {
        if ((name = name.trim()).length() >= 2) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name.toLowerCase();
    }

    public static String getMethodSqlLogicJar(String sqlurl) {
        StringBuffer sb = new StringBuffer();
        InputStream is = MiniDaoUtil.class.getResourceAsStream(sqlurl);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = "";
        try {
            while ((s = br.readLine()) != null) {
                sb.append(s + " ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static boolean isAbstract(Method method) {
        int mod = method.getModifiers();
        return Modifier.isAbstract(mod);
    }

    public static boolean isWrapClass(Class<?> clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        logger.debug((Object)MiniDaoUtil.isWrapClass(Long.class));
        logger.debug((Object)MiniDaoUtil.isWrapClass(Integer.class));
        logger.debug((Object)MiniDaoUtil.isWrapClass(String.class));
    }
}

